/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.saver;

import java.io.IOException;
import org.deeplearning4j.earlystopping.EarlyStoppingModelSaver;
import org.deeplearning4j.nn.api.Model;

public class InMemoryModelSaver<T extends Model>
implements EarlyStoppingModelSaver<T> {
    private transient T bestModel;
    private transient T latestModel;

    @Override
    public void saveBestModel(T net, double score) throws IOException {
        try {
            this.bestModel = (Model)net.getClass().getDeclaredMethod("clone", new Class[0]).invoke(net, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveLatestModel(T net, double score) throws IOException {
        try {
            this.latestModel = (Model)net.getClass().getDeclaredMethod("clone", new Class[0]).invoke(net, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T getBestModel() throws IOException {
        return this.bestModel;
    }

    @Override
    public T getLatestModel() throws IOException {
        return this.latestModel;
    }

    public String toString() {
        return "InMemoryModelSaver()";
    }
}

