/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Serializable;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.BaseTrainingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectScoresListener
extends BaseTrainingListener
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CollectScoresListener.class);
    private final int frequency;
    private final boolean logScore;
    private final IntArrayList listIteration;
    private final DoubleArrayList listScore;

    public CollectScoresListener(int frequency) {
        this(frequency, false);
    }

    public CollectScoresListener(int frequency, boolean logScore) {
        this.frequency = frequency;
        this.logScore = logScore;
        this.listIteration = new IntArrayList();
        this.listScore = new DoubleArrayList();
    }

    @Override
    public void iterationDone(Model model, int iteration, int epoch) {
        if (iteration % this.frequency == 0) {
            double score = model.score();
            this.listIteration.add(iteration);
            this.listScore.add(score);
            if (this.logScore) {
                log.info("Score at iteration {} is {}", (Object)iteration, (Object)score);
            }
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean isLogScore() {
        return this.logScore;
    }

    public IntArrayList getListIteration() {
        return this.listIteration;
    }

    public DoubleArrayList getListScore() {
        return this.listScore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectScoresListener)) {
            return false;
        }
        CollectScoresListener other = (CollectScoresListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFrequency() != other.getFrequency()) {
            return false;
        }
        if (this.isLogScore() != other.isLogScore()) {
            return false;
        }
        IntArrayList this$listIteration = this.getListIteration();
        IntArrayList other$listIteration = other.getListIteration();
        if (this$listIteration == null ? other$listIteration != null : !this$listIteration.equals(other$listIteration)) {
            return false;
        }
        DoubleArrayList this$listScore = this.getListScore();
        DoubleArrayList other$listScore = other.getListScore();
        return !(this$listScore == null ? other$listScore != null : !this$listScore.equals(other$listScore));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectScoresListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFrequency();
        result = result * 59 + (this.isLogScore() ? 79 : 97);
        IntArrayList $listIteration = this.getListIteration();
        result = result * 59 + ($listIteration == null ? 43 : $listIteration.hashCode());
        DoubleArrayList $listScore = this.getListScore();
        result = result * 59 + ($listScore == null ? 43 : $listScore.hashCode());
        return result;
    }

    public String toString() {
        return "CollectScoresListener(frequency=" + this.getFrequency() + ", logScore=" + this.isLogScore() + ", listIteration=" + this.getListIteration() + ", listScore=" + this.getListScore() + ")";
    }
}

