/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.layers.LayerHelper;
import org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingHelper;
import org.deeplearning4j.nn.layers.mkldnn.MKLDNNSubsamplingHelper;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.layers.convolution.LegacyPooling2D;
import org.nd4j.linalg.api.ops.impl.transforms.any.IsMax;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.util.OneTimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsamplingLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.SubsamplingLayer> {
    private static final Logger log = LoggerFactory.getLogger(SubsamplingLayer.class);
    protected SubsamplingHelper helper = null;
    protected int helperCountFail = 0;
    protected ConvolutionMode convolutionMode;

    public SubsamplingLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
        this.initializeHelper();
        this.convolutionMode = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)conf.getLayer()).getConvolutionMode();
    }

    void initializeHelper() {
        block8: {
            String backend = Nd4j.getExecutioner().getEnvironmentInformation().getProperty("backend");
            if ("CUDA".equalsIgnoreCase(backend)) {
                try {
                    this.helper = Class.forName("org.deeplearning4j.nn.layers.convolution.subsampling.CudnnSubsamplingHelper").asSubclass(SubsamplingHelper.class).getConstructor(DataType.class).newInstance(this.dataType);
                    log.debug("CudnnSubsamplingHelper successfully initialized");
                    if (!this.helper.checkSupported()) {
                        this.helper = null;
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ClassNotFoundException)) {
                        log.warn("Could not initialize CudnnSubsamplingHelper", t);
                        break block8;
                    }
                    OneTimeLogger.info((Logger)log, (String)"cuDNN not found: use cuDNN for better GPU performance by including the deeplearning4j-cuda module. For more information, please refer to: https://deeplearning4j.org/docs/latest/deeplearning4j-config-cudnn", (Object[])new Object[]{t});
                }
            } else if ("CPU".equalsIgnoreCase(backend)) {
                this.helper = new MKLDNNSubsamplingHelper(this.dataType);
                log.debug("Created MKL-DNN helper: MKLDNNSubsamplingHelper, layer {}", (Object)((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getLayerName());
            }
        }
        if (this.helper != null && !this.helper.checkSupported()) {
            log.debug("Removed helper {} as not supported", this.helper.getClass());
            this.helper = null;
        }
    }

    @Override
    public double calcRegularizationScore(boolean backpropOnlyParams) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.SUBSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray epsilon1d;
        INDArray col6dPermuted;
        INDArray col6d;
        int[] pad;
        int[] outSize;
        this.assertInputSet(true);
        INDArray input = this.input.castTo(this.dataType);
        int miniBatch = (int)input.size(0);
        int inDepth = (int)input.size(1);
        int inH = (int)input.size(2);
        int inW = (int)input.size(3);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        if (!(this.helper == null || this.helperCountFail != 0 && ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback())) {
            Pair<Gradient, INDArray> ret = null;
            try {
                ret = this.helper.backpropGradient(input, epsilon, kernel, strides, pad, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType(), this.convolutionMode, dilation, workspaceMgr);
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("Failed to allocate")) {
                    throw e;
                }
                if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback()) {
                    ++this.helperCountFail;
                    if (this.helper instanceof MKLDNNSubsamplingHelper) {
                        log.warn("MKL-DNN execution failed - falling back on built-in implementation", (Throwable)e);
                    } else {
                        log.warn("CuDNN execution failed - falling back on built-in implementation", (Throwable)e);
                    }
                }
                throw new RuntimeException(e);
            }
            if (ret != null) {
                return ret;
            }
        }
        int inputHeight = (int)this.input().size(-2);
        int inputWidth = (int)this.input().size(-1);
        DefaultGradient retGradient = new DefaultGradient();
        boolean cOrderStrides = false;
        if (epsilon.ordering() != 'c') {
            epsilon = epsilon.dup('c');
            cOrderStrides = true;
        }
        if (!cOrderStrides && Shape.strideDescendingCAscendingF((INDArray)epsilon)) {
            cOrderStrides = true;
        } else if (!Arrays.equals(new long[]{outH * outW, inDepth * outH * outW, outW, 1L}, epsilon.stride())) {
            epsilon = epsilon.dup('c');
            cOrderStrides = true;
        }
        if (cOrderStrides) {
            col6d = Nd4j.create((DataType)this.dataType, (long[])new long[]{miniBatch, inDepth, outH, outW, kernel[0], kernel[1]}, (char)'c');
            col6dPermuted = col6d.permute(new int[]{0, 1, 4, 5, 2, 3});
            epsilon1d = epsilon.reshape('c', ArrayUtil.prod((long[])new long[]{epsilon.length()}), 1);
        } else {
            col6d = Nd4j.create((DataType)this.dataType, (long[])new long[]{inDepth, miniBatch, outH, outW, kernel[0], kernel[1]}, (char)'c');
            col6dPermuted = col6d.permute(new int[]{1, 0, 4, 5, 2, 3});
            INDArray epsilonTemp = epsilon.permute(new int[]{1, 0, 2, 3});
            epsilon1d = epsilonTemp.reshape('c', new int[]{ArrayUtil.prod((long[])new long[]{epsilon.length()}), 1});
        }
        INDArray col2d = col6d.reshape('c', miniBatch * inDepth * outH * outW, kernel[0] * kernel[1]);
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case MAX: {
                DynamicCustomOp op = DynamicCustomOp.builder((String)"im2col").addIntegerArguments(new int[]{kernel[0], kernel[1], strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], ArrayUtil.fromBoolean((this.convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0)}).addFloatingPointArguments(new Double[]{SubsamplingLayer.minValue()}).addInputs(new INDArray[]{input}).addOutputs(new INDArray[]{col6dPermuted}).build();
                Nd4j.getExecutioner().exec((CustomOp)op);
                INDArray isMax = Nd4j.getExecutioner().exec((Op)new IsMax(col2d, col2d, new int[]{1}));
                isMax.muliColumnVector(epsilon1d);
                break;
            }
            case AVG: {
                col2d.addiColumnVector(epsilon1d);
                break;
            }
            case PNORM: {
                INDArray numerator;
                int pnorm = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPnorm();
                Convolution.im2col((INDArray)input, (int)kernel[0], (int)kernel[1], (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (int)dilation[0], (int)dilation[1], (this.convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0, (INDArray)col6dPermuted);
                INDArray pNorm = Transforms.abs((INDArray)col2d, (boolean)true);
                Transforms.pow((INDArray)pNorm, (Number)pnorm, (boolean)false);
                pNorm = pNorm.sum(new int[]{1}).reshape(pNorm.size(0), 1L);
                Transforms.pow((INDArray)pNorm, (Number)(1.0 / (double)pnorm), (boolean)false);
                if (pnorm == 2) {
                    numerator = col2d;
                } else {
                    INDArray absp2 = Transforms.pow((INDArray)Transforms.abs((INDArray)col2d, (boolean)true), (Number)(pnorm - 2), (boolean)false);
                    numerator = col2d.muli(absp2);
                }
                INDArray denom = Transforms.pow((INDArray)pNorm, (Number)(pnorm - 1), (boolean)false);
                double eps = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getEps();
                Transforms.max((INDArray)denom, (double)eps, (boolean)false);
                numerator.muliColumnVector(denom.rdivi(epsilon1d));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown or unsupported pooling type: " + (Object)((Object)((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) + " " + this.layerId());
            }
        }
        INDArray tempEpsilon = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, this.dataType, new long[]{inDepth, miniBatch, inH, inW}, 'c');
        INDArray outEpsilon = tempEpsilon.permute(new int[]{1, 0, 2, 3});
        Convolution.col2im((INDArray)col6dPermuted, (INDArray)outEpsilon, (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (int)inputHeight, (int)inputWidth, (int)dilation[0], (int)dilation[1]);
        if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType() == PoolingType.AVG) {
            outEpsilon.divi((Number)ArrayUtil.prod((int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize()));
        }
        return new Pair((Object)retGradient, (Object)outEpsilon);
    }

    private static double minValue() {
        switch (Nd4j.dataType()) {
            case DOUBLE: {
                return -1.7976931348623157E308;
            }
            case FLOAT: {
                return -3.4028234663852886E38;
            }
            case HALF: {
                return -65504.0;
            }
        }
        throw new IllegalStateException("Unexpected data type: " + Nd4j.dataType());
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        LegacyPooling2D.Pooling2DType pt;
        int[] pad;
        int[] outSize;
        this.assertInputSet(false);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, channels, inputHeight, inputWidth]. " + this.layerId());
        }
        INDArray input = this.input.castTo(this.dataType);
        int miniBatch = (int)input.size(0);
        int inDepth = (int)input.size(1);
        int inH = (int)input.size(2);
        int inW = (int)input.size(3);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        if (!(this.helper == null || this.helperCountFail != 0 && ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback())) {
            INDArray ret = null;
            try {
                ret = this.helper.activate(input, training, kernel, strides, pad, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType(), this.convolutionMode, dilation, workspaceMgr);
            }
            catch (Exception e) {
                if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback()) {
                    ++this.helperCountFail;
                    if (this.helper instanceof MKLDNNSubsamplingHelper) {
                        log.warn("MKL-DNN execution failed - falling back on built-in implementation", (Throwable)e);
                    } else {
                        log.warn("CuDNN execution failed - falling back on built-in implementation", (Throwable)e);
                    }
                }
                throw new RuntimeException(e);
            }
            if (ret != null) {
                return ret;
            }
        }
        INDArray output = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, input.dataType(), new long[]{miniBatch, inDepth, outH, outW}, 'c');
        double extra = 0.0;
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case MAX: {
                pt = LegacyPooling2D.Pooling2DType.MAX;
                break;
            }
            case AVG: {
                pt = LegacyPooling2D.Pooling2DType.AVG;
                extra = 1.0;
                break;
            }
            case PNORM: {
                pt = LegacyPooling2D.Pooling2DType.PNORM;
                extra = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPnorm();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported: " + (Object)((Object)((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()));
            }
        }
        LegacyPooling2D op = new LegacyPooling2D(input, kernel[0], kernel[1], strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], this.convolutionMode == ConvolutionMode.Same, pt, extra, output);
        Nd4j.getExecutioner().exec((Op)op);
        return output;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public LayerHelper getHelper() {
        return this.helper;
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null) {
            return new Pair((Object)maskArray, (Object)currentMaskState);
        }
        INDArray outMask = ConvolutionUtils.cnn2dMaskReduction(maskArray, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getConvolutionMode());
        return super.feedForwardMaskArray(outMask, currentMaskState, minibatchSize);
    }
}

