/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FeedForwardToCnnPreProcessor
implements InputPreProcessor {
    private long inputHeight;
    private long inputWidth;
    private long numChannels;
    private long[] shape;

    @JsonCreator
    public FeedForwardToCnnPreProcessor(@JsonProperty(value="inputHeight") long inputHeight, @JsonProperty(value="inputWidth") long inputWidth, @JsonProperty(value="numChannels") long numChannels) {
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = numChannels;
    }

    public FeedForwardToCnnPreProcessor(long inputWidth, long inputHeight) {
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = 1L;
    }

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        this.shape = input.shape();
        if (input.rank() == 4) {
            return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, input);
        }
        if ((long)input.columns() != this.inputWidth * this.inputHeight * this.numChannels) {
            throw new IllegalArgumentException("Invalid input: expect output columns must be equal to rows " + this.inputHeight + " x columns " + this.inputWidth + " x channels " + this.numChannels + " but was instead " + Arrays.toString(input.shape()));
        }
        if (input.ordering() != 'c' || !Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = workspaceMgr.dup(ArrayType.ACTIVATIONS, input, 'c');
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, input.reshape('c', new long[]{input.size(0), this.numChannels, this.inputHeight, this.inputWidth}));
    }

    @Override
    public INDArray backprop(INDArray epsilons, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (epsilons.ordering() != 'c' || !Shape.hasDefaultStridesForShape((INDArray)epsilons)) {
            epsilons = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, epsilons, 'c');
        }
        if (this.shape == null || (long)ArrayUtil.prod((long[])this.shape) != epsilons.length()) {
            if (epsilons.rank() == 2) {
                return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsilons);
            }
            return epsilons.reshape('c', new long[]{epsilons.size(0), this.numChannels, this.inputHeight, this.inputWidth});
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsilons.reshape('c', this.shape));
    }

    @Override
    public FeedForwardToCnnPreProcessor clone() {
        try {
            FeedForwardToCnnPreProcessor clone = (FeedForwardToCnnPreProcessor)super.clone();
            if (clone.shape != null) {
                clone.shape = (long[])clone.shape.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        switch (inputType.getType()) {
            case FF: {
                InputType.InputTypeFeedForward c = (InputType.InputTypeFeedForward)inputType;
                long expSize = this.inputHeight * this.inputWidth * this.numChannels;
                if (c.getSize() != expSize) {
                    throw new IllegalStateException("Invalid input: expected FeedForward input of size " + expSize + " = (d=" + this.numChannels + " * w=" + this.inputWidth + " * h=" + this.inputHeight + "), got " + inputType);
                }
                return InputType.convolutional(this.inputHeight, this.inputWidth, this.numChannels);
            }
            case CNN: {
                InputType.InputTypeConvolutional c2 = (InputType.InputTypeConvolutional)inputType;
                if (c2.getChannels() != this.numChannels || c2.getHeight() != this.inputHeight || c2.getWidth() != this.inputWidth) {
                    throw new IllegalStateException("Invalid input: Got CNN input type with (d,w,h)=(" + c2.getChannels() + "," + c2.getWidth() + "," + c2.getHeight() + ") but expected (" + this.numChannels + "," + this.inputHeight + "," + this.inputWidth + ")");
                }
                return c2;
            }
            case CNNFlat: {
                InputType.InputTypeConvolutionalFlat c3 = (InputType.InputTypeConvolutionalFlat)inputType;
                if (c3.getDepth() != this.numChannels || c3.getHeight() != this.inputHeight || c3.getWidth() != this.inputWidth) {
                    throw new IllegalStateException("Invalid input: Got CNN input type with (d,w,h)=(" + c3.getDepth() + "," + c3.getWidth() + "," + c3.getHeight() + ") but expected (" + this.numChannels + "," + this.inputHeight + "," + this.inputWidth + ")");
                }
                return c3.getUnflattenedType();
            }
        }
        throw new IllegalStateException("Invalid input type: got " + inputType);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        return new Pair((Object)maskArray, (Object)currentMaskState);
    }

    public long getInputHeight() {
        return this.inputHeight;
    }

    public long getInputWidth() {
        return this.inputWidth;
    }

    public long getNumChannels() {
        return this.numChannels;
    }

    public void setInputHeight(long inputHeight) {
        this.inputHeight = inputHeight;
    }

    public void setInputWidth(long inputWidth) {
        this.inputWidth = inputWidth;
    }

    public void setNumChannels(long numChannels) {
        this.numChannels = numChannels;
    }

    public String toString() {
        return "FeedForwardToCnnPreProcessor(inputHeight=" + this.getInputHeight() + ", inputWidth=" + this.getInputWidth() + ", numChannels=" + this.getNumChannels() + ", shape=" + Arrays.toString(this.shape) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardToCnnPreProcessor)) {
            return false;
        }
        FeedForwardToCnnPreProcessor other = (FeedForwardToCnnPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInputHeight() != other.getInputHeight()) {
            return false;
        }
        if (this.getInputWidth() != other.getInputWidth()) {
            return false;
        }
        return this.getNumChannels() == other.getNumChannels();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardToCnnPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $inputHeight = this.getInputHeight();
        result = result * 59 + (int)($inputHeight >>> 32 ^ $inputHeight);
        long $inputWidth = this.getInputWidth();
        result = result * 59 + (int)($inputWidth >>> 32 ^ $inputWidth);
        long $numChannels = this.getNumChannels();
        result = result * 59 + (int)($numChannels >>> 32 ^ $numChannels);
        return result;
    }
}

