/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.layers.BaseRecurrentLayer;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationSigmoid;

public abstract class AbstractLSTM
extends BaseRecurrentLayer {
    protected double forgetGateBiasInit;
    protected IActivation gateActivationFn = new ActivationSigmoid();

    protected AbstractLSTM(Builder builder) {
        super(builder);
        this.forgetGateBiasInit = builder.forgetGateBiasInit;
        this.gateActivationFn = builder.gateActivationFn;
    }

    public double getForgetGateBiasInit() {
        return this.forgetGateBiasInit;
    }

    public IActivation getGateActivationFn() {
        return this.gateActivationFn;
    }

    public void setForgetGateBiasInit(double forgetGateBiasInit) {
        this.forgetGateBiasInit = forgetGateBiasInit;
    }

    public void setGateActivationFn(IActivation gateActivationFn) {
        this.gateActivationFn = gateActivationFn;
    }

    public AbstractLSTM() {
    }

    @Override
    public String toString() {
        return "AbstractLSTM(super=" + super.toString() + ", forgetGateBiasInit=" + this.getForgetGateBiasInit() + ", gateActivationFn=" + this.getGateActivationFn() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLSTM)) {
            return false;
        }
        AbstractLSTM other = (AbstractLSTM)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getForgetGateBiasInit(), other.getForgetGateBiasInit()) != 0) {
            return false;
        }
        IActivation this$gateActivationFn = this.getGateActivationFn();
        IActivation other$gateActivationFn = other.getGateActivationFn();
        return !(this$gateActivationFn == null ? other$gateActivationFn != null : !this$gateActivationFn.equals(other$gateActivationFn));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractLSTM;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $forgetGateBiasInit = Double.doubleToLongBits(this.getForgetGateBiasInit());
        result = result * 59 + (int)($forgetGateBiasInit >>> 32 ^ $forgetGateBiasInit);
        IActivation $gateActivationFn = this.getGateActivationFn();
        result = result * 59 + ($gateActivationFn == null ? 43 : $gateActivationFn.hashCode());
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseRecurrentLayer.Builder<T> {
        protected double forgetGateBiasInit = 1.0;
        protected IActivation gateActivationFn = new ActivationSigmoid();

        public T forgetGateBiasInit(double biasInit) {
            this.setForgetGateBiasInit(biasInit);
            return (T)this;
        }

        public T gateActivationFunction(String gateActivationFn) {
            return this.gateActivationFunction(Activation.fromString((String)gateActivationFn));
        }

        public T gateActivationFunction(Activation gateActivationFn) {
            return this.gateActivationFunction(gateActivationFn.getActivationFunction());
        }

        public T gateActivationFunction(IActivation gateActivationFn) {
            this.setGateActivationFn(gateActivationFn);
            return (T)this;
        }

        public Builder(double forgetGateBiasInit, IActivation gateActivationFn) {
            this.forgetGateBiasInit = forgetGateBiasInit;
            this.gateActivationFn = gateActivationFn;
        }

        public Builder() {
        }

        public double getForgetGateBiasInit() {
            return this.forgetGateBiasInit;
        }

        public IActivation getGateActivationFn() {
            return this.gateActivationFn;
        }

        public void setForgetGateBiasInit(double forgetGateBiasInit) {
            this.forgetGateBiasInit = forgetGateBiasInit;
        }

        public void setGateActivationFn(IActivation gateActivationFn) {
            this.gateActivationFn = gateActivationFn;
        }
    }
}

