/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers.accumulation;

import EDU.oswego.cs.dl.util.concurrent.ReaderPreferenceReadWriteLock;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.NonNull;
import org.deeplearning4j.optimize.solvers.accumulation.FancyBlockingQueue;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartFancyBlockingQueue
extends FancyBlockingQueue<INDArray> {
    private static final Logger log = LoggerFactory.getLogger(SmartFancyBlockingQueue.class);
    protected final ReaderPreferenceReadWriteLock smartLock = new ReaderPreferenceReadWriteLock();
    protected int decompressionThreshold = 32;
    protected AtomicBoolean collapsedMode = new AtomicBoolean(false);
    protected final long[] paramsShape;
    protected final char paramsOrder;

    public SmartFancyBlockingQueue(int decompressionThreshold, @NonNull INDArray paramsMatrix) {
        this(decompressionThreshold, new LinkedBlockingQueue<INDArray>(1024), paramsMatrix);
        if (paramsMatrix == null) {
            throw new NullPointerException("paramsMatrix is marked @NonNull but is null");
        }
    }

    public SmartFancyBlockingQueue(int decompressionThreshold, BlockingQueue<INDArray> queue, @NonNull INDArray paramsMatrix) {
        super(queue);
        if (paramsMatrix == null) {
            throw new NullPointerException("paramsMatrix is marked @NonNull but is null");
        }
        this.decompressionThreshold = decompressionThreshold;
        this.paramsShape = paramsMatrix.shape();
        this.paramsOrder = paramsMatrix.ordering();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected INDArray smartDecompress(INDArray encoded, INDArray target) {
        INDArray result;
        INDArray iNDArray = result = target == null ? Nd4j.create((long[])this.paramsShape, (char)this.paramsOrder) : target;
        if (encoded.isCompressed() || encoded.data().dataType() == DataBuffer.Type.INT) {
            int encoding = encoded.data().getInt(3L);
            if (encoding == 0) {
                Nd4j.getExecutioner().thresholdDecode(encoded, result);
                return result;
            } else {
                if (encoding != 1) throw new ND4JIllegalStateException("Unknown encoding mode: [" + encoding + "]");
                Nd4j.getExecutioner().bitmapDecode(encoded, result);
            }
            return result;
        } else {
            result.addi(encoded);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        try {
            this.smartLock.readLock().acquire();
            if (this.currentConsumers.get() > 0) {
                this.synchronize(this.currentConsumers.get());
            }
            boolean bl = super.isEmpty();
            return bl;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.smartLock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(INDArray array) throws InterruptedException {
        try {
            this.smartLock.writeLock().acquire();
            if (this.backingQueue.size() > this.decompressionThreshold || this.collapsedMode.get()) {
                log.info("Collapsing updates...");
                INDArray params = this.smartDecompress(array, this.collapsedMode.get() && this.backingQueue.size() == 1 ? (INDArray)this.backingQueue.poll() : null);
                while (!this.backingQueue.isEmpty()) {
                    INDArray arr = (INDArray)this.backingQueue.poll();
                    this.smartDecompress(arr, params);
                }
                this.numElementsDrained.set(0);
                this.numElementsReady.set(1);
                this.collapsedMode.set(true);
                super.put(params);
            } else {
                super.put(array);
            }
        }
        finally {
            this.smartLock.writeLock().release();
        }
    }

    @Override
    public INDArray poll() {
        try {
            this.smartLock.readLock().acquire();
            this.collapsedMode.set(false);
            INDArray iNDArray = (INDArray)super.poll();
            return iNDArray;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.smartLock.readLock().release();
        }
    }
}

