/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.PReLULayer;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class PReLUParamInitializer
implements ParamInitializer {
    public static final String WEIGHT_KEY = "W";
    private long[] weightShape;
    private long[] sharedAxes;

    public PReLUParamInitializer(long[] shape, long[] sharedAxes) {
        this.weightShape = shape;
        this.sharedAxes = sharedAxes;
        if (sharedAxes != null) {
            for (long axis : sharedAxes) {
                this.weightShape[(int)axis - 1] = 1L;
            }
        }
    }

    public static PReLUParamInitializer getInstance(long[] shape, long[] sharedAxes) {
        return new PReLUParamInitializer(shape, sharedAxes);
    }

    @Override
    public long numParams(NeuralNetConfiguration conf) {
        return this.numParams(conf.getLayer());
    }

    @Override
    public long numParams(Layer l) {
        return this.numParams(this.weightShape);
    }

    private long numParams(long[] shape) {
        long flattened = 1L;
        for (long value : shape) {
            flattened *= value;
        }
        return flattened;
    }

    @Override
    public List<String> paramKeys(Layer layer) {
        return this.weightKeys(layer);
    }

    @Override
    public List<String> weightKeys(Layer layer) {
        return Collections.singletonList(WEIGHT_KEY);
    }

    @Override
    public List<String> biasKeys(Layer layer) {
        return Collections.emptyList();
    }

    @Override
    public boolean isWeightParam(Layer layer, String key) {
        return WEIGHT_KEY.equals(key);
    }

    @Override
    public boolean isBiasParam(Layer layer, String key) {
        return false;
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        if (!(conf.getLayer() instanceof BaseLayer)) {
            throw new IllegalArgumentException("unsupported layer type: " + conf.getLayer().getClass().getName());
        }
        Map<String, INDArray> params = Collections.synchronizedMap(new LinkedHashMap());
        long length = this.numParams(conf);
        if (paramsView.length() != length) {
            throw new IllegalStateException("Expected params view of length " + length + ", got length " + paramsView.length());
        }
        INDArray weightView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.point((long)0L), NDArrayIndex.interval((long)0L, (long)length)});
        params.put(WEIGHT_KEY, this.createWeightMatrix(conf, weightView, initializeParams));
        conf.addVariable(WEIGHT_KEY);
        return params;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        long length = this.numParams(conf);
        INDArray weightGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((long)0L), NDArrayIndex.interval((long)0L, (long)length)}).reshape('f', this.weightShape);
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        out.put(WEIGHT_KEY, weightGradientView);
        return out;
    }

    protected INDArray createWeightMatrix(NeuralNetConfiguration conf, INDArray weightParamView, boolean initializeParameters) {
        PReLULayer layerConf = (PReLULayer)conf.getLayer();
        if (initializeParameters) {
            Distribution dist = Distributions.createDistribution(layerConf.getDist());
            return WeightInitUtil.initWeights((double)layerConf.getNIn(), (double)layerConf.getNOut(), this.weightShape, layerConf.getWeightInit(), dist, weightParamView);
        }
        return WeightInitUtil.reshapeWeights(this.weightShape, weightParamView);
    }
}

