/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.constraint;

import java.util.Collections;
import java.util.Set;
import org.deeplearning4j.nn.conf.constraint.BaseConstraint;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Broadcast;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.Conditions;

public class MaxNormConstraint
extends BaseConstraint {
    private double maxNorm;

    private MaxNormConstraint() {
    }

    public MaxNormConstraint(double maxNorm, Set<String> paramNames, int ... dimensions) {
        super(paramNames, 1.0E-6, dimensions);
        this.maxNorm = maxNorm;
    }

    public MaxNormConstraint(double maxNorm, int ... dimensions) {
        this(maxNorm, Collections.emptySet(), dimensions);
    }

    @Override
    public void apply(INDArray param) {
        INDArray norm = param.norm2(this.dimensions);
        INDArray clipped = norm.unsafeDuplication();
        BooleanIndexing.replaceWhere((INDArray)clipped, (Number)this.maxNorm, (Condition)Conditions.greaterThan((Number)this.maxNorm));
        norm.addi((Number)this.epsilon);
        clipped.divi(norm);
        Broadcast.mul((INDArray)param, (INDArray)clipped, (INDArray)param, (int[])MaxNormConstraint.getBroadcastDims(this.dimensions, param.rank()));
    }

    @Override
    public MaxNormConstraint clone() {
        return new MaxNormConstraint(this.maxNorm, this.params, this.dimensions);
    }

    public double getMaxNorm() {
        return this.maxNorm;
    }

    public void setMaxNorm(double maxNorm) {
        this.maxNorm = maxNorm;
    }

    @Override
    public String toString() {
        return "MaxNormConstraint(maxNorm=" + this.getMaxNorm() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxNormConstraint)) {
            return false;
        }
        MaxNormConstraint other = (MaxNormConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Double.compare(this.getMaxNorm(), other.getMaxNorm()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MaxNormConstraint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $maxNorm = Double.doubleToLongBits(this.getMaxNorm());
        result = result * 59 + (int)($maxNorm >>> 32 ^ $maxNorm);
        return result;
    }
}

