/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastCopyOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.LegacyPooling2D;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;

public class ConvolutionUtils {
    private static final int[] ONES = new int[]{1, 1};

    private ConvolutionUtils() {
    }

    public static int[] getOutputSize(INDArray inputData, int[] kernel, int[] strides, int[] padding, ConvolutionMode convolutionMode) {
        return ConvolutionUtils.getOutputSize(inputData, kernel, strides, padding, convolutionMode, ONES);
    }

    public static int[] getDeconvolutionOutputSize(INDArray inputData, int[] kernel, int[] strides, int[] padding, ConvolutionMode convolutionMode, int[] dilation) {
        int hIn = (int)inputData.size(2);
        int wIn = (int)inputData.size(3);
        int[] eKernel = ConvolutionUtils.effectiveKernelSize(kernel, dilation);
        boolean atrous = eKernel == kernel;
        int[] inShape = new int[]{hIn, wIn};
        ConvolutionUtils.validateShapes(inputData, kernel, strides, padding, convolutionMode, dilation, inShape, atrous);
        if (convolutionMode == ConvolutionMode.Same) {
            int hOut = strides[0] * hIn;
            int wOut = strides[1] * wIn;
            return new int[]{hOut, wOut};
        }
        int hOut = strides[0] * (hIn - 1) + eKernel[0] - 2 * padding[0];
        int wOut = strides[1] * (wIn - 1) + eKernel[1] - 2 * padding[1];
        return new int[]{hOut, wOut};
    }

    public static int[] getOutputSize(INDArray inputData, int[] kernel, int[] strides, int[] padding, ConvolutionMode convolutionMode, int[] dilation) {
        int inH = (int)inputData.size(2);
        int inW = (int)inputData.size(3);
        int[] eKernel = ConvolutionUtils.effectiveKernelSize(kernel, dilation);
        boolean atrous = eKernel == kernel;
        int[] inShape = new int[]{inH, inW};
        ConvolutionUtils.validateShapes(inputData, eKernel, strides, padding, convolutionMode, dilation, inShape, atrous);
        if (convolutionMode == ConvolutionMode.Same) {
            int outH = (int)Math.ceil((double)inH / (double)strides[0]);
            int outW = (int)Math.ceil((double)inW / (double)strides[1]);
            return new int[]{outH, outW};
        }
        int hOut = (inH - eKernel[0] + 2 * padding[0]) / strides[0] + 1;
        int wOut = (inW - eKernel[1] + 2 * padding[1]) / strides[1] + 1;
        return new int[]{hOut, wOut};
    }

    public static void validateShapes(INDArray inputData, int[] eKernel, int[] strides, int[] padding, ConvolutionMode convolutionMode, int[] dilation, int[] inShape, boolean atrous) {
        int inH = inShape[0];
        int inW = inShape[1];
        if (convolutionMode != ConvolutionMode.Same && (eKernel[0] <= 0 || eKernel[0] > inH + 2 * padding[0])) {
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid input data or configuration: ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel height and input height must satisfy 0 < ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel height <= input height + 2 * padding height. \nGot ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel height = ").append(eKernel[0]).append(", input height = ").append(inH).append(" and padding height = ").append(padding[0]).append(" which do not satisfy 0 < ").append(eKernel[0]).append(" <= ").append(inH + 2 * padding[0]).append(ConvolutionUtils.getCommonErrorMsg(inputData, eKernel, strides, padding, dilation));
            throw new DL4JInvalidInputException(sb.toString());
        }
        if (convolutionMode != ConvolutionMode.Same && (eKernel[1] <= 0 || eKernel[1] > inW + 2 * padding[1])) {
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid input data or configuration: ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel width and input width must satisfy  0 < kernel width <= input width + 2 * padding width. ");
            sb.append("\nGot ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel width = ").append(eKernel[1]).append(", input width = ").append(inW).append(" and padding width = ").append(padding[1]).append(" which do not satisfy 0 < ").append(eKernel[1]).append(" <= ").append(inW + 2 * padding[1]).append("\nInput size: [numExamples,inputDepth,inputHeight,inputWidth]=").append(Arrays.toString(inputData.shape())).append(ConvolutionUtils.getCommonErrorMsg(inputData, eKernel, strides, padding, dilation));
            throw new DL4JInvalidInputException(sb.toString());
        }
        if (eKernel.length == 3 && convolutionMode != ConvolutionMode.Same && (eKernel[2] <= 0 || eKernel[2] > inShape[2] + 2 * padding[2])) {
            int inD = inShape[2];
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid input data or configuration: ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel channels and input channels must satisfy 0 < ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel channels <= input channels + 2 * padding channels. \nGot ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel channels = ").append(eKernel[2]).append(", input channels = ").append(inD).append(" and padding height = ").append(padding[2]).append(" which do not satisfy 0 < ").append(eKernel[2]).append(" <= ").append(inD + 2 * padding[2]).append(ConvolutionUtils.getCommonErrorMsg(inputData, eKernel, strides, padding, dilation));
            throw new DL4JInvalidInputException(sb.toString());
        }
        if (convolutionMode == ConvolutionMode.Strict) {
            if ((inH - eKernel[0] + 2 * padding[0]) % strides[0] != 0) {
                double d = (double)(inH - eKernel[0] + 2 * padding[0]) / (double)strides[0] + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inH / (double)strides[0]);
                StringBuilder sb = new StringBuilder();
                sb.append("Invalid input data or configuration: Combination of kernel size, stride and padding are not valid for given input height, using ConvolutionMode.Strict\n").append("ConvolutionMode.Strict requires: output height = (input height - kernelSize + 2*padding)/stride + 1 to be an integer. Got: (").append(inH).append(" - ").append(eKernel[0]).append(" + 2*").append(padding[0]).append(")/").append(strides[0]).append(" + 1 = ").append(str).append("\n").append("See \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\n").append("To truncate/crop the input, such that output height = floor(").append(str).append(") = ").append(truncated).append(", use ConvolutionType.Truncate.\n").append("Alternatively use ConvolutionType.Same, which will use padding to give an output height of ceil(").append(inH).append("/").append(strides[0]).append(")=").append(sameSize).append(ConvolutionUtils.getCommonErrorMsg(inputData, eKernel, strides, padding, dilation));
                throw new DL4JInvalidConfigException(sb.toString());
            }
            if ((inW - eKernel[1] + 2 * padding[1]) % strides[1] != 0) {
                double d = (double)(inW - eKernel[1] + 2 * padding[1]) / (double)strides[1] + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inW / (double)strides[1]);
                StringBuilder sb = new StringBuilder();
                sb.append("Invalid input data or configuration: Combination of kernel size, stride and padding are not valid for given input width, using ConvolutionMode.Strict\n").append("ConvolutionMode.Strict requires: output width = (input - kernelSize + 2*padding)/stride + 1 to be an integer. Got: (").append(inW).append(" - ").append(eKernel[1]).append(" + 2*").append(padding[1]).append(")/").append(strides[1]).append(" + 1 = ").append(str).append("\n").append("See \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\n").append("To truncate/crop the input, such that output width = floor(").append(str).append(") = ").append(truncated).append(", use ConvolutionType.Truncate.\n").append("Alternatively use ConvolutionType.Same, which will use padding to give an output width of ceil(").append(inW).append("/").append(strides[1]).append(")=").append(sameSize).append(ConvolutionUtils.getCommonErrorMsg(inputData, eKernel, strides, padding, dilation));
                throw new DL4JInvalidConfigException(sb.toString());
            }
            if (eKernel.length == 3 && (inShape[2] - eKernel[2] + 2 * padding[2]) % strides[2] != 0) {
                int inD = inShape[2];
                double d = (double)(inD - eKernel[2] + 2 * padding[2]) / (double)strides[2] + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inD / (double)strides[2]);
                StringBuilder sb = new StringBuilder();
                sb.append("Invalid input data or configuration: Combination of kernel size, stride and padding are not valid for given input width, using ConvolutionMode.Strict\n").append("ConvolutionMode.Strict requires: output channels = (input - kernelSize + 2*padding)/stride + 1 to be an integer. Got: (").append(inD).append(" - ").append(eKernel[2]).append(" + 2*").append(padding[2]).append(")/").append(strides[1]).append(" + 1 = ").append(str).append("\n").append("See \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\n").append("To truncate/crop the input, such that output width = floor(").append(str).append(") = ").append(truncated).append(", use ConvolutionType.Truncate.\n").append("Alternatively use ConvolutionType.Same, which will use padding to give an output width of ceil(").append(inW).append("/").append(strides[2]).append(")=").append(sameSize).append(ConvolutionUtils.getCommonErrorMsg(inputData, eKernel, strides, padding, dilation));
                throw new DL4JInvalidConfigException(sb.toString());
            }
        }
    }

    public static int[] effectiveKernelSize(int[] kernel, int[] dilation) {
        if (kernel.length == 2) {
            if (dilation[0] == 1 && dilation[1] == 1) {
                return kernel;
            }
            return new int[]{kernel[0] + (kernel[0] - 1) * (dilation[0] - 1), kernel[1] + (kernel[1] - 1) * (dilation[1] - 1)};
        }
        if (kernel.length == 3) {
            if (dilation[0] == 1 && dilation[1] == 1 && dilation[2] == 1) {
                return kernel;
            }
            return new int[]{kernel[0] + (kernel[0] - 1) * (dilation[0] - 1), kernel[1] + (kernel[1] - 1) * (dilation[1] - 1), kernel[2] + (kernel[2] - 1) * (dilation[2] - 1)};
        }
        throw new IllegalArgumentException("Kernel size has to be either two or three, got: " + kernel.length);
    }

    private static String getCommonErrorMsg(INDArray inputData, int[] kernel, int[] strides, int[] padding, int[] dilation) {
        String s = "\nInput size: [numExamples,inputDepth,inputHeight,inputWidth]=" + Arrays.toString(inputData.shape()) + ", inputKernel=" + Arrays.toString(kernel);
        if (dilation[0] != 1 || dilation[1] != 1) {
            int[] effectiveKernel = ConvolutionUtils.effectiveKernelSize(kernel, dilation);
            s = s + ", effectiveKernelGivenDilation=" + Arrays.toString(effectiveKernel);
        }
        return s + ", strides=" + Arrays.toString(strides) + ", padding=" + Arrays.toString(padding) + ", dilation=" + Arrays.toString(dilation);
    }

    public static int[] getSameModeTopLeftPadding(int[] outSize, int[] inSize, int[] kernel, int[] strides, int[] dilation) {
        int[] eKernel = ConvolutionUtils.effectiveKernelSize(kernel, dilation);
        int[] outPad = new int[]{((outSize[0] - 1) * strides[0] + eKernel[0] - inSize[0]) / 2, ((outSize[1] - 1) * strides[1] + eKernel[1] - inSize[1]) / 2};
        Preconditions.checkState((outPad[0] >= 0 && outPad[1] >= 0 ? 1 : 0) != 0, (String)"Invalid padding values calculated: %s - layer configuration is invalid? Input size %s, output size %s, kernel %s, strides %s, dilation %s", (Object)outPad, (Object)inSize, (Object)outSize, (Object)kernel, (Object)strides, (Object)dilation);
        return outPad;
    }

    public static int[] getSameModeBottomRightPadding(int[] outSize, int[] inSize, int[] kernel, int[] strides, int[] dilation) {
        int[] eKernel = ConvolutionUtils.effectiveKernelSize(kernel, dilation);
        int[] outPad = new int[]{((outSize[0] - 1) * strides[0] + eKernel[0] - inSize[0] + 1) / 2, ((outSize[1] - 1) * strides[1] + eKernel[1] - inSize[1] + 1) / 2};
        Preconditions.checkState((outPad[0] >= 0 && outPad[1] >= 0 ? 1 : 0) != 0, (String)"Invalid padding values calculated: %s - layer configuration is invalid? Input size %s, output size %s, kernel %s, strides %s, dilation %s", (Object)outPad, (Object)inSize, (Object)outSize, (Object)kernel, (Object)strides, (Object)dilation);
        return outPad;
    }

    public static int[] getHeightAndWidth(NeuralNetConfiguration conf) {
        return ConvolutionUtils.getHeightAndWidth(((ConvolutionLayer)conf.getLayer()).getKernelSize());
    }

    public static long numFeatureMap(NeuralNetConfiguration conf) {
        return ((ConvolutionLayer)conf.getLayer()).getNOut();
    }

    public static int[] getHeightAndWidth(int[] shape) {
        if (shape.length < 2) {
            throw new IllegalArgumentException("No width and height able to be found: array must be at least length 2");
        }
        return new int[]{shape[shape.length - 1], shape[shape.length - 2]};
    }

    public static int numChannels(int[] shape) {
        if (shape.length < 4) {
            return 1;
        }
        return shape[1];
    }

    public static void validateConvolutionModePadding(ConvolutionMode mode, int[] padding) {
        if (mode == ConvolutionMode.Same) {
            boolean nullPadding = true;
            for (int i : padding) {
                if (i == 0) continue;
                nullPadding = false;
            }
            if (!nullPadding) {
                throw new IllegalArgumentException("Padding cannot be used when using the `same' convolution mode");
            }
        }
    }

    public static void validateCnnKernelStridePadding(int[] kernelSize, int[] stride, int[] padding) {
        if (kernelSize == null || kernelSize.length != 2) {
            throw new IllegalStateException("Invalid kernel size: expected int[] of length 2, got " + (kernelSize == null ? null : Arrays.toString(kernelSize)));
        }
        if (stride == null || stride.length != 2) {
            throw new IllegalStateException("Invalid stride configuration: expected int[] of length 2, got " + (stride == null ? null : Arrays.toString(stride)));
        }
        if (padding == null || padding.length != 2) {
            throw new IllegalStateException("Invalid padding configuration: expected int[] of length 2, got " + (padding == null ? null : Arrays.toString(padding)));
        }
        if (kernelSize[0] <= 0 || kernelSize[1] <= 0) {
            throw new IllegalStateException("Invalid kernel size: values must be positive (> 0) for all dimensions. Got: " + Arrays.toString(kernelSize));
        }
        if (stride[0] <= 0 || stride[1] <= 0) {
            throw new IllegalStateException("Invalid stride configuration: values must be positive (> 0) for all dimensions. Got: " + Arrays.toString(stride));
        }
        if (padding[0] < 0 || padding[1] < 0) {
            throw new IllegalStateException("Invalid padding configuration: values must be >= 0 for all dimensions. Got: " + Arrays.toString(padding));
        }
    }

    public static INDArray reshape4dTo2d(INDArray in, LayerWorkspaceMgr workspaceMgr, ArrayType type) {
        if (in.rank() != 4) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 4, got rank " + in.rank() + " with shape " + Arrays.toString(in.shape()));
        }
        long[] shape = in.shape();
        INDArray out = in.permute(new int[]{0, 2, 3, 1});
        if (out.ordering() != 'c' || !Shape.strideDescendingCAscendingF((INDArray)out)) {
            out = out.dup('c');
        }
        return out.reshape('c', new long[]{shape[0] * shape[2] * shape[3], shape[1]});
    }

    public static INDArray reshape2dTo4d(INDArray in2d, int[] toShape, LayerWorkspaceMgr workspaceMgr, ArrayType type) {
        if (in2d.rank() != 2) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 2");
        }
        if (toShape.length != 4) {
            throw new IllegalArgumentException("Invalid input: expect toShape with 4 elements: got " + Arrays.toString(toShape));
        }
        if (in2d.ordering() != 'c' || !Shape.hasDefaultStridesForShape((INDArray)in2d)) {
            in2d = workspaceMgr.dup(type, in2d, 'c');
        }
        INDArray out = in2d.reshape('c', new int[]{toShape[0], toShape[2], toShape[3], toShape[1]});
        return workspaceMgr.leverageTo(type, out.permute(new int[]{0, 3, 1, 2}));
    }

    public static INDArray reshapeMaskIfRequired(INDArray mask, INDArray output, LayerWorkspaceMgr workspaceMgr, ArrayType type) {
        if (mask == null) {
            return null;
        }
        if (mask.rank() == 2) {
            return ConvolutionUtils.adapt2dMask(mask, output, workspaceMgr, type);
        }
        if (mask.rank() == 3) {
            return ConvolutionUtils.reshape3dMask(mask, workspaceMgr, type);
        }
        return ConvolutionUtils.reshape4dTo2d(mask, workspaceMgr, type);
    }

    public static INDArray adapt2dMask(INDArray mask, INDArray output, LayerWorkspaceMgr workspaceMgr, ArrayType type) {
        long[] s = output.shape();
        INDArray bMask = workspaceMgr.create(type, new long[]{s[0], 1L, s[2], s[3]}, 'c');
        Nd4j.getExecutioner().exec((Op)new BroadcastCopyOp(bMask, mask, bMask, new int[]{0, 1}));
        INDArray bMaskPermute = bMask.permute(new int[]{0, 2, 3}).dup('c');
        return workspaceMgr.leverageTo(type, bMaskPermute.reshape('c', new long[]{s[0] * s[2] * s[3], 1L}));
    }

    public static INDArray reshape3dMask(INDArray mask, LayerWorkspaceMgr workspaceMgr, ArrayType type) {
        if (mask.ordering() != 'c' || !Shape.hasDefaultStridesForShape((INDArray)mask)) {
            mask = workspaceMgr.dup(type, mask, 'c');
        }
        return mask.reshape('c', new long[]{mask.length(), 1L});
    }

    public static INDArray reshape4dMask(INDArray mask, LayerWorkspaceMgr workspaceMgr, ArrayType arrayType) {
        return ConvolutionUtils.reshape4dTo2d(mask, workspaceMgr, arrayType);
    }

    public static int[] getHWDFromInputType(InputType inputType) {
        int inDepth;
        int inW;
        int inH;
        if (inputType instanceof InputType.InputTypeConvolutional) {
            InputType.InputTypeConvolutional conv = (InputType.InputTypeConvolutional)inputType;
            inH = (int)conv.getHeight();
            inW = (int)conv.getWidth();
            inDepth = (int)conv.getChannels();
        } else if (inputType instanceof InputType.InputTypeConvolutionalFlat) {
            InputType.InputTypeConvolutionalFlat conv = (InputType.InputTypeConvolutionalFlat)inputType;
            inH = (int)conv.getHeight();
            inW = (int)conv.getWidth();
            inDepth = (int)conv.getDepth();
        } else {
            throw new IllegalStateException("Invalid input type: expected InputTypeConvolutional or InputTypeConvolutionalFlat. Got: " + inputType);
        }
        return new int[]{inH, inW, inDepth};
    }

    public static INDArray cnn1dMaskReduction(INDArray in, int kernel, int stride, int padding, int dilation, ConvolutionMode cm) {
        int[] outSize;
        Preconditions.checkState((in.rank() == 2 ? 1 : 0) != 0, (String)"Rank must be 2 for cnn1d mask array - shape ", (Object)in.shape());
        if (cm == ConvolutionMode.Same && stride == 1) {
            return in;
        }
        if (!Shape.hasDefaultStridesForShape((INDArray)in)) {
            in = in.dup();
        }
        INDArray reshaped4d = in.reshape(new long[]{in.size(0), 1L, in.size(1), 1L});
        int[] k = new int[]{kernel, 1};
        int[] s = new int[]{stride, 1};
        int[] d = new int[]{dilation, 1};
        if (cm == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(reshaped4d, k, s, null, cm, d);
        } else {
            int[] pad = new int[]{padding, 0};
            outSize = ConvolutionUtils.getOutputSize(reshaped4d, k, s, pad, cm, d);
        }
        int outH = outSize[0];
        INDArray output = Nd4j.createUninitialized((int[])new int[]{(int)in.size(0), 1, outH, 1}, (char)'c');
        LegacyPooling2D op = new LegacyPooling2D(reshaped4d, kernel, 1, stride, 1, padding, 0, dilation, 1, cm == ConvolutionMode.Same, LegacyPooling2D.Pooling2DType.MAX, 0.0, output);
        Nd4j.getExecutioner().exec((Op)op);
        return output.reshape('c', new long[]{in.size(0), outH});
    }

    public static INDArray cnn2dMaskReduction(INDArray inMask, int[] kernel, int[] stride, int[] padding, int[] dilation, ConvolutionMode convolutionMode) {
        int[] d;
        int[] p;
        int[] s;
        int[] k;
        if (inMask.rank() != 4) {
            throw new IllegalStateException("Expected rank 4 mask array for 2D CNN layers. Mask arrays for 2D CNN layers must have shape [batchSize,channels,X,Y] where X = (1 or activationsHeight) and Y = (1 or activationsWidth): Got rank " + inMask.rank() + " array with shape " + Arrays.toString(inMask.shape()));
        }
        if (convolutionMode == ConvolutionMode.Same && stride[0] == 1 && stride[1] == 1) {
            return inMask;
        }
        if (inMask.size(2) == 1L && inMask.size(3) == 1L) {
            return inMask;
        }
        if (inMask.size(3) == 1L) {
            k = new int[]{kernel[0], 1};
            s = new int[]{stride[0], 1};
            p = new int[]{padding[0], 0};
            d = new int[]{dilation[0], 1};
        } else if (inMask.size(2) == 1L) {
            k = new int[]{1, kernel[1]};
            s = new int[]{1, stride[1]};
            p = new int[]{0, padding[1]};
            d = new int[]{1, dilation[1]};
        } else {
            k = kernel;
            s = stride;
            p = padding;
            d = dilation;
        }
        int[] outSize = ConvolutionUtils.getOutputSize(inMask, k, s, p, convolutionMode, d);
        boolean allEq = true;
        for (int i = 0; i < outSize.length; ++i) {
            if ((long)outSize[i] == inMask.size(i)) continue;
            allEq = false;
            break;
        }
        if (allEq) {
            return inMask;
        }
        long[] outArraySize = new long[]{inMask.size(0), inMask.size(1), outSize[0], outSize[1]};
        INDArray outMask = Nd4j.createUninitialized((long[])outArraySize);
        LegacyPooling2D op = new LegacyPooling2D(inMask, kernel[0], kernel[1], stride[0], stride[1], padding[0], padding[1], dilation[0], dilation[1], convolutionMode == ConvolutionMode.Same, LegacyPooling2D.Pooling2DType.MAX, 0.0, outMask);
        Nd4j.getExecutioner().exec((Op)op);
        return outMask;
    }
}

