/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Convolution1DUtils {
    private static final int ONE = 1;

    private Convolution1DUtils() {
    }

    public static int getOutputSize(INDArray inputData, int kernel, int strides, int padding, ConvolutionMode convolutionMode) {
        return Convolution1DUtils.getOutputSize(inputData, kernel, strides, padding, convolutionMode, 1);
    }

    public static int getOutputSize(int inH, int kernel, int strides, int padding, ConvolutionMode convolutionMode, int dilation) {
        int eKernel = Convolution1DUtils.effectiveKernelSize(kernel, dilation);
        if (convolutionMode == ConvolutionMode.Same) {
            return (int)Math.ceil((double)inH / (double)strides);
        }
        return (inH - eKernel + 2 * padding) / strides + 1;
    }

    public static int getOutputSize(INDArray inputData, int kernel, int strides, int padding, ConvolutionMode convolutionMode, int dilation) {
        int inH = (int)inputData.size(2);
        int eKernel = Convolution1DUtils.effectiveKernelSize(kernel, dilation);
        boolean atrous = eKernel == kernel;
        Convolution1DUtils.validateShapes(inputData, eKernel, strides, padding, convolutionMode, dilation, inH, atrous);
        if (convolutionMode == ConvolutionMode.Same) {
            int outH = (int)Math.ceil((double)inH / (double)strides);
            return outH;
        }
        int outH = (inH - eKernel + 2 * padding) / strides + 1;
        return outH;
    }

    public static void validateShapes(INDArray inputData, int eKernel, int strides, int padding, ConvolutionMode convolutionMode, int dilation, int inShape, boolean atrous) {
        int inH = inShape;
        if (convolutionMode != ConvolutionMode.Same && (eKernel <= 0 || eKernel > inH + 2 * padding)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid input data or configuration: ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel height and input height must satisfy 0 < ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel height <= input height + 2 * padding height. \nGot ");
            if (atrous) {
                sb.append("effective ");
            }
            sb.append("kernel height = ").append(eKernel).append(", input height = ").append(inH).append(" and padding height = ").append(padding).append(" which do not satisfy 0 < ").append(eKernel).append(" <= ").append(inH + 2 * padding).append(Convolution1DUtils.getCommonErrorMsg(inputData, eKernel, strides, padding, dilation));
            throw new DL4JInvalidInputException(sb.toString());
        }
        if (convolutionMode == ConvolutionMode.Strict && (inH - eKernel + 2 * padding) % strides != 0) {
            double d = (double)(inH - eKernel + 2 * padding) / (double)strides + 1.0;
            String str = String.format("%.2f", d);
            int truncated = (int)d;
            int sameSize = (int)Math.ceil((double)inH / (double)strides);
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid input data or configuration: Combination of kernel size, stride and padding are not valid for given input height, using ConvolutionMode.Strict\n").append("ConvolutionMode.Strict requires: output height = (input height - kernelSize + 2*padding)/stride + 1 to be an integer. Got: (").append(inH).append(" - ").append(eKernel).append(" + 2*").append(padding).append(")/").append(strides).append(" + 1 = ").append(str).append("\n").append("See \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\n").append("To truncate/crop the input, such that output height = floor(").append(str).append(") = ").append(truncated).append(", use ConvolutionType.Truncate.\n").append("Alternatively use ConvolutionType.Same, which will use padding to give an output height of ceil(").append(inH).append("/").append(strides).append(")=").append(sameSize).append(Convolution1DUtils.getCommonErrorMsg(inputData, eKernel, strides, padding, dilation));
            throw new DL4JInvalidConfigException(sb.toString());
        }
    }

    public static int effectiveKernelSize(int kernel, int dilation) {
        if (dilation == 1) {
            return kernel;
        }
        return kernel + (kernel - 1) * (dilation - 1);
    }

    private static String getCommonErrorMsg(INDArray inputData, int kernel, int strides, int padding, int dilation) {
        String s = "\nInput size: [numExamples,inputDepth,inputHeight,inputWidth]=" + Arrays.toString(inputData.shape()) + ", inputKernel=" + kernel;
        if (dilation != 1) {
            int effectiveKernel = Convolution1DUtils.effectiveKernelSize(kernel, dilation);
            s = s + ", effectiveKernelGivenDilation=" + effectiveKernel;
        }
        return s + ", stride=" + strides + ", padding=" + padding + ", dilation=" + dilation;
    }

    public static void validateConvolutionModePadding(ConvolutionMode mode, int padding) {
        if (mode == ConvolutionMode.Same) {
            boolean nullPadding = true;
            if (padding != 0) {
                nullPadding = false;
            }
            if (!nullPadding) {
                throw new IllegalArgumentException("Padding cannot be used when using the `same' convolution mode");
            }
        }
    }

    public static int getSameModeTopLeftPadding(int outSize, int inSize, int kernel, int strides, int dilation) {
        int eKernel = Convolution1DUtils.effectiveKernelSize(kernel, dilation);
        int outPad = ((outSize - 1) * strides + eKernel - inSize) / 2;
        Preconditions.checkState((outPad >= 0 ? 1 : 0) != 0, (String)"Invalid padding values calculated: %s - layer configuration is invalid? Input size %s, output size %s, kernel %s, strides %s, dilation %s", (Object)outPad, (Object)inSize, (Object)outSize, (Object)kernel, (Object)strides, (Object)dilation);
        return outPad;
    }

    public static void validateCnn1DKernelStridePadding(int kernel, int stride, int padding) {
        if (kernel <= 0) {
            throw new IllegalStateException("Invalid kernel size: value must be positive (> 0). Got: " + kernel);
        }
        if (stride <= 0) {
            throw new IllegalStateException("Invalid kernel size: value must be positive (> 0). Got: " + stride);
        }
        if (padding < 0) {
            throw new IllegalStateException("Invalid kernel size: value must be positive (> 0). Got: " + padding);
        }
    }
}

