/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.transferlearning;

import java.io.IOException;
import java.util.List;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.dropout.Dropout;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.conf.weightnoise.IWeightNoise;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.primitives.Optional;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FineTuneConfiguration {
    protected IActivation activationFn;
    protected WeightInit weightInit;
    protected Double biasInit;
    protected Distribution dist;
    protected Double l1;
    protected Double l2;
    protected Double l1Bias;
    protected Double l2Bias;
    protected Optional<IDropout> dropout;
    protected Optional<IWeightNoise> weightNoise;
    protected IUpdater updater;
    protected IUpdater biasUpdater;
    protected Boolean miniBatch;
    protected Integer maxNumLineSearchIterations;
    protected Long seed;
    protected OptimizationAlgorithm optimizationAlgo;
    protected StepFunction stepFunction;
    protected Boolean minimize;
    protected Optional<GradientNormalization> gradientNormalization;
    protected Double gradientNormalizationThreshold;
    protected ConvolutionMode convolutionMode;
    protected ConvolutionLayer.AlgoMode cudnnAlgoMode;
    protected Optional<List<LayerConstraint>> constraints;
    protected Boolean pretrain;
    protected Boolean backprop;
    protected BackpropType backpropType;
    protected Integer tbpttFwdLength;
    protected Integer tbpttBackLength;
    protected WorkspaceMode trainingWorkspaceMode;
    protected WorkspaceMode inferenceWorkspaceMode;

    public static Builder builder() {
        return new Builder();
    }

    public NeuralNetConfiguration appliedNeuralNetConfiguration(NeuralNetConfiguration nnc) {
        this.applyToNeuralNetConfiguration(nnc);
        nnc = new NeuralNetConfiguration.Builder(nnc.clone()).build();
        return nnc;
    }

    public void applyToNeuralNetConfiguration(NeuralNetConfiguration nnc) {
        Layer l = nnc.getLayer();
        Object originalUpdater = null;
        WeightInit origWeightInit = null;
        if (l != null) {
            if (this.dropout != null) {
                l.setIDropout((IDropout)this.dropout.orElse(null));
            }
            if (this.constraints != null) {
                l.setConstraints((List)this.constraints.orElse(null));
            }
        }
        if (l != null && l instanceof BaseLayer) {
            BaseLayer bl = (BaseLayer)l;
            origWeightInit = bl.getWeightInit();
            if (this.activationFn != null) {
                bl.setActivationFn(this.activationFn);
            }
            if (this.weightInit != null) {
                bl.setWeightInit(this.weightInit);
            }
            if (this.biasInit != null) {
                bl.setBiasInit(this.biasInit);
            }
            if (this.dist != null) {
                bl.setDist(this.dist);
            }
            if (this.l1 != null) {
                bl.setL1(this.l1);
            }
            if (this.l2 != null) {
                bl.setL2(this.l2);
            }
            if (this.l1Bias != null) {
                bl.setL1Bias(this.l1Bias);
            }
            if (this.l2Bias != null) {
                bl.setL2Bias(this.l2Bias);
            }
            if (this.gradientNormalization != null) {
                bl.setGradientNormalization((GradientNormalization)((Object)this.gradientNormalization.orElse(null)));
            }
            if (this.gradientNormalizationThreshold != null) {
                bl.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
            }
            if (this.updater != null) {
                bl.setIUpdater(this.updater);
            }
            if (this.biasUpdater != null) {
                bl.setBiasUpdater(this.biasUpdater);
            }
            if (this.weightNoise != null) {
                bl.setWeightNoise((IWeightNoise)this.weightNoise.orElse(null));
            }
        }
        if (this.miniBatch != null) {
            nnc.setMiniBatch(this.miniBatch);
        }
        if (this.maxNumLineSearchIterations != null) {
            nnc.setMaxNumLineSearchIterations(this.maxNumLineSearchIterations);
        }
        if (this.seed != null) {
            nnc.setSeed(this.seed);
        }
        if (this.optimizationAlgo != null) {
            nnc.setOptimizationAlgo(this.optimizationAlgo);
        }
        if (this.stepFunction != null) {
            nnc.setStepFunction(this.stepFunction);
        }
        if (this.minimize != null) {
            nnc.setMinimize(this.minimize);
        }
        if (this.convolutionMode != null && l instanceof ConvolutionLayer) {
            ((ConvolutionLayer)l).setConvolutionMode(this.convolutionMode);
        }
        if (this.cudnnAlgoMode != null && l instanceof ConvolutionLayer) {
            ((ConvolutionLayer)l).setCudnnAlgoMode(this.cudnnAlgoMode);
        }
        if (this.convolutionMode != null && l instanceof SubsamplingLayer) {
            ((SubsamplingLayer)l).setConvolutionMode(this.convolutionMode);
        }
        if (l != null && l instanceof BaseLayer && origWeightInit == WeightInit.DISTRIBUTION && this.weightInit != null && this.weightInit != WeightInit.DISTRIBUTION) {
            ((BaseLayer)l).setDist(null);
        }
        if (l != null) {
            LayerValidation.generalValidation(l.getLayerName(), l, FineTuneConfiguration.get(this.dropout), this.l2, this.l2Bias, this.l1, this.l1Bias, this.dist, FineTuneConfiguration.get(this.constraints), null, null);
        }
    }

    private static <T> T get(Optional<T> optional) {
        if (optional == null) {
            return null;
        }
        return (T)optional.orElse(null);
    }

    public void applyToMultiLayerConfiguration(MultiLayerConfiguration conf) {
        if (this.pretrain != null) {
            conf.setPretrain(this.pretrain);
        }
        if (this.backprop != null) {
            conf.setBackprop(this.backprop);
        }
        if (this.backpropType != null) {
            conf.setBackpropType(this.backpropType);
        }
        if (this.tbpttFwdLength != null) {
            conf.setTbpttFwdLength(this.tbpttFwdLength);
        }
        if (this.tbpttBackLength != null) {
            conf.setTbpttBackLength(this.tbpttBackLength);
        }
    }

    public void applyToComputationGraphConfiguration(ComputationGraphConfiguration conf) {
        if (this.pretrain != null) {
            conf.setPretrain(this.pretrain);
        }
        if (this.backprop != null) {
            conf.setBackprop(this.backprop);
        }
        if (this.backpropType != null) {
            conf.setBackpropType(this.backpropType);
        }
        if (this.tbpttFwdLength != null) {
            conf.setTbpttFwdLength(this.tbpttFwdLength);
        }
        if (this.tbpttBackLength != null) {
            conf.setTbpttBackLength(this.tbpttBackLength);
        }
    }

    public NeuralNetConfiguration.Builder appliedNeuralNetConfigurationBuilder() {
        NeuralNetConfiguration.Builder confBuilder = new NeuralNetConfiguration.Builder();
        if (this.activationFn != null) {
            confBuilder.setActivationFn(this.activationFn);
        }
        if (this.weightInit != null) {
            confBuilder.setWeightInit(this.weightInit);
        }
        if (this.biasInit != null) {
            confBuilder.setBiasInit(this.biasInit);
        }
        if (this.dist != null) {
            confBuilder.setDist(this.dist);
        }
        if (this.l1 != null) {
            confBuilder.setL1(this.l1);
        }
        if (this.l2 != null) {
            confBuilder.setL2(this.l2);
        }
        if (this.l1Bias != null) {
            confBuilder.setL1Bias(this.l1Bias);
        }
        if (this.l2Bias != null) {
            confBuilder.setL2Bias(this.l2Bias);
        }
        if (this.dropout != null) {
            confBuilder.setIdropOut((IDropout)this.dropout.orElse(null));
        }
        if (this.updater != null) {
            confBuilder.updater(this.updater);
        }
        if (this.biasUpdater != null) {
            confBuilder.biasUpdater(this.biasUpdater);
        }
        if (this.miniBatch != null) {
            confBuilder.setMiniBatch(this.miniBatch);
        }
        if (this.maxNumLineSearchIterations != null) {
            confBuilder.setMaxNumLineSearchIterations(this.maxNumLineSearchIterations);
        }
        if (this.seed != null) {
            confBuilder.setSeed(this.seed);
        }
        if (this.optimizationAlgo != null) {
            confBuilder.setOptimizationAlgo(this.optimizationAlgo);
        }
        if (this.stepFunction != null) {
            confBuilder.setStepFunction(this.stepFunction);
        }
        if (this.minimize != null) {
            confBuilder.setMinimize(this.minimize);
        }
        if (this.gradientNormalization != null) {
            confBuilder.setGradientNormalization((GradientNormalization)((Object)this.gradientNormalization.orElse(null)));
        }
        if (this.gradientNormalizationThreshold != null) {
            confBuilder.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
        }
        if (this.trainingWorkspaceMode != null) {
            confBuilder.trainingWorkspaceMode(this.trainingWorkspaceMode);
        }
        if (this.inferenceWorkspaceMode != null) {
            confBuilder.inferenceWorkspaceMode(this.inferenceWorkspaceMode);
        }
        return confBuilder;
    }

    public String toJson() {
        try {
            return NeuralNetConfiguration.mapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return NeuralNetConfiguration.mapperYaml().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static FineTuneConfiguration fromJson(String json) {
        try {
            return (FineTuneConfiguration)NeuralNetConfiguration.mapper().readValue(json, FineTuneConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FineTuneConfiguration fromYaml(String yaml) {
        try {
            return (FineTuneConfiguration)NeuralNetConfiguration.mapperYaml().readValue(yaml, FineTuneConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FineTuneConfiguration() {
    }

    public FineTuneConfiguration(IActivation activationFn, WeightInit weightInit, Double biasInit, Distribution dist, Double l1, Double l2, Double l1Bias, Double l2Bias, Optional<IDropout> dropout, Optional<IWeightNoise> weightNoise, IUpdater updater, IUpdater biasUpdater, Boolean miniBatch, Integer maxNumLineSearchIterations, Long seed, OptimizationAlgorithm optimizationAlgo, StepFunction stepFunction, Boolean minimize, Optional<GradientNormalization> gradientNormalization, Double gradientNormalizationThreshold, ConvolutionMode convolutionMode, ConvolutionLayer.AlgoMode cudnnAlgoMode, Optional<List<LayerConstraint>> constraints, Boolean pretrain, Boolean backprop, BackpropType backpropType, Integer tbpttFwdLength, Integer tbpttBackLength, WorkspaceMode trainingWorkspaceMode, WorkspaceMode inferenceWorkspaceMode) {
        this.activationFn = activationFn;
        this.weightInit = weightInit;
        this.biasInit = biasInit;
        this.dist = dist;
        this.l1 = l1;
        this.l2 = l2;
        this.l1Bias = l1Bias;
        this.l2Bias = l2Bias;
        this.dropout = dropout;
        this.weightNoise = weightNoise;
        this.updater = updater;
        this.biasUpdater = biasUpdater;
        this.miniBatch = miniBatch;
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
        this.seed = seed;
        this.optimizationAlgo = optimizationAlgo;
        this.stepFunction = stepFunction;
        this.minimize = minimize;
        this.gradientNormalization = gradientNormalization;
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
        this.convolutionMode = convolutionMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
        this.constraints = constraints;
        this.pretrain = pretrain;
        this.backprop = backprop;
        this.backpropType = backpropType;
        this.tbpttFwdLength = tbpttFwdLength;
        this.tbpttBackLength = tbpttBackLength;
        this.trainingWorkspaceMode = trainingWorkspaceMode;
        this.inferenceWorkspaceMode = inferenceWorkspaceMode;
    }

    public IActivation getActivationFn() {
        return this.activationFn;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public Double getBiasInit() {
        return this.biasInit;
    }

    public Distribution getDist() {
        return this.dist;
    }

    public Double getL1() {
        return this.l1;
    }

    public Double getL2() {
        return this.l2;
    }

    public Double getL1Bias() {
        return this.l1Bias;
    }

    public Double getL2Bias() {
        return this.l2Bias;
    }

    public Optional<IDropout> getDropout() {
        return this.dropout;
    }

    public Optional<IWeightNoise> getWeightNoise() {
        return this.weightNoise;
    }

    public IUpdater getUpdater() {
        return this.updater;
    }

    public IUpdater getBiasUpdater() {
        return this.biasUpdater;
    }

    public Boolean getMiniBatch() {
        return this.miniBatch;
    }

    public Integer getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public Long getSeed() {
        return this.seed;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public Boolean getMinimize() {
        return this.minimize;
    }

    public Optional<GradientNormalization> getGradientNormalization() {
        return this.gradientNormalization;
    }

    public Double getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public ConvolutionLayer.AlgoMode getCudnnAlgoMode() {
        return this.cudnnAlgoMode;
    }

    public Optional<List<LayerConstraint>> getConstraints() {
        return this.constraints;
    }

    public Boolean getPretrain() {
        return this.pretrain;
    }

    public Boolean getBackprop() {
        return this.backprop;
    }

    public BackpropType getBackpropType() {
        return this.backpropType;
    }

    public Integer getTbpttFwdLength() {
        return this.tbpttFwdLength;
    }

    public Integer getTbpttBackLength() {
        return this.tbpttBackLength;
    }

    public WorkspaceMode getTrainingWorkspaceMode() {
        return this.trainingWorkspaceMode;
    }

    public WorkspaceMode getInferenceWorkspaceMode() {
        return this.inferenceWorkspaceMode;
    }

    public void setActivationFn(IActivation activationFn) {
        this.activationFn = activationFn;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public void setBiasInit(Double biasInit) {
        this.biasInit = biasInit;
    }

    public void setDist(Distribution dist) {
        this.dist = dist;
    }

    public void setL1(Double l1) {
        this.l1 = l1;
    }

    public void setL2(Double l2) {
        this.l2 = l2;
    }

    public void setL1Bias(Double l1Bias) {
        this.l1Bias = l1Bias;
    }

    public void setL2Bias(Double l2Bias) {
        this.l2Bias = l2Bias;
    }

    public void setDropout(Optional<IDropout> dropout) {
        this.dropout = dropout;
    }

    public void setWeightNoise(Optional<IWeightNoise> weightNoise) {
        this.weightNoise = weightNoise;
    }

    public void setUpdater(IUpdater updater) {
        this.updater = updater;
    }

    public void setBiasUpdater(IUpdater biasUpdater) {
        this.biasUpdater = biasUpdater;
    }

    public void setMiniBatch(Boolean miniBatch) {
        this.miniBatch = miniBatch;
    }

    public void setMaxNumLineSearchIterations(Integer maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setMinimize(Boolean minimize) {
        this.minimize = minimize;
    }

    public void setGradientNormalization(Optional<GradientNormalization> gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(Double gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setCudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public void setConstraints(Optional<List<LayerConstraint>> constraints) {
        this.constraints = constraints;
    }

    public void setPretrain(Boolean pretrain) {
        this.pretrain = pretrain;
    }

    public void setBackprop(Boolean backprop) {
        this.backprop = backprop;
    }

    public void setBackpropType(BackpropType backpropType) {
        this.backpropType = backpropType;
    }

    public void setTbpttFwdLength(Integer tbpttFwdLength) {
        this.tbpttFwdLength = tbpttFwdLength;
    }

    public void setTbpttBackLength(Integer tbpttBackLength) {
        this.tbpttBackLength = tbpttBackLength;
    }

    public void setTrainingWorkspaceMode(WorkspaceMode trainingWorkspaceMode) {
        this.trainingWorkspaceMode = trainingWorkspaceMode;
    }

    public void setInferenceWorkspaceMode(WorkspaceMode inferenceWorkspaceMode) {
        this.inferenceWorkspaceMode = inferenceWorkspaceMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FineTuneConfiguration)) {
            return false;
        }
        FineTuneConfiguration other = (FineTuneConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IActivation this$activationFn = this.getActivationFn();
        IActivation other$activationFn = other.getActivationFn();
        if (this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn)) {
            return false;
        }
        WeightInit this$weightInit = this.getWeightInit();
        WeightInit other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
            return false;
        }
        Double this$biasInit = this.getBiasInit();
        Double other$biasInit = other.getBiasInit();
        if (this$biasInit == null ? other$biasInit != null : !((Object)this$biasInit).equals(other$biasInit)) {
            return false;
        }
        Distribution this$dist = this.getDist();
        Distribution other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        Double this$l1 = this.getL1();
        Double other$l1 = other.getL1();
        if (this$l1 == null ? other$l1 != null : !((Object)this$l1).equals(other$l1)) {
            return false;
        }
        Double this$l2 = this.getL2();
        Double other$l2 = other.getL2();
        if (this$l2 == null ? other$l2 != null : !((Object)this$l2).equals(other$l2)) {
            return false;
        }
        Double this$l1Bias = this.getL1Bias();
        Double other$l1Bias = other.getL1Bias();
        if (this$l1Bias == null ? other$l1Bias != null : !((Object)this$l1Bias).equals(other$l1Bias)) {
            return false;
        }
        Double this$l2Bias = this.getL2Bias();
        Double other$l2Bias = other.getL2Bias();
        if (this$l2Bias == null ? other$l2Bias != null : !((Object)this$l2Bias).equals(other$l2Bias)) {
            return false;
        }
        Optional<IDropout> this$dropout = this.getDropout();
        Optional<IDropout> other$dropout = other.getDropout();
        if (this$dropout == null ? other$dropout != null : !this$dropout.equals(other$dropout)) {
            return false;
        }
        Optional<IWeightNoise> this$weightNoise = this.getWeightNoise();
        Optional<IWeightNoise> other$weightNoise = other.getWeightNoise();
        if (this$weightNoise == null ? other$weightNoise != null : !this$weightNoise.equals(other$weightNoise)) {
            return false;
        }
        IUpdater this$updater = this.getUpdater();
        IUpdater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !this$updater.equals(other$updater)) {
            return false;
        }
        IUpdater this$biasUpdater = this.getBiasUpdater();
        IUpdater other$biasUpdater = other.getBiasUpdater();
        if (this$biasUpdater == null ? other$biasUpdater != null : !this$biasUpdater.equals(other$biasUpdater)) {
            return false;
        }
        Boolean this$miniBatch = this.getMiniBatch();
        Boolean other$miniBatch = other.getMiniBatch();
        if (this$miniBatch == null ? other$miniBatch != null : !((Object)this$miniBatch).equals(other$miniBatch)) {
            return false;
        }
        Integer this$maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        Integer other$maxNumLineSearchIterations = other.getMaxNumLineSearchIterations();
        if (this$maxNumLineSearchIterations == null ? other$maxNumLineSearchIterations != null : !((Object)this$maxNumLineSearchIterations).equals(other$maxNumLineSearchIterations)) {
            return false;
        }
        Long this$seed = this.getSeed();
        Long other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
        OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
            return false;
        }
        StepFunction this$stepFunction = this.getStepFunction();
        StepFunction other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        Boolean this$minimize = this.getMinimize();
        Boolean other$minimize = other.getMinimize();
        if (this$minimize == null ? other$minimize != null : !((Object)this$minimize).equals(other$minimize)) {
            return false;
        }
        Optional<GradientNormalization> this$gradientNormalization = this.getGradientNormalization();
        Optional<GradientNormalization> other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !this$gradientNormalization.equals(other$gradientNormalization)) {
            return false;
        }
        Double this$gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        Double other$gradientNormalizationThreshold = other.getGradientNormalizationThreshold();
        if (this$gradientNormalizationThreshold == null ? other$gradientNormalizationThreshold != null : !((Object)this$gradientNormalizationThreshold).equals(other$gradientNormalizationThreshold)) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        ConvolutionLayer.AlgoMode this$cudnnAlgoMode = this.getCudnnAlgoMode();
        ConvolutionLayer.AlgoMode other$cudnnAlgoMode = other.getCudnnAlgoMode();
        if (this$cudnnAlgoMode == null ? other$cudnnAlgoMode != null : !((Object)((Object)this$cudnnAlgoMode)).equals((Object)other$cudnnAlgoMode)) {
            return false;
        }
        Optional<List<LayerConstraint>> this$constraints = this.getConstraints();
        Optional<List<LayerConstraint>> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !this$constraints.equals(other$constraints)) {
            return false;
        }
        Boolean this$pretrain = this.getPretrain();
        Boolean other$pretrain = other.getPretrain();
        if (this$pretrain == null ? other$pretrain != null : !((Object)this$pretrain).equals(other$pretrain)) {
            return false;
        }
        Boolean this$backprop = this.getBackprop();
        Boolean other$backprop = other.getBackprop();
        if (this$backprop == null ? other$backprop != null : !((Object)this$backprop).equals(other$backprop)) {
            return false;
        }
        BackpropType this$backpropType = this.getBackpropType();
        BackpropType other$backpropType = other.getBackpropType();
        if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
            return false;
        }
        Integer this$tbpttFwdLength = this.getTbpttFwdLength();
        Integer other$tbpttFwdLength = other.getTbpttFwdLength();
        if (this$tbpttFwdLength == null ? other$tbpttFwdLength != null : !((Object)this$tbpttFwdLength).equals(other$tbpttFwdLength)) {
            return false;
        }
        Integer this$tbpttBackLength = this.getTbpttBackLength();
        Integer other$tbpttBackLength = other.getTbpttBackLength();
        if (this$tbpttBackLength == null ? other$tbpttBackLength != null : !((Object)this$tbpttBackLength).equals(other$tbpttBackLength)) {
            return false;
        }
        WorkspaceMode this$trainingWorkspaceMode = this.getTrainingWorkspaceMode();
        WorkspaceMode other$trainingWorkspaceMode = other.getTrainingWorkspaceMode();
        if (this$trainingWorkspaceMode == null ? other$trainingWorkspaceMode != null : !((Object)((Object)this$trainingWorkspaceMode)).equals((Object)other$trainingWorkspaceMode)) {
            return false;
        }
        WorkspaceMode this$inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
        WorkspaceMode other$inferenceWorkspaceMode = other.getInferenceWorkspaceMode();
        return !(this$inferenceWorkspaceMode == null ? other$inferenceWorkspaceMode != null : !((Object)((Object)this$inferenceWorkspaceMode)).equals((Object)other$inferenceWorkspaceMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FineTuneConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IActivation $activationFn = this.getActivationFn();
        result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
        WeightInit $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : ((Object)((Object)$weightInit)).hashCode());
        Double $biasInit = this.getBiasInit();
        result = result * 59 + ($biasInit == null ? 43 : ((Object)$biasInit).hashCode());
        Distribution $dist = this.getDist();
        result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
        Double $l1 = this.getL1();
        result = result * 59 + ($l1 == null ? 43 : ((Object)$l1).hashCode());
        Double $l2 = this.getL2();
        result = result * 59 + ($l2 == null ? 43 : ((Object)$l2).hashCode());
        Double $l1Bias = this.getL1Bias();
        result = result * 59 + ($l1Bias == null ? 43 : ((Object)$l1Bias).hashCode());
        Double $l2Bias = this.getL2Bias();
        result = result * 59 + ($l2Bias == null ? 43 : ((Object)$l2Bias).hashCode());
        Optional<IDropout> $dropout = this.getDropout();
        result = result * 59 + ($dropout == null ? 43 : $dropout.hashCode());
        Optional<IWeightNoise> $weightNoise = this.getWeightNoise();
        result = result * 59 + ($weightNoise == null ? 43 : $weightNoise.hashCode());
        IUpdater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        IUpdater $biasUpdater = this.getBiasUpdater();
        result = result * 59 + ($biasUpdater == null ? 43 : $biasUpdater.hashCode());
        Boolean $miniBatch = this.getMiniBatch();
        result = result * 59 + ($miniBatch == null ? 43 : ((Object)$miniBatch).hashCode());
        Integer $maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        result = result * 59 + ($maxNumLineSearchIterations == null ? 43 : ((Object)$maxNumLineSearchIterations).hashCode());
        Long $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 43 : ((Object)((Object)$optimizationAlgo)).hashCode());
        StepFunction $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
        Boolean $minimize = this.getMinimize();
        result = result * 59 + ($minimize == null ? 43 : ((Object)$minimize).hashCode());
        Optional<GradientNormalization> $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : $gradientNormalization.hashCode());
        Double $gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        result = result * 59 + ($gradientNormalizationThreshold == null ? 43 : ((Object)$gradientNormalizationThreshold).hashCode());
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        ConvolutionLayer.AlgoMode $cudnnAlgoMode = this.getCudnnAlgoMode();
        result = result * 59 + ($cudnnAlgoMode == null ? 43 : ((Object)((Object)$cudnnAlgoMode)).hashCode());
        Optional<List<LayerConstraint>> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : $constraints.hashCode());
        Boolean $pretrain = this.getPretrain();
        result = result * 59 + ($pretrain == null ? 43 : ((Object)$pretrain).hashCode());
        Boolean $backprop = this.getBackprop();
        result = result * 59 + ($backprop == null ? 43 : ((Object)$backprop).hashCode());
        BackpropType $backpropType = this.getBackpropType();
        result = result * 59 + ($backpropType == null ? 43 : ((Object)((Object)$backpropType)).hashCode());
        Integer $tbpttFwdLength = this.getTbpttFwdLength();
        result = result * 59 + ($tbpttFwdLength == null ? 43 : ((Object)$tbpttFwdLength).hashCode());
        Integer $tbpttBackLength = this.getTbpttBackLength();
        result = result * 59 + ($tbpttBackLength == null ? 43 : ((Object)$tbpttBackLength).hashCode());
        WorkspaceMode $trainingWorkspaceMode = this.getTrainingWorkspaceMode();
        result = result * 59 + ($trainingWorkspaceMode == null ? 43 : ((Object)((Object)$trainingWorkspaceMode)).hashCode());
        WorkspaceMode $inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
        result = result * 59 + ($inferenceWorkspaceMode == null ? 43 : ((Object)((Object)$inferenceWorkspaceMode)).hashCode());
        return result;
    }

    public String toString() {
        return "FineTuneConfiguration(activationFn=" + this.getActivationFn() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", l1Bias=" + this.getL1Bias() + ", l2Bias=" + this.getL2Bias() + ", dropout=" + this.getDropout() + ", weightNoise=" + this.getWeightNoise() + ", updater=" + this.getUpdater() + ", biasUpdater=" + this.getBiasUpdater() + ", miniBatch=" + this.getMiniBatch() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", stepFunction=" + this.getStepFunction() + ", minimize=" + this.getMinimize() + ", gradientNormalization=" + this.getGradientNormalization() + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ", cudnnAlgoMode=" + (Object)((Object)this.getCudnnAlgoMode()) + ", constraints=" + this.getConstraints() + ", pretrain=" + this.getPretrain() + ", backprop=" + this.getBackprop() + ", backpropType=" + (Object)((Object)this.getBackpropType()) + ", tbpttFwdLength=" + this.getTbpttFwdLength() + ", tbpttBackLength=" + this.getTbpttBackLength() + ", trainingWorkspaceMode=" + (Object)((Object)this.getTrainingWorkspaceMode()) + ", inferenceWorkspaceMode=" + (Object)((Object)this.getInferenceWorkspaceMode()) + ")";
    }

    public static class Builder {
        private IActivation activation;
        private WeightInit weightInit;
        private Double biasInit;
        private Distribution dist;
        private Double l1;
        private Double l2;
        private Double l1Bias;
        private Double l2Bias;
        private Optional<IDropout> dropout;
        private Optional<IWeightNoise> weightNoise;
        private IUpdater updater;
        private IUpdater biasUpdater;
        private Boolean miniBatch;
        private Integer maxNumLineSearchIterations;
        private Long seed;
        private OptimizationAlgorithm optimizationAlgo;
        private StepFunction stepFunction;
        private Boolean minimize;
        private Optional<GradientNormalization> gradientNormalization;
        private Double gradientNormalizationThreshold;
        private ConvolutionMode convolutionMode;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;
        private Optional<List<LayerConstraint>> constraints;
        private Boolean pretrain;
        private Boolean backprop;
        private BackpropType backpropType;
        private Integer tbpttFwdLength;
        private Integer tbpttBackLength;
        private WorkspaceMode trainingWorkspaceMode;
        private WorkspaceMode inferenceWorkspaceMode;

        public Builder activation(IActivation activationFn) {
            this.activation = activationFn;
            return this;
        }

        public Builder activation(Activation activation) {
            this.activation = activation.getActivationFunction();
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return this;
        }

        public Builder weightInit(Distribution distribution) {
            this.weightInit(WeightInit.DISTRIBUTION);
            return this.dist(distribution);
        }

        public Builder biasInit(double biasInit) {
            this.biasInit = biasInit;
            return this;
        }

        public Builder dist(Distribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder l1(double l1) {
            this.l1 = l1;
            return this;
        }

        public Builder l2(double l2) {
            this.l2 = l2;
            return this;
        }

        public Builder l1Bias(double l1Bias) {
            this.l1Bias = l1Bias;
            return this;
        }

        public Builder l2Bias(double l2Bias) {
            this.l2Bias = l2Bias;
            return this;
        }

        public Builder dropout(IDropout dropout) {
            this.dropout = Optional.ofNullable((Object)dropout);
            return this;
        }

        public Builder dropOut(double inputRetainProbability) {
            if (inputRetainProbability == 0.0) {
                return this.dropout(null);
            }
            return this.dropout(new Dropout(inputRetainProbability));
        }

        public Builder weightNoise(IWeightNoise weightNoise) {
            this.weightNoise = Optional.ofNullable((Object)weightNoise);
            return this;
        }

        public Builder updater(IUpdater updater) {
            this.updater = updater;
            return this;
        }

        @Deprecated
        public Builder updater(Updater updater) {
            return this.updater(updater.getIUpdaterWithDefaultConfig());
        }

        public Builder biasUpdater(IUpdater biasUpdater) {
            this.biasUpdater = biasUpdater;
            return this;
        }

        public Builder miniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder seed(int seed) {
            return this.seed((long)seed);
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = Optional.ofNullable((Object)((Object)gradientNormalization));
            return this;
        }

        public Builder gradientNormalizationThreshold(double gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return this;
        }

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        public Builder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            return this;
        }

        public Builder constraints(List<LayerConstraint> constraints) {
            this.constraints = Optional.ofNullable(constraints);
            return this;
        }

        public Builder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public Builder backprop(boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        public Builder backpropType(BackpropType backpropType) {
            this.backpropType = backpropType;
            return this;
        }

        public Builder tbpttFwdLength(int tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
            return this;
        }

        public Builder tbpttBackLength(int tbpttBackLength) {
            this.tbpttBackLength = tbpttBackLength;
            return this;
        }

        public Builder trainingWorkspaceMode(WorkspaceMode trainingWorkspaceMode) {
            this.trainingWorkspaceMode = trainingWorkspaceMode;
            return this;
        }

        public Builder inferenceWorkspaceMode(WorkspaceMode inferenceWorkspaceMode) {
            this.inferenceWorkspaceMode = inferenceWorkspaceMode;
            return this;
        }

        public FineTuneConfiguration build() {
            return new FineTuneConfiguration(this.activation, this.weightInit, this.biasInit, this.dist, this.l1, this.l2, this.l1Bias, this.l2Bias, this.dropout, this.weightNoise, this.updater, this.biasUpdater, this.miniBatch, this.maxNumLineSearchIterations, this.seed, this.optimizationAlgo, this.stepFunction, this.minimize, this.gradientNormalization, this.gradientNormalizationThreshold, this.convolutionMode, this.cudnnAlgoMode, this.constraints, this.pretrain, this.backprop, this.backpropType, this.tbpttFwdLength, this.tbpttBackLength, this.trainingWorkspaceMode, this.inferenceWorkspaceMode);
        }

        public String toString() {
            return "FineTuneConfiguration.Builder(activation=" + this.activation + ", weightInit=" + (Object)((Object)this.weightInit) + ", biasInit=" + this.biasInit + ", dist=" + this.dist + ", l1=" + this.l1 + ", l2=" + this.l2 + ", l1Bias=" + this.l1Bias + ", l2Bias=" + this.l2Bias + ", dropout=" + this.dropout + ", weightNoise=" + this.weightNoise + ", updater=" + this.updater + ", biasUpdater=" + this.biasUpdater + ", miniBatch=" + this.miniBatch + ", maxNumLineSearchIterations=" + this.maxNumLineSearchIterations + ", seed=" + this.seed + ", optimizationAlgo=" + (Object)((Object)this.optimizationAlgo) + ", stepFunction=" + this.stepFunction + ", minimize=" + this.minimize + ", gradientNormalization=" + this.gradientNormalization + ", gradientNormalizationThreshold=" + this.gradientNormalizationThreshold + ", convolutionMode=" + (Object)((Object)this.convolutionMode) + ", cudnnAlgoMode=" + (Object)((Object)this.cudnnAlgoMode) + ", constraints=" + this.constraints + ", pretrain=" + this.pretrain + ", backprop=" + this.backprop + ", backpropType=" + (Object)((Object)this.backpropType) + ", tbpttFwdLength=" + this.tbpttFwdLength + ", tbpttBackLength=" + this.tbpttBackLength + ", trainingWorkspaceMode=" + (Object)((Object)this.trainingWorkspaceMode) + ", inferenceWorkspaceMode=" + (Object)((Object)this.inferenceWorkspaceMode) + ")";
        }
    }
}

