/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.DefaultParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class EmbeddingLayer
extends FeedForwardLayer {
    private boolean hasBias = true;

    private EmbeddingLayer(Builder builder) {
        super(builder);
        this.hasBias = builder.hasBias;
        this.initializeConstraints(builder);
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.feedforward.embedding.EmbeddingLayer ret = new org.deeplearning4j.nn.layers.feedforward.embedding.EmbeddingLayer(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return DefaultParamInitializer.getInstance();
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        int actElementsPerEx = outputType.arrayElementsPerExample();
        int numParams = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize((long)numParams);
        return new LayerMemoryReport.Builder(this.layerName, EmbeddingLayer.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, 0L, actElementsPerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public boolean hasBias() {
        return this.hasBias;
    }

    public boolean isHasBias() {
        return this.hasBias;
    }

    public void setHasBias(boolean hasBias) {
        this.hasBias = hasBias;
    }

    public EmbeddingLayer() {
    }

    @Override
    public String toString() {
        return "EmbeddingLayer(super=" + super.toString() + ", hasBias=" + this.isHasBias() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingLayer)) {
            return false;
        }
        EmbeddingLayer other = (EmbeddingLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isHasBias() == other.isHasBias();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isHasBias() ? 79 : 97);
        return result;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        private boolean hasBias = false;

        public Builder hasBias(boolean hasBias) {
            this.hasBias = hasBias;
            return this;
        }

        @Override
        public EmbeddingLayer build() {
            return new EmbeddingLayer(this);
        }
    }
}

