/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.dropout;

import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class GaussianNoise
implements IDropout {
    private double stddev;
    private ISchedule stddevSchedule;

    public GaussianNoise(double stddev) {
        this(stddev, null);
    }

    public GaussianNoise(ISchedule stddevSchedule) {
        this(Double.NaN, stddevSchedule);
    }

    protected GaussianNoise(@JsonProperty(value="stddev") double stddev, @JsonProperty(value="stddevSchedule") ISchedule stddevSchedule) {
        this.stddev = stddev;
        this.stddevSchedule = stddevSchedule;
    }

    @Override
    public INDArray applyDropout(INDArray inputActivations, int iteration, int epoch, boolean inPlace) {
        double currS = this.stddevSchedule != null ? this.stddevSchedule.valueAt(iteration, epoch) : this.stddev;
        INDArray result = inPlace ? inputActivations : inputActivations.dup(inputActivations.ordering());
        INDArray noise = Nd4j.createUninitialized((int[])inputActivations.shape(), (char)inputActivations.ordering());
        Nd4j.getExecutioner().exec((RandomOp)new GaussianDistribution(noise, 0.0, currS));
        result.addi(noise);
        return result;
    }

    @Override
    public IDropout clone() {
        return new GaussianNoise(this.stddev, this.stddevSchedule);
    }

    public double getStddev() {
        return this.stddev;
    }

    public ISchedule getStddevSchedule() {
        return this.stddevSchedule;
    }

    public void setStddev(double stddev) {
        this.stddev = stddev;
    }

    public void setStddevSchedule(ISchedule stddevSchedule) {
        this.stddevSchedule = stddevSchedule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GaussianNoise)) {
            return false;
        }
        GaussianNoise other = (GaussianNoise)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getStddev(), other.getStddev()) != 0) {
            return false;
        }
        ISchedule this$stddevSchedule = this.getStddevSchedule();
        ISchedule other$stddevSchedule = other.getStddevSchedule();
        return !(this$stddevSchedule == null ? other$stddevSchedule != null : !this$stddevSchedule.equals(other$stddevSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GaussianNoise;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $stddev = Double.doubleToLongBits(this.getStddev());
        result = result * 59 + (int)($stddev >>> 32 ^ $stddev);
        ISchedule $stddevSchedule = this.getStddevSchedule();
        result = result * 59 + ($stddevSchedule == null ? 43 : $stddevSchedule.hashCode());
        return result;
    }

    public String toString() {
        return "GaussianNoise(stddev=" + this.getStddev() + ", stddevSchedule=" + this.getStddevSchedule() + ")";
    }
}

