/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeIterationListener
implements IterationListener {
    private static final long serialVersionUID = 1L;
    private boolean invoked;
    private long start;
    private int iterationCount;
    private AtomicLong iterationCounter = new AtomicLong(0L);
    private static final Logger log = LoggerFactory.getLogger(TimeIterationListener.class);

    public TimeIterationListener(int iterationCount) {
        this.iterationCount = iterationCount;
        this.start = System.currentTimeMillis();
    }

    @Override
    public void iterationDone(Model model, int iteration, int epoch) {
        long currentIteration = this.iterationCounter.incrementAndGet();
        long elapsed = System.currentTimeMillis() - this.start;
        long remaining = ((long)this.iterationCount - currentIteration) * elapsed / currentIteration;
        long minutes = remaining / 60000L;
        Date date = new Date(this.start + elapsed + remaining);
        log.info("Remaining time : " + minutes + "mn - End expected : " + date.toString());
    }
}

