/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceListener
implements IterationListener {
    private final int frequency;
    private static final Logger logger = LoggerFactory.getLogger(PerformanceListener.class);
    private transient ThreadLocal<Double> samplesPerSec = new ThreadLocal();
    private transient ThreadLocal<Double> batchesPerSec = new ThreadLocal();
    private transient ThreadLocal<Long> lastTime = new ThreadLocal();
    private boolean reportScore;
    private boolean reportSample = true;
    private boolean reportBatch = true;
    private boolean reportIteration = true;
    private boolean reportEtl = true;
    private boolean reportTime = true;

    public PerformanceListener(int frequency) {
        this(frequency, false);
    }

    public PerformanceListener(int frequency, boolean reportScore) {
        Preconditions.checkArgument((frequency > 0 ? 1 : 0) != 0, (Object)("Invalid frequency, must be > 0: Got " + frequency));
        this.frequency = frequency;
        this.reportScore = reportScore;
        this.lastTime.set(System.currentTimeMillis());
    }

    @Override
    public void iterationDone(Model model, int iteration, int epoch) {
        if (this.lastTime.get() == null) {
            this.lastTime.set(System.currentTimeMillis());
        }
        if (this.samplesPerSec.get() == null) {
            this.samplesPerSec.set(0.0);
        }
        if (this.batchesPerSec.get() == null) {
            this.batchesPerSec.set(0.0);
        }
        if (iteration % this.frequency == 0) {
            ComputationGraph cg;
            INDArray[] inputs;
            long currentTime = System.currentTimeMillis();
            long timeSpent = currentTime - this.lastTime.get();
            float timeSec = (float)timeSpent / 1000.0f;
            INDArray input = model instanceof ComputationGraph ? ((inputs = (cg = (ComputationGraph)model).getInputs()) != null && inputs.length > 0 ? inputs[0] : model.input()) : model.input();
            long numSamples = input.size(0);
            this.samplesPerSec.set(Double.valueOf((float)numSamples / timeSec));
            this.batchesPerSec.set(Double.valueOf(1.0f / timeSec));
            StringBuilder builder = new StringBuilder();
            if (Nd4j.getAffinityManager().getNumberOfDevices() > 1) {
                builder.append("Device: [").append(Nd4j.getAffinityManager().getDeviceForCurrentThread()).append("]; ");
            }
            if (this.reportEtl) {
                long time = model instanceof MultiLayerNetwork ? ((MultiLayerNetwork)model).getLastEtlTime() : ((ComputationGraph)model).getLastEtlTime();
                builder.append("ETL: ").append(time).append(" ms; ");
            }
            if (this.reportIteration) {
                builder.append("iteration ").append(iteration).append("; ");
            }
            if (this.reportTime) {
                builder.append("iteration time: ").append(timeSpent).append(" ms; ");
            }
            if (this.reportSample) {
                builder.append("samples/sec: ").append(String.format("%.3f", this.samplesPerSec.get())).append("; ");
            }
            if (this.reportBatch) {
                builder.append("batches/sec: ").append(String.format("%.3f", this.batchesPerSec.get())).append("; ");
            }
            if (this.reportScore) {
                builder.append("score: ").append(model.score()).append(";");
            }
            logger.info(builder.toString());
        }
        this.lastTime.set(System.currentTimeMillis());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.samplesPerSec = new ThreadLocal();
        this.batchesPerSec = new ThreadLocal();
        this.lastTime = new ThreadLocal();
    }

    public static class Builder {
        private int frequency = 1;
        private boolean reportScore;
        private boolean reportSample = true;
        private boolean reportBatch = true;
        private boolean reportIteration = true;
        private boolean reportTime = true;
        private boolean reportEtl = true;

        public Builder reportIteration(boolean reportIteration) {
            this.reportIteration = reportIteration;
            return this;
        }

        public Builder reportTime(boolean reportTime) {
            this.reportTime = reportTime;
            return this;
        }

        public Builder reportETL(boolean reportEtl) {
            this.reportEtl = reportEtl;
            return this;
        }

        public Builder reportSample(boolean reportSample) {
            this.reportSample = reportSample;
            return this;
        }

        public Builder reportBatch(boolean reportBatch) {
            this.reportBatch = reportBatch;
            return this;
        }

        public Builder reportScore(boolean reportScore) {
            this.reportScore = reportScore;
            return this;
        }

        public Builder setFrequency(int frequency) {
            this.frequency = frequency;
            return this;
        }

        public PerformanceListener build() {
            PerformanceListener listener = new PerformanceListener(this.frequency, this.reportScore);
            listener.reportIteration = this.reportIteration;
            listener.reportTime = this.reportTime;
            listener.reportBatch = this.reportBatch;
            listener.reportSample = this.reportSample;
            listener.reportEtl = this.reportEtl;
            return listener;
        }
    }
}

