/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.util;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Broadcast;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class MaskLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.util.MaskLayer> {
    private Gradient emptyGradient = new DefaultGradient();

    public MaskLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    @Override
    public Layer clone() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public INDArray preOutput(boolean training) {
        return this.activate(training);
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        return new Pair((Object)this.emptyGradient, (Object)MaskLayer.applyMask(epsilon, this.maskArray));
    }

    @Override
    public INDArray activate(boolean training) {
        return MaskLayer.applyMask(this.input, this.maskArray);
    }

    private static INDArray applyMask(INDArray input, INDArray maskArray) {
        if (maskArray == null) {
            return input;
        }
        switch (input.rank()) {
            case 2: {
                if (!maskArray.isColumnVector() || maskArray.size(0) != input.size(0)) {
                    throw new IllegalStateException("Expected column vector for mask with 2d input, with same size(0) as input. Got mask with shape: " + Arrays.toString(maskArray.shape()) + ", input shape = " + Arrays.toString(input.shape()));
                }
                return input.mulColumnVector(maskArray);
            }
            case 3: {
                if (maskArray.rank() != 2 || input.size(0) != maskArray.size(0) || input.size(2) != maskArray.size(1)) {
                    throw new IllegalStateException("With 3d (time series) input with shape [minibatch, size, sequenceLength]=" + Arrays.toString(input.shape()) + ", expected 2d mask array with shape [minibatch, sequenceLength]. Got mask with shape: " + Arrays.toString(maskArray.shape()));
                }
                INDArray fwd = Nd4j.create((int[])input.shape(), (char)'f');
                Broadcast.mul((INDArray)input, (INDArray)maskArray, (INDArray)fwd, (int[])new int[]{0, 2});
                return fwd;
            }
            case 4: {
                if (!maskArray.isColumnVector() || maskArray.size(0) != input.size(0)) {
                    throw new IllegalStateException("Expected column vector for mask with 2d input, with same size(0) as input. Got mask with shape: " + Arrays.toString(maskArray.shape()) + ", input shape = " + Arrays.toString(input.shape()));
                }
                INDArray fwd2 = Nd4j.create((int[])input.shape(), (char)'c');
                Broadcast.mul((INDArray)input, (INDArray)maskArray, (INDArray)fwd2, (int[])new int[]{0});
                return fwd2;
            }
        }
        throw new RuntimeException("Expected rank 2 to 4 input. Got rank " + input.rank() + " with shape " + Arrays.toString(input.shape()));
    }
}

