/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseOutputLayer;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.OldSoftMax;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.primitives.Pair;

public class RnnOutputLayer
extends BaseOutputLayer<org.deeplearning4j.nn.conf.layers.RnnOutputLayer> {
    public RnnOutputLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public RnnOutputLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        if (this.input.rank() != 3) {
            throw new UnsupportedOperationException("Input is not rank 3. Got input with rank " + this.input.rank() + " " + this.layerId());
        }
        INDArray inputTemp = this.input;
        this.input = TimeSeriesUtils.reshape3dTo2d(this.input);
        Pair<Gradient, INDArray> gradAndEpsilonNext = super.backpropGradient(epsilon);
        this.input = inputTemp;
        INDArray epsilon2d = (INDArray)gradAndEpsilonNext.getSecond();
        INDArray epsilon3d = TimeSeriesUtils.reshape2dTo3d(epsilon2d, this.input.size(0));
        this.weightNoiseParams.clear();
        return new Pair(gradAndEpsilonNext.getFirst(), (Object)epsilon3d);
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        if (examples.rank() == 3) {
            examples = TimeSeriesUtils.reshape3dTo2d(examples);
        }
        if (labels.rank() == 3) {
            labels = TimeSeriesUtils.reshape3dTo2d(labels);
        }
        return super.f1Score(examples, labels);
    }

    @Override
    public INDArray getInput() {
        return this.input;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        this.setInput(x);
        return TimeSeriesUtils.reshape2dTo3d(this.preOutput2d(training), this.input.size(0));
    }

    @Override
    protected INDArray preOutput2d(boolean training) {
        if (this.input.rank() == 3) {
            INDArray inputTemp = this.input;
            this.input = TimeSeriesUtils.reshape3dTo2d(this.input);
            INDArray out = super.preOutput(this.input, training);
            this.input = inputTemp;
            return out;
        }
        INDArray out = super.preOutput(this.input, training);
        return out;
    }

    @Override
    protected INDArray getLabels2d() {
        if (this.labels.rank() == 3) {
            return TimeSeriesUtils.reshape3dTo2d(this.labels);
        }
        return this.labels;
    }

    @Override
    public INDArray output(INDArray input) {
        if (input.rank() != 3) {
            throw new IllegalArgumentException("Input must be rank 3 (is: " + input.rank() + ") " + this.layerId());
        }
        this.setInput(input);
        return this.output(false);
    }

    @Override
    public INDArray output(boolean training) {
        if (this.input.rank() != 3) {
            throw new IllegalArgumentException("input must be rank 3. Got input with rank " + this.input.rank() + " " + this.layerId());
        }
        INDArray preOutput2d = this.preOutput2d(training);
        if (((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getActivationFn() instanceof ActivationSoftmax) {
            INDArray out2d = Nd4j.getExecutioner().execAndReturn((TransformOp)new OldSoftMax(preOutput2d));
            if (this.maskArray != null) {
                out2d.muliColumnVector(this.maskArray);
            }
            return TimeSeriesUtils.reshape2dTo3d(out2d, this.input.size(0));
        }
        this.applyDropOutIfNecessary(training);
        INDArray origInput = this.input;
        this.input = TimeSeriesUtils.reshape3dTo2d(this.input);
        INDArray out = super.activate(true);
        this.input = origInput;
        if (this.maskArray != null) {
            out.muliColumnVector(this.maskArray);
        }
        return TimeSeriesUtils.reshape2dTo3d(out, this.input.size(0));
    }

    @Override
    public INDArray activate(boolean training) {
        if (this.input.rank() != 3) {
            throw new UnsupportedOperationException("Input must be rank 3. Got input with rank " + this.input.rank() + " " + this.layerId());
        }
        INDArray b = this.getParamWithNoise("b", training);
        INDArray W = this.getParamWithNoise("W", training);
        INDArray input2d = TimeSeriesUtils.reshape3dTo2d(this.input);
        INDArray act2d = ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getActivationFn().getActivation(input2d.mmul(W).addiRowVector(b), training);
        if (this.maskArray != null) {
            if (!this.maskArray.isColumnVector() || Arrays.equals(this.maskArray.shape(), act2d.shape())) {
                act2d.muli(this.maskArray);
            } else {
                act2d.muliColumnVector(this.maskArray);
            }
        }
        return TimeSeriesUtils.reshape2dTo3d(act2d, this.input.size(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setMaskArray(INDArray maskArray) {
        if (maskArray != null) {
            if (maskArray.rank() == 2) {
                this.maskArray = TimeSeriesUtils.reshapeTimeSeriesMaskToVector(maskArray);
                return;
            } else {
                if (maskArray.rank() != 3) throw new UnsupportedOperationException("Invalid mask array: must be rank 2 or 3 (got: rank " + maskArray.rank() + ", shape = " + Arrays.toString(maskArray.shape()) + ") " + this.layerId());
                this.maskArray = TimeSeriesUtils.reshape3dTo2d(maskArray);
            }
            return;
        } else {
            this.maskArray = null;
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray != null && currentMaskState == MaskState.Active) {
            this.inputMaskArray = TimeSeriesUtils.reshapeTimeSeriesMaskToVector(maskArray);
            this.inputMaskArrayState = currentMaskState;
        } else {
            this.inputMaskArray = null;
            this.inputMaskArrayState = null;
        }
        return null;
    }

    @Override
    public INDArray computeScoreForExamples(double fullNetworkL1, double fullNetworkL2) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        INDArray preOut = this.preOutput2d(false);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getLossFn();
        INDArray scoreArray = lossFunction.computeScoreArray(this.getLabels2d(), preOut, ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getActivationFn(), this.maskArray);
        INDArray scoreArrayTs = TimeSeriesUtils.reshapeVectorToTimeSeriesMask(scoreArray, this.input.size(0));
        INDArray summedScores = scoreArrayTs.sum(new int[]{1});
        double l1l2 = fullNetworkL1 + fullNetworkL2;
        if (l1l2 != 0.0) {
            summedScores.addi((Number)l1l2);
        }
        return summedScores;
    }
}

