/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.upsampling;

import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BaseUpsamplingLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.upsampling.Upsampling2D;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling1D
extends Upsampling2D {
    private static final Logger log = LoggerFactory.getLogger(Upsampling1D.class);

    public Upsampling1D(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Upsampling1D(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        int size = ((BaseUpsamplingLayer)this.layerConf()).getSize();
        epsilon = epsilon.reshape(new int[]{epsilon.size(0), epsilon.size(1), epsilon.size(2), 1});
        epsilon = epsilon.repeat(3, new int[]{size});
        INDArray originalInput = this.input;
        this.input = this.input.reshape(new int[]{this.input.size(0), this.input.size(1), this.input.size(2), 1});
        int miniBatch = this.input.size(0);
        int inDepth = this.input.size(1);
        int inH = this.input.size(2);
        int inW = this.input.size(3);
        INDArray outEpsilon = Nd4j.create((int)(miniBatch * inDepth * inH * inW));
        INDArray reshapedEpsilon = outEpsilon.reshape('c', new int[]{miniBatch, inDepth, inH, inW});
        INDArray forwardOutput = this.preOutput(true, true);
        forwardOutput = forwardOutput.reshape(new int[]{forwardOutput.size(0), forwardOutput.size(1), forwardOutput.size(2), 1});
        forwardOutput = forwardOutput.repeat(3, new int[]{size});
        DynamicCustomOp op = DynamicCustomOp.builder((String)"upsampling_bp").addIntegerArguments(size).addInputs(new INDArray[]{forwardOutput, epsilon}).addOutputs(new INDArray[]{reshapedEpsilon}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient gradient = new DefaultGradient();
        reshapedEpsilon = reshapedEpsilon.slice(0, 3);
        this.input = originalInput;
        return new Pair((Object)gradient, (Object)reshapedEpsilon.divi((Number)size));
    }

    @Override
    protected int getSize() {
        return ((org.deeplearning4j.nn.conf.layers.Upsampling1D)this.conf.getLayer()).getSize();
    }

    @Override
    public INDArray preOutput(boolean training) {
        return this.preOutput(training, false);
    }

    @Override
    public INDArray preOutput(boolean training, boolean forBackprop) {
        INDArray originalInput = this.input;
        this.input = this.input.reshape(new int[]{this.input.size(0), this.input.size(1), this.input.size(2), 1});
        INDArray preOutput = super.preOutput(training, forBackprop);
        this.input = originalInput;
        preOutput = preOutput.slice(0, 3);
        return preOutput;
    }
}

