/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class Deconvolution2DLayer
extends ConvolutionLayer {
    public Deconvolution2DLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Deconvolution2DLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    void initializeHelper() {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        DynamicCustomOp op;
        int[] pad;
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, depth, inputHeight, inputWidth]. " + this.layerId());
        }
        INDArray weights = this.getParamWithNoise("W", true);
        int miniBatch = this.input.size(0);
        int inH = this.input.size(2);
        int inW = this.input.size(3);
        int inDepth = weights.size(0);
        int kH = weights.size(2);
        int kW = weights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            int[] outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        INDArray weightGradView = (INDArray)this.gradientViews.get("W");
        INDArray outEpsilon = Nd4j.create((int)(miniBatch * inDepth * inH * inW));
        INDArray reshapedEpsilon = outEpsilon.reshape('c', new int[]{miniBatch, inDepth, inH, inW});
        Integer sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode};
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        Pair<INDArray, INDArray> p = this.preOutput4d(true, true);
        INDArray delta = (INDArray)afn.backprop((INDArray)p.getFirst(), epsilon).getFirst();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            INDArray bias = this.getParamWithNoise("b", true);
            op = DynamicCustomOp.builder((String)"deconv2d_bp").addInputs(new INDArray[]{this.input, weights, bias, delta}).addIntegerArguments(args).addOutputs(new INDArray[]{reshapedEpsilon, weightGradView, biasGradView}).callInplace(false).build();
        } else {
            op = DynamicCustomOp.builder((String)"deconv2d_bp").addInputs(new INDArray[]{this.input, weights, delta}).addIntegerArguments(args).addOutputs(new INDArray[]{reshapedEpsilon, weightGradView}).callInplace(false).build();
        }
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            retGradient.setGradientFor("b", biasGradView);
        }
        retGradient.setGradientFor("W", weightGradView, Character.valueOf('c'));
        this.weightNoiseParams.clear();
        reshapedEpsilon = reshapedEpsilon.permute(new int[]{1, 0, 2, 3});
        return new Pair((Object)retGradient, (Object)reshapedEpsilon);
    }

    @Override
    public INDArray preOutput(boolean training) {
        return (INDArray)this.preOutput(training, false).getFirst();
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop) {
        int[] pad;
        int[] outSize;
        if (this.convolutionMode == ConvolutionMode.Same) {
            throw new IllegalArgumentException("Border mode Same currently not supported.");
        }
        INDArray bias = this.getParamWithNoise("b", training);
        INDArray weights = this.getParamWithNoise("W", training);
        if (this.input.rank() != 4) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Deconvolution2D (layer name = " + layerName + ", layer index = " + this.index + ") with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, layerInputDepth, inputHeight, inputWidth]." + (this.input.rank() == 2 ? " (Wrong input type (see InputType.convolutionalFlat()) or wrong data type?)" : "") + " " + this.layerId());
        }
        int inDepth = weights.size(0);
        int outDepth = weights.size(1);
        if (this.input.size(1) != inDepth) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Cannot do forward pass in Deconvolution2D layer (layer name = " + layerName + ", layer index = " + this.index + "): input array depth does not match CNN layer configuration (data input depth = " + this.input.size(1) + ", [minibatch,inputDepth,height,width]=" + Arrays.toString(this.input.shape()) + "; expected input depth = " + inDepth + ") " + this.layerId());
        }
        int kH = weights.size(2);
        int kW = weights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{this.input.size(2), this.input.size(3)}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        int miniBatch = this.input.size(0);
        INDArray output = Nd4j.create((int)(miniBatch * outDepth * outH * outW));
        INDArray reshapedOutput = output.reshape('c', new int[]{miniBatch, outDepth, outH, outW});
        int sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode, 0};
        DynamicCustomOp op = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias() ? DynamicCustomOp.builder((String)"deconv2d").addInputs(new INDArray[]{this.input, weights, bias}).addIntegerArguments(args).addOutputs(new INDArray[]{reshapedOutput}).callInplace(false).build() : DynamicCustomOp.builder((String)"deconv2d").addInputs(new INDArray[]{this.input, weights}).addIntegerArguments(args).addOutputs(new INDArray[]{reshapedOutput}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return new Pair((Object)reshapedOutput, null);
    }

    @Override
    public INDArray activate(boolean training) {
        INDArray ret;
        if (this.input == null) {
            throw new IllegalArgumentException("Cannot perform forward pass with null input " + this.layerId());
        }
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        this.applyDropOutIfNecessary(training);
        INDArray z = this.preOutput(training);
        if (training && this.cacheMode != CacheMode.NONE && Nd4j.getWorkspaceManager().checkIfWorkspaceExistsAndActive("LOOP_CACHE")) {
            try (MemoryWorkspace wsB = Nd4j.getWorkspaceManager().getWorkspaceForCurrentThread("LOOP_CACHE").notifyScopeBorrowed();){
                this.preOutput = z.unsafeDuplication();
            }
        }
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        if (this.helper != null && Shape.strideDescendingCAscendingF((INDArray)z) && (ret = this.helper.activate(z, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn())) != null) {
            return ret;
        }
        INDArray activation = afn.getActivation(z, training);
        return activation;
    }
}

