/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.samediff;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.samediff.AbstractSameDiffLayer;
import org.deeplearning4j.nn.layers.samediff.SameDiffLayer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;

public abstract class BaseSameDiffLayer
extends AbstractSameDiffLayer {
    protected WeightInit weightInit;

    protected BaseSameDiffLayer(Builder builder) {
        super(builder);
        this.weightInit = builder.weightInit;
    }

    protected BaseSameDiffLayer() {
    }

    public abstract List<SDVariable> defineLayer(SameDiff var1, SDVariable var2, Map<String, SDVariable> var3);

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        return null;
    }

    @Override
    public void applyGlobalConfigToLayer(NeuralNetConfiguration.Builder globalConfig) {
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        SameDiffLayer ret = new SameDiffLayer(conf);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    @Override
    public String toString() {
        return "BaseSameDiffLayer(weightInit=" + (Object)((Object)this.getWeightInit()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseSameDiffLayer)) {
            return false;
        }
        BaseSameDiffLayer other = (BaseSameDiffLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WeightInit this$weightInit = this.getWeightInit();
        WeightInit other$weightInit = other.getWeightInit();
        return !(this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseSameDiffLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        WeightInit $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : ((Object)((Object)$weightInit)).hashCode());
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractSameDiffLayer.Builder<T> {
        protected WeightInit weightInit = WeightInit.XAVIER;

        public T weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }
    }
}

