/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ZeroPaddingLayer
extends NoParamLayer {
    private int[] padding;

    public ZeroPaddingLayer(int padTopBottom, int padLeftRight) {
        this(new Builder(padTopBottom, padLeftRight));
    }

    public ZeroPaddingLayer(int padTop, int padBottom, int padLeft, int padRight) {
        this(new Builder(padTop, padBottom, padLeft, padRight));
    }

    private ZeroPaddingLayer(Builder builder) {
        super(builder);
        if (builder.padding == null || builder.padding.length != 4) {
            throw new IllegalArgumentException("Invalid padding values: must have exactly 4 values [top, bottom, left, right]. Got: " + (builder.padding == null ? null : Arrays.toString(builder.padding)));
        }
        this.padding = builder.padding;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.convolution.ZeroPaddingLayer ret = new org.deeplearning4j.nn.layers.convolution.ZeroPaddingLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        int[] hwd = ConvolutionUtils.getHWDFromInputType(inputType);
        int outH = hwd[0] + this.padding[0] + this.padding[1];
        int outW = hwd[1] + this.padding[2] + this.padding[3];
        return InputType.convolutional(outH, outW, hwd[2]);
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        Preconditions.checkArgument((inputType != null ? 1 : 0) != 0, (Object)("Invalid input for ZeroPaddingLayer layer (layer name=\"" + this.getLayerName() + "\"): InputType is null"));
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, ZeroPaddingLayer.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public int[] getPadding() {
        return this.padding;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    @Override
    public String toString() {
        return "ZeroPaddingLayer(padding=" + Arrays.toString(this.getPadding()) + ")";
    }

    public ZeroPaddingLayer() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZeroPaddingLayer)) {
            return false;
        }
        ZeroPaddingLayer other = (ZeroPaddingLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getPadding(), other.getPadding());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ZeroPaddingLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getPadding());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private int[] padding = new int[]{0, 0, 0, 0};

        public Builder(int padHeight, int padWidth) {
            this(padHeight, padHeight, padWidth, padWidth);
        }

        public Builder(int padTop, int padBottom, int padLeft, int padRight) {
            this(new int[]{padTop, padBottom, padLeft, padRight});
        }

        public Builder(int[] padding) {
            if (padding.length == 2) {
                padding = new int[]{padding[0], padding[0], padding[1], padding[1]};
            } else if (padding.length != 4) {
                throw new IllegalArgumentException("Padding must have exactly 2 or 4 values - got " + Arrays.toString(padding));
            }
            this.padding = padding;
        }

        @Override
        public ZeroPaddingLayer build() {
            for (int p : this.padding) {
                if (p >= 0) continue;
                throw new IllegalStateException("Invalid zero padding layer config: padding [top, bottom, left, right] must be > 0 for all elements. Got: " + Arrays.toString(this.padding));
            }
            return new ZeroPaddingLayer(this);
        }
    }
}

