/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ActivationLayer
extends Layer {
    protected IActivation activationFn;

    protected ActivationLayer(Builder builder) {
        super(builder);
        this.activationFn = builder.activationFn;
        this.initializeConstraints(builder);
    }

    @Override
    public ActivationLayer clone() {
        ActivationLayer clone = (ActivationLayer)super.clone();
        return clone;
    }

    @Override
    public org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.ActivationLayer ret = new org.deeplearning4j.nn.layers.ActivationLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input type: null for layer name \"" + this.getLayerName() + "\"");
        }
        return inputType;
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        return null;
    }

    @Override
    public double getL1ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("Activation layer does not contain parameters");
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        int actElementsPerEx = inputType.arrayElementsPerExample();
        return new LayerMemoryReport.Builder(this.layerName, ActivationLayer.class, inputType, inputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, actElementsPerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    public IActivation getActivationFn() {
        return this.activationFn;
    }

    public void setActivationFn(IActivation activationFn) {
        this.activationFn = activationFn;
    }

    public ActivationLayer() {
    }

    @Override
    public String toString() {
        return "ActivationLayer(super=" + super.toString() + ", activationFn=" + this.getActivationFn() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivationLayer)) {
            return false;
        }
        ActivationLayer other = (ActivationLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IActivation this$activationFn = this.getActivationFn();
        IActivation other$activationFn = other.getActivationFn();
        return !(this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ActivationLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IActivation $activationFn = this.getActivationFn();
        result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private IActivation activationFn = null;

        @Deprecated
        public Builder activation(String activationFunction) {
            return this.activation(Activation.fromString((String)activationFunction));
        }

        public Builder activation(IActivation activationFunction) {
            this.activationFn = activationFunction;
            return this;
        }

        public Builder activation(Activation activation) {
            return this.activation(activation.getActivationFunction());
        }

        @Override
        public ActivationLayer build() {
            return new ActivationLayer(this);
        }

        public Builder(IActivation activationFn) {
            this.activationFn = activationFn;
        }

        public Builder() {
        }
    }
}

