/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.inputs;

import java.io.Serializable;
import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonIgnore;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonSubTypes;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=InputTypeFeedForward.class, name="FeedForward"), @JsonSubTypes.Type(value=InputTypeRecurrent.class, name="Recurrent"), @JsonSubTypes.Type(value=InputTypeConvolutional.class, name="Convolutional"), @JsonSubTypes.Type(value=InputTypeConvolutionalFlat.class, name="ConvolutionalFlat")})
public abstract class InputType
implements Serializable {
    @JsonIgnore
    public abstract Type getType();

    public abstract String toString();

    @JsonIgnore
    public abstract int arrayElementsPerExample();

    public static InputType feedForward(int size) {
        return new InputTypeFeedForward(size);
    }

    public static InputType recurrent(int size) {
        return new InputTypeRecurrent(size);
    }

    public static InputType recurrent(int size, int timeSeriesLength) {
        return new InputTypeRecurrent(size, timeSeriesLength);
    }

    public static InputType convolutional(int height, int width, int depth) {
        return new InputTypeConvolutional(height, width, depth);
    }

    public static InputType convolutionalFlat(int height, int width, int depth) {
        return new InputTypeConvolutionalFlat(height, width, depth);
    }

    public static InputType inferInputType(INDArray inputArray) {
        switch (inputArray.rank()) {
            case 2: {
                return InputType.feedForward(inputArray.size(1));
            }
            case 3: {
                return InputType.recurrent(inputArray.size(1), inputArray.size(2));
            }
            case 4: {
                return InputType.convolutional(inputArray.size(2), inputArray.size(3), inputArray.size(1));
            }
        }
        throw new IllegalArgumentException("Cannot infer input type for array with shape: " + Arrays.toString(inputArray.shape()));
    }

    public static InputType[] inferInputTypes(INDArray ... inputArrays) {
        InputType[] out = new InputType[inputArrays.length];
        for (int i = 0; i < inputArrays.length; ++i) {
            out[i] = InputType.inferInputType(inputArrays[i]);
        }
        return out;
    }

    public static class InputTypeConvolutionalFlat
    extends InputType {
        private int height;
        private int width;
        private int depth;

        @Override
        public Type getType() {
            return Type.CNNFlat;
        }

        public int getFlattenedSize() {
            return this.height * this.width * this.depth;
        }

        public InputType getUnflattenedType() {
            return InputType.convolutional(this.height, this.width, this.depth);
        }

        @Override
        public String toString() {
            return "InputTypeConvolutionalFlat(h=" + this.height + ",w=" + this.width + ",d=" + this.depth + ")";
        }

        @Override
        public int arrayElementsPerExample() {
            return this.height * this.width * this.depth;
        }

        public InputTypeConvolutionalFlat(int height, int width, int depth) {
            this.height = height;
            this.width = width;
            this.depth = depth;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeConvolutionalFlat)) {
                return false;
            }
            InputTypeConvolutionalFlat other = (InputTypeConvolutionalFlat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getDepth() == other.getDepth();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeConvolutionalFlat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHeight();
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getDepth();
            return result;
        }

        public InputTypeConvolutionalFlat() {
        }
    }

    public static class InputTypeConvolutional
    extends InputType {
        private int height;
        private int width;
        private int depth;

        @Override
        public Type getType() {
            return Type.CNN;
        }

        @Override
        public String toString() {
            return "InputTypeConvolutional(h=" + this.height + ",w=" + this.width + ",d=" + this.depth + ")";
        }

        @Override
        public int arrayElementsPerExample() {
            return this.height * this.width * this.depth;
        }

        public InputTypeConvolutional(int height, int width, int depth) {
            this.height = height;
            this.width = width;
            this.depth = depth;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeConvolutional)) {
                return false;
            }
            InputTypeConvolutional other = (InputTypeConvolutional)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getDepth() == other.getDepth();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeConvolutional;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHeight();
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getDepth();
            return result;
        }

        public InputTypeConvolutional() {
        }
    }

    public static class InputTypeRecurrent
    extends InputType {
        private int size;
        private int timeSeriesLength;

        public InputTypeRecurrent(int size) {
            this(size, -1);
        }

        @Override
        public Type getType() {
            return Type.RNN;
        }

        @Override
        public String toString() {
            if (this.timeSeriesLength > 0) {
                return "InputTypeRecurrent(" + this.size + ",timeSeriesLength=" + this.timeSeriesLength + ")";
            }
            return "InputTypeRecurrent(" + this.size + ")";
        }

        @Override
        public int arrayElementsPerExample() {
            if (this.timeSeriesLength <= 0) {
                throw new IllegalStateException("Cannot calculate number of array elements per example: time series length is not set. Use InputType.recurrent(int size, int timeSeriesLength) instead?");
            }
            return this.timeSeriesLength * this.size;
        }

        public int getSize() {
            return this.size;
        }

        public int getTimeSeriesLength() {
            return this.timeSeriesLength;
        }

        public InputTypeRecurrent() {
        }

        public InputTypeRecurrent(int size, int timeSeriesLength) {
            this.size = size;
            this.timeSeriesLength = timeSeriesLength;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeRecurrent)) {
                return false;
            }
            InputTypeRecurrent other = (InputTypeRecurrent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            return this.getTimeSeriesLength() == other.getTimeSeriesLength();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeRecurrent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            result = result * 59 + this.getTimeSeriesLength();
            return result;
        }
    }

    public static class InputTypeFeedForward
    extends InputType {
        private int size;

        @Override
        public Type getType() {
            return Type.FF;
        }

        @Override
        public String toString() {
            return "InputTypeFeedForward(" + this.size + ")";
        }

        @Override
        public int arrayElementsPerExample() {
            return this.size;
        }

        public InputTypeFeedForward(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public InputTypeFeedForward() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeFeedForward)) {
                return false;
            }
            InputTypeFeedForward other = (InputTypeFeedForward)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getSize() == other.getSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeFeedForward;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            return result;
        }
    }

    public static enum Type {
        FF,
        RNN,
        CNN,
        CNNFlat;

    }
}

