/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;

public class StackVertex
extends GraphVertex {
    @Override
    public StackVertex clone() {
        return new StackVertex();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof StackVertex;
    }

    @Override
    public int numParams(boolean backprop) {
        return 0;
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int hashCode() {
        return 433682566;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams) {
        return new org.deeplearning4j.nn.graph.vertex.impl.StackVertex(graph, name, idx);
    }

    public String toString() {
        return "StackVertex()";
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length == 1) {
            return vertexInputs[0];
        }
        InputType first = vertexInputs[0];
        if (first.getType() == InputType.Type.CNNFlat) {
            throw new InvalidInputTypeException("Invalid input: StackVertex cannot currently merge CNN data in flattened format. Got: " + vertexInputs);
        }
        if (first.getType() != InputType.Type.CNN) {
            int size = 0;
            int tsLength = -1;
            InputType.Type type = null;
            for (int i = 0; i < vertexInputs.length; ++i) {
                int thisSize;
                if (vertexInputs[i].getType() != first.getType()) {
                    throw new InvalidInputTypeException("Invalid input: StackVertex cannot merge activations of different types: first type = " + (Object)((Object)first.getType()) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
                }
                switch (vertexInputs[i].getType()) {
                    case FF: {
                        thisSize = ((InputType.InputTypeFeedForward)vertexInputs[i]).getSize();
                        type = InputType.Type.FF;
                        break;
                    }
                    case RNN: {
                        thisSize = ((InputType.InputTypeRecurrent)vertexInputs[i]).getSize();
                        tsLength = ((InputType.InputTypeRecurrent)vertexInputs[i]).getTimeSeriesLength();
                        type = InputType.Type.RNN;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown input type: " + vertexInputs[i]);
                    }
                }
                if (thisSize <= 0) {
                    size = -1;
                    continue;
                }
                size += thisSize;
            }
            if (size > 0) {
                if (type == InputType.Type.FF) {
                    return InputType.feedForward(size);
                }
                return InputType.recurrent(size, tsLength);
            }
            if (type == InputType.Type.FF) {
                return InputType.feedForward(-1);
            }
            return InputType.recurrent(-1, tsLength);
        }
        InputType.InputTypeConvolutional firstConv = (InputType.InputTypeConvolutional)first;
        int fd = firstConv.getDepth();
        int fw = firstConv.getWidth();
        int fh = firstConv.getHeight();
        int depthSum = fd;
        for (int i = 1; i < vertexInputs.length; ++i) {
            if (vertexInputs[i].getType() != InputType.Type.CNN) {
                throw new InvalidInputTypeException("Invalid input: StackVertex cannot process activations of different types: first type = " + (Object)((Object)InputType.Type.CNN) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
            }
            InputType.InputTypeConvolutional otherConv = (InputType.InputTypeConvolutional)vertexInputs[i];
            int od = otherConv.getDepth();
            int ow = otherConv.getWidth();
            int oh = otherConv.getHeight();
            if (fw != ow || fh != oh) {
                throw new InvalidInputTypeException("Invalid input: StackVertex cannot merge CNN activations of different width/heights:first [depth,width,height] = [" + fd + "," + fw + "," + fh + "], input " + i + " = [" + od + "," + ow + "," + oh + "]");
            }
            depthSum += od;
        }
        return InputType.convolutional(fh, fw, depthSum);
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        InputType outputType = this.getOutputType(-1, inputTypes);
        return new LayerMemoryReport.Builder(null, StackVertex.class, inputTypes[0], outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }
}

