/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.dropout;

import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.random.impl.DropOutInverted;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class Dropout
implements IDropout {
    private double p;
    private ISchedule pSchedule;

    public Dropout(double activationRetainProbability) {
        this(activationRetainProbability, null);
        if (activationRetainProbability < 0.0) {
            throw new IllegalArgumentException("Activation retain probability must be > 0. Got: " + activationRetainProbability);
        }
        if (activationRetainProbability == 0.0) {
            throw new IllegalArgumentException("Invalid probability value: Dropout with 0.0 probability of retaining activations is not supported");
        }
    }

    public Dropout(ISchedule activationRetainProbabilitySchedule) {
        this(Double.NaN, activationRetainProbabilitySchedule);
    }

    protected Dropout(@JsonProperty(value="p") double activationRetainProbability, @JsonProperty(value="pSchedule") ISchedule activationRetainProbabilitySchedule) {
        this.p = activationRetainProbability;
        this.pSchedule = activationRetainProbabilitySchedule;
    }

    @Override
    public INDArray applyDropout(INDArray inputActivations, int iteration, int epoch, boolean inPlace) {
        double currP = this.pSchedule != null ? this.pSchedule.valueAt(iteration, epoch) : this.p;
        INDArray result = inPlace ? inputActivations : inputActivations.dup(inputActivations.ordering());
        Nd4j.getExecutioner().exec((RandomOp)new DropOutInverted(result, currP));
        return result;
    }

    @Override
    public Dropout clone() {
        return new Dropout(this.p, this.pSchedule == null ? null : this.pSchedule.clone());
    }

    public double getP() {
        return this.p;
    }

    public ISchedule getPSchedule() {
        return this.pSchedule;
    }

    public void setP(double p) {
        this.p = p;
    }

    public void setPSchedule(ISchedule pSchedule) {
        this.pSchedule = pSchedule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dropout)) {
            return false;
        }
        Dropout other = (Dropout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getP(), other.getP()) != 0) {
            return false;
        }
        ISchedule this$pSchedule = this.getPSchedule();
        ISchedule other$pSchedule = other.getPSchedule();
        return !(this$pSchedule == null ? other$pSchedule != null : !this$pSchedule.equals(other$pSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Dropout;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $p = Double.doubleToLongBits(this.getP());
        result = result * 59 + (int)($p >>> 32 ^ $p);
        ISchedule $pSchedule = this.getPSchedule();
        result = result * 59 + ($pSchedule == null ? 43 : $pSchedule.hashCode());
        return result;
    }

    public String toString() {
        return "Dropout(p=" + this.getP() + ", pSchedule=" + this.getPSchedule() + ")";
    }
}

