/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.eval.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.deeplearning4j.eval.ConfusionMatrix;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.node.ArrayNode;
import org.nd4j.shade.jackson.databind.node.ObjectNode;

public class ConfusionMatrixDeserializer
extends JsonDeserializer<ConfusionMatrix<Integer>> {
    public ConfusionMatrix<Integer> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode n = (JsonNode)jp.getCodec().readTree(jp);
        ArrayNode classesNode = (ArrayNode)n.get("classes");
        ArrayList<Integer> classes = new ArrayList<Integer>();
        for (JsonNode cn : classesNode) {
            classes.add(cn.asInt());
        }
        ConfusionMatrix<Integer> cm = new ConfusionMatrix<Integer>(classes);
        ObjectNode matrix = (ObjectNode)n.get("matrix");
        Iterator matrixIter = matrix.fields();
        while (matrixIter.hasNext()) {
            Map.Entry e = (Map.Entry)matrixIter.next();
            int actualClass = Integer.parseInt((String)e.getKey());
            ArrayNode an = (ArrayNode)e.getValue();
            ArrayNode innerMultiSetKey = (ArrayNode)an.get(0);
            ArrayNode innerMultiSetCount = (ArrayNode)an.get(1);
            Iterator iterKey = innerMultiSetKey.iterator();
            Iterator iterCnt = innerMultiSetCount.iterator();
            while (iterKey.hasNext()) {
                int predictedClass = ((JsonNode)iterKey.next()).asInt();
                int count = ((JsonNode)iterCnt.next()).asInt();
                cm.add(actualClass, predictedClass, count);
            }
        }
        return cm;
    }
}

