/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.LossLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class RnnLossLayer
extends FeedForwardLayer {
    private RNNFormat rnnDataFormat = RNNFormat.NCW;
    protected ILossFunction lossFn;

    private RnnLossLayer(Builder builder) {
        super(builder);
        this.setLossFn(builder.lossFn);
        this.rnnDataFormat = builder.rnnDataFormat;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.recurrent.RnnLossLayer ret = new org.deeplearning4j.nn.layers.recurrent.RnnLossLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input type for RnnLossLayer (layer index = " + layerIndex + ", layer name=\"" + this.getLayerName() + "\"): Expected RNN input, got " + inputType);
        }
        return inputType;
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        return InputTypeUtil.getPreprocessorForInputTypeRnnLayers(inputType, RNNFormat.NCW, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return new LayerMemoryReport.Builder(this.layerName, LossLayer.class, inputType, inputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    public RNNFormat getRnnDataFormat() {
        return this.rnnDataFormat;
    }

    public ILossFunction getLossFn() {
        return this.lossFn;
    }

    public void setRnnDataFormat(RNNFormat rnnDataFormat) {
        this.rnnDataFormat = rnnDataFormat;
    }

    public void setLossFn(ILossFunction lossFn) {
        this.lossFn = lossFn;
    }

    public RnnLossLayer() {
    }

    @Override
    public String toString() {
        return "RnnLossLayer(super=" + super.toString() + ", rnnDataFormat=" + this.getRnnDataFormat() + ", lossFn=" + this.getLossFn() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RnnLossLayer)) {
            return false;
        }
        RnnLossLayer other = (RnnLossLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RNNFormat this$rnnDataFormat = this.getRnnDataFormat();
        RNNFormat other$rnnDataFormat = other.getRnnDataFormat();
        if (this$rnnDataFormat == null ? other$rnnDataFormat != null : !this$rnnDataFormat.equals(other$rnnDataFormat)) {
            return false;
        }
        ILossFunction this$lossFn = this.getLossFn();
        ILossFunction other$lossFn = other.getLossFn();
        return !(this$lossFn == null ? other$lossFn != null : !this$lossFn.equals(other$lossFn));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RnnLossLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RNNFormat $rnnDataFormat = this.getRnnDataFormat();
        result = result * 59 + ($rnnDataFormat == null ? 43 : $rnnDataFormat.hashCode());
        ILossFunction $lossFn = this.getLossFn();
        result = result * 59 + ($lossFn == null ? 43 : $lossFn.hashCode());
        return result;
    }

    public static class Builder
    extends BaseOutputLayer.Builder<Builder> {
        private RNNFormat rnnDataFormat = RNNFormat.NCW;

        public Builder() {
        }

        public Builder(LossFunctions.LossFunction lossFunction) {
            this.lossFunction(lossFunction);
        }

        public Builder(ILossFunction lossFunction) {
            this.setLossFn(lossFunction);
        }

        @Override
        public Builder nIn(int nIn) {
            throw new UnsupportedOperationException("Ths layer has no parameters, thus nIn will always equal nOut.");
        }

        @Override
        public Builder nOut(int nOut) {
            throw new UnsupportedOperationException("Ths layer has no parameters, thus nIn will always equal nOut.");
        }

        @Override
        public void setNIn(long nIn) {
            throw new UnsupportedOperationException("This layer has no parameters, thus nIn will always equal nOut.");
        }

        @Override
        public void setNOut(long nOut) {
            throw new UnsupportedOperationException("This layer has no parameters, thus nIn will always equal nOut.");
        }

        public Builder dataFormat(RNNFormat rnnDataFormat) {
            this.rnnDataFormat = rnnDataFormat;
            return this;
        }

        @Override
        public RnnLossLayer build() {
            return new RnnLossLayer(this);
        }
    }
}

