/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.conf.preprocessor.CnnToRnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToCnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToRnnPreProcessor;
import org.nd4j.common.primitives.Counter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputTypeUtil {
    private static final Logger log = LoggerFactory.getLogger(InputTypeUtil.class);

    private InputTypeUtil() {
    }

    public static InputType getOutputTypeDeconvLayer(InputType inputType, int[] kernelSize, int[] stride, int[] padding, int[] dilation, ConvolutionMode convolutionMode, long outputDepth, long layerIdx, String layerName, Class<?> layerClass) {
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        long hIn = i.getHeight();
        long wIn = i.getWidth();
        int padH = padding == null ? 0 : padding[0];
        int padW = padding == null ? 0 : padding[1];
        int kH = kernelSize[0];
        int kW = kernelSize[1];
        if (dilation[0] != 1) {
            kH += (kH - 1) * (dilation[0] - 1);
        }
        if (dilation[1] != 1) {
            kW += (kW - 1) * (dilation[1] - 1);
        }
        int sH = stride[0];
        int sW = stride[1];
        if (sH <= 0 || sW <= 0) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, sH <= 0) + " Invalid strides: strides must be > 0 (strideH = " + sH + ", strideW = " + sW + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
        }
        if (convolutionMode == ConvolutionMode.Same) {
            long hOut = (long)stride[0] * hIn;
            long wOut = (long)stride[1] * wIn;
            return InputType.convolutional(hOut, wOut, outputDepth, i.getFormat());
        }
        long hOut = (long)sH * (hIn - 1L) + (long)kH - (long)(2 * padH);
        long wOut = (long)sW * (wIn - 1L) + (long)kW - (long)(2 * padW);
        return InputType.convolutional(hOut, wOut, outputDepth, i.getFormat());
    }

    public static InputType getOutputTypeDeconv3dLayer(InputType inputType, int[] kernelSize, int[] stride, int[] padding, int[] dilation, ConvolutionMode convolutionMode, Convolution3D.DataFormat dataFormat, long outputDepth, long layerIdx, String layerName, Class<?> layerClass) {
        InputType.InputTypeConvolutional3D i = (InputType.InputTypeConvolutional3D)inputType;
        long hIn = i.getHeight();
        long wIn = i.getWidth();
        long dIn = i.getDepth();
        int padH = padding == null ? 0 : padding[0];
        int padW = padding == null ? 0 : padding[1];
        int padD = padding == null ? 0 : padding[2];
        int kH = kernelSize[0];
        int kW = kernelSize[1];
        int kD = kernelSize[2];
        if (dilation[0] != 1) {
            kH += (kH - 1) * (dilation[0] - 1);
        }
        if (dilation[1] != 1) {
            kW += (kW - 1) * (dilation[1] - 1);
        }
        if (dilation[2] != 1) {
            kD += (kD - 1) * (dilation[2] - 1);
        }
        int sH = stride[0];
        int sW = stride[1];
        int sD = stride[2];
        if (sH <= 0 || sW <= 0 || sD <= 0) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, sH <= 0) + " Invalid strides: strides must be > 0 (strideH = " + sH + ", strideW = " + sW + ", stride = " + sD + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
        }
        if (convolutionMode == ConvolutionMode.Same) {
            long hOut = (long)stride[0] * hIn;
            long wOut = (long)stride[1] * wIn;
            long dOut = (long)stride[2] * dIn;
            return InputType.convolutional3D(dataFormat, dOut, hOut, wOut, outputDepth);
        }
        long hOut = (long)sH * (hIn - 1L) + (long)kH - (long)(2 * padH);
        long wOut = (long)sW * (wIn - 1L) + (long)kW - (long)(2 * padW);
        long dOut = (long)sD * (dIn - 1L) + (long)kD - (long)(2 * padD);
        return InputType.convolutional3D(dataFormat, dOut, hOut, wOut, outputDepth);
    }

    public static InputType getOutputTypeCnn3DLayers(InputType inputType, Convolution3D.DataFormat dataFormat, int[] kernelSize, int[] stride, int[] padding, int[] dilation, ConvolutionMode convolutionMode, long outputChannels, long layerIdx, String layerName, Class<?> layerClass) {
        if (convolutionMode == null) {
            String name = layerName == null ? "(not named)" : layerName;
            throw new DL4JInvalidConfigException("Invalid configuration: convolution mode is null for layer (idx=" + layerIdx + ", name=" + name + ", type=" + layerClass.getName() + ")");
        }
        InputType.InputTypeConvolutional3D i = (InputType.InputTypeConvolutional3D)inputType;
        long inDepth = i.getDepth();
        long inHeight = i.getHeight();
        long inWidth = i.getWidth();
        int padD = padding == null ? 0 : padding[0];
        int padH = padding == null ? 0 : padding[1];
        int padW = padding == null ? 0 : padding[2];
        int kD = kernelSize[0];
        int kH = kernelSize[1];
        int kW = kernelSize[2];
        if (dilation[0] != 1) {
            kD += (kD - 1) * (dilation[0] - 1);
        }
        if (dilation[1] != 1) {
            kH += (kH - 1) * (dilation[1] - 1);
        }
        if (dilation[2] != 1) {
            kW += (kW - 1) * (dilation[2] - 1);
        }
        int sD = stride[0];
        int sH = stride[1];
        int sW = stride[1];
        if (sH <= 0 || sW <= 0 || sD <= 0) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, sH <= 0) + " Invalid strides: strides must be > 0 (strideH = " + sH + ", strideW = " + sW + ", strideD = " + sD + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
        }
        if (kH <= 0 || padH > 0 && (long)kH > inHeight + (long)(2 * padH)) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + " Invalid input configuration for kernel height. Require 0 < kH <= inHeight + 2*padH; got (kH=" + kH + ", inHeight=" + inHeight + ", padH=" + padH + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
        }
        if (kW <= 0 || padW > 0 && (long)kW > inWidth + (long)(2 * padW)) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + " Invalid input configuration for kernel width. Require 0 < kW <= inWidth + 2*padW; got (kW=" + kW + ", inWidth=" + inWidth + ", padW=" + padW + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
        }
        if (kD <= 0 || padD > 0 && (long)kD > inDepth + (long)(2 * padD)) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + " Invalid input configuration for kernel channels. Require 0 < kD <= inDepth + 2*padD; got (kD=" + kD + ", inDepth=" + inDepth + ", padD=" + padD + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
        }
        if (convolutionMode == ConvolutionMode.Strict) {
            if ((inHeight - (long)kH + (long)(2 * padH)) % (long)sH != 0L) {
                double d = (double)(inHeight - (long)kH + (long)(2 * padH)) / (double)sH + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inHeight / (double)stride[0]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + "\nCombination of kernel size, stride and padding are not valid for given input height, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output height = (input height - kernelSize + 2*padding)/stride + 1 in height dimension to be an integer. Got: (" + inHeight + " - " + kH + " + 2*" + padH + ")/" + sH + " + 1 = " + str + "\nSee ConvolutionType enumeration Javadoc and \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/\nTo truncate/crop the input, such that output height = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output height of ceil(" + inHeight + "/" + stride[0] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
            }
            if ((inWidth - (long)kW + (long)(2 * padW)) % (long)sW != 0L) {
                double d = (double)(inWidth - (long)kW + (long)(2 * padW)) / (double)sW + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inWidth / (double)stride[1]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + "\nCombination of kernel size, stride and padding are not valid for given input width, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output width = (input width - kernelSize + 2*padding)/stride + 1 in width dimension to be an integer. Got: (" + inWidth + " - " + kW + " + 2*" + padW + ")/" + sW + " + 1 = " + str + "\nSee \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\nTo truncate/crop the input, such that output width = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output width of ceil(" + inWidth + "/" + stride[1] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
            }
            if ((inDepth - (long)kD + (long)(2 * padD)) % (long)sD != 0L) {
                double d = (double)(inDepth - (long)kD + (long)(2 * padD)) / (double)sD + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inDepth / (double)stride[2]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + "\nCombination of kernel size, stride and padding are not valid for given input width, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output channels = (input channels - kernelSize + 2*padding)/stride + 1 in width dimension to be an integer. Got: (" + inDepth + " - " + kD + " + 2*" + padD + ")/" + sD + " + 1 = " + str + "\nSee \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\nTo truncate/crop the input, such that output width = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output width of ceil(" + inDepth + "/" + stride[2] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
            }
        } else if (convolutionMode == ConvolutionMode.Same) {
            int outD = (int)Math.ceil((double)inDepth / (double)sD);
            int outH = (int)Math.ceil((double)inHeight / (double)sH);
            int outW = (int)Math.ceil((double)inWidth / (double)sW);
            return InputType.convolutional3D(dataFormat, outD, outH, outW, outputChannels);
        }
        long dOut = (inDepth - (long)kD + (long)(2 * padD)) / (long)sD + 1L;
        long hOut = (inHeight - (long)kH + (long)(2 * padH)) / (long)sH + 1L;
        long wOut = (inWidth - (long)kW + (long)(2 * padW)) / (long)sW + 1L;
        return InputType.convolutional3D(dOut, hOut, wOut, outputChannels);
    }

    public static InputType getOutputTypeCnn1DLayers(InputType inputType, int kH, int sH, int padH, int dilation, ConvolutionMode convolutionMode, long outputDepth, long layerIdx, String layerName, Class<?> layerClass) {
        if (convolutionMode == null) {
            String name = layerName == null ? "(not named)" : layerName;
            throw new DL4JInvalidConfigException("Invalid configuration: convolution mode is null for layer (idx=" + layerIdx + ", name=" + name + ", type=" + layerClass.getName() + ")");
        }
        InputType.InputTypeRecurrent i = (InputType.InputTypeRecurrent)inputType;
        int inHeight = (int)i.getTimeSeriesLength();
        if (dilation != 1) {
            kH += (kH - 1) * (dilation - 1);
        }
        if (sH <= 0) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, sH <= 0) + " Invalid strides: strides must be > 0 (strideH = " + sH + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine1D(inputType, kH, sH, padH, outputDepth, convolutionMode));
        }
        if (kH <= 0 || padH > 0 && kH > inHeight + 2 * padH) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + " Invalid input configuration for kernel height. Require 0 < kH <= inHeight + 2*padH; got (kH=" + kH + ", inHeight=" + inHeight + ", padH=" + padH + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine1D(inputType, kH, sH, padH, outputDepth, convolutionMode));
        }
        if (convolutionMode == ConvolutionMode.Strict) {
            if ((inHeight - kH + 2 * padH) % sH != 0) {
                double d = (double)(inHeight - kH + 2 * padH) / (double)sH + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inHeight / (double)sH);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + "\nCombination of kernel size, stride and padding are not valid for given input height, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output height = (input height - kernelSize + 2*padding)/stride + 1 in height dimension to be an integer. Got: (" + inHeight + " - " + kH + " + 2*" + padH + ")/" + sH + " + 1 = " + str + "\nSee ConvolutionType enumeration Javadoc and \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/\nTo truncate/crop the input, such that output height = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output height of ceil(" + inHeight + "/" + sH + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine1D(inputType, kH, sH, padH, outputDepth, convolutionMode));
            }
        } else if (convolutionMode == ConvolutionMode.Same) {
            int outH = (int)Math.ceil((double)inHeight / (double)sH);
            return InputType.recurrent(outputDepth, outH);
        }
        int outH = (inHeight - kH + 2 * padH) / sH + 1;
        return InputType.recurrent(outputDepth, outH);
    }

    @Deprecated
    public static InputType getOutputTypeCnnLayers(InputType inputType, int[] kernelSize, int[] stride, int[] padding, int[] dilation, ConvolutionMode convolutionMode, long outputDepth, long layerIdx, String layerName, Class<?> layerClass) {
        return InputTypeUtil.getOutputTypeCnnLayers(inputType, kernelSize, stride, padding, dilation, convolutionMode, outputDepth, layerIdx, layerName, CNN2DFormat.NCHW, layerClass);
    }

    public static InputType getOutputTypeCnnLayers(InputType inputType, int[] kernelSize, int[] stride, int[] padding, int[] dilation, ConvolutionMode convolutionMode, long outputDepth, long layerIdx, String layerName, CNN2DFormat format, Class<?> layerClass) {
        if (convolutionMode == null) {
            String name = layerName == null ? "(not named)" : layerName;
            throw new DL4JInvalidConfigException("Invalid configuration: convolution mode is null for layer (idx=" + layerIdx + ", name=" + name + ", type=" + layerClass.getName() + ")");
        }
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        long inHeight = i.getHeight();
        long inWidth = i.getWidth();
        if (format != i.getFormat()) {
            if (format == CNN2DFormat.NCHW) {
                inWidth = i.getChannels();
                outputDepth = i.getWidth();
            } else if (format == CNN2DFormat.NHWC) {
                inWidth = i.getChannels();
                outputDepth = i.getWidth();
            }
        }
        int padH = padding == null ? 0 : padding[0];
        int padW = padding == null ? 0 : padding[1];
        int kH = kernelSize[0];
        int kW = kernelSize[1];
        if (dilation[0] != 1) {
            kH += (kH - 1) * (dilation[0] - 1);
        }
        if (dilation[1] != 1) {
            kW += (kW - 1) * (dilation[1] - 1);
        }
        int sH = stride[0];
        int sW = stride[1];
        if (sH <= 0 || sW <= 0) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, sH <= 0) + " Invalid strides: strides must be > 0 (strideH = " + sH + ", strideW = " + sW + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
        }
        if (kH <= 0 || padH > 0 && padH > 0 && (long)kH > inHeight + (long)(2 * padH)) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + " Invalid input configuration for kernel height. Require 0 < kH <= inHeight + 2*padH; got (kH=" + kH + ", inHeight=" + inHeight + ", padH=" + padH + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
        }
        if (kW <= 0 || padW > 0 && padW > 0 && (long)kW > inWidth + (long)(2 * padW)) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + " Invalid input configuration for kernel width. Require 0 < kW <= inWidth + 2*padW; got (kW=" + kW + ", inWidth=" + inWidth + ", padW=" + padW + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
        }
        if (convolutionMode == ConvolutionMode.Strict) {
            if ((inHeight - (long)kH + (long)(2 * padH)) % (long)sH != 0L) {
                double d = (double)(inHeight - (long)kH + (long)(2 * padH)) / (double)sH + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inHeight / (double)stride[0]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + "\nCombination of kernel size, stride and padding are not valid for given input height, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output height = (input height - kernelSize + 2*padding)/stride + 1 in height dimension to be an integer. Got: (" + inHeight + " - " + kH + " + 2*" + padH + ")/" + sH + " + 1 = " + str + "\nSee ConvolutionType enumeration Javadoc and \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/\nTo truncate/crop the input, such that output height = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output height of ceil(" + inHeight + "/" + stride[0] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
            }
            if ((inWidth - (long)kW + (long)(2 * padW)) % (long)sW != 0L) {
                double d = (double)(inWidth - (long)kW + (long)(2 * padW)) / (double)sW + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inWidth / (double)stride[1]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + "\nCombination of kernel size, stride and padding are not valid for given input width, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output width = (input width - kernelSize + 2*padding)/stride + 1 in width dimension to be an integer. Got: (" + inWidth + " - " + kW + " + 2*" + padW + ")/" + sW + " + 1 = " + str + "\nSee \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\nTo truncate/crop the input, such that output width = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output width of ceil(" + inWidth + "/" + stride[1] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
            }
        } else if (convolutionMode == ConvolutionMode.Same) {
            int outH = (int)Math.ceil((double)inHeight / (double)stride[0]);
            int outW = (int)Math.ceil((double)inWidth / (double)stride[1]);
            return InputType.convolutional(outH, outW, outputDepth, format);
        }
        long hOut = (inHeight - (long)kH + (long)(2 * padH)) / (long)sH + 1L;
        long wOut = (inWidth - (long)kW + (long)(2 * padW)) / (long)sW + 1L;
        return InputType.convolutional(hOut, wOut, outputDepth, format);
    }

    private static String getConfigErrorCommonLine(long layerIdx, String layerName, Class<?> layerClass, boolean isHeight) {
        String name = layerName == null ? "(not named)" : layerName;
        String layerType = layerClass.getSimpleName();
        return "Invalid configuration for layer (idx=" + layerIdx + ", name=" + name + ", type=" + layerType + ") for " + (isHeight ? "height" : "width") + " dimension: ";
    }

    private static String getConfigErrorCommonLastLine1D(InputType inputType, int kernelSize, int stride, int padding, long outputDepth, ConvolutionMode convolutionMode) {
        return "Input type = " + inputType + ", kernel = " + kernelSize + ", strides = " + stride + ", padding = " + padding + ", layer size (output channels) = " + outputDepth + ", convolution mode = " + (Object)((Object)convolutionMode);
    }

    private static String getConfigErrorCommonLastLine(InputType inputType, int[] kernelSize, int[] stride, int[] padding, long outputDepth, ConvolutionMode convolutionMode) {
        return "Input type = " + inputType + ", kernel = " + Arrays.toString(kernelSize) + ", strides = " + Arrays.toString(stride) + ", padding = " + Arrays.toString(padding) + ", layer size (output channels) = " + outputDepth + ", convolution mode = " + (Object)((Object)convolutionMode);
    }

    public static InputPreProcessor getPreProcessorForInputTypeCnn3DLayers(InputType inputType, String layerName) {
        switch (inputType.getType()) {
            case FF: {
                log.info("Automatic addition of FF -> CNN3D preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case RNN: {
                log.warn("Automatic addition of RNN -> CNN3D preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case CNN3D: {
                return null;
            }
        }
        throw new RuntimeException("Unknown input type: " + inputType);
    }

    public static InputPreProcessor getPreProcessorForInputTypeCnnLayers(InputType inputType, String layerName) {
        switch (inputType.getType()) {
            case FF: {
                log.info("Automatic addition of FF -> CNN preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case RNN: {
                log.warn("Automatic addition of RNN -> CNN preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case CNN: {
                return null;
            }
            case CNNFlat: {
                InputType.InputTypeConvolutionalFlat f = (InputType.InputTypeConvolutionalFlat)inputType;
                return new FeedForwardToCnnPreProcessor(f.getHeight(), f.getWidth(), f.getDepth());
            }
        }
        throw new RuntimeException("Unknown input type: " + inputType);
    }

    public static InputPreProcessor getPreprocessorForInputTypeRnnLayers(InputType inputType, RNNFormat rnnDataFormat, String layerName) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for RNN layer (layer name = \"" + layerName + "\"): input type is null");
        }
        switch (inputType.getType()) {
            case CNNFlat: {
                return new FeedForwardToRnnPreProcessor(rnnDataFormat);
            }
            case FF: {
                InputType.InputTypeFeedForward ff = (InputType.InputTypeFeedForward)inputType;
                if (ff.getTimeDistributedFormat() != null && ff.getTimeDistributedFormat() instanceof RNNFormat) {
                    return new FeedForwardToRnnPreProcessor((RNNFormat)ff.getTimeDistributedFormat());
                }
                return new FeedForwardToRnnPreProcessor(rnnDataFormat);
            }
            case RNN: {
                return null;
            }
            case CNN: {
                InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
                return new CnnToRnnPreProcessor(c.getHeight(), c.getWidth(), c.getChannels(), rnnDataFormat);
            }
        }
        throw new RuntimeException("Unknown input type: " + inputType);
    }

    public static void convertMultipleTypes(InputType[] vertexInputs) {
        Counter counter = new Counter();
        for (int i = 0; i < vertexInputs.length; ++i) {
            counter.incrementCount((Object)vertexInputs[i].getType(), 1.0);
        }
        InputType.Type maxType = (InputType.Type)((Object)counter.argMax());
        if (counter.size() > 1) {
            switch (maxType) {
                case FF: {
                    block11: for (int i = 0; i < vertexInputs.length; ++i) {
                        if (vertexInputs[i].getType() == maxType) continue;
                        switch (vertexInputs[i].getType()) {
                            case RNN: {
                                InputType.InputTypeRecurrent recurrent = (InputType.InputTypeRecurrent)vertexInputs[i];
                                if (recurrent.getTimeSeriesLength() != 1L) continue block11;
                                vertexInputs[i] = InputType.feedForward(recurrent.getSize());
                                continue block11;
                            }
                            default: {
                                throw new IllegalArgumentException("Attempted conversion of types and was unable to");
                            }
                        }
                    }
                    break;
                }
                case RNN: {
                    int i;
                    RNNFormat rnnFormat = null;
                    for (i = 0; i < vertexInputs.length; ++i) {
                        if (vertexInputs[i].getType() != InputType.Type.RNN) continue;
                        InputType.InputTypeRecurrent firstRecurrent = (InputType.InputTypeRecurrent)vertexInputs[i];
                        rnnFormat = firstRecurrent.getFormat();
                        break;
                    }
                    block13: for (i = 0; i < vertexInputs.length; ++i) {
                        if (vertexInputs[i].getType() == maxType) continue;
                        switch (vertexInputs[i].getType()) {
                            case FF: {
                                InputType.InputTypeFeedForward ff = (InputType.InputTypeFeedForward)vertexInputs[i];
                                vertexInputs[i] = InputType.recurrent(ff.getSize(), rnnFormat);
                                continue block13;
                            }
                            default: {
                                throw new IllegalArgumentException("Attempted conversion of types and was unable to");
                            }
                        }
                    }
                    break;
                }
            }
        }
    }
}

