/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.terminations;

import org.apache.commons.math3.util.FastMath;
import org.deeplearning4j.optimize.api.TerminationCondition;
import org.nd4j.linalg.factory.Nd4j;

public class EpsTermination
implements TerminationCondition {
    private double eps = 1.0E-4;
    private double tolerance = Nd4j.EPS_THRESHOLD;

    public EpsTermination(double eps, double tolerance) {
        this.eps = eps;
        this.tolerance = tolerance;
    }

    public EpsTermination() {
    }

    @Override
    public boolean terminate(double cost, double old, Object[] otherParams) {
        if (cost == 0.0 && old == 0.0) {
            return false;
        }
        double aO = FastMath.abs((double)old);
        double aC = FastMath.abs((double)cost);
        if (otherParams.length >= 2) {
            double eps = (Double)otherParams[0];
            double tolerance = (Double)otherParams[1];
            return 2.0 * FastMath.abs((double)(old - cost)) <= tolerance * (aO + aC + eps);
        }
        return 2.0 * FastMath.abs((double)(old - cost)) <= this.tolerance * (aO + aC + this.eps);
    }
}

