/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.transferlearning;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FineTuneConfiguration {
    protected IActivation activationFn;
    protected WeightInit weightInit;
    protected Double biasInit;
    protected Distribution dist;
    protected Double learningRate;
    protected Double biasLearningRate;
    protected Map<Integer, Double> learningRateSchedule;
    protected Double lrScoreBasedDecay;
    protected Double l1;
    protected Double l2;
    protected Double l1Bias;
    protected Double l2Bias;
    protected Double dropOut;
    @Deprecated
    protected Updater updater;
    protected IUpdater iUpdater;
    @Deprecated
    protected Double momentum;
    @Deprecated
    protected Map<Integer, Double> momentumSchedule;
    @Deprecated
    protected Double epsilon;
    @Deprecated
    protected Double rho;
    @Deprecated
    protected Double rmsDecay;
    @Deprecated
    protected Double adamMeanDecay;
    @Deprecated
    protected Double adamVarDecay;
    protected Boolean miniBatch;
    protected Integer numIterations;
    protected Integer maxNumLineSearchIterations;
    protected Long seed;
    protected Boolean useRegularization;
    protected OptimizationAlgorithm optimizationAlgo;
    protected StepFunction stepFunction;
    protected Boolean useDropConnect;
    protected Boolean minimize;
    protected GradientNormalization gradientNormalization;
    protected Double gradientNormalizationThreshold;
    protected LearningRatePolicy learningRatePolicy;
    protected Double lrPolicyDecayRate;
    protected Double lrPolicySteps;
    protected Double lrPolicyPower;
    protected ConvolutionMode convolutionMode;
    protected Boolean pretrain;
    protected Boolean backprop;
    protected BackpropType backpropType;
    protected Integer tbpttFwdLength;
    protected Integer tbpttBackLength;

    public NeuralNetConfiguration appliedNeuralNetConfiguration(NeuralNetConfiguration nnc) {
        this.applyToNeuralNetConfiguration(nnc);
        nnc = new NeuralNetConfiguration.Builder(nnc.clone()).build();
        return nnc;
    }

    public void applyToNeuralNetConfiguration(NeuralNetConfiguration nnc) {
        BaseLayer bl;
        Layer l = nnc.getLayer();
        Updater originalUpdater = null;
        WeightInit origWeightInit = null;
        if (l != null && this.dropOut != null) {
            l.setDropOut(this.dropOut);
        }
        if (l != null && l instanceof BaseLayer) {
            bl = (BaseLayer)l;
            originalUpdater = bl.getUpdater();
            origWeightInit = bl.getWeightInit();
            if (this.activationFn != null) {
                bl.setActivationFn(this.activationFn);
            }
            if (this.weightInit != null) {
                bl.setWeightInit(this.weightInit);
            }
            if (this.biasInit != null) {
                bl.setBiasInit(this.biasInit);
            }
            if (this.dist != null) {
                bl.setDist(this.dist);
            }
            if (this.learningRate != null) {
                bl.setLearningRate(this.learningRate);
                bl.setBiasLearningRate(this.learningRate);
            }
            if (this.biasLearningRate != null) {
                bl.setBiasLearningRate(this.biasLearningRate);
            }
            if (this.learningRateSchedule != null) {
                bl.setLearningRateSchedule(this.learningRateSchedule);
            }
            if (this.l1 != null) {
                bl.setL1(this.l1);
            }
            if (this.l2 != null) {
                bl.setL2(this.l2);
            }
            if (this.l1Bias != null) {
                bl.setL1Bias(this.l1Bias);
            }
            if (this.l2Bias != null) {
                bl.setL2Bias(this.l2Bias);
            }
            if (this.updater != null) {
                bl.setUpdater(this.updater);
            }
            if (this.iUpdater != null) {
                bl.setIUpdater(this.iUpdater);
            }
            if (this.momentum != null) {
                bl.setMomentum(this.momentum);
            }
            if (this.momentumSchedule != null) {
                bl.setMomentum(this.momentum);
            }
            if (this.epsilon != null) {
                bl.setEpsilon(this.epsilon);
            }
            if (this.rho != null) {
                bl.setRho(this.rho);
            }
            if (this.rmsDecay != null) {
                bl.setRmsDecay(this.rmsDecay);
            }
            if (this.adamMeanDecay != null) {
                bl.setAdamMeanDecay(this.adamMeanDecay);
            }
            if (this.adamVarDecay != null) {
                bl.setAdamVarDecay(this.adamVarDecay);
            }
            if (this.gradientNormalization != null) {
                bl.setGradientNormalization(this.gradientNormalization);
            }
            if (this.gradientNormalizationThreshold != null) {
                bl.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
            }
        }
        if (this.miniBatch != null) {
            nnc.setMiniBatch(this.miniBatch);
        }
        if (this.numIterations != null) {
            nnc.setNumIterations(this.numIterations);
        }
        if (this.maxNumLineSearchIterations != null) {
            nnc.setMaxNumLineSearchIterations(this.maxNumLineSearchIterations);
        }
        if (this.seed != null) {
            nnc.setSeed(this.seed);
        }
        if (this.useRegularization != null) {
            nnc.setUseRegularization(this.useRegularization);
        }
        if (this.optimizationAlgo != null) {
            nnc.setOptimizationAlgo(this.optimizationAlgo);
        }
        if (this.stepFunction != null) {
            nnc.setStepFunction(this.stepFunction);
        }
        if (this.useDropConnect != null) {
            nnc.setUseDropConnect(this.useDropConnect);
        }
        if (this.minimize != null) {
            nnc.setMinimize(this.minimize);
        }
        if (this.learningRatePolicy != null) {
            nnc.setLearningRatePolicy(this.learningRatePolicy);
        }
        if (this.lrPolicySteps != null) {
            nnc.setLrPolicySteps(this.lrPolicySteps);
        }
        if (this.lrPolicyPower != null) {
            nnc.setLrPolicyPower(this.lrPolicyPower);
        }
        if (this.convolutionMode != null && l instanceof ConvolutionLayer) {
            ((ConvolutionLayer)l).setConvolutionMode(this.convolutionMode);
        }
        if (this.convolutionMode != null && l instanceof SubsamplingLayer) {
            ((SubsamplingLayer)l).setConvolutionMode(this.convolutionMode);
        }
        if (l != null && l instanceof BaseLayer && this.updater != null && originalUpdater != null && this.updater != originalUpdater) {
            bl = (BaseLayer)l;
            switch (originalUpdater) {
                case ADAM: 
                case ADAMAX: {
                    if (this.adamMeanDecay == null) {
                        bl.setAdamMeanDecay(Double.NaN);
                    }
                    if (this.adamVarDecay != null) break;
                    bl.setAdamVarDecay(Double.NaN);
                    break;
                }
                case ADADELTA: {
                    if (this.rho == null) {
                        bl.setRho(Double.NaN);
                    }
                    if (this.epsilon != null) break;
                    bl.setEpsilon(Double.NaN);
                    break;
                }
                case NESTEROVS: {
                    if (this.momentum == null) {
                        bl.setMomentum(Double.NaN);
                    }
                    if (this.momentumSchedule == null) {
                        bl.setMomentumSchedule(null);
                    }
                    if (this.epsilon != null) break;
                    bl.setEpsilon(Double.NaN);
                    break;
                }
                case ADAGRAD: {
                    if (this.epsilon != null) break;
                    bl.setEpsilon(Double.NaN);
                    break;
                }
                case RMSPROP: {
                    if (this.rmsDecay == null) {
                        bl.setRmsDecay(Double.NaN);
                    }
                    if (this.epsilon != null) break;
                    bl.setEpsilon(Double.NaN);
                }
            }
        }
        if (l != null && l instanceof BaseLayer && origWeightInit == WeightInit.DISTRIBUTION && this.weightInit != null && this.weightInit != WeightInit.DISTRIBUTION) {
            ((BaseLayer)l).setDist(null);
        }
        if (l != null) {
            LayerValidation.updaterValidation(l.getLayerName(), l, this.learningRate, this.momentum, this.momentumSchedule, this.adamMeanDecay, this.adamVarDecay, this.rho, this.rmsDecay, this.epsilon);
            boolean useDropCon = this.useDropConnect == null ? nnc.isUseDropConnect() : this.useDropConnect.booleanValue();
            LayerValidation.generalValidation(l.getLayerName(), l, nnc.isUseRegularization(), useDropCon, this.dropOut, this.l2, this.l2Bias, this.l1, this.l1Bias, this.dist);
        }
        if (nnc.variables(false) != null) {
            for (String s : nnc.variables(false)) {
                nnc.setLayerParamLR(s);
            }
        }
    }

    public void applyToMultiLayerConfiguration(MultiLayerConfiguration conf) {
        if (this.pretrain != null) {
            conf.setPretrain(this.pretrain);
        }
        if (this.backprop != null) {
            conf.setBackprop(this.backprop);
        }
        if (this.backpropType != null) {
            conf.setBackpropType(this.backpropType);
        }
        if (this.tbpttFwdLength != null) {
            conf.setTbpttFwdLength(this.tbpttFwdLength);
        }
        if (this.tbpttBackLength != null) {
            conf.setTbpttBackLength(this.tbpttBackLength);
        }
    }

    public void applyToComputationGraphConfiguration(ComputationGraphConfiguration conf) {
        if (this.pretrain != null) {
            conf.setPretrain(this.pretrain);
        }
        if (this.backprop != null) {
            conf.setBackprop(this.backprop);
        }
        if (this.backpropType != null) {
            conf.setBackpropType(this.backpropType);
        }
        if (this.tbpttFwdLength != null) {
            conf.setTbpttFwdLength(this.tbpttFwdLength);
        }
        if (this.tbpttBackLength != null) {
            conf.setTbpttBackLength(this.tbpttBackLength);
        }
    }

    public NeuralNetConfiguration.Builder appliedNeuralNetConfigurationBuilder() {
        NeuralNetConfiguration.Builder confBuilder = new NeuralNetConfiguration.Builder();
        if (this.activationFn != null) {
            confBuilder.setActivationFn(this.activationFn);
        }
        if (this.weightInit != null) {
            confBuilder.setWeightInit(this.weightInit);
        }
        if (this.biasInit != null) {
            confBuilder.setBiasInit(this.biasInit);
        }
        if (this.dist != null) {
            confBuilder.setDist(this.dist);
        }
        if (this.learningRate != null) {
            confBuilder.setLearningRate(this.learningRate);
        }
        if (this.biasLearningRate != null) {
            confBuilder.setBiasLearningRate(this.biasLearningRate);
        }
        if (this.learningRateSchedule != null) {
            confBuilder.setLearningRateSchedule(this.learningRateSchedule);
        }
        if (this.l1 != null) {
            confBuilder.setL1(this.l1);
        }
        if (this.l2 != null) {
            confBuilder.setL2(this.l2);
        }
        if (this.l1Bias != null) {
            confBuilder.setL1Bias(this.l1Bias);
        }
        if (this.l2Bias != null) {
            confBuilder.setL2Bias(this.l2Bias);
        }
        if (this.dropOut != null) {
            confBuilder.setDropOut(this.dropOut);
        }
        if (this.iUpdater != null) {
            confBuilder.updater(this.iUpdater);
        }
        if (this.updater != null) {
            confBuilder.setUpdater(this.updater);
        }
        if (this.momentum != null) {
            confBuilder.setMomentum(this.momentum);
        }
        if (this.momentumSchedule != null) {
            confBuilder.setMomentum(this.momentum);
        }
        if (this.epsilon != null) {
            confBuilder.setEpsilon(this.epsilon);
        }
        if (this.rho != null) {
            confBuilder.setRho(this.rho);
        }
        if (this.rmsDecay != null) {
            confBuilder.setRmsDecay(this.rmsDecay);
        }
        if (this.adamMeanDecay != null) {
            confBuilder.setAdamMeanDecay(this.adamMeanDecay);
        }
        if (this.adamVarDecay != null) {
            confBuilder.setAdamVarDecay(this.adamVarDecay);
        }
        if (this.miniBatch != null) {
            confBuilder.setMiniBatch(this.miniBatch);
        }
        if (this.numIterations != null) {
            confBuilder.setNumIterations(this.numIterations);
        }
        if (this.maxNumLineSearchIterations != null) {
            confBuilder.setMaxNumLineSearchIterations(this.maxNumLineSearchIterations);
        }
        if (this.seed != null) {
            confBuilder.setSeed(this.seed);
        }
        if (this.useRegularization != null) {
            confBuilder.setUseRegularization(this.useRegularization);
        }
        if (this.optimizationAlgo != null) {
            confBuilder.setOptimizationAlgo(this.optimizationAlgo);
        }
        if (this.stepFunction != null) {
            confBuilder.setStepFunction(this.stepFunction);
        }
        if (this.useDropConnect != null) {
            confBuilder.setUseDropConnect(this.useDropConnect);
        }
        if (this.minimize != null) {
            confBuilder.setMinimize(this.minimize);
        }
        if (this.gradientNormalization != null) {
            confBuilder.setGradientNormalization(this.gradientNormalization);
        }
        if (this.gradientNormalizationThreshold != null) {
            confBuilder.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
        }
        if (this.learningRatePolicy != null) {
            confBuilder.setLearningRatePolicy(this.learningRatePolicy);
        }
        if (this.lrPolicySteps != null) {
            confBuilder.setLrPolicySteps(this.lrPolicySteps);
        }
        if (this.lrPolicyPower != null) {
            confBuilder.setLrPolicyPower(this.lrPolicyPower);
        }
        return confBuilder;
    }

    public String toJson() {
        try {
            return NeuralNetConfiguration.mapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return NeuralNetConfiguration.mapperYaml().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static FineTuneConfiguration fromJson(String json) {
        try {
            return (FineTuneConfiguration)NeuralNetConfiguration.mapper().readValue(json, FineTuneConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FineTuneConfiguration fromYaml(String yaml) {
        try {
            return (FineTuneConfiguration)NeuralNetConfiguration.mapperYaml().readValue(yaml, FineTuneConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public FineTuneConfiguration() {
    }

    @ConstructorProperties(value={"activationFn", "weightInit", "biasInit", "dist", "learningRate", "biasLearningRate", "learningRateSchedule", "lrScoreBasedDecay", "l1", "l2", "l1Bias", "l2Bias", "dropOut", "updater", "iUpdater", "momentum", "momentumSchedule", "epsilon", "rho", "rmsDecay", "adamMeanDecay", "adamVarDecay", "miniBatch", "numIterations", "maxNumLineSearchIterations", "seed", "useRegularization", "optimizationAlgo", "stepFunction", "useDropConnect", "minimize", "gradientNormalization", "gradientNormalizationThreshold", "learningRatePolicy", "lrPolicyDecayRate", "lrPolicySteps", "lrPolicyPower", "convolutionMode", "pretrain", "backprop", "backpropType", "tbpttFwdLength", "tbpttBackLength"})
    public FineTuneConfiguration(IActivation activationFn, WeightInit weightInit, Double biasInit, Distribution dist, Double learningRate, Double biasLearningRate, Map<Integer, Double> learningRateSchedule, Double lrScoreBasedDecay, Double l1, Double l2, Double l1Bias, Double l2Bias, Double dropOut, Updater updater, IUpdater iUpdater, Double momentum, Map<Integer, Double> momentumSchedule, Double epsilon, Double rho, Double rmsDecay, Double adamMeanDecay, Double adamVarDecay, Boolean miniBatch, Integer numIterations, Integer maxNumLineSearchIterations, Long seed, Boolean useRegularization, OptimizationAlgorithm optimizationAlgo, StepFunction stepFunction, Boolean useDropConnect, Boolean minimize, GradientNormalization gradientNormalization, Double gradientNormalizationThreshold, LearningRatePolicy learningRatePolicy, Double lrPolicyDecayRate, Double lrPolicySteps, Double lrPolicyPower, ConvolutionMode convolutionMode, Boolean pretrain, Boolean backprop, BackpropType backpropType, Integer tbpttFwdLength, Integer tbpttBackLength) {
        this.activationFn = activationFn;
        this.weightInit = weightInit;
        this.biasInit = biasInit;
        this.dist = dist;
        this.learningRate = learningRate;
        this.biasLearningRate = biasLearningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.lrScoreBasedDecay = lrScoreBasedDecay;
        this.l1 = l1;
        this.l2 = l2;
        this.l1Bias = l1Bias;
        this.l2Bias = l2Bias;
        this.dropOut = dropOut;
        this.updater = updater;
        this.iUpdater = iUpdater;
        this.momentum = momentum;
        this.momentumSchedule = momentumSchedule;
        this.epsilon = epsilon;
        this.rho = rho;
        this.rmsDecay = rmsDecay;
        this.adamMeanDecay = adamMeanDecay;
        this.adamVarDecay = adamVarDecay;
        this.miniBatch = miniBatch;
        this.numIterations = numIterations;
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
        this.seed = seed;
        this.useRegularization = useRegularization;
        this.optimizationAlgo = optimizationAlgo;
        this.stepFunction = stepFunction;
        this.useDropConnect = useDropConnect;
        this.minimize = minimize;
        this.gradientNormalization = gradientNormalization;
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
        this.learningRatePolicy = learningRatePolicy;
        this.lrPolicyDecayRate = lrPolicyDecayRate;
        this.lrPolicySteps = lrPolicySteps;
        this.lrPolicyPower = lrPolicyPower;
        this.convolutionMode = convolutionMode;
        this.pretrain = pretrain;
        this.backprop = backprop;
        this.backpropType = backpropType;
        this.tbpttFwdLength = tbpttFwdLength;
        this.tbpttBackLength = tbpttBackLength;
    }

    public IActivation getActivationFn() {
        return this.activationFn;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public Double getBiasInit() {
        return this.biasInit;
    }

    public Distribution getDist() {
        return this.dist;
    }

    public Double getLearningRate() {
        return this.learningRate;
    }

    public Double getBiasLearningRate() {
        return this.biasLearningRate;
    }

    public Map<Integer, Double> getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public Double getLrScoreBasedDecay() {
        return this.lrScoreBasedDecay;
    }

    public Double getL1() {
        return this.l1;
    }

    public Double getL2() {
        return this.l2;
    }

    public Double getL1Bias() {
        return this.l1Bias;
    }

    public Double getL2Bias() {
        return this.l2Bias;
    }

    public Double getDropOut() {
        return this.dropOut;
    }

    @Deprecated
    public Updater getUpdater() {
        return this.updater;
    }

    public IUpdater getIUpdater() {
        return this.iUpdater;
    }

    @Deprecated
    public Double getMomentum() {
        return this.momentum;
    }

    @Deprecated
    public Map<Integer, Double> getMomentumSchedule() {
        return this.momentumSchedule;
    }

    @Deprecated
    public Double getEpsilon() {
        return this.epsilon;
    }

    @Deprecated
    public Double getRho() {
        return this.rho;
    }

    @Deprecated
    public Double getRmsDecay() {
        return this.rmsDecay;
    }

    @Deprecated
    public Double getAdamMeanDecay() {
        return this.adamMeanDecay;
    }

    @Deprecated
    public Double getAdamVarDecay() {
        return this.adamVarDecay;
    }

    public Boolean getMiniBatch() {
        return this.miniBatch;
    }

    public Integer getNumIterations() {
        return this.numIterations;
    }

    public Integer getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public Long getSeed() {
        return this.seed;
    }

    public Boolean getUseRegularization() {
        return this.useRegularization;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public Boolean getUseDropConnect() {
        return this.useDropConnect;
    }

    public Boolean getMinimize() {
        return this.minimize;
    }

    public GradientNormalization getGradientNormalization() {
        return this.gradientNormalization;
    }

    public Double getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public LearningRatePolicy getLearningRatePolicy() {
        return this.learningRatePolicy;
    }

    public Double getLrPolicyDecayRate() {
        return this.lrPolicyDecayRate;
    }

    public Double getLrPolicySteps() {
        return this.lrPolicySteps;
    }

    public Double getLrPolicyPower() {
        return this.lrPolicyPower;
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public Boolean getPretrain() {
        return this.pretrain;
    }

    public Boolean getBackprop() {
        return this.backprop;
    }

    public BackpropType getBackpropType() {
        return this.backpropType;
    }

    public Integer getTbpttFwdLength() {
        return this.tbpttFwdLength;
    }

    public Integer getTbpttBackLength() {
        return this.tbpttBackLength;
    }

    public void setActivationFn(IActivation activationFn) {
        this.activationFn = activationFn;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public void setBiasInit(Double biasInit) {
        this.biasInit = biasInit;
    }

    public void setDist(Distribution dist) {
        this.dist = dist;
    }

    public void setLearningRate(Double learningRate) {
        this.learningRate = learningRate;
    }

    public void setBiasLearningRate(Double biasLearningRate) {
        this.biasLearningRate = biasLearningRate;
    }

    public void setLearningRateSchedule(Map<Integer, Double> learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setLrScoreBasedDecay(Double lrScoreBasedDecay) {
        this.lrScoreBasedDecay = lrScoreBasedDecay;
    }

    public void setL1(Double l1) {
        this.l1 = l1;
    }

    public void setL2(Double l2) {
        this.l2 = l2;
    }

    public void setL1Bias(Double l1Bias) {
        this.l1Bias = l1Bias;
    }

    public void setL2Bias(Double l2Bias) {
        this.l2Bias = l2Bias;
    }

    public void setDropOut(Double dropOut) {
        this.dropOut = dropOut;
    }

    @Deprecated
    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    public void setIUpdater(IUpdater iUpdater) {
        this.iUpdater = iUpdater;
    }

    @Deprecated
    public void setMomentum(Double momentum) {
        this.momentum = momentum;
    }

    @Deprecated
    public void setMomentumSchedule(Map<Integer, Double> momentumSchedule) {
        this.momentumSchedule = momentumSchedule;
    }

    @Deprecated
    public void setEpsilon(Double epsilon) {
        this.epsilon = epsilon;
    }

    @Deprecated
    public void setRho(Double rho) {
        this.rho = rho;
    }

    @Deprecated
    public void setRmsDecay(Double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    @Deprecated
    public void setAdamMeanDecay(Double adamMeanDecay) {
        this.adamMeanDecay = adamMeanDecay;
    }

    @Deprecated
    public void setAdamVarDecay(Double adamVarDecay) {
        this.adamVarDecay = adamVarDecay;
    }

    public void setMiniBatch(Boolean miniBatch) {
        this.miniBatch = miniBatch;
    }

    public void setNumIterations(Integer numIterations) {
        this.numIterations = numIterations;
    }

    public void setMaxNumLineSearchIterations(Integer maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public void setUseRegularization(Boolean useRegularization) {
        this.useRegularization = useRegularization;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setUseDropConnect(Boolean useDropConnect) {
        this.useDropConnect = useDropConnect;
    }

    public void setMinimize(Boolean minimize) {
        this.minimize = minimize;
    }

    public void setGradientNormalization(GradientNormalization gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(Double gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    public void setLearningRatePolicy(LearningRatePolicy learningRatePolicy) {
        this.learningRatePolicy = learningRatePolicy;
    }

    public void setLrPolicyDecayRate(Double lrPolicyDecayRate) {
        this.lrPolicyDecayRate = lrPolicyDecayRate;
    }

    public void setLrPolicySteps(Double lrPolicySteps) {
        this.lrPolicySteps = lrPolicySteps;
    }

    public void setLrPolicyPower(Double lrPolicyPower) {
        this.lrPolicyPower = lrPolicyPower;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setPretrain(Boolean pretrain) {
        this.pretrain = pretrain;
    }

    public void setBackprop(Boolean backprop) {
        this.backprop = backprop;
    }

    public void setBackpropType(BackpropType backpropType) {
        this.backpropType = backpropType;
    }

    public void setTbpttFwdLength(Integer tbpttFwdLength) {
        this.tbpttFwdLength = tbpttFwdLength;
    }

    public void setTbpttBackLength(Integer tbpttBackLength) {
        this.tbpttBackLength = tbpttBackLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FineTuneConfiguration)) {
            return false;
        }
        FineTuneConfiguration other = (FineTuneConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IActivation this$activationFn = this.getActivationFn();
        IActivation other$activationFn = other.getActivationFn();
        if (this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn)) {
            return false;
        }
        WeightInit this$weightInit = this.getWeightInit();
        WeightInit other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
            return false;
        }
        Double this$biasInit = this.getBiasInit();
        Double other$biasInit = other.getBiasInit();
        if (this$biasInit == null ? other$biasInit != null : !((Object)this$biasInit).equals(other$biasInit)) {
            return false;
        }
        Distribution this$dist = this.getDist();
        Distribution other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        Double this$learningRate = this.getLearningRate();
        Double other$learningRate = other.getLearningRate();
        if (this$learningRate == null ? other$learningRate != null : !((Object)this$learningRate).equals(other$learningRate)) {
            return false;
        }
        Double this$biasLearningRate = this.getBiasLearningRate();
        Double other$biasLearningRate = other.getBiasLearningRate();
        if (this$biasLearningRate == null ? other$biasLearningRate != null : !((Object)this$biasLearningRate).equals(other$biasLearningRate)) {
            return false;
        }
        Map<Integer, Double> this$learningRateSchedule = this.getLearningRateSchedule();
        Map<Integer, Double> other$learningRateSchedule = other.getLearningRateSchedule();
        if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !((Object)this$learningRateSchedule).equals(other$learningRateSchedule)) {
            return false;
        }
        Double this$lrScoreBasedDecay = this.getLrScoreBasedDecay();
        Double other$lrScoreBasedDecay = other.getLrScoreBasedDecay();
        if (this$lrScoreBasedDecay == null ? other$lrScoreBasedDecay != null : !((Object)this$lrScoreBasedDecay).equals(other$lrScoreBasedDecay)) {
            return false;
        }
        Double this$l1 = this.getL1();
        Double other$l1 = other.getL1();
        if (this$l1 == null ? other$l1 != null : !((Object)this$l1).equals(other$l1)) {
            return false;
        }
        Double this$l2 = this.getL2();
        Double other$l2 = other.getL2();
        if (this$l2 == null ? other$l2 != null : !((Object)this$l2).equals(other$l2)) {
            return false;
        }
        Double this$l1Bias = this.getL1Bias();
        Double other$l1Bias = other.getL1Bias();
        if (this$l1Bias == null ? other$l1Bias != null : !((Object)this$l1Bias).equals(other$l1Bias)) {
            return false;
        }
        Double this$l2Bias = this.getL2Bias();
        Double other$l2Bias = other.getL2Bias();
        if (this$l2Bias == null ? other$l2Bias != null : !((Object)this$l2Bias).equals(other$l2Bias)) {
            return false;
        }
        Double this$dropOut = this.getDropOut();
        Double other$dropOut = other.getDropOut();
        if (this$dropOut == null ? other$dropOut != null : !((Object)this$dropOut).equals(other$dropOut)) {
            return false;
        }
        Updater this$updater = this.getUpdater();
        Updater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !((Object)((Object)this$updater)).equals((Object)other$updater)) {
            return false;
        }
        IUpdater this$iUpdater = this.getIUpdater();
        IUpdater other$iUpdater = other.getIUpdater();
        if (this$iUpdater == null ? other$iUpdater != null : !this$iUpdater.equals(other$iUpdater)) {
            return false;
        }
        Double this$momentum = this.getMomentum();
        Double other$momentum = other.getMomentum();
        if (this$momentum == null ? other$momentum != null : !((Object)this$momentum).equals(other$momentum)) {
            return false;
        }
        Map<Integer, Double> this$momentumSchedule = this.getMomentumSchedule();
        Map<Integer, Double> other$momentumSchedule = other.getMomentumSchedule();
        if (this$momentumSchedule == null ? other$momentumSchedule != null : !((Object)this$momentumSchedule).equals(other$momentumSchedule)) {
            return false;
        }
        Double this$epsilon = this.getEpsilon();
        Double other$epsilon = other.getEpsilon();
        if (this$epsilon == null ? other$epsilon != null : !((Object)this$epsilon).equals(other$epsilon)) {
            return false;
        }
        Double this$rho = this.getRho();
        Double other$rho = other.getRho();
        if (this$rho == null ? other$rho != null : !((Object)this$rho).equals(other$rho)) {
            return false;
        }
        Double this$rmsDecay = this.getRmsDecay();
        Double other$rmsDecay = other.getRmsDecay();
        if (this$rmsDecay == null ? other$rmsDecay != null : !((Object)this$rmsDecay).equals(other$rmsDecay)) {
            return false;
        }
        Double this$adamMeanDecay = this.getAdamMeanDecay();
        Double other$adamMeanDecay = other.getAdamMeanDecay();
        if (this$adamMeanDecay == null ? other$adamMeanDecay != null : !((Object)this$adamMeanDecay).equals(other$adamMeanDecay)) {
            return false;
        }
        Double this$adamVarDecay = this.getAdamVarDecay();
        Double other$adamVarDecay = other.getAdamVarDecay();
        if (this$adamVarDecay == null ? other$adamVarDecay != null : !((Object)this$adamVarDecay).equals(other$adamVarDecay)) {
            return false;
        }
        Boolean this$miniBatch = this.getMiniBatch();
        Boolean other$miniBatch = other.getMiniBatch();
        if (this$miniBatch == null ? other$miniBatch != null : !((Object)this$miniBatch).equals(other$miniBatch)) {
            return false;
        }
        Integer this$numIterations = this.getNumIterations();
        Integer other$numIterations = other.getNumIterations();
        if (this$numIterations == null ? other$numIterations != null : !((Object)this$numIterations).equals(other$numIterations)) {
            return false;
        }
        Integer this$maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        Integer other$maxNumLineSearchIterations = other.getMaxNumLineSearchIterations();
        if (this$maxNumLineSearchIterations == null ? other$maxNumLineSearchIterations != null : !((Object)this$maxNumLineSearchIterations).equals(other$maxNumLineSearchIterations)) {
            return false;
        }
        Long this$seed = this.getSeed();
        Long other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Boolean this$useRegularization = this.getUseRegularization();
        Boolean other$useRegularization = other.getUseRegularization();
        if (this$useRegularization == null ? other$useRegularization != null : !((Object)this$useRegularization).equals(other$useRegularization)) {
            return false;
        }
        OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
        OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
            return false;
        }
        StepFunction this$stepFunction = this.getStepFunction();
        StepFunction other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        Boolean this$useDropConnect = this.getUseDropConnect();
        Boolean other$useDropConnect = other.getUseDropConnect();
        if (this$useDropConnect == null ? other$useDropConnect != null : !((Object)this$useDropConnect).equals(other$useDropConnect)) {
            return false;
        }
        Boolean this$minimize = this.getMinimize();
        Boolean other$minimize = other.getMinimize();
        if (this$minimize == null ? other$minimize != null : !((Object)this$minimize).equals(other$minimize)) {
            return false;
        }
        GradientNormalization this$gradientNormalization = this.getGradientNormalization();
        GradientNormalization other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
            return false;
        }
        Double this$gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        Double other$gradientNormalizationThreshold = other.getGradientNormalizationThreshold();
        if (this$gradientNormalizationThreshold == null ? other$gradientNormalizationThreshold != null : !((Object)this$gradientNormalizationThreshold).equals(other$gradientNormalizationThreshold)) {
            return false;
        }
        LearningRatePolicy this$learningRatePolicy = this.getLearningRatePolicy();
        LearningRatePolicy other$learningRatePolicy = other.getLearningRatePolicy();
        if (this$learningRatePolicy == null ? other$learningRatePolicy != null : !((Object)((Object)this$learningRatePolicy)).equals((Object)other$learningRatePolicy)) {
            return false;
        }
        Double this$lrPolicyDecayRate = this.getLrPolicyDecayRate();
        Double other$lrPolicyDecayRate = other.getLrPolicyDecayRate();
        if (this$lrPolicyDecayRate == null ? other$lrPolicyDecayRate != null : !((Object)this$lrPolicyDecayRate).equals(other$lrPolicyDecayRate)) {
            return false;
        }
        Double this$lrPolicySteps = this.getLrPolicySteps();
        Double other$lrPolicySteps = other.getLrPolicySteps();
        if (this$lrPolicySteps == null ? other$lrPolicySteps != null : !((Object)this$lrPolicySteps).equals(other$lrPolicySteps)) {
            return false;
        }
        Double this$lrPolicyPower = this.getLrPolicyPower();
        Double other$lrPolicyPower = other.getLrPolicyPower();
        if (this$lrPolicyPower == null ? other$lrPolicyPower != null : !((Object)this$lrPolicyPower).equals(other$lrPolicyPower)) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        Boolean this$pretrain = this.getPretrain();
        Boolean other$pretrain = other.getPretrain();
        if (this$pretrain == null ? other$pretrain != null : !((Object)this$pretrain).equals(other$pretrain)) {
            return false;
        }
        Boolean this$backprop = this.getBackprop();
        Boolean other$backprop = other.getBackprop();
        if (this$backprop == null ? other$backprop != null : !((Object)this$backprop).equals(other$backprop)) {
            return false;
        }
        BackpropType this$backpropType = this.getBackpropType();
        BackpropType other$backpropType = other.getBackpropType();
        if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
            return false;
        }
        Integer this$tbpttFwdLength = this.getTbpttFwdLength();
        Integer other$tbpttFwdLength = other.getTbpttFwdLength();
        if (this$tbpttFwdLength == null ? other$tbpttFwdLength != null : !((Object)this$tbpttFwdLength).equals(other$tbpttFwdLength)) {
            return false;
        }
        Integer this$tbpttBackLength = this.getTbpttBackLength();
        Integer other$tbpttBackLength = other.getTbpttBackLength();
        return !(this$tbpttBackLength == null ? other$tbpttBackLength != null : !((Object)this$tbpttBackLength).equals(other$tbpttBackLength));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FineTuneConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IActivation $activationFn = this.getActivationFn();
        result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
        WeightInit $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : ((Object)((Object)$weightInit)).hashCode());
        Double $biasInit = this.getBiasInit();
        result = result * 59 + ($biasInit == null ? 43 : ((Object)$biasInit).hashCode());
        Distribution $dist = this.getDist();
        result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
        Double $learningRate = this.getLearningRate();
        result = result * 59 + ($learningRate == null ? 43 : ((Object)$learningRate).hashCode());
        Double $biasLearningRate = this.getBiasLearningRate();
        result = result * 59 + ($biasLearningRate == null ? 43 : ((Object)$biasLearningRate).hashCode());
        Map<Integer, Double> $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : ((Object)$learningRateSchedule).hashCode());
        Double $lrScoreBasedDecay = this.getLrScoreBasedDecay();
        result = result * 59 + ($lrScoreBasedDecay == null ? 43 : ((Object)$lrScoreBasedDecay).hashCode());
        Double $l1 = this.getL1();
        result = result * 59 + ($l1 == null ? 43 : ((Object)$l1).hashCode());
        Double $l2 = this.getL2();
        result = result * 59 + ($l2 == null ? 43 : ((Object)$l2).hashCode());
        Double $l1Bias = this.getL1Bias();
        result = result * 59 + ($l1Bias == null ? 43 : ((Object)$l1Bias).hashCode());
        Double $l2Bias = this.getL2Bias();
        result = result * 59 + ($l2Bias == null ? 43 : ((Object)$l2Bias).hashCode());
        Double $dropOut = this.getDropOut();
        result = result * 59 + ($dropOut == null ? 43 : ((Object)$dropOut).hashCode());
        Updater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : ((Object)((Object)$updater)).hashCode());
        IUpdater $iUpdater = this.getIUpdater();
        result = result * 59 + ($iUpdater == null ? 43 : $iUpdater.hashCode());
        Double $momentum = this.getMomentum();
        result = result * 59 + ($momentum == null ? 43 : ((Object)$momentum).hashCode());
        Map<Integer, Double> $momentumSchedule = this.getMomentumSchedule();
        result = result * 59 + ($momentumSchedule == null ? 43 : ((Object)$momentumSchedule).hashCode());
        Double $epsilon = this.getEpsilon();
        result = result * 59 + ($epsilon == null ? 43 : ((Object)$epsilon).hashCode());
        Double $rho = this.getRho();
        result = result * 59 + ($rho == null ? 43 : ((Object)$rho).hashCode());
        Double $rmsDecay = this.getRmsDecay();
        result = result * 59 + ($rmsDecay == null ? 43 : ((Object)$rmsDecay).hashCode());
        Double $adamMeanDecay = this.getAdamMeanDecay();
        result = result * 59 + ($adamMeanDecay == null ? 43 : ((Object)$adamMeanDecay).hashCode());
        Double $adamVarDecay = this.getAdamVarDecay();
        result = result * 59 + ($adamVarDecay == null ? 43 : ((Object)$adamVarDecay).hashCode());
        Boolean $miniBatch = this.getMiniBatch();
        result = result * 59 + ($miniBatch == null ? 43 : ((Object)$miniBatch).hashCode());
        Integer $numIterations = this.getNumIterations();
        result = result * 59 + ($numIterations == null ? 43 : ((Object)$numIterations).hashCode());
        Integer $maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        result = result * 59 + ($maxNumLineSearchIterations == null ? 43 : ((Object)$maxNumLineSearchIterations).hashCode());
        Long $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Boolean $useRegularization = this.getUseRegularization();
        result = result * 59 + ($useRegularization == null ? 43 : ((Object)$useRegularization).hashCode());
        OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 43 : ((Object)((Object)$optimizationAlgo)).hashCode());
        StepFunction $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
        Boolean $useDropConnect = this.getUseDropConnect();
        result = result * 59 + ($useDropConnect == null ? 43 : ((Object)$useDropConnect).hashCode());
        Boolean $minimize = this.getMinimize();
        result = result * 59 + ($minimize == null ? 43 : ((Object)$minimize).hashCode());
        GradientNormalization $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : ((Object)((Object)$gradientNormalization)).hashCode());
        Double $gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        result = result * 59 + ($gradientNormalizationThreshold == null ? 43 : ((Object)$gradientNormalizationThreshold).hashCode());
        LearningRatePolicy $learningRatePolicy = this.getLearningRatePolicy();
        result = result * 59 + ($learningRatePolicy == null ? 43 : ((Object)((Object)$learningRatePolicy)).hashCode());
        Double $lrPolicyDecayRate = this.getLrPolicyDecayRate();
        result = result * 59 + ($lrPolicyDecayRate == null ? 43 : ((Object)$lrPolicyDecayRate).hashCode());
        Double $lrPolicySteps = this.getLrPolicySteps();
        result = result * 59 + ($lrPolicySteps == null ? 43 : ((Object)$lrPolicySteps).hashCode());
        Double $lrPolicyPower = this.getLrPolicyPower();
        result = result * 59 + ($lrPolicyPower == null ? 43 : ((Object)$lrPolicyPower).hashCode());
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        Boolean $pretrain = this.getPretrain();
        result = result * 59 + ($pretrain == null ? 43 : ((Object)$pretrain).hashCode());
        Boolean $backprop = this.getBackprop();
        result = result * 59 + ($backprop == null ? 43 : ((Object)$backprop).hashCode());
        BackpropType $backpropType = this.getBackpropType();
        result = result * 59 + ($backpropType == null ? 43 : ((Object)((Object)$backpropType)).hashCode());
        Integer $tbpttFwdLength = this.getTbpttFwdLength();
        result = result * 59 + ($tbpttFwdLength == null ? 43 : ((Object)$tbpttFwdLength).hashCode());
        Integer $tbpttBackLength = this.getTbpttBackLength();
        result = result * 59 + ($tbpttBackLength == null ? 43 : ((Object)$tbpttBackLength).hashCode());
        return result;
    }

    public String toString() {
        return "FineTuneConfiguration(activationFn=" + this.getActivationFn() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", learningRate=" + this.getLearningRate() + ", biasLearningRate=" + this.getBiasLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", lrScoreBasedDecay=" + this.getLrScoreBasedDecay() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", l1Bias=" + this.getL1Bias() + ", l2Bias=" + this.getL2Bias() + ", dropOut=" + this.getDropOut() + ", updater=" + (Object)((Object)this.getUpdater()) + ", iUpdater=" + this.getIUpdater() + ", momentum=" + this.getMomentum() + ", momentumSchedule=" + this.getMomentumSchedule() + ", epsilon=" + this.getEpsilon() + ", rho=" + this.getRho() + ", rmsDecay=" + this.getRmsDecay() + ", adamMeanDecay=" + this.getAdamMeanDecay() + ", adamVarDecay=" + this.getAdamVarDecay() + ", miniBatch=" + this.getMiniBatch() + ", numIterations=" + this.getNumIterations() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", useRegularization=" + this.getUseRegularization() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", stepFunction=" + this.getStepFunction() + ", useDropConnect=" + this.getUseDropConnect() + ", minimize=" + this.getMinimize() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ", learningRatePolicy=" + (Object)((Object)this.getLearningRatePolicy()) + ", lrPolicyDecayRate=" + this.getLrPolicyDecayRate() + ", lrPolicySteps=" + this.getLrPolicySteps() + ", lrPolicyPower=" + this.getLrPolicyPower() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ", pretrain=" + this.getPretrain() + ", backprop=" + this.getBackprop() + ", backpropType=" + (Object)((Object)this.getBackpropType()) + ", tbpttFwdLength=" + this.getTbpttFwdLength() + ", tbpttBackLength=" + this.getTbpttBackLength() + ")";
    }

    public static class Builder {
        private IActivation activationFn;
        private WeightInit weightInit;
        private Double biasInit;
        private Distribution dist;
        private Double learningRate;
        private Double biasLearningRate;
        private Map<Integer, Double> learningRateSchedule;
        private Double lrScoreBasedDecay;
        private Double l1;
        private Double l2;
        private Double l1Bias;
        private Double l2Bias;
        private Double dropOut;
        private Updater updater;
        private IUpdater iUpdater;
        private Double momentum;
        private Map<Integer, Double> momentumSchedule;
        private Double epsilon;
        private Double rho;
        private Double rmsDecay;
        private Double adamMeanDecay;
        private Double adamVarDecay;
        private Boolean miniBatch;
        private Integer numIterations;
        private Integer maxNumLineSearchIterations;
        private Long seed;
        private Boolean useRegularization;
        private OptimizationAlgorithm optimizationAlgo;
        private StepFunction stepFunction;
        private Boolean useDropConnect;
        private Boolean minimize;
        private GradientNormalization gradientNormalization;
        private Double gradientNormalizationThreshold;
        private LearningRatePolicy learningRatePolicy;
        private Double lrPolicyDecayRate;
        private Double lrPolicySteps;
        private Double lrPolicyPower;
        private ConvolutionMode convolutionMode;
        private Boolean pretrain;
        private Boolean backprop;
        private BackpropType backpropType;
        private Integer tbpttFwdLength;
        private Integer tbpttBackLength;

        public Builder seed(int seed) {
            this.seed = seed;
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder regularization(boolean regularization) {
            this.useRegularization = regularization;
            return this;
        }

        public Builder iterations(int iterations) {
            this.numIterations = iterations;
            return this;
        }

        public Builder activation(Activation activation) {
            this.activationFn = activation.getActivationFunction();
            return this;
        }

        public Builder updater(IUpdater updater) {
            return this.iUpdater(updater);
        }

        public Builder updater(Updater updater) {
            this.updater = updater;
            return this.updater(updater.getIUpdaterWithDefaultConfig());
        }

        public Builder activationFn(IActivation activationFn) {
            this.activationFn = activationFn;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return this;
        }

        public Builder biasInit(Double biasInit) {
            this.biasInit = biasInit;
            return this;
        }

        public Builder dist(Distribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder learningRate(Double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder biasLearningRate(Double biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return this;
        }

        public Builder learningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return this;
        }

        public Builder lrScoreBasedDecay(Double lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return this;
        }

        public Builder l1(Double l1) {
            this.l1 = l1;
            return this;
        }

        public Builder l2(Double l2) {
            this.l2 = l2;
            return this;
        }

        public Builder l1Bias(Double l1Bias) {
            this.l1Bias = l1Bias;
            return this;
        }

        public Builder l2Bias(Double l2Bias) {
            this.l2Bias = l2Bias;
            return this;
        }

        public Builder dropOut(Double dropOut) {
            this.dropOut = dropOut;
            return this;
        }

        public Builder iUpdater(IUpdater iUpdater) {
            this.iUpdater = iUpdater;
            return this;
        }

        @Deprecated
        public Builder momentum(Double momentum) {
            this.momentum = momentum;
            return this;
        }

        @Deprecated
        public Builder momentumSchedule(Map<Integer, Double> momentumSchedule) {
            this.momentumSchedule = momentumSchedule;
            return this;
        }

        @Deprecated
        public Builder epsilon(Double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        @Deprecated
        public Builder rho(Double rho) {
            this.rho = rho;
            return this;
        }

        @Deprecated
        public Builder rmsDecay(Double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return this;
        }

        @Deprecated
        public Builder adamMeanDecay(Double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return this;
        }

        @Deprecated
        public Builder adamVarDecay(Double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return this;
        }

        public Builder miniBatch(Boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder numIterations(Integer numIterations) {
            this.numIterations = numIterations;
            return this;
        }

        public Builder maxNumLineSearchIterations(Integer maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return this;
        }

        public Builder useRegularization(Boolean useRegularization) {
            this.useRegularization = useRegularization;
            return this;
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public Builder useDropConnect(Boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
            return this;
        }

        public Builder minimize(Boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return this;
        }

        public Builder gradientNormalizationThreshold(Double gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return this;
        }

        public Builder learningRatePolicy(LearningRatePolicy learningRatePolicy) {
            this.learningRatePolicy = learningRatePolicy;
            return this;
        }

        public Builder lrPolicyDecayRate(Double lrPolicyDecayRate) {
            this.lrPolicyDecayRate = lrPolicyDecayRate;
            return this;
        }

        public Builder lrPolicySteps(Double lrPolicySteps) {
            this.lrPolicySteps = lrPolicySteps;
            return this;
        }

        public Builder lrPolicyPower(Double lrPolicyPower) {
            this.lrPolicyPower = lrPolicyPower;
            return this;
        }

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        public Builder pretrain(Boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public Builder backprop(Boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        public Builder backpropType(BackpropType backpropType) {
            this.backpropType = backpropType;
            return this;
        }

        public Builder tbpttFwdLength(Integer tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
            return this;
        }

        public Builder tbpttBackLength(Integer tbpttBackLength) {
            this.tbpttBackLength = tbpttBackLength;
            return this;
        }

        public FineTuneConfiguration build() {
            return new FineTuneConfiguration(this.activationFn, this.weightInit, this.biasInit, this.dist, this.learningRate, this.biasLearningRate, this.learningRateSchedule, this.lrScoreBasedDecay, this.l1, this.l2, this.l1Bias, this.l2Bias, this.dropOut, this.updater, this.iUpdater, this.momentum, this.momentumSchedule, this.epsilon, this.rho, this.rmsDecay, this.adamMeanDecay, this.adamVarDecay, this.miniBatch, this.numIterations, this.maxNumLineSearchIterations, this.seed, this.useRegularization, this.optimizationAlgo, this.stepFunction, this.useDropConnect, this.minimize, this.gradientNormalization, this.gradientNormalizationThreshold, this.learningRatePolicy, this.lrPolicyDecayRate, this.lrPolicySteps, this.lrPolicyPower, this.convolutionMode, this.pretrain, this.backprop, this.backpropType, this.tbpttFwdLength, this.tbpttBackLength);
        }

        public String toString() {
            return "FineTuneConfiguration.Builder(activationFn=" + this.activationFn + ", weightInit=" + (Object)((Object)this.weightInit) + ", biasInit=" + this.biasInit + ", dist=" + this.dist + ", learningRate=" + this.learningRate + ", biasLearningRate=" + this.biasLearningRate + ", learningRateSchedule=" + this.learningRateSchedule + ", lrScoreBasedDecay=" + this.lrScoreBasedDecay + ", l1=" + this.l1 + ", l2=" + this.l2 + ", l1Bias=" + this.l1Bias + ", l2Bias=" + this.l2Bias + ", dropOut=" + this.dropOut + ", updater=" + (Object)((Object)this.updater) + ", iUpdater=" + this.iUpdater + ", momentum=" + this.momentum + ", momentumSchedule=" + this.momentumSchedule + ", epsilon=" + this.epsilon + ", rho=" + this.rho + ", rmsDecay=" + this.rmsDecay + ", adamMeanDecay=" + this.adamMeanDecay + ", adamVarDecay=" + this.adamVarDecay + ", miniBatch=" + this.miniBatch + ", numIterations=" + this.numIterations + ", maxNumLineSearchIterations=" + this.maxNumLineSearchIterations + ", seed=" + this.seed + ", useRegularization=" + this.useRegularization + ", optimizationAlgo=" + (Object)((Object)this.optimizationAlgo) + ", stepFunction=" + this.stepFunction + ", useDropConnect=" + this.useDropConnect + ", minimize=" + this.minimize + ", gradientNormalization=" + (Object)((Object)this.gradientNormalization) + ", gradientNormalizationThreshold=" + this.gradientNormalizationThreshold + ", learningRatePolicy=" + (Object)((Object)this.learningRatePolicy) + ", lrPolicyDecayRate=" + this.lrPolicyDecayRate + ", lrPolicySteps=" + this.lrPolicySteps + ", lrPolicyPower=" + this.lrPolicyPower + ", convolutionMode=" + (Object)((Object)this.convolutionMode) + ", pretrain=" + this.pretrain + ", backprop=" + this.backprop + ", backpropType=" + (Object)((Object)this.backpropType) + ", tbpttFwdLength=" + this.tbpttFwdLength + ", tbpttBackLength=" + this.tbpttBackLength + ")";
        }
    }
}

