/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.transforms.Or;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class ReshapeVertex
extends BaseGraphVertex {
    private int[] newShape;

    public ReshapeVertex(ComputationGraph graph, String name, int vertexIndex, int[] newShape) {
        this(graph, name, vertexIndex, null, null, newShape);
    }

    public ReshapeVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, int[] newShape) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
        this.newShape = newShape;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public boolean isOutputVertex() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: inputs not set");
        }
        if (this.inputs.length > 1) {
            throw new IllegalStateException("Reshape vertex requires a single input.");
        }
        return this.inputs[0].reshape(this.inputs[0].ordering(), this.newShape);
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: errors not set");
        }
        INDArray[] out = new INDArray[]{this.epsilon.reshape(this.inputs[0].ordering(), this.inputs[0].shape())};
        return new Pair(null, (Object)out);
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null) {
            return new Pair(null, (Object)currentMaskState);
        }
        for (INDArray arr : maskArrays) {
            if (arr != null) continue;
            return new Pair(null, (Object)currentMaskState);
        }
        if (maskArrays.length == 1) {
            return new Pair((Object)maskArrays[0], (Object)currentMaskState);
        }
        INDArray ret = maskArrays[0].dup(maskArrays[0].ordering());
        Nd4j.getExecutioner().exec((Op)new Or(maskArrays[0], maskArrays[1], ret));
        for (int i = 2; i < maskArrays.length; ++i) {
            Nd4j.getExecutioner().exec((Op)new Or(maskArrays[i], ret, ret));
        }
        return new Pair((Object)ret, (Object)currentMaskState);
    }

    @Override
    public String toString() {
        return "ReshapeVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + "\",shape=" + this.newShape.toString() + ")";
    }
}

