/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.learning.config.IUpdater;

public abstract class BaseLayer
extends Layer
implements Serializable,
Cloneable {
    protected IActivation activationFn;
    protected WeightInit weightInit;
    protected double biasInit;
    protected Distribution dist;
    protected double learningRate;
    protected double biasLearningRate;
    protected Map<Integer, Double> learningRateSchedule;
    @Deprecated
    protected double momentum;
    @Deprecated
    protected Map<Integer, Double> momentumSchedule;
    protected double l1;
    protected double l2;
    protected double l1Bias;
    protected double l2Bias;
    @Deprecated
    protected Updater updater;
    protected IUpdater iUpdater;
    @Deprecated
    protected double rho;
    @Deprecated
    protected double epsilon;
    @Deprecated
    protected double rmsDecay;
    @Deprecated
    protected double adamMeanDecay;
    @Deprecated
    protected double adamVarDecay;
    protected GradientNormalization gradientNormalization = GradientNormalization.None;
    protected double gradientNormalizationThreshold = 1.0;

    public BaseLayer(Builder builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.activationFn = builder.activationFn;
        this.weightInit = builder.weightInit;
        this.biasInit = builder.biasInit;
        this.dist = builder.dist;
        this.learningRate = builder.learningRate;
        this.biasLearningRate = builder.biasLearningRate;
        this.learningRateSchedule = builder.learningRateSchedule;
        this.momentum = builder.momentum;
        this.momentumSchedule = builder.momentumAfter;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.l1Bias = builder.l1Bias;
        this.l2Bias = builder.l2Bias;
        this.updater = builder.updater;
        this.iUpdater = builder.iupdater;
        this.rho = builder.rho;
        this.epsilon = builder.epsilon;
        this.rmsDecay = builder.rmsDecay;
        this.adamMeanDecay = builder.adamMeanDecay;
        this.adamVarDecay = builder.adamVarDecay;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
    }

    @Override
    public void resetLayerDefaultConfig() {
        this.setUpdater(null);
        this.setIUpdater(null);
        this.setMomentum(Double.NaN);
        this.setWeightInit(null);
        this.setBiasInit(Double.NaN);
        this.setDist(null);
        this.setLearningRate(Double.NaN);
        this.setBiasLearningRate(Double.NaN);
        this.setLearningRateSchedule(null);
        this.setMomentumSchedule(null);
        this.setL1(Double.NaN);
        this.setL2(Double.NaN);
        this.setRho(Double.NaN);
        this.setEpsilon(Double.NaN);
        this.setRmsDecay(Double.NaN);
        this.setAdamMeanDecay(Double.NaN);
        this.setAdamVarDecay(Double.NaN);
        this.setGradientNormalization(GradientNormalization.None);
        this.setGradientNormalizationThreshold(1.0);
    }

    @Override
    public BaseLayer clone() {
        BaseLayer clone = (BaseLayer)super.clone();
        if (clone.dist != null) {
            clone.dist = clone.dist.clone();
        }
        if (clone.learningRateSchedule != null) {
            clone.learningRateSchedule = new HashMap<Integer, Double>(clone.learningRateSchedule);
        }
        if (clone.momentumSchedule != null) {
            clone.momentumSchedule = new HashMap<Integer, Double>(clone.momentumSchedule);
        }
        return clone;
    }

    @Override
    @Deprecated
    public Updater getUpdaterByParam(String paramName) {
        return this.updater;
    }

    @Override
    public IUpdater getIUpdaterByParam(String paramName) {
        return this.iUpdater;
    }

    public IActivation getActivationFn() {
        return this.activationFn;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public double getBiasInit() {
        return this.biasInit;
    }

    public Distribution getDist() {
        return this.dist;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getBiasLearningRate() {
        return this.biasLearningRate;
    }

    public Map<Integer, Double> getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    @Deprecated
    public double getMomentum() {
        return this.momentum;
    }

    @Deprecated
    public Map<Integer, Double> getMomentumSchedule() {
        return this.momentumSchedule;
    }

    public double getL1() {
        return this.l1;
    }

    public double getL2() {
        return this.l2;
    }

    public double getL1Bias() {
        return this.l1Bias;
    }

    public double getL2Bias() {
        return this.l2Bias;
    }

    @Deprecated
    public Updater getUpdater() {
        return this.updater;
    }

    public IUpdater getIUpdater() {
        return this.iUpdater;
    }

    @Deprecated
    public double getRho() {
        return this.rho;
    }

    @Deprecated
    public double getEpsilon() {
        return this.epsilon;
    }

    @Deprecated
    public double getRmsDecay() {
        return this.rmsDecay;
    }

    @Deprecated
    public double getAdamMeanDecay() {
        return this.adamMeanDecay;
    }

    @Deprecated
    public double getAdamVarDecay() {
        return this.adamVarDecay;
    }

    public GradientNormalization getGradientNormalization() {
        return this.gradientNormalization;
    }

    public double getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public void setActivationFn(IActivation activationFn) {
        this.activationFn = activationFn;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public void setBiasInit(double biasInit) {
        this.biasInit = biasInit;
    }

    public void setDist(Distribution dist) {
        this.dist = dist;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setBiasLearningRate(double biasLearningRate) {
        this.biasLearningRate = biasLearningRate;
    }

    public void setLearningRateSchedule(Map<Integer, Double> learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    @Deprecated
    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    @Deprecated
    public void setMomentumSchedule(Map<Integer, Double> momentumSchedule) {
        this.momentumSchedule = momentumSchedule;
    }

    public void setL1(double l1) {
        this.l1 = l1;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public void setL1Bias(double l1Bias) {
        this.l1Bias = l1Bias;
    }

    public void setL2Bias(double l2Bias) {
        this.l2Bias = l2Bias;
    }

    @Deprecated
    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    public void setIUpdater(IUpdater iUpdater) {
        this.iUpdater = iUpdater;
    }

    @Deprecated
    public void setRho(double rho) {
        this.rho = rho;
    }

    @Deprecated
    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Deprecated
    public void setRmsDecay(double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    @Deprecated
    public void setAdamMeanDecay(double adamMeanDecay) {
        this.adamMeanDecay = adamMeanDecay;
    }

    @Deprecated
    public void setAdamVarDecay(double adamVarDecay) {
        this.adamVarDecay = adamVarDecay;
    }

    public void setGradientNormalization(GradientNormalization gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    @Override
    public String toString() {
        return "BaseLayer(activationFn=" + this.getActivationFn() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", learningRate=" + this.getLearningRate() + ", biasLearningRate=" + this.getBiasLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", momentum=" + this.getMomentum() + ", momentumSchedule=" + this.getMomentumSchedule() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", l1Bias=" + this.getL1Bias() + ", l2Bias=" + this.getL2Bias() + ", updater=" + (Object)((Object)this.getUpdater()) + ", iUpdater=" + this.getIUpdater() + ", rho=" + this.getRho() + ", epsilon=" + this.getEpsilon() + ", rmsDecay=" + this.getRmsDecay() + ", adamMeanDecay=" + this.getAdamMeanDecay() + ", adamVarDecay=" + this.getAdamVarDecay() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseLayer)) {
            return false;
        }
        BaseLayer other = (BaseLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IActivation this$activationFn = this.getActivationFn();
        IActivation other$activationFn = other.getActivationFn();
        if (this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn)) {
            return false;
        }
        WeightInit this$weightInit = this.getWeightInit();
        WeightInit other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
            return false;
        }
        if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
            return false;
        }
        Distribution this$dist = this.getDist();
        Distribution other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getBiasLearningRate(), other.getBiasLearningRate()) != 0) {
            return false;
        }
        Map<Integer, Double> this$learningRateSchedule = this.getLearningRateSchedule();
        Map<Integer, Double> other$learningRateSchedule = other.getLearningRateSchedule();
        if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !((Object)this$learningRateSchedule).equals(other$learningRateSchedule)) {
            return false;
        }
        if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
            return false;
        }
        Map<Integer, Double> this$momentumSchedule = this.getMomentumSchedule();
        Map<Integer, Double> other$momentumSchedule = other.getMomentumSchedule();
        if (this$momentumSchedule == null ? other$momentumSchedule != null : !((Object)this$momentumSchedule).equals(other$momentumSchedule)) {
            return false;
        }
        if (Double.compare(this.getL1(), other.getL1()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2(), other.getL2()) != 0) {
            return false;
        }
        if (Double.compare(this.getL1Bias(), other.getL1Bias()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2Bias(), other.getL2Bias()) != 0) {
            return false;
        }
        Updater this$updater = this.getUpdater();
        Updater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !((Object)((Object)this$updater)).equals((Object)other$updater)) {
            return false;
        }
        IUpdater this$iUpdater = this.getIUpdater();
        IUpdater other$iUpdater = other.getIUpdater();
        if (this$iUpdater == null ? other$iUpdater != null : !this$iUpdater.equals(other$iUpdater)) {
            return false;
        }
        if (Double.compare(this.getRho(), other.getRho()) != 0) {
            return false;
        }
        if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
            return false;
        }
        if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getAdamMeanDecay(), other.getAdamMeanDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getAdamVarDecay(), other.getAdamVarDecay()) != 0) {
            return false;
        }
        GradientNormalization this$gradientNormalization = this.getGradientNormalization();
        GradientNormalization other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
            return false;
        }
        return Double.compare(this.getGradientNormalizationThreshold(), other.getGradientNormalizationThreshold()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        IActivation $activationFn = this.getActivationFn();
        result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
        WeightInit $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : ((Object)((Object)$weightInit)).hashCode());
        long $biasInit = Double.doubleToLongBits(this.getBiasInit());
        result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
        Distribution $dist = this.getDist();
        result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $biasLearningRate = Double.doubleToLongBits(this.getBiasLearningRate());
        result = result * 59 + (int)($biasLearningRate >>> 32 ^ $biasLearningRate);
        Map<Integer, Double> $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : ((Object)$learningRateSchedule).hashCode());
        long $momentum = Double.doubleToLongBits(this.getMomentum());
        result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
        Map<Integer, Double> $momentumSchedule = this.getMomentumSchedule();
        result = result * 59 + ($momentumSchedule == null ? 43 : ((Object)$momentumSchedule).hashCode());
        long $l1 = Double.doubleToLongBits(this.getL1());
        result = result * 59 + (int)($l1 >>> 32 ^ $l1);
        long $l2 = Double.doubleToLongBits(this.getL2());
        result = result * 59 + (int)($l2 >>> 32 ^ $l2);
        long $l1Bias = Double.doubleToLongBits(this.getL1Bias());
        result = result * 59 + (int)($l1Bias >>> 32 ^ $l1Bias);
        long $l2Bias = Double.doubleToLongBits(this.getL2Bias());
        result = result * 59 + (int)($l2Bias >>> 32 ^ $l2Bias);
        Updater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : ((Object)((Object)$updater)).hashCode());
        IUpdater $iUpdater = this.getIUpdater();
        result = result * 59 + ($iUpdater == null ? 43 : $iUpdater.hashCode());
        long $rho = Double.doubleToLongBits(this.getRho());
        result = result * 59 + (int)($rho >>> 32 ^ $rho);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
        result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
        long $adamMeanDecay = Double.doubleToLongBits(this.getAdamMeanDecay());
        result = result * 59 + (int)($adamMeanDecay >>> 32 ^ $adamMeanDecay);
        long $adamVarDecay = Double.doubleToLongBits(this.getAdamVarDecay());
        result = result * 59 + (int)($adamVarDecay >>> 32 ^ $adamVarDecay);
        GradientNormalization $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : ((Object)((Object)$gradientNormalization)).hashCode());
        long $gradientNormalizationThreshold = Double.doubleToLongBits(this.getGradientNormalizationThreshold());
        result = result * 59 + (int)($gradientNormalizationThreshold >>> 32 ^ $gradientNormalizationThreshold);
        return result;
    }

    public BaseLayer() {
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Layer.Builder<T> {
        protected IActivation activationFn = null;
        protected WeightInit weightInit = null;
        protected double biasInit = Double.NaN;
        protected Distribution dist = null;
        protected double learningRate = Double.NaN;
        protected double biasLearningRate = Double.NaN;
        protected Map<Integer, Double> learningRateSchedule = null;
        @Deprecated
        protected double momentum = Double.NaN;
        @Deprecated
        protected Map<Integer, Double> momentumAfter = null;
        protected double l1 = Double.NaN;
        protected double l2 = Double.NaN;
        protected double l1Bias = Double.NaN;
        protected double l2Bias = Double.NaN;
        @Deprecated
        protected Updater updater = null;
        protected IUpdater iupdater = null;
        @Deprecated
        protected double rho = Double.NaN;
        @Deprecated
        protected double epsilon = Double.NaN;
        @Deprecated
        protected double rmsDecay = Double.NaN;
        @Deprecated
        protected double adamMeanDecay = Double.NaN;
        @Deprecated
        protected double adamVarDecay = Double.NaN;
        protected GradientNormalization gradientNormalization = null;
        protected double gradientNormalizationThreshold = Double.NaN;
        protected LearningRatePolicy learningRatePolicy = null;

        @Deprecated
        public T activation(String activationFunction) {
            return this.activation(Activation.fromString((String)activationFunction));
        }

        public T activation(IActivation activationFunction) {
            this.activationFn = activationFunction;
            return (T)this;
        }

        public T activation(Activation activation) {
            return this.activation(activation.getActivationFunction());
        }

        public T weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T biasInit(double biasInit) {
            this.biasInit = biasInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            this.dist = dist;
            return (T)this;
        }

        public T learningRate(double learningRate) {
            this.learningRate = learningRate;
            return (T)this;
        }

        public T biasLearningRate(double biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return (T)this;
        }

        public T learningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return (T)this;
        }

        public T l1(double l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T l1Bias(double l1Bias) {
            this.l1Bias = l1Bias;
            return (T)this;
        }

        public T l2Bias(double l2Bias) {
            this.l2Bias = l2Bias;
            return (T)this;
        }

        @Deprecated
        public T momentum(double momentum) {
            this.momentum = momentum;
            return (T)this;
        }

        @Deprecated
        public T momentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return (T)this;
        }

        public T updater(Updater updater) {
            return this.updater(updater.getIUpdaterWithDefaultConfig());
        }

        public T updater(IUpdater updater) {
            this.iupdater = updater;
            return (T)this;
        }

        @Deprecated
        public T rho(double rho) {
            this.rho = rho;
            return (T)this;
        }

        @Deprecated
        public T rmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return (T)this;
        }

        @Deprecated
        public T epsilon(double epsilon) {
            this.epsilon = epsilon;
            return (T)this;
        }

        @Deprecated
        public T adamMeanDecay(double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return (T)this;
        }

        @Deprecated
        public T adamVarDecay(double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            this.gradientNormalizationThreshold = threshold;
            return (T)this;
        }

        public T learningRateDecayPolicy(LearningRatePolicy policy) {
            this.learningRatePolicy = policy;
            return (T)this;
        }
    }
}

