/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.AdaGrad;
import org.nd4j.linalg.learning.config.AdaMax;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nadam;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.learning.config.NoOp;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.learning.config.Sgd;

public enum Updater {
    SGD,
    ADAM,
    ADAMAX,
    ADADELTA,
    NESTEROVS,
    NADAM,
    ADAGRAD,
    RMSPROP,
    NONE,
    CUSTOM;


    public IUpdater getIUpdaterWithDefaultConfig() {
        switch (this) {
            case SGD: {
                return new Sgd();
            }
            case ADAM: {
                return new Adam();
            }
            case ADAMAX: {
                return new AdaMax();
            }
            case ADADELTA: {
                return new AdaDelta();
            }
            case NESTEROVS: {
                return new Nesterovs();
            }
            case NADAM: {
                return new Nadam();
            }
            case ADAGRAD: {
                return new AdaGrad();
            }
            case RMSPROP: {
                return new RmsProp();
            }
            case NONE: {
                return new NoOp();
            }
        }
        throw new UnsupportedOperationException("Unknown or not supported updater: " + (Object)((Object)this));
    }
}

