/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.layers.misc.FrozenLayer;
import org.deeplearning4j.nn.conf.layers.variational.ReconstructionDistribution;
import org.deeplearning4j.nn.conf.serde.ComputationGraphConfigurationDeserializer;
import org.deeplearning4j.nn.conf.serde.MultiLayerConfigurationDeserializer;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.util.reflections.DL4JSubTypesScanner;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationSigmoid;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.AdaGrad;
import org.nd4j.linalg.learning.config.AdaMax;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nadam;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.learning.config.NoOp;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.learning.config.Sgd;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.AnnotationIntrospector;
import org.nd4j.shade.jackson.databind.BeanDescription;
import org.nd4j.shade.jackson.databind.DeserializationConfig;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.Module;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.cfg.MapperConfig;
import org.nd4j.shade.jackson.databind.deser.BeanDeserializerModifier;
import org.nd4j.shade.jackson.databind.introspect.AnnotatedClass;
import org.nd4j.shade.jackson.databind.jsontype.NamedType;
import org.nd4j.shade.jackson.databind.module.SimpleModule;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuralNetConfiguration
implements Serializable,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(NeuralNetConfiguration.class);
    public static final String CUSTOM_FUNCTIONALITY = "org.deeplearning4j.config.custom.enabled";
    protected Layer layer;
    @Deprecated
    protected double leakyreluAlpha;
    protected boolean miniBatch = true;
    protected int numIterations;
    protected int maxNumLineSearchIterations;
    protected long seed;
    protected OptimizationAlgorithm optimizationAlgo;
    protected List<String> variables = new ArrayList<String>();
    protected StepFunction stepFunction;
    protected boolean useRegularization = false;
    protected boolean useDropConnect = false;
    protected boolean minimize = true;
    protected Map<String, Double> learningRateByParam = new HashMap<String, Double>();
    protected Map<String, Double> l1ByParam = new HashMap<String, Double>();
    protected Map<String, Double> l2ByParam = new HashMap<String, Double>();
    protected LearningRatePolicy learningRatePolicy = LearningRatePolicy.None;
    protected double lrPolicyDecayRate;
    protected double lrPolicySteps;
    protected double lrPolicyPower;
    protected boolean pretrain;
    protected CacheMode cacheMode;
    protected int iterationCount = 0;
    private static ObjectMapper mapper = NeuralNetConfiguration.initMapper();
    private static final ObjectMapper mapperYaml = NeuralNetConfiguration.initMapperYaml();
    private static Set<Class<?>> subtypesClassCache = null;

    public NeuralNetConfiguration clone() {
        try {
            NeuralNetConfiguration clone = (NeuralNetConfiguration)super.clone();
            if (clone.layer != null) {
                clone.layer = clone.layer.clone();
            }
            if (clone.stepFunction != null) {
                clone.stepFunction = clone.stepFunction.clone();
            }
            if (clone.variables != null) {
                clone.variables = new ArrayList<String>(clone.variables);
            }
            if (clone.learningRateByParam != null) {
                clone.learningRateByParam = new HashMap<String, Double>(clone.learningRateByParam);
            }
            if (clone.l1ByParam != null) {
                clone.l1ByParam = new HashMap<String, Double>(clone.l1ByParam);
            }
            if (clone.l2ByParam != null) {
                clone.l2ByParam = new HashMap<String, Double>(clone.l2ByParam);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> variables() {
        return new ArrayList<String>(this.variables);
    }

    public List<String> variables(boolean copy) {
        if (copy) {
            return this.variables();
        }
        return this.variables;
    }

    public void addVariable(String variable) {
        if (!this.variables.contains(variable)) {
            this.variables.add(variable);
            this.setLayerParamLR(variable);
        }
    }

    public void clearVariables() {
        this.variables.clear();
        this.l1ByParam.clear();
        this.l2ByParam.clear();
        this.learningRateByParam.clear();
    }

    public void resetVariables() {
        for (String s : this.variables) {
            this.setLayerParamLR(s);
        }
    }

    public void setLayerParamLR(String variable) {
        double l2;
        double lr = this.layer.getLearningRateByParam(variable);
        double l1 = this.layer.getL1ByParam(variable);
        if (Double.isNaN(l1)) {
            l1 = 0.0;
        }
        if (Double.isNaN(l2 = this.layer.getL2ByParam(variable))) {
            l2 = 0.0;
        }
        this.learningRateByParam.put(variable, lr);
        this.l1ByParam.put(variable, l1);
        this.l2ByParam.put(variable, l2);
    }

    public double getLearningRateByParam(String variable) {
        return this.learningRateByParam.get(variable);
    }

    public void setLearningRateByParam(String variable, double rate) {
        this.learningRateByParam.put(variable, rate);
    }

    public double getL1ByParam(String variable) {
        return this.l1ByParam.get(variable);
    }

    public double getL2ByParam(String variable) {
        return this.l2ByParam.get(variable);
    }

    public String toYaml() {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper mapperYaml() {
        return mapperYaml;
    }

    private static ObjectMapper initMapperYaml() {
        ObjectMapper ret = new ObjectMapper((JsonFactory)new YAMLFactory());
        NeuralNetConfiguration.configureMapper(ret);
        return ret;
    }

    public static ObjectMapper mapper() {
        return mapper;
    }

    public static ObjectMapper reinitMapperWithSubtypes(Collection<NamedType> additionalTypes) {
        mapper.registerSubtypes(additionalTypes.toArray(new NamedType[additionalTypes.size()]));
        mapper = mapper.copy();
        return mapper;
    }

    private static ObjectMapper initMapper() {
        ObjectMapper ret = new ObjectMapper();
        NeuralNetConfiguration.configureMapper(ret);
        return ret;
    }

    private static void configureMapper(ObjectMapper ret) {
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule customDeserializerModule = new SimpleModule();
        customDeserializerModule.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (beanDesc.getBeanClass() == MultiLayerConfiguration.class) {
                    return new MultiLayerConfigurationDeserializer(deserializer);
                }
                if (beanDesc.getBeanClass() == ComputationGraphConfiguration.class) {
                    return new ComputationGraphConfigurationDeserializer(deserializer);
                }
                return deserializer;
            }
        });
        ret.registerModule((Module)customDeserializerModule);
        NeuralNetConfiguration.registerSubtypes(ret);
    }

    private static synchronized void registerSubtypes(ObjectMapper mapper) {
        List<Class> classes = Arrays.asList(InputPreProcessor.class, ILossFunction.class, IActivation.class, Layer.class, GraphVertex.class, ReconstructionDistribution.class);
        ArrayList<String> classNames = new ArrayList<String>(6);
        for (Class c : classes) {
            classNames.add(c.getName());
        }
        if (subtypesClassCache == null) {
            String prop = System.getProperty(CUSTOM_FUNCTIONALITY);
            if (prop != null && !Boolean.parseBoolean(prop)) {
                subtypesClassCache = Collections.emptySet();
            } else {
                List<Class> interfaces = Arrays.asList(InputPreProcessor.class, ILossFunction.class, IActivation.class, ReconstructionDistribution.class);
                List<Class<?>> classesList = Arrays.asList(Layer.class, GraphVertex.class);
                Collection urls = ClasspathHelper.forClassLoader();
                ArrayList<URL> scanUrls = new ArrayList<URL>();
                for (URL u : urls) {
                    String path = u.getPath();
                    if (path.matches(".*/jre/lib/.*jar")) continue;
                    scanUrls.add(u);
                }
                Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().exclude("^(?!.*\\.class$).*$").exclude("^org.nd4j.*").exclude("^org.datavec.*").exclude("^org.bytedeco.*").exclude("^com.fasterxml.*").exclude("^org.apache.*").exclude("^org.projectlombok.*").exclude("^com.twelvemonkeys.*").exclude("^org.joda.*").exclude("^org.slf4j.*").exclude("^com.google.*").exclude("^org.reflections.*").exclude("^ch.qos.*")).addUrls(scanUrls).setScanners(new Scanner[]{new DL4JSubTypesScanner(interfaces, classesList)}));
                Store store = reflections.getStore();
                Iterable subtypesByName = store.getAll(DL4JSubTypesScanner.class.getSimpleName(), classNames);
                HashSet subtypeClasses = Sets.newHashSet((Iterable)ReflectionUtils.forNames((Iterable)subtypesByName, (ClassLoader[])new ClassLoader[0]));
                subtypesClassCache = new HashSet();
                for (Class c : subtypeClasses) {
                    if (Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers())) continue;
                    subtypesClassCache.add(c);
                }
            }
        }
        HashSet<Class> registeredSubtypes = new HashSet<Class>();
        for (Class c : classes) {
            AnnotatedClass ac = AnnotatedClass.construct((Class)c, (AnnotationIntrospector)mapper.getSerializationConfig().getAnnotationIntrospector(), null);
            Collection types = mapper.getSubtypeResolver().collectAndResolveSubtypes(ac, (MapperConfig)mapper.getSerializationConfig(), mapper.getSerializationConfig().getAnnotationIntrospector());
            for (NamedType nt : types) {
                registeredSubtypes.add(nt.getType());
            }
        }
        ArrayList<NamedType> toRegister = new ArrayList<NamedType>();
        block5: for (Class<?> c : subtypesClassCache) {
            String name;
            if (Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers()) || registeredSubtypes.contains(c)) continue;
            if (ClassUtils.isInnerClass(c)) {
                Class<?> c2 = c.getDeclaringClass();
                name = c2.getSimpleName() + "$" + c.getSimpleName();
            } else {
                name = c.getSimpleName();
            }
            toRegister.add(new NamedType(c, name));
            if (!log.isDebugEnabled()) continue;
            for (Class baseClass : classes) {
                if (!baseClass.isAssignableFrom(c)) continue;
                log.debug("Registering class for JSON serialization: {} as subtype of {}", (Object)c.getName(), (Object)baseClass.getName());
                continue block5;
            }
        }
        mapper.registerSubtypes(toRegister.toArray(new NamedType[toRegister.size()]));
    }

    public Layer getLayer() {
        return this.layer;
    }

    @Deprecated
    public double getLeakyreluAlpha() {
        return this.leakyreluAlpha;
    }

    public boolean isMiniBatch() {
        return this.miniBatch;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public int getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public long getSeed() {
        return this.seed;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public boolean isUseRegularization() {
        return this.useRegularization;
    }

    public boolean isUseDropConnect() {
        return this.useDropConnect;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public Map<String, Double> getLearningRateByParam() {
        return this.learningRateByParam;
    }

    public Map<String, Double> getL1ByParam() {
        return this.l1ByParam;
    }

    public Map<String, Double> getL2ByParam() {
        return this.l2ByParam;
    }

    public LearningRatePolicy getLearningRatePolicy() {
        return this.learningRatePolicy;
    }

    public double getLrPolicyDecayRate() {
        return this.lrPolicyDecayRate;
    }

    public double getLrPolicySteps() {
        return this.lrPolicySteps;
    }

    public double getLrPolicyPower() {
        return this.lrPolicyPower;
    }

    public boolean isPretrain() {
        return this.pretrain;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Deprecated
    public void setLeakyreluAlpha(double leakyreluAlpha) {
        this.leakyreluAlpha = leakyreluAlpha;
    }

    public void setMiniBatch(boolean miniBatch) {
        this.miniBatch = miniBatch;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public void setMaxNumLineSearchIterations(int maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setUseRegularization(boolean useRegularization) {
        this.useRegularization = useRegularization;
    }

    public void setUseDropConnect(boolean useDropConnect) {
        this.useDropConnect = useDropConnect;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setLearningRateByParam(Map<String, Double> learningRateByParam) {
        this.learningRateByParam = learningRateByParam;
    }

    public void setL1ByParam(Map<String, Double> l1ByParam) {
        this.l1ByParam = l1ByParam;
    }

    public void setL2ByParam(Map<String, Double> l2ByParam) {
        this.l2ByParam = l2ByParam;
    }

    public void setLearningRatePolicy(LearningRatePolicy learningRatePolicy) {
        this.learningRatePolicy = learningRatePolicy;
    }

    public void setLrPolicyDecayRate(double lrPolicyDecayRate) {
        this.lrPolicyDecayRate = lrPolicyDecayRate;
    }

    public void setLrPolicySteps(double lrPolicySteps) {
        this.lrPolicySteps = lrPolicySteps;
    }

    public void setLrPolicyPower(double lrPolicyPower) {
        this.lrPolicyPower = lrPolicyPower;
    }

    public void setPretrain(boolean pretrain) {
        this.pretrain = pretrain;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NeuralNetConfiguration)) {
            return false;
        }
        NeuralNetConfiguration other = (NeuralNetConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        if (this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer)) {
            return false;
        }
        if (Double.compare(this.getLeakyreluAlpha(), other.getLeakyreluAlpha()) != 0) {
            return false;
        }
        if (this.isMiniBatch() != other.isMiniBatch()) {
            return false;
        }
        if (this.getNumIterations() != other.getNumIterations()) {
            return false;
        }
        if (this.getMaxNumLineSearchIterations() != other.getMaxNumLineSearchIterations()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
        OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
            return false;
        }
        List<String> this$variables = this.getVariables();
        List<String> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        StepFunction this$stepFunction = this.getStepFunction();
        StepFunction other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        if (this.isUseRegularization() != other.isUseRegularization()) {
            return false;
        }
        if (this.isUseDropConnect() != other.isUseDropConnect()) {
            return false;
        }
        if (this.isMinimize() != other.isMinimize()) {
            return false;
        }
        Map<String, Double> this$learningRateByParam = this.getLearningRateByParam();
        Map<String, Double> other$learningRateByParam = other.getLearningRateByParam();
        if (this$learningRateByParam == null ? other$learningRateByParam != null : !((Object)this$learningRateByParam).equals(other$learningRateByParam)) {
            return false;
        }
        Map<String, Double> this$l1ByParam = this.getL1ByParam();
        Map<String, Double> other$l1ByParam = other.getL1ByParam();
        if (this$l1ByParam == null ? other$l1ByParam != null : !((Object)this$l1ByParam).equals(other$l1ByParam)) {
            return false;
        }
        Map<String, Double> this$l2ByParam = this.getL2ByParam();
        Map<String, Double> other$l2ByParam = other.getL2ByParam();
        if (this$l2ByParam == null ? other$l2ByParam != null : !((Object)this$l2ByParam).equals(other$l2ByParam)) {
            return false;
        }
        LearningRatePolicy this$learningRatePolicy = this.getLearningRatePolicy();
        LearningRatePolicy other$learningRatePolicy = other.getLearningRatePolicy();
        if (this$learningRatePolicy == null ? other$learningRatePolicy != null : !((Object)((Object)this$learningRatePolicy)).equals((Object)other$learningRatePolicy)) {
            return false;
        }
        if (Double.compare(this.getLrPolicyDecayRate(), other.getLrPolicyDecayRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getLrPolicySteps(), other.getLrPolicySteps()) != 0) {
            return false;
        }
        if (Double.compare(this.getLrPolicyPower(), other.getLrPolicyPower()) != 0) {
            return false;
        }
        if (this.isPretrain() != other.isPretrain()) {
            return false;
        }
        CacheMode this$cacheMode = this.getCacheMode();
        CacheMode other$cacheMode = other.getCacheMode();
        if (this$cacheMode == null ? other$cacheMode != null : !((Object)((Object)this$cacheMode)).equals((Object)other$cacheMode)) {
            return false;
        }
        return this.getIterationCount() == other.getIterationCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NeuralNetConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : ((Object)$layer).hashCode());
        long $leakyreluAlpha = Double.doubleToLongBits(this.getLeakyreluAlpha());
        result = result * 59 + (int)($leakyreluAlpha >>> 32 ^ $leakyreluAlpha);
        result = result * 59 + (this.isMiniBatch() ? 79 : 97);
        result = result * 59 + this.getNumIterations();
        result = result * 59 + this.getMaxNumLineSearchIterations();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 43 : ((Object)((Object)$optimizationAlgo)).hashCode());
        List<String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        StepFunction $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
        result = result * 59 + (this.isUseRegularization() ? 79 : 97);
        result = result * 59 + (this.isUseDropConnect() ? 79 : 97);
        result = result * 59 + (this.isMinimize() ? 79 : 97);
        Map<String, Double> $learningRateByParam = this.getLearningRateByParam();
        result = result * 59 + ($learningRateByParam == null ? 43 : ((Object)$learningRateByParam).hashCode());
        Map<String, Double> $l1ByParam = this.getL1ByParam();
        result = result * 59 + ($l1ByParam == null ? 43 : ((Object)$l1ByParam).hashCode());
        Map<String, Double> $l2ByParam = this.getL2ByParam();
        result = result * 59 + ($l2ByParam == null ? 43 : ((Object)$l2ByParam).hashCode());
        LearningRatePolicy $learningRatePolicy = this.getLearningRatePolicy();
        result = result * 59 + ($learningRatePolicy == null ? 43 : ((Object)((Object)$learningRatePolicy)).hashCode());
        long $lrPolicyDecayRate = Double.doubleToLongBits(this.getLrPolicyDecayRate());
        result = result * 59 + (int)($lrPolicyDecayRate >>> 32 ^ $lrPolicyDecayRate);
        long $lrPolicySteps = Double.doubleToLongBits(this.getLrPolicySteps());
        result = result * 59 + (int)($lrPolicySteps >>> 32 ^ $lrPolicySteps);
        long $lrPolicyPower = Double.doubleToLongBits(this.getLrPolicyPower());
        result = result * 59 + (int)($lrPolicyPower >>> 32 ^ $lrPolicyPower);
        result = result * 59 + (this.isPretrain() ? 79 : 97);
        CacheMode $cacheMode = this.getCacheMode();
        result = result * 59 + ($cacheMode == null ? 43 : ((Object)((Object)$cacheMode)).hashCode());
        result = result * 59 + this.getIterationCount();
        return result;
    }

    public String toString() {
        return "NeuralNetConfiguration(layer=" + this.getLayer() + ", leakyreluAlpha=" + this.getLeakyreluAlpha() + ", miniBatch=" + this.isMiniBatch() + ", numIterations=" + this.getNumIterations() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", variables=" + this.getVariables() + ", stepFunction=" + this.getStepFunction() + ", useRegularization=" + this.isUseRegularization() + ", useDropConnect=" + this.isUseDropConnect() + ", minimize=" + this.isMinimize() + ", learningRateByParam=" + this.getLearningRateByParam() + ", l1ByParam=" + this.getL1ByParam() + ", l2ByParam=" + this.getL2ByParam() + ", learningRatePolicy=" + (Object)((Object)this.getLearningRatePolicy()) + ", lrPolicyDecayRate=" + this.getLrPolicyDecayRate() + ", lrPolicySteps=" + this.getLrPolicySteps() + ", lrPolicyPower=" + this.getLrPolicyPower() + ", pretrain=" + this.isPretrain() + ", cacheMode=" + (Object)((Object)this.getCacheMode()) + ", iterationCount=" + this.getIterationCount() + ")";
    }

    public static class Builder
    implements Cloneable {
        protected IActivation activationFn = new ActivationSigmoid();
        protected WeightInit weightInit = WeightInit.XAVIER;
        protected double biasInit = 0.0;
        protected Distribution dist = null;
        protected double learningRate = 0.1;
        protected double biasLearningRate = Double.NaN;
        protected Map<Integer, Double> learningRateSchedule = null;
        protected double lrScoreBasedDecay;
        protected double l1 = Double.NaN;
        protected double l2 = Double.NaN;
        protected double l1Bias = Double.NaN;
        protected double l2Bias = Double.NaN;
        protected double dropOut = 0.0;
        @Deprecated
        protected Updater updater = Updater.SGD;
        protected IUpdater iUpdater = new Sgd();
        @Deprecated
        protected double momentum = Double.NaN;
        @Deprecated
        protected Map<Integer, Double> momentumSchedule = null;
        @Deprecated
        protected double epsilon = Double.NaN;
        @Deprecated
        protected double rho = Double.NaN;
        @Deprecated
        protected double rmsDecay = Double.NaN;
        @Deprecated
        protected double adamMeanDecay = Double.NaN;
        @Deprecated
        protected double adamVarDecay = Double.NaN;
        protected Layer layer;
        @Deprecated
        protected double leakyreluAlpha = 0.01;
        protected boolean miniBatch = true;
        protected int numIterations = 1;
        protected int maxNumLineSearchIterations = 5;
        protected long seed = System.currentTimeMillis();
        protected boolean useRegularization = false;
        protected OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT;
        protected StepFunction stepFunction = null;
        protected boolean useDropConnect = false;
        protected boolean minimize = true;
        protected GradientNormalization gradientNormalization = GradientNormalization.None;
        protected double gradientNormalizationThreshold = 1.0;
        protected LearningRatePolicy learningRatePolicy = LearningRatePolicy.None;
        protected double lrPolicyDecayRate = Double.NaN;
        protected double lrPolicySteps = Double.NaN;
        protected double lrPolicyPower = Double.NaN;
        protected boolean pretrain = false;
        protected WorkspaceMode trainingWorkspaceMode = WorkspaceMode.NONE;
        protected WorkspaceMode inferenceWorkspaceMode = WorkspaceMode.SEPARATE;
        protected CacheMode cacheMode = CacheMode.NONE;
        protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;

        public Builder() {
        }

        public Builder(NeuralNetConfiguration newConf) {
            if (newConf != null) {
                this.minimize = newConf.minimize;
                this.maxNumLineSearchIterations = newConf.maxNumLineSearchIterations;
                this.layer = newConf.layer;
                this.numIterations = newConf.numIterations;
                this.useRegularization = newConf.useRegularization;
                this.optimizationAlgo = newConf.optimizationAlgo;
                this.seed = newConf.seed;
                this.stepFunction = newConf.stepFunction;
                this.useDropConnect = newConf.useDropConnect;
                this.miniBatch = newConf.miniBatch;
                this.learningRatePolicy = newConf.learningRatePolicy;
                this.lrPolicyDecayRate = newConf.lrPolicyDecayRate;
                this.lrPolicySteps = newConf.lrPolicySteps;
                this.lrPolicyPower = newConf.lrPolicyPower;
                this.pretrain = newConf.pretrain;
            }
        }

        public Builder miniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder trainingWorkspaceMode(@NonNull WorkspaceMode workspaceMode) {
            if (workspaceMode == null) {
                throw new NullPointerException("workspaceMode");
            }
            this.trainingWorkspaceMode = workspaceMode;
            return this;
        }

        public Builder inferenceWorkspaceMode(@NonNull WorkspaceMode workspaceMode) {
            if (workspaceMode == null) {
                throw new NullPointerException("workspaceMode");
            }
            this.inferenceWorkspaceMode = workspaceMode;
            return this;
        }

        public Builder cacheMode(@NonNull CacheMode cacheMode) {
            if (cacheMode == null) {
                throw new NullPointerException("cacheMode");
            }
            this.cacheMode = cacheMode;
            return this;
        }

        public Builder useDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return this;
        }

        public Builder layer(Layer layer) {
            this.layer = layer;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public ListBuilder list() {
            return new ListBuilder(this);
        }

        public ListBuilder list(Layer ... layers) {
            if (layers == null || layers.length == 0) {
                throw new IllegalArgumentException("Cannot create network with no layers");
            }
            HashMap<Integer, Builder> layerMap = new HashMap<Integer, Builder>();
            for (int i = 0; i < layers.length; ++i) {
                Builder b = this.clone();
                b.layer(layers[i]);
                layerMap.put(i, b);
            }
            return new ListBuilder(this, layerMap);
        }

        public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
            return new ComputationGraphConfiguration.GraphBuilder(this);
        }

        public Builder iterations(int numIterations) {
            this.numIterations = numIterations;
            return this;
        }

        public Builder seed(int seed) {
            this.seed = seed;
            Nd4j.getRandom().setSeed(seed);
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            Nd4j.getRandom().setSeed(seed);
            return this;
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder regularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
            return this;
        }

        public Builder clone() {
            try {
                Builder clone = (Builder)super.clone();
                if (clone.layer != null) {
                    clone.layer = clone.layer.clone();
                }
                if (clone.stepFunction != null) {
                    clone.stepFunction = clone.stepFunction.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        @Deprecated
        public Builder activation(String activationFunction) {
            return this.activation(Activation.fromString((String)activationFunction).getActivationFunction());
        }

        public Builder activation(IActivation activationFunction) {
            this.activationFn = activationFunction;
            return this;
        }

        public Builder activation(Activation activation) {
            return this.activation(activation.getActivationFunction());
        }

        @Deprecated
        public Builder leakyreluAlpha(double leakyreluAlpha) {
            this.leakyreluAlpha = leakyreluAlpha;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return this;
        }

        public Builder biasInit(double biasInit) {
            this.biasInit = biasInit;
            return this;
        }

        public Builder dist(Distribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder biasLearningRate(double biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return this;
        }

        public Builder learningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return this;
        }

        public Builder learningRateScoreBasedDecayRate(double lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return this;
        }

        public Builder l1(double l1) {
            this.l1 = l1;
            return this;
        }

        public Builder l2(double l2) {
            this.l2 = l2;
            return this;
        }

        public Builder l1Bias(double l1Bias) {
            this.l1Bias = l1Bias;
            return this;
        }

        public Builder l2Bias(double l2Bias) {
            this.l2Bias = l2Bias;
            return this;
        }

        public Builder dropOut(double dropOut) {
            this.dropOut = dropOut;
            return this;
        }

        @Deprecated
        public Builder momentum(double momentum) {
            this.momentum = momentum;
            return this;
        }

        @Deprecated
        public Builder momentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumSchedule = momentumAfter;
            return this;
        }

        public Builder updater(Updater updater) {
            this.updater = updater;
            return this.updater(updater.getIUpdaterWithDefaultConfig());
        }

        public Builder updater(IUpdater updater) {
            if (updater instanceof Sgd) {
                this.updater = Updater.SGD;
            } else if (updater instanceof Adam) {
                this.updater = Updater.ADAM;
            } else if (updater instanceof AdaMax) {
                this.updater = Updater.ADAMAX;
            } else if (updater instanceof AdaDelta) {
                this.updater = Updater.ADADELTA;
            } else if (updater instanceof Nesterovs) {
                this.updater = Updater.NESTEROVS;
            } else if (updater instanceof Nadam) {
                this.updater = Updater.NADAM;
            } else if (updater instanceof AdaGrad) {
                this.updater = Updater.ADAGRAD;
            } else if (updater instanceof RmsProp) {
                this.updater = Updater.RMSPROP;
            } else if (updater instanceof NoOp) {
                this.updater = Updater.NONE;
            }
            this.iUpdater = updater;
            return this;
        }

        @Deprecated
        public Builder rho(double rho) {
            this.rho = rho;
            return this;
        }

        @Deprecated
        public Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        @Deprecated
        public Builder rmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return this;
        }

        @Deprecated
        public Builder adamMeanDecay(double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return this;
        }

        @Deprecated
        public Builder adamVarDecay(double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return this;
        }

        public Builder gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return this;
        }

        public Builder gradientNormalizationThreshold(double threshold) {
            this.gradientNormalizationThreshold = threshold;
            return this;
        }

        public Builder learningRateDecayPolicy(LearningRatePolicy policy) {
            this.learningRatePolicy = policy;
            return this;
        }

        public Builder lrPolicyDecayRate(double lrPolicyDecayRate) {
            this.lrPolicyDecayRate = lrPolicyDecayRate;
            return this;
        }

        public Builder lrPolicySteps(double lrPolicySteps) {
            this.lrPolicySteps = lrPolicySteps;
            return this;
        }

        public Builder lrPolicyPower(double lrPolicyPower) {
            this.lrPolicyPower = lrPolicyPower;
            return this;
        }

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        private void learningRateValidation(String layerName) {
            if (this.learningRatePolicy != LearningRatePolicy.None && Double.isNaN(this.lrPolicyDecayRate) && (this.learningRatePolicy != LearningRatePolicy.Schedule || this.learningRateSchedule == null) && (this.learningRatePolicy != LearningRatePolicy.Poly || Double.isNaN(this.lrPolicyPower))) {
                throw new IllegalStateException("Layer \"" + layerName + "\" learning rate policy decay rate (lrPolicyDecayRate) must be set to use learningRatePolicy.");
            }
            switch (this.learningRatePolicy) {
                case Inverse: 
                case Poly: {
                    if (!Double.isNaN(this.lrPolicyPower)) break;
                    throw new IllegalStateException("Layer \"" + layerName + "\" learning rate policy power (lrPolicyPower) must be set to use " + (Object)((Object)this.learningRatePolicy));
                }
                case Step: 
                case Sigmoid: {
                    if (!Double.isNaN(this.lrPolicySteps)) break;
                    throw new IllegalStateException("Layer \"" + layerName + "\" learning rate policy steps (lrPolicySteps) must be set to use " + (Object)((Object)this.learningRatePolicy));
                }
                case Schedule: {
                    if (this.learningRateSchedule != null) break;
                    throw new IllegalStateException("Layer \"" + layerName + "\" learning rate policy schedule (learningRateSchedule) must be set to use " + (Object)((Object)this.learningRatePolicy));
                }
            }
            if (!Double.isNaN(this.lrPolicyPower) && this.learningRatePolicy != LearningRatePolicy.Inverse && this.learningRatePolicy != LearningRatePolicy.Poly) {
                throw new IllegalStateException("Layer \"" + layerName + "\" power has been set but will not be applied unless the learning rate policy is set to Inverse or Poly.");
            }
            if (!Double.isNaN(this.lrPolicySteps) && this.learningRatePolicy != LearningRatePolicy.Step && this.learningRatePolicy != LearningRatePolicy.Sigmoid && this.learningRatePolicy != LearningRatePolicy.TorchStep) {
                throw new IllegalStateException("Layer \"" + layerName + "\" steps have been set but will not be applied unless the learning rate policy is set to Step or Sigmoid.");
            }
            if (this.learningRateSchedule != null && this.learningRatePolicy != LearningRatePolicy.Schedule) {
                throw new IllegalStateException("Layer \"" + layerName + "\" learning rate schedule has been set but will not be applied unless the learning rate policy is set to Schedule.");
            }
        }

        public NeuralNetConfiguration build() {
            NeuralNetConfiguration conf = new NeuralNetConfiguration();
            conf.minimize = this.minimize;
            conf.maxNumLineSearchIterations = this.maxNumLineSearchIterations;
            conf.layer = this.layer;
            conf.numIterations = this.numIterations;
            conf.useRegularization = this.useRegularization;
            conf.optimizationAlgo = this.optimizationAlgo;
            conf.seed = this.seed;
            conf.stepFunction = this.stepFunction;
            conf.useDropConnect = this.useDropConnect;
            conf.miniBatch = this.miniBatch;
            conf.learningRatePolicy = this.learningRatePolicy;
            conf.lrPolicyDecayRate = this.lrPolicyDecayRate;
            conf.lrPolicySteps = this.lrPolicySteps;
            conf.lrPolicyPower = this.lrPolicyPower;
            conf.pretrain = this.pretrain;
            conf.cacheMode = this.cacheMode;
            this.configureLayer(this.layer);
            if (this.layer instanceof FrozenLayer) {
                this.configureLayer(((FrozenLayer)this.layer).getLayer());
            }
            return conf;
        }

        private void configureLayer(Layer layer) {
            SubsamplingLayer sl;
            ConvolutionLayer cl;
            String layerName = layer == null || layer.getLayerName() == null ? "Layer not named" : layer.getLayerName();
            this.learningRateValidation(layerName);
            if (layer != null) {
                this.copyConfigToLayer(layerName, layer);
            }
            if (layer instanceof FrozenLayer) {
                this.copyConfigToLayer(layerName, ((FrozenLayer)layer).getLayer());
            }
            if (layer instanceof ConvolutionLayer && (cl = (ConvolutionLayer)layer).getConvolutionMode() == null) {
                cl.setConvolutionMode(this.convolutionMode);
            }
            if (layer instanceof SubsamplingLayer && (sl = (SubsamplingLayer)layer).getConvolutionMode() == null) {
                sl.setConvolutionMode(this.convolutionMode);
            }
            LayerValidation.generalValidation(layerName, layer, this.useRegularization, this.useDropConnect, this.dropOut, this.l2, this.l2Bias, this.l1, this.l1Bias, this.dist);
        }

        private void copyConfigToLayer(String layerName, Layer layer) {
            if (Double.isNaN(layer.getDropOut())) {
                layer.setDropOut(this.dropOut);
            }
            if (layer instanceof BaseLayer) {
                BaseLayer bLayer = (BaseLayer)layer;
                if (Double.isNaN(bLayer.getLearningRate())) {
                    bLayer.setLearningRate(this.learningRate);
                }
                if (Double.isNaN(bLayer.getBiasLearningRate())) {
                    if (!Double.isNaN(this.biasLearningRate)) {
                        bLayer.setBiasLearningRate(this.biasLearningRate);
                    } else {
                        bLayer.setBiasLearningRate(bLayer.getLearningRate());
                    }
                }
                if (bLayer.getLearningRateSchedule() == null) {
                    bLayer.setLearningRateSchedule(this.learningRateSchedule);
                }
                if (Double.isNaN(bLayer.getL1())) {
                    bLayer.setL1(this.l1);
                }
                if (Double.isNaN(bLayer.getL2())) {
                    bLayer.setL2(this.l2);
                }
                if (bLayer.getActivationFn() == null) {
                    bLayer.setActivationFn(this.activationFn);
                }
                if (bLayer.getWeightInit() == null) {
                    bLayer.setWeightInit(this.weightInit);
                }
                if (Double.isNaN(bLayer.getBiasInit())) {
                    bLayer.setBiasInit(this.biasInit);
                }
                if (bLayer.getUpdater() == null) {
                    bLayer.setUpdater(this.updater);
                }
                if (bLayer.getIUpdater() == null) {
                    bLayer.setIUpdater(this.iUpdater.clone());
                }
                LayerValidation.updaterValidation(layerName, layer, (Double)this.learningRate, (Double)this.momentum, this.momentumSchedule, (Double)this.adamMeanDecay, (Double)this.adamVarDecay, (Double)this.rho, (Double)this.rmsDecay, (Double)this.epsilon);
                if (bLayer.getGradientNormalization() == null) {
                    bLayer.setGradientNormalization(this.gradientNormalization);
                }
                if (Double.isNaN(bLayer.getGradientNormalizationThreshold())) {
                    bLayer.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
                }
            }
        }

        public IActivation getActivationFn() {
            return this.activationFn;
        }

        public WeightInit getWeightInit() {
            return this.weightInit;
        }

        public double getBiasInit() {
            return this.biasInit;
        }

        public Distribution getDist() {
            return this.dist;
        }

        public double getLearningRate() {
            return this.learningRate;
        }

        public double getBiasLearningRate() {
            return this.biasLearningRate;
        }

        public Map<Integer, Double> getLearningRateSchedule() {
            return this.learningRateSchedule;
        }

        public double getLrScoreBasedDecay() {
            return this.lrScoreBasedDecay;
        }

        public double getL1() {
            return this.l1;
        }

        public double getL2() {
            return this.l2;
        }

        public double getL1Bias() {
            return this.l1Bias;
        }

        public double getL2Bias() {
            return this.l2Bias;
        }

        public double getDropOut() {
            return this.dropOut;
        }

        @Deprecated
        public Updater getUpdater() {
            return this.updater;
        }

        public IUpdater getIUpdater() {
            return this.iUpdater;
        }

        @Deprecated
        public double getMomentum() {
            return this.momentum;
        }

        @Deprecated
        public Map<Integer, Double> getMomentumSchedule() {
            return this.momentumSchedule;
        }

        @Deprecated
        public double getEpsilon() {
            return this.epsilon;
        }

        @Deprecated
        public double getRho() {
            return this.rho;
        }

        @Deprecated
        public double getRmsDecay() {
            return this.rmsDecay;
        }

        @Deprecated
        public double getAdamMeanDecay() {
            return this.adamMeanDecay;
        }

        @Deprecated
        public double getAdamVarDecay() {
            return this.adamVarDecay;
        }

        public Layer getLayer() {
            return this.layer;
        }

        @Deprecated
        public double getLeakyreluAlpha() {
            return this.leakyreluAlpha;
        }

        public boolean isMiniBatch() {
            return this.miniBatch;
        }

        public int getNumIterations() {
            return this.numIterations;
        }

        public int getMaxNumLineSearchIterations() {
            return this.maxNumLineSearchIterations;
        }

        public long getSeed() {
            return this.seed;
        }

        public boolean isUseRegularization() {
            return this.useRegularization;
        }

        public OptimizationAlgorithm getOptimizationAlgo() {
            return this.optimizationAlgo;
        }

        public StepFunction getStepFunction() {
            return this.stepFunction;
        }

        public boolean isUseDropConnect() {
            return this.useDropConnect;
        }

        public boolean isMinimize() {
            return this.minimize;
        }

        public GradientNormalization getGradientNormalization() {
            return this.gradientNormalization;
        }

        public double getGradientNormalizationThreshold() {
            return this.gradientNormalizationThreshold;
        }

        public LearningRatePolicy getLearningRatePolicy() {
            return this.learningRatePolicy;
        }

        public double getLrPolicyDecayRate() {
            return this.lrPolicyDecayRate;
        }

        public double getLrPolicySteps() {
            return this.lrPolicySteps;
        }

        public double getLrPolicyPower() {
            return this.lrPolicyPower;
        }

        public boolean isPretrain() {
            return this.pretrain;
        }

        public WorkspaceMode getTrainingWorkspaceMode() {
            return this.trainingWorkspaceMode;
        }

        public WorkspaceMode getInferenceWorkspaceMode() {
            return this.inferenceWorkspaceMode;
        }

        public CacheMode getCacheMode() {
            return this.cacheMode;
        }

        public ConvolutionMode getConvolutionMode() {
            return this.convolutionMode;
        }

        public void setActivationFn(IActivation activationFn) {
            this.activationFn = activationFn;
        }

        public void setWeightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
        }

        public void setBiasInit(double biasInit) {
            this.biasInit = biasInit;
        }

        public void setDist(Distribution dist) {
            this.dist = dist;
        }

        public void setLearningRate(double learningRate) {
            this.learningRate = learningRate;
        }

        public void setBiasLearningRate(double biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
        }

        public void setLearningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
        }

        public void setLrScoreBasedDecay(double lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
        }

        public void setL1(double l1) {
            this.l1 = l1;
        }

        public void setL2(double l2) {
            this.l2 = l2;
        }

        public void setL1Bias(double l1Bias) {
            this.l1Bias = l1Bias;
        }

        public void setL2Bias(double l2Bias) {
            this.l2Bias = l2Bias;
        }

        public void setDropOut(double dropOut) {
            this.dropOut = dropOut;
        }

        @Deprecated
        public void setUpdater(Updater updater) {
            this.updater = updater;
        }

        public void setIUpdater(IUpdater iUpdater) {
            this.iUpdater = iUpdater;
        }

        @Deprecated
        public void setMomentum(double momentum) {
            this.momentum = momentum;
        }

        @Deprecated
        public void setMomentumSchedule(Map<Integer, Double> momentumSchedule) {
            this.momentumSchedule = momentumSchedule;
        }

        @Deprecated
        public void setEpsilon(double epsilon) {
            this.epsilon = epsilon;
        }

        @Deprecated
        public void setRho(double rho) {
            this.rho = rho;
        }

        @Deprecated
        public void setRmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
        }

        @Deprecated
        public void setAdamMeanDecay(double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
        }

        @Deprecated
        public void setAdamVarDecay(double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
        }

        public void setLayer(Layer layer) {
            this.layer = layer;
        }

        @Deprecated
        public void setLeakyreluAlpha(double leakyreluAlpha) {
            this.leakyreluAlpha = leakyreluAlpha;
        }

        public void setMiniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
        }

        public void setNumIterations(int numIterations) {
            this.numIterations = numIterations;
        }

        public void setMaxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
        }

        public void setSeed(long seed) {
            this.seed = seed;
        }

        public void setUseRegularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
        }

        public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
        }

        public void setStepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
        }

        public void setUseDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
        }

        public void setMinimize(boolean minimize) {
            this.minimize = minimize;
        }

        public void setGradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
        }

        public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
        }

        public void setLearningRatePolicy(LearningRatePolicy learningRatePolicy) {
            this.learningRatePolicy = learningRatePolicy;
        }

        public void setLrPolicyDecayRate(double lrPolicyDecayRate) {
            this.lrPolicyDecayRate = lrPolicyDecayRate;
        }

        public void setLrPolicySteps(double lrPolicySteps) {
            this.lrPolicySteps = lrPolicySteps;
        }

        public void setLrPolicyPower(double lrPolicyPower) {
            this.lrPolicyPower = lrPolicyPower;
        }

        public void setPretrain(boolean pretrain) {
            this.pretrain = pretrain;
        }

        public void setTrainingWorkspaceMode(WorkspaceMode trainingWorkspaceMode) {
            this.trainingWorkspaceMode = trainingWorkspaceMode;
        }

        public void setInferenceWorkspaceMode(WorkspaceMode inferenceWorkspaceMode) {
            this.inferenceWorkspaceMode = inferenceWorkspaceMode;
        }

        public void setCacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
        }

        public void setConvolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IActivation this$activationFn = this.getActivationFn();
            IActivation other$activationFn = other.getActivationFn();
            if (this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn)) {
                return false;
            }
            WeightInit this$weightInit = this.getWeightInit();
            WeightInit other$weightInit = other.getWeightInit();
            if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
                return false;
            }
            if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
                return false;
            }
            Distribution this$dist = this.getDist();
            Distribution other$dist = other.getDist();
            if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
                return false;
            }
            if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
                return false;
            }
            if (Double.compare(this.getBiasLearningRate(), other.getBiasLearningRate()) != 0) {
                return false;
            }
            Map<Integer, Double> this$learningRateSchedule = this.getLearningRateSchedule();
            Map<Integer, Double> other$learningRateSchedule = other.getLearningRateSchedule();
            if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !((Object)this$learningRateSchedule).equals(other$learningRateSchedule)) {
                return false;
            }
            if (Double.compare(this.getLrScoreBasedDecay(), other.getLrScoreBasedDecay()) != 0) {
                return false;
            }
            if (Double.compare(this.getL1(), other.getL1()) != 0) {
                return false;
            }
            if (Double.compare(this.getL2(), other.getL2()) != 0) {
                return false;
            }
            if (Double.compare(this.getL1Bias(), other.getL1Bias()) != 0) {
                return false;
            }
            if (Double.compare(this.getL2Bias(), other.getL2Bias()) != 0) {
                return false;
            }
            if (Double.compare(this.getDropOut(), other.getDropOut()) != 0) {
                return false;
            }
            Updater this$updater = this.getUpdater();
            Updater other$updater = other.getUpdater();
            if (this$updater == null ? other$updater != null : !((Object)((Object)this$updater)).equals((Object)other$updater)) {
                return false;
            }
            IUpdater this$iUpdater = this.getIUpdater();
            IUpdater other$iUpdater = other.getIUpdater();
            if (this$iUpdater == null ? other$iUpdater != null : !this$iUpdater.equals(other$iUpdater)) {
                return false;
            }
            if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
                return false;
            }
            Map<Integer, Double> this$momentumSchedule = this.getMomentumSchedule();
            Map<Integer, Double> other$momentumSchedule = other.getMomentumSchedule();
            if (this$momentumSchedule == null ? other$momentumSchedule != null : !((Object)this$momentumSchedule).equals(other$momentumSchedule)) {
                return false;
            }
            if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
                return false;
            }
            if (Double.compare(this.getRho(), other.getRho()) != 0) {
                return false;
            }
            if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
                return false;
            }
            if (Double.compare(this.getAdamMeanDecay(), other.getAdamMeanDecay()) != 0) {
                return false;
            }
            if (Double.compare(this.getAdamVarDecay(), other.getAdamVarDecay()) != 0) {
                return false;
            }
            Layer this$layer = this.getLayer();
            Layer other$layer = other.getLayer();
            if (this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer)) {
                return false;
            }
            if (Double.compare(this.getLeakyreluAlpha(), other.getLeakyreluAlpha()) != 0) {
                return false;
            }
            if (this.isMiniBatch() != other.isMiniBatch()) {
                return false;
            }
            if (this.getNumIterations() != other.getNumIterations()) {
                return false;
            }
            if (this.getMaxNumLineSearchIterations() != other.getMaxNumLineSearchIterations()) {
                return false;
            }
            if (this.getSeed() != other.getSeed()) {
                return false;
            }
            if (this.isUseRegularization() != other.isUseRegularization()) {
                return false;
            }
            OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
            OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
            if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
                return false;
            }
            StepFunction this$stepFunction = this.getStepFunction();
            StepFunction other$stepFunction = other.getStepFunction();
            if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
                return false;
            }
            if (this.isUseDropConnect() != other.isUseDropConnect()) {
                return false;
            }
            if (this.isMinimize() != other.isMinimize()) {
                return false;
            }
            GradientNormalization this$gradientNormalization = this.getGradientNormalization();
            GradientNormalization other$gradientNormalization = other.getGradientNormalization();
            if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
                return false;
            }
            if (Double.compare(this.getGradientNormalizationThreshold(), other.getGradientNormalizationThreshold()) != 0) {
                return false;
            }
            LearningRatePolicy this$learningRatePolicy = this.getLearningRatePolicy();
            LearningRatePolicy other$learningRatePolicy = other.getLearningRatePolicy();
            if (this$learningRatePolicy == null ? other$learningRatePolicy != null : !((Object)((Object)this$learningRatePolicy)).equals((Object)other$learningRatePolicy)) {
                return false;
            }
            if (Double.compare(this.getLrPolicyDecayRate(), other.getLrPolicyDecayRate()) != 0) {
                return false;
            }
            if (Double.compare(this.getLrPolicySteps(), other.getLrPolicySteps()) != 0) {
                return false;
            }
            if (Double.compare(this.getLrPolicyPower(), other.getLrPolicyPower()) != 0) {
                return false;
            }
            if (this.isPretrain() != other.isPretrain()) {
                return false;
            }
            WorkspaceMode this$trainingWorkspaceMode = this.getTrainingWorkspaceMode();
            WorkspaceMode other$trainingWorkspaceMode = other.getTrainingWorkspaceMode();
            if (this$trainingWorkspaceMode == null ? other$trainingWorkspaceMode != null : !((Object)((Object)this$trainingWorkspaceMode)).equals((Object)other$trainingWorkspaceMode)) {
                return false;
            }
            WorkspaceMode this$inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
            WorkspaceMode other$inferenceWorkspaceMode = other.getInferenceWorkspaceMode();
            if (this$inferenceWorkspaceMode == null ? other$inferenceWorkspaceMode != null : !((Object)((Object)this$inferenceWorkspaceMode)).equals((Object)other$inferenceWorkspaceMode)) {
                return false;
            }
            CacheMode this$cacheMode = this.getCacheMode();
            CacheMode other$cacheMode = other.getCacheMode();
            if (this$cacheMode == null ? other$cacheMode != null : !((Object)((Object)this$cacheMode)).equals((Object)other$cacheMode)) {
                return false;
            }
            ConvolutionMode this$convolutionMode = this.getConvolutionMode();
            ConvolutionMode other$convolutionMode = other.getConvolutionMode();
            return !(this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IActivation $activationFn = this.getActivationFn();
            result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
            WeightInit $weightInit = this.getWeightInit();
            result = result * 59 + ($weightInit == null ? 43 : ((Object)((Object)$weightInit)).hashCode());
            long $biasInit = Double.doubleToLongBits(this.getBiasInit());
            result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
            Distribution $dist = this.getDist();
            result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
            long $learningRate = Double.doubleToLongBits(this.getLearningRate());
            result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
            long $biasLearningRate = Double.doubleToLongBits(this.getBiasLearningRate());
            result = result * 59 + (int)($biasLearningRate >>> 32 ^ $biasLearningRate);
            Map<Integer, Double> $learningRateSchedule = this.getLearningRateSchedule();
            result = result * 59 + ($learningRateSchedule == null ? 43 : ((Object)$learningRateSchedule).hashCode());
            long $lrScoreBasedDecay = Double.doubleToLongBits(this.getLrScoreBasedDecay());
            result = result * 59 + (int)($lrScoreBasedDecay >>> 32 ^ $lrScoreBasedDecay);
            long $l1 = Double.doubleToLongBits(this.getL1());
            result = result * 59 + (int)($l1 >>> 32 ^ $l1);
            long $l2 = Double.doubleToLongBits(this.getL2());
            result = result * 59 + (int)($l2 >>> 32 ^ $l2);
            long $l1Bias = Double.doubleToLongBits(this.getL1Bias());
            result = result * 59 + (int)($l1Bias >>> 32 ^ $l1Bias);
            long $l2Bias = Double.doubleToLongBits(this.getL2Bias());
            result = result * 59 + (int)($l2Bias >>> 32 ^ $l2Bias);
            long $dropOut = Double.doubleToLongBits(this.getDropOut());
            result = result * 59 + (int)($dropOut >>> 32 ^ $dropOut);
            Updater $updater = this.getUpdater();
            result = result * 59 + ($updater == null ? 43 : ((Object)((Object)$updater)).hashCode());
            IUpdater $iUpdater = this.getIUpdater();
            result = result * 59 + ($iUpdater == null ? 43 : $iUpdater.hashCode());
            long $momentum = Double.doubleToLongBits(this.getMomentum());
            result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
            Map<Integer, Double> $momentumSchedule = this.getMomentumSchedule();
            result = result * 59 + ($momentumSchedule == null ? 43 : ((Object)$momentumSchedule).hashCode());
            long $epsilon = Double.doubleToLongBits(this.getEpsilon());
            result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
            long $rho = Double.doubleToLongBits(this.getRho());
            result = result * 59 + (int)($rho >>> 32 ^ $rho);
            long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
            result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
            long $adamMeanDecay = Double.doubleToLongBits(this.getAdamMeanDecay());
            result = result * 59 + (int)($adamMeanDecay >>> 32 ^ $adamMeanDecay);
            long $adamVarDecay = Double.doubleToLongBits(this.getAdamVarDecay());
            result = result * 59 + (int)($adamVarDecay >>> 32 ^ $adamVarDecay);
            Layer $layer = this.getLayer();
            result = result * 59 + ($layer == null ? 43 : ((Object)$layer).hashCode());
            long $leakyreluAlpha = Double.doubleToLongBits(this.getLeakyreluAlpha());
            result = result * 59 + (int)($leakyreluAlpha >>> 32 ^ $leakyreluAlpha);
            result = result * 59 + (this.isMiniBatch() ? 79 : 97);
            result = result * 59 + this.getNumIterations();
            result = result * 59 + this.getMaxNumLineSearchIterations();
            long $seed = this.getSeed();
            result = result * 59 + (int)($seed >>> 32 ^ $seed);
            result = result * 59 + (this.isUseRegularization() ? 79 : 97);
            OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
            result = result * 59 + ($optimizationAlgo == null ? 43 : ((Object)((Object)$optimizationAlgo)).hashCode());
            StepFunction $stepFunction = this.getStepFunction();
            result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
            result = result * 59 + (this.isUseDropConnect() ? 79 : 97);
            result = result * 59 + (this.isMinimize() ? 79 : 97);
            GradientNormalization $gradientNormalization = this.getGradientNormalization();
            result = result * 59 + ($gradientNormalization == null ? 43 : ((Object)((Object)$gradientNormalization)).hashCode());
            long $gradientNormalizationThreshold = Double.doubleToLongBits(this.getGradientNormalizationThreshold());
            result = result * 59 + (int)($gradientNormalizationThreshold >>> 32 ^ $gradientNormalizationThreshold);
            LearningRatePolicy $learningRatePolicy = this.getLearningRatePolicy();
            result = result * 59 + ($learningRatePolicy == null ? 43 : ((Object)((Object)$learningRatePolicy)).hashCode());
            long $lrPolicyDecayRate = Double.doubleToLongBits(this.getLrPolicyDecayRate());
            result = result * 59 + (int)($lrPolicyDecayRate >>> 32 ^ $lrPolicyDecayRate);
            long $lrPolicySteps = Double.doubleToLongBits(this.getLrPolicySteps());
            result = result * 59 + (int)($lrPolicySteps >>> 32 ^ $lrPolicySteps);
            long $lrPolicyPower = Double.doubleToLongBits(this.getLrPolicyPower());
            result = result * 59 + (int)($lrPolicyPower >>> 32 ^ $lrPolicyPower);
            result = result * 59 + (this.isPretrain() ? 79 : 97);
            WorkspaceMode $trainingWorkspaceMode = this.getTrainingWorkspaceMode();
            result = result * 59 + ($trainingWorkspaceMode == null ? 43 : ((Object)((Object)$trainingWorkspaceMode)).hashCode());
            WorkspaceMode $inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
            result = result * 59 + ($inferenceWorkspaceMode == null ? 43 : ((Object)((Object)$inferenceWorkspaceMode)).hashCode());
            CacheMode $cacheMode = this.getCacheMode();
            result = result * 59 + ($cacheMode == null ? 43 : ((Object)((Object)$cacheMode)).hashCode());
            ConvolutionMode $convolutionMode = this.getConvolutionMode();
            result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
            return result;
        }

        public String toString() {
            return "NeuralNetConfiguration.Builder(activationFn=" + this.getActivationFn() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", learningRate=" + this.getLearningRate() + ", biasLearningRate=" + this.getBiasLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", lrScoreBasedDecay=" + this.getLrScoreBasedDecay() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", l1Bias=" + this.getL1Bias() + ", l2Bias=" + this.getL2Bias() + ", dropOut=" + this.getDropOut() + ", updater=" + (Object)((Object)this.getUpdater()) + ", iUpdater=" + this.getIUpdater() + ", momentum=" + this.getMomentum() + ", momentumSchedule=" + this.getMomentumSchedule() + ", epsilon=" + this.getEpsilon() + ", rho=" + this.getRho() + ", rmsDecay=" + this.getRmsDecay() + ", adamMeanDecay=" + this.getAdamMeanDecay() + ", adamVarDecay=" + this.getAdamVarDecay() + ", layer=" + this.getLayer() + ", leakyreluAlpha=" + this.getLeakyreluAlpha() + ", miniBatch=" + this.isMiniBatch() + ", numIterations=" + this.getNumIterations() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", useRegularization=" + this.isUseRegularization() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", stepFunction=" + this.getStepFunction() + ", useDropConnect=" + this.isUseDropConnect() + ", minimize=" + this.isMinimize() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ", learningRatePolicy=" + (Object)((Object)this.getLearningRatePolicy()) + ", lrPolicyDecayRate=" + this.getLrPolicyDecayRate() + ", lrPolicySteps=" + this.getLrPolicySteps() + ", lrPolicyPower=" + this.getLrPolicyPower() + ", pretrain=" + this.isPretrain() + ", trainingWorkspaceMode=" + (Object)((Object)this.getTrainingWorkspaceMode()) + ", inferenceWorkspaceMode=" + (Object)((Object)this.getInferenceWorkspaceMode()) + ", cacheMode=" + (Object)((Object)this.getCacheMode()) + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ")";
        }
    }

    public static class ListBuilder
    extends MultiLayerConfiguration.Builder {
        private Map<Integer, Builder> layerwise;
        private Builder globalConfig;

        public ListBuilder(Builder globalConfig, Map<Integer, Builder> layerMap) {
            this.globalConfig = globalConfig;
            this.layerwise = layerMap;
        }

        public ListBuilder(Builder globalConfig) {
            this(globalConfig, new HashMap<Integer, Builder>());
        }

        @Override
        public ListBuilder backprop(boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        @Override
        public ListBuilder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public ListBuilder layer(int ind, Layer layer) {
            if (this.layerwise.containsKey(ind)) {
                this.layerwise.get(ind).layer(layer);
            } else {
                this.layerwise.put(ind, this.globalConfig.clone().layer(layer));
            }
            return this;
        }

        public Map<Integer, Builder> getLayerwise() {
            return this.layerwise;
        }

        @Override
        public MultiLayerConfiguration build() {
            ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
            if (this.layerwise.isEmpty()) {
                throw new IllegalStateException("Invalid configuration: no layers defined");
            }
            for (int i = 0; i < this.layerwise.size(); ++i) {
                if (this.layerwise.get(i) == null) {
                    throw new IllegalStateException("Invalid configuration: layer number " + i + " not specified. Expect layer numbers to be 0 to " + (this.layerwise.size() - 1) + " inclusive (number of layers defined: " + this.layerwise.size() + ")");
                }
                if (this.layerwise.get(i).getLayer() == null) {
                    throw new IllegalStateException("Cannot construct network: Layer config forlayer with index " + i + " is not defined)");
                }
                if (this.layerwise.get(i).getLayer().getLayerName() == null) {
                    this.layerwise.get(i).getLayer().setLayerName("layer" + i);
                }
                list.add(this.layerwise.get(i).build());
            }
            return new MultiLayerConfiguration.Builder().backprop(this.backprop).inputPreProcessors(this.inputPreProcessors).pretrain(this.pretrain).backpropType(this.backpropType).tBPTTForwardLength(this.tbpttFwdLength).tBPTTBackwardLength(this.tbpttBackLength).setInputType(this.inputType).trainingWorkspaceMode(this.globalConfig.trainingWorkspaceMode).cacheMode(this.globalConfig.cacheMode).inferenceWorkspaceMode(this.globalConfig.inferenceWorkspaceMode).confs(list).build();
        }
    }
}

