/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.updater;

import java.util.HashMap;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Updater;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.updater.BaseMultiLayerUpdater;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLayerUpdater
extends BaseMultiLayerUpdater<MultiLayerNetwork> {
    private static final Logger log = LoggerFactory.getLogger(MultiLayerUpdater.class);

    public MultiLayerUpdater(MultiLayerNetwork network) {
        this(network, (INDArray)null);
    }

    public MultiLayerUpdater(MultiLayerNetwork network, INDArray updaterState) {
        super(network, updaterState);
        this.layersByName = new HashMap();
        Layer[] l = network.getLayers();
        for (int i = 0; i < l.length; ++i) {
            this.layersByName.put(String.valueOf(i), l[i]);
        }
    }

    @Override
    protected Layer[] getOrderedLayers() {
        return ((MultiLayerNetwork)this.network).getLayers();
    }

    @Override
    protected INDArray getFlattenedGradientsView() {
        if (((MultiLayerNetwork)this.network).getFlattenedGradients() == null) {
            ((MultiLayerNetwork)this.network).initGradientsView();
        }
        return ((MultiLayerNetwork)this.network).getFlattenedGradients();
    }

    @Override
    protected INDArray getParams() {
        return ((MultiLayerNetwork)this.network).params();
    }

    @Override
    protected boolean isMiniBatch() {
        return ((MultiLayerNetwork)this.network).conf().isMiniBatch();
    }

    public Updater clone() {
        return new MultiLayerUpdater((MultiLayerNetwork)this.network, null);
    }
}

