/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingHelper;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.IsMax;
import org.nd4j.linalg.api.ops.impl.transforms.convolution.Pooling2D;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsamplingLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.SubsamplingLayer> {
    private static final Logger log = LoggerFactory.getLogger(SubsamplingLayer.class);
    protected SubsamplingHelper helper = null;
    protected ConvolutionMode convolutionMode;

    public SubsamplingLayer(NeuralNetConfiguration conf) {
        super(conf);
        this.initializeHelper();
        this.convolutionMode = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)conf.getLayer()).getConvolutionMode();
    }

    public SubsamplingLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
        this.initializeHelper();
    }

    void initializeHelper() {
        block3: {
            try {
                this.helper = Class.forName("org.deeplearning4j.nn.layers.convolution.subsampling.CudnnSubsamplingHelper").asSubclass(SubsamplingHelper.class).newInstance();
                log.debug("CudnnSubsamplingHelper successfully initialized");
                if (!this.helper.checkSupported()) {
                    this.helper = null;
                }
            }
            catch (Throwable t) {
                if (t instanceof ClassNotFoundException) break block3;
                log.warn("Could not initialize CudnnSubsamplingHelper", t);
            }
        }
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.SUBSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray epsilon1d;
        INDArray col6dPermuted;
        INDArray col6d;
        Pair<Gradient, INDArray> ret;
        int[] pad;
        int[] outSize;
        int miniBatch = this.input.size(0);
        int inDepth = this.input.size(1);
        int inH = this.input.size(2);
        int inW = this.input.size(3);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(this.input, kernel, strides, null, this.convolutionMode);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(this.input, kernel, strides, pad, this.convolutionMode);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        if (this.helper != null && (ret = this.helper.backpropGradient(this.input, epsilon, kernel, strides, pad, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType(), this.convolutionMode)) != null) {
            return ret;
        }
        int inputHeight = this.input().size(-2);
        int inputWidth = this.input().size(-1);
        DefaultGradient retGradient = new DefaultGradient();
        boolean cOrderStrides = false;
        if (epsilon.ordering() != 'c') {
            epsilon = epsilon.dup('c');
            cOrderStrides = true;
        }
        if (!cOrderStrides && Shape.strideDescendingCAscendingF((INDArray)epsilon)) {
            cOrderStrides = true;
        } else if (!Arrays.equals(new int[]{outH * outW, inDepth * outH * outW, outW, 1}, epsilon.stride())) {
            epsilon = epsilon.dup('c');
            cOrderStrides = true;
        }
        if (cOrderStrides) {
            col6d = Nd4j.create((int[])new int[]{miniBatch, inDepth, outH, outW, kernel[0], kernel[1]}, (char)'c');
            col6dPermuted = col6d.permute(new int[]{0, 1, 4, 5, 2, 3});
            epsilon1d = epsilon.reshape('c', ArrayUtil.prod((int[])new int[]{epsilon.length()}), 1);
        } else {
            col6d = Nd4j.create((int[])new int[]{inDepth, miniBatch, outH, outW, kernel[0], kernel[1]}, (char)'c');
            col6dPermuted = col6d.permute(new int[]{1, 0, 4, 5, 2, 3});
            INDArray epsilonTemp = epsilon.permute(new int[]{1, 0, 2, 3});
            epsilon1d = epsilonTemp.reshape('c', new int[]{ArrayUtil.prod((int[])new int[]{epsilon.length()}), 1});
        }
        INDArray col2d = col6d.reshape('c', miniBatch * inDepth * outH * outW, kernel[0] * kernel[1]);
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case MAX: {
                Convolution.im2col((INDArray)this.input, (int)kernel[0], (int)kernel[1], (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (this.convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0, (INDArray)col6dPermuted);
                INDArray isMax = Nd4j.getExecutioner().execAndReturn((TransformOp)new IsMax(col2d, new int[]{1}));
                isMax.muliColumnVector(epsilon1d);
                break;
            }
            case AVG: {
                col2d.addiColumnVector(epsilon1d);
                break;
            }
            case PNORM: {
                INDArray numerator;
                int pnorm = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPnorm();
                Convolution.im2col((INDArray)this.input, (int)kernel[0], (int)kernel[1], (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (this.convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0, (INDArray)col6dPermuted);
                INDArray pNorm = Transforms.abs((INDArray)col2d, (boolean)true);
                Transforms.pow((INDArray)pNorm, (Number)pnorm, (boolean)false);
                pNorm = pNorm.sum(new int[]{1});
                Transforms.pow((INDArray)pNorm, (Number)(1.0 / (double)pnorm), (boolean)false);
                if (pnorm == 2) {
                    numerator = col2d;
                } else {
                    INDArray absp2 = Transforms.pow((INDArray)Transforms.abs((INDArray)col2d, (boolean)true), (Number)(pnorm - 2), (boolean)false);
                    numerator = col2d.muli(absp2);
                }
                INDArray denom = Transforms.pow((INDArray)pNorm, (Number)(pnorm - 1), (boolean)false);
                double eps = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getEps();
                Transforms.max((INDArray)denom, (double)eps, (boolean)false);
                numerator.muliColumnVector(denom.rdivi(epsilon1d));
                break;
            }
            case NONE: {
                return new Pair<Gradient, INDArray>(retGradient, epsilon);
            }
            default: {
                throw new IllegalStateException("Unknown or unsupported pooling type: " + (Object)((Object)((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) + " " + this.layerId());
            }
        }
        INDArray tempEpsilon = Nd4j.create((int[])new int[]{inDepth, miniBatch, inH, inW}, (char)'c');
        INDArray outEpsilon = tempEpsilon.permute(new int[]{1, 0, 2, 3});
        Convolution.col2im((INDArray)col6dPermuted, (INDArray)outEpsilon, (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (int)inputHeight, (int)inputWidth);
        if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType() == PoolingType.AVG) {
            outEpsilon.divi((Number)ArrayUtil.prod((int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize()));
        }
        return new Pair<Gradient, INDArray>(retGradient, outEpsilon);
    }

    @Override
    public INDArray activate(boolean training) {
        INDArray ret;
        int[] pad;
        int[] outSize;
        if (training && this.conf.getLayer().getDropOut() > 0.0) {
            Dropout.applyDropout(this.input, this.conf.getLayer().getDropOut());
        }
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, depth, inputHeight, inputWidth]. " + this.layerId());
        }
        int miniBatch = this.input.size(0);
        int inDepth = this.input.size(1);
        int inH = this.input.size(2);
        int inW = this.input.size(3);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(this.input, kernel, strides, null, this.convolutionMode);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(this.input, kernel, strides, pad, this.convolutionMode);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        if (this.helper != null && (ret = this.helper.activate(this.input, training, kernel, strides, pad, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType(), this.convolutionMode)) != null) {
            return ret;
        }
        INDArray output = Nd4j.createUninitialized((int)(miniBatch * inDepth * outH * outW));
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case AVG: {
                Convolution.pooling2D((INDArray)this.input, (int)kernel[0], (int)kernel[1], (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (this.convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0, (Pooling2D.Pooling2DType)Pooling2D.Pooling2DType.AVG, (double)0.0, (int)outH, (int)outW, (INDArray)output);
                break;
            }
            case MAX: {
                Convolution.pooling2D((INDArray)this.input, (int)kernel[0], (int)kernel[1], (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (this.convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0, (Pooling2D.Pooling2DType)Pooling2D.Pooling2DType.MAX, (double)0.0, (int)outH, (int)outW, (INDArray)output);
                break;
            }
            case PNORM: {
                int pnorm = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPnorm();
                Convolution.pooling2D((INDArray)this.input, (int)kernel[0], (int)kernel[1], (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (this.convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0, (Pooling2D.Pooling2DType)Pooling2D.Pooling2DType.PNORM, (double)pnorm, (int)outH, (int)outW, (INDArray)output);
                break;
            }
            case NONE: {
                return this.input;
            }
            default: {
                throw new IllegalStateException("Unknown/not supported pooling type: " + (Object)((Object)((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) + " " + this.layerId());
            }
        }
        return output.reshape('c', new int[]{miniBatch, inDepth, outH, outW});
    }

    @Override
    public Gradient error(INDArray input) {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray indArray) {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public void merge(Layer layer, int batchSize) {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public INDArray activationMean() {
        return null;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public Layer clone() {
        return new SubsamplingLayer(this.conf.clone());
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void iterate(INDArray input) {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public int numParams() {
        return 0;
    }

    @Override
    public void fit(INDArray input) {
    }

    @Override
    public void computeGradientAndScore() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void accumulateScore(double accum) {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }

    @Override
    public INDArray preOutput(boolean training) {
        return this.activate(training);
    }
}

