/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.OutputLayer;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.OneTimeLogger;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrozenLayer
implements Layer {
    private static final Logger log = LoggerFactory.getLogger(FrozenLayer.class);
    private Layer insideLayer;
    private boolean logUpdate = false;
    private boolean logFit = false;
    private boolean logTestMode = false;
    private boolean logGradient = false;
    private Gradient zeroGradient;

    public FrozenLayer(Layer insideLayer) {
        this.insideLayer = insideLayer;
        if (insideLayer instanceof OutputLayer) {
            throw new IllegalArgumentException("Output Layers are not allowed to be frozen " + this.layerId());
        }
        this.insideLayer = insideLayer;
        this.zeroGradient = new DefaultGradient(insideLayer.params());
        if (insideLayer.paramTable() != null) {
            for (String paramType : insideLayer.paramTable().keySet()) {
                this.zeroGradient.setGradientFor(paramType, null);
            }
        }
    }

    @Override
    public void setCacheMode(CacheMode mode) {
    }

    protected String layerId() {
        String name = this.insideLayer.conf().getLayer().getLayerName();
        return "(layer name: " + (name == null ? "\"\"" : name) + ", layer index: " + this.insideLayer.getIndex() + ")";
    }

    @Override
    public double calcL2(boolean backpropOnlyParams) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropOnlyParams) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return this.insideLayer.type();
    }

    @Override
    public Gradient error(INDArray input) {
        if (!this.logGradient) {
            OneTimeLogger.info(log, "Gradients for the frozen layer are not set and will therefore will not be updated.Warning will be issued only once per instance", new Object[0]);
            this.logGradient = true;
        }
        return this.zeroGradient;
    }

    @Override
    public INDArray derivativeActivation(INDArray input) {
        return this.insideLayer.derivativeActivation(input);
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray indArray) {
        return this.zeroGradient;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        return new Pair<Gradient, Object>(this.zeroGradient, null);
    }

    @Override
    public void merge(Layer layer, int batchSize) {
        this.insideLayer.merge(layer, batchSize);
    }

    @Override
    public INDArray activationMean() {
        return this.insideLayer.activationMean();
    }

    @Override
    public INDArray preOutput(INDArray x) {
        return this.insideLayer.preOutput(x);
    }

    @Override
    public INDArray preOutput(INDArray x, Layer.TrainingMode training) {
        this.logTestMode(training);
        return this.insideLayer.preOutput(x, Layer.TrainingMode.TEST);
    }

    @Override
    public INDArray activate(Layer.TrainingMode training) {
        this.logTestMode(training);
        return this.insideLayer.activate(Layer.TrainingMode.TEST);
    }

    @Override
    public INDArray activate(INDArray input, Layer.TrainingMode training) {
        this.logTestMode(training);
        return this.insideLayer.activate(input, Layer.TrainingMode.TEST);
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        this.logTestMode(training);
        return this.preOutput(x, Layer.TrainingMode.TEST);
    }

    @Override
    public INDArray activate(boolean training) {
        this.logTestMode(training);
        return this.insideLayer.activate(false);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.logTestMode(training);
        return this.insideLayer.activate(input, false);
    }

    @Override
    public INDArray activate() {
        return this.insideLayer.activate();
    }

    @Override
    public INDArray activate(INDArray input) {
        return this.insideLayer.activate(input);
    }

    @Override
    public Layer transpose() {
        return new FrozenLayer(this.insideLayer.transpose());
    }

    @Override
    public Layer clone() {
        OneTimeLogger.info(log, "Frozen layers are cloned as their original versions.", new Object[0]);
        return new FrozenLayer(this.insideLayer.clone());
    }

    @Override
    public Collection<IterationListener> getListeners() {
        return this.insideLayer.getListeners();
    }

    @Override
    public void setListeners(IterationListener ... listeners) {
        this.insideLayer.setListeners(listeners);
    }

    @Override
    public void addListeners(IterationListener ... listener) {
        this.insideLayer.addListeners(listener);
    }

    @Override
    public void fit() {
        if (!this.logFit) {
            OneTimeLogger.info(log, "Frozen layers cannot be fit. Warning will be issued only once per instance", new Object[0]);
            this.logFit = true;
        }
    }

    @Override
    public void update(Gradient gradient) {
        if (!this.logUpdate) {
            OneTimeLogger.info(log, "Frozen layers will not be updated. Warning will be issued only once per instance", new Object[0]);
            this.logUpdate = true;
        }
    }

    @Override
    public void update(INDArray gradient, String paramType) {
        if (!this.logUpdate) {
            OneTimeLogger.info(log, "Frozen layers will not be updated. Warning will be issued only once per instance", new Object[0]);
            this.logUpdate = true;
        }
    }

    @Override
    public double score() {
        return this.insideLayer.score();
    }

    @Override
    public void computeGradientAndScore() {
        if (!this.logGradient) {
            OneTimeLogger.info(log, "Gradients for the frozen layer are not set and will therefore will not be updated.Warning will be issued only once per instance", new Object[0]);
            this.logGradient = true;
        }
        this.insideLayer.score();
    }

    @Override
    public void accumulateScore(double accum) {
        this.insideLayer.accumulateScore(accum);
    }

    @Override
    public INDArray params() {
        return this.insideLayer.params();
    }

    @Override
    public int numParams() {
        return this.insideLayer.numParams();
    }

    @Override
    public int numParams(boolean backwards) {
        return this.insideLayer.numParams(backwards);
    }

    @Override
    public void setParams(INDArray params) {
        this.insideLayer.setParams(params);
    }

    @Override
    public void setParamsViewArray(INDArray params) {
        this.insideLayer.setParamsViewArray(params);
    }

    @Override
    public INDArray getGradientsViewArray() {
        return this.insideLayer.getGradientsViewArray();
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray gradients) {
        if (!this.logGradient) {
            OneTimeLogger.info(log, "Gradients for the frozen layer are not set and will therefore will not be updated.Warning will be issued only once per instance", new Object[0]);
            this.logGradient = true;
        }
    }

    @Override
    public void applyLearningRateScoreDecay() {
        this.insideLayer.applyLearningRateScoreDecay();
    }

    @Override
    public void fit(INDArray data) {
        if (!this.logFit) {
            OneTimeLogger.info(log, "Frozen layers cannot be fit.Warning will be issued only once per instance", new Object[0]);
            this.logFit = true;
        }
    }

    @Override
    public void iterate(INDArray input) {
        this.insideLayer.iterate(input);
    }

    @Override
    public Gradient gradient() {
        return this.zeroGradient;
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        if (!this.logGradient) {
            OneTimeLogger.info(log, "Gradients for the frozen layer are not set and will therefore will not be updated.Warning will be issued only once per instance", new Object[0]);
            this.logGradient = true;
        }
        return new Pair<Gradient, Double>(this.zeroGradient, this.insideLayer.score());
    }

    @Override
    public int batchSize() {
        return this.insideLayer.batchSize();
    }

    @Override
    public NeuralNetConfiguration conf() {
        return this.insideLayer.conf();
    }

    @Override
    public void setConf(NeuralNetConfiguration conf) {
        this.insideLayer.setConf(conf);
    }

    @Override
    public INDArray input() {
        return this.insideLayer.input();
    }

    @Override
    public void validateInput() {
        this.insideLayer.validateInput();
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        return this.insideLayer.getOptimizer();
    }

    @Override
    public INDArray getParam(String param) {
        return this.insideLayer.getParam(param);
    }

    @Override
    public void initParams() {
        this.insideLayer.initParams();
    }

    @Override
    public Map<String, INDArray> paramTable() {
        return this.insideLayer.paramTable();
    }

    @Override
    public Map<String, INDArray> paramTable(boolean backpropParamsOnly) {
        return this.insideLayer.paramTable(backpropParamsOnly);
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        this.insideLayer.setParamTable(paramTable);
    }

    @Override
    public void setParam(String key, INDArray val) {
        this.insideLayer.setParam(key, val);
    }

    @Override
    public void clear() {
        this.insideLayer.clear();
    }

    @Override
    public void init() {
    }

    @Override
    public void setListeners(Collection<IterationListener> listeners) {
        this.insideLayer.setListeners(listeners);
    }

    @Override
    public void setIndex(int index) {
        this.insideLayer.setIndex(index);
    }

    @Override
    public int getIndex() {
        return this.insideLayer.getIndex();
    }

    @Override
    public void setInput(INDArray input) {
        this.insideLayer.setInput(input);
    }

    @Override
    public void setInputMiniBatchSize(int size) {
        this.insideLayer.setInputMiniBatchSize(size);
    }

    @Override
    public int getInputMiniBatchSize() {
        return this.insideLayer.getInputMiniBatchSize();
    }

    @Override
    public void setMaskArray(INDArray maskArray) {
        this.insideLayer.setMaskArray(maskArray);
    }

    @Override
    public INDArray getMaskArray() {
        return this.insideLayer.getMaskArray();
    }

    @Override
    public boolean isPretrainLayer() {
        return this.insideLayer.isPretrainLayer();
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        return this.insideLayer.feedForwardMaskArray(maskArray, currentMaskState, minibatchSize);
    }

    public void logTestMode(boolean training) {
        if (!training) {
            return;
        }
        if (this.logTestMode) {
            return;
        }
        OneTimeLogger.info(log, "Frozen layer instance found! Frozen layers are treated as always in test mode. Warning will only be issued once per instance", new Object[0]);
        this.logTestMode = true;
    }

    public void logTestMode(Layer.TrainingMode training) {
        if (training.equals((Object)Layer.TrainingMode.TEST)) {
            return;
        }
        if (this.logTestMode) {
            return;
        }
        OneTimeLogger.info(log, "Frozen layer instance found! Frozen layers are treated as always in test mode. Warning will only be issued once per instance", new Object[0]);
        this.logTestMode = true;
    }

    public Layer getInsideLayer() {
        return this.insideLayer;
    }
}

