/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.io.Serializable;
import java.util.Collection;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.AutoEncoder;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.Convolution1DLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;
import org.deeplearning4j.nn.conf.layers.EmbeddingLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.conf.layers.LSTM;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;
import org.deeplearning4j.nn.conf.layers.LossLayer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.RBM;
import org.deeplearning4j.nn.conf.layers.RnnOutputLayer;
import org.deeplearning4j.nn.conf.layers.Subsampling1DLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer;
import org.deeplearning4j.nn.conf.layers.misc.FrozenLayer;
import org.deeplearning4j.nn.conf.layers.variational.VariationalAutoencoder;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.shade.jackson.annotation.JsonSubTypes;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AutoEncoder.class, name="autoEncoder"), @JsonSubTypes.Type(value=ConvolutionLayer.class, name="convolution"), @JsonSubTypes.Type(value=Convolution1DLayer.class, name="convolution1d"), @JsonSubTypes.Type(value=GravesLSTM.class, name="gravesLSTM"), @JsonSubTypes.Type(value=LSTM.class, name="LSTM"), @JsonSubTypes.Type(value=GravesBidirectionalLSTM.class, name="gravesBidirectionalLSTM"), @JsonSubTypes.Type(value=OutputLayer.class, name="output"), @JsonSubTypes.Type(value=RnnOutputLayer.class, name="rnnoutput"), @JsonSubTypes.Type(value=LossLayer.class, name="loss"), @JsonSubTypes.Type(value=RBM.class, name="RBM"), @JsonSubTypes.Type(value=DenseLayer.class, name="dense"), @JsonSubTypes.Type(value=SubsamplingLayer.class, name="subsampling"), @JsonSubTypes.Type(value=Subsampling1DLayer.class, name="subsampling1d"), @JsonSubTypes.Type(value=BatchNormalization.class, name="batchNormalization"), @JsonSubTypes.Type(value=LocalResponseNormalization.class, name="localResponseNormalization"), @JsonSubTypes.Type(value=EmbeddingLayer.class, name="embedding"), @JsonSubTypes.Type(value=ActivationLayer.class, name="activation"), @JsonSubTypes.Type(value=VariationalAutoencoder.class, name="VariationalAutoencoder"), @JsonSubTypes.Type(value=DropoutLayer.class, name="dropout"), @JsonSubTypes.Type(value=GlobalPoolingLayer.class, name="GlobalPooling"), @JsonSubTypes.Type(value=ZeroPaddingLayer.class, name="zeroPadding"), @JsonSubTypes.Type(value=FrozenLayer.class, name="FrozenLayer")})
public abstract class Layer
implements Serializable,
Cloneable {
    protected String layerName;
    protected double dropOut;

    public Layer(Builder builder) {
        this.layerName = builder.layerName;
        this.dropOut = builder.dropOut;
    }

    public void resetLayerDefaultConfig() {
        this.setDropOut(Double.NaN);
    }

    public Layer clone() {
        try {
            return (Layer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration var1, Collection<IterationListener> var2, int var3, INDArray var4, boolean var5);

    public abstract ParamInitializer initializer();

    public abstract InputType getOutputType(int var1, InputType var2);

    public abstract void setNIn(InputType var1, boolean var2);

    public abstract InputPreProcessor getPreProcessorForInputType(InputType var1);

    public abstract double getL1ByParam(String var1);

    public abstract double getL2ByParam(String var1);

    public abstract double getLearningRateByParam(String var1);

    public abstract boolean isPretrainParam(String var1);

    @Deprecated
    public Updater getUpdaterByParam(String paramName) {
        throw new UnsupportedOperationException("Not supported: all layers with parameters should override this method");
    }

    public IUpdater getIUpdaterByParam(String paramName) {
        throw new UnsupportedOperationException("Not supported: all layers with parameters should override this method");
    }

    public abstract LayerMemoryReport getMemoryReport(InputType var1);

    public String getLayerName() {
        return this.layerName;
    }

    public double getDropOut() {
        return this.dropOut;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public void setDropOut(double dropOut) {
        this.dropOut = dropOut;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$layerName = this.getLayerName();
        String other$layerName = other.getLayerName();
        if (this$layerName == null ? other$layerName != null : !this$layerName.equals(other$layerName)) {
            return false;
        }
        return Double.compare(this.getDropOut(), other.getDropOut()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Layer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $layerName = this.getLayerName();
        result = result * 59 + ($layerName == null ? 43 : $layerName.hashCode());
        long $dropOut = Double.doubleToLongBits(this.getDropOut());
        result = result * 59 + (int)($dropOut >>> 32 ^ $dropOut);
        return result;
    }

    public String toString() {
        return "Layer(layerName=" + this.getLayerName() + ", dropOut=" + this.getDropOut() + ")";
    }

    public Layer() {
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String layerName = null;
        protected double dropOut = Double.NaN;

        public T name(String layerName) {
            this.layerName = layerName;
            return (T)this;
        }

        public T dropOut(double dropOut) {
            this.dropOut = dropOut;
            return (T)this;
        }

        public abstract <E extends Layer> E build();
    }
}

