/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.saver;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FilenameUtils;
import org.deeplearning4j.earlystopping.EarlyStoppingModelSaver;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.util.ModelSerializer;

public class LocalFileModelSaver
implements EarlyStoppingModelSaver<MultiLayerNetwork> {
    private static final String bestFileName = "bestModel.bin";
    private static final String latestFileName = "latestModel.bin";
    private String directory;
    private Charset encoding;

    public LocalFileModelSaver(String directory) {
        this(directory, Charset.defaultCharset());
    }

    public LocalFileModelSaver(String directory, Charset encoding) {
        this.directory = directory;
        this.encoding = encoding;
        File dir = new File(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    @Override
    public void saveBestModel(MultiLayerNetwork net, double score) throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)bestFileName);
        this.save(net, confOut);
    }

    @Override
    public void saveLatestModel(MultiLayerNetwork net, double score) throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)latestFileName);
        this.save(net, confOut);
    }

    @Override
    public MultiLayerNetwork getBestModel() throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)bestFileName);
        return this.load(confOut);
    }

    @Override
    public MultiLayerNetwork getLatestModel() throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)latestFileName);
        return this.load(confOut);
    }

    private void save(MultiLayerNetwork net, String modelName) throws IOException {
        ModelSerializer.writeModel((Model)net, modelName, true);
    }

    private MultiLayerNetwork load(String modelName) throws IOException {
        MultiLayerNetwork net = ModelSerializer.restoreMultiLayerNetwork(modelName);
        return net;
    }

    public String toString() {
        return "LocalFileModelSaver(dir=" + this.directory + ")";
    }
}

