/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.Map;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.recurrent.BaseRecurrentLayer;
import org.deeplearning4j.nn.layers.recurrent.FwdPassReturn;
import org.deeplearning4j.nn.layers.recurrent.LSTMHelpers;
import org.nd4j.linalg.api.ndarray.INDArray;

public class GravesBidirectionalLSTM
extends BaseRecurrentLayer<org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM> {
    public GravesBidirectionalLSTM(NeuralNetConfiguration conf) {
        super(conf);
    }

    public GravesBidirectionalLSTM(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray activation) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        return this.backpropGradientHelper(epsilon, false, -1);
    }

    @Override
    public Pair<Gradient, INDArray> tbpttBackpropGradient(INDArray epsilon, int tbpttBackwardLength) {
        return this.backpropGradientHelper(epsilon, true, tbpttBackwardLength);
    }

    private Pair<Gradient, INDArray> backpropGradientHelper(INDArray epsilon, boolean truncatedBPTT, int tbpttBackwardLength) {
        if (truncatedBPTT) {
            throw new UnsupportedOperationException("you can not time step a bidirectional RNN, it has to run on a batch of data all at once");
        }
        FwdPassReturn fwdPass = this.activateHelperDirectional(true, null, null, true, true);
        Pair<Gradient, INDArray> forwardsGradient = LSTMHelpers.backpropGradientHelper(this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam("RWF"), this.getParam("WF"), epsilon, truncatedBPTT, tbpttBackwardLength, fwdPass, true, "WF", "RWF", "bF", this.gradientViews, this.maskArray);
        FwdPassReturn backPass = this.activateHelperDirectional(true, null, null, true, false);
        Pair<Gradient, INDArray> backwardsGradient = LSTMHelpers.backpropGradientHelper(this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam("RWB"), this.getParam("WB"), epsilon, truncatedBPTT, tbpttBackwardLength, backPass, false, "WB", "RWB", "bB", this.gradientViews, this.maskArray);
        DefaultGradient combinedGradient = new DefaultGradient();
        for (Map.Entry<String, INDArray> entry : forwardsGradient.getFirst().gradientForVariable().entrySet()) {
            combinedGradient.setGradientFor(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, INDArray> entry : backwardsGradient.getFirst().gradientForVariable().entrySet()) {
            combinedGradient.setGradientFor(entry.getKey(), entry.getValue());
        }
        DefaultGradient correctOrderedGradient = new DefaultGradient();
        for (String key : this.params.keySet()) {
            correctOrderedGradient.setGradientFor(key, combinedGradient.getGradientFor(key));
        }
        INDArray iNDArray = forwardsGradient.getSecond();
        INDArray backwardsEpsilon = backwardsGradient.getSecond();
        INDArray combinedEpsilon = iNDArray.addi(backwardsEpsilon);
        return new Pair<Gradient, INDArray>(correctOrderedGradient, combinedEpsilon);
    }

    @Override
    public INDArray preOutput(INDArray x) {
        return this.activate(x, true);
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        return this.activate(x, training);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input);
        return this.activateOutput(training, false);
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.activateOutput(true, false);
    }

    @Override
    public INDArray activate(boolean training) {
        return this.activateOutput(training, false);
    }

    @Override
    public INDArray activate() {
        return this.activateOutput(false, false);
    }

    private INDArray activateOutput(boolean training, boolean forBackprop) {
        FwdPassReturn forwardsEval = LSTMHelpers.activateHelper(this, this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam("RWF"), this.getParam("WF"), this.getParam("bF"), training, null, null, forBackprop, true, "WF", this.maskArray);
        FwdPassReturn backwardsEval = LSTMHelpers.activateHelper(this, this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam("RWB"), this.getParam("WB"), this.getParam("bB"), training, null, null, forBackprop, false, "WB", this.maskArray);
        INDArray fwdOutput = forwardsEval.fwdPassOutput;
        INDArray backOutput = backwardsEval.fwdPassOutput;
        INDArray totalOutput = fwdOutput.addi(backOutput);
        return totalOutput;
    }

    private FwdPassReturn activateHelperDirectional(boolean training, INDArray prevOutputActivations, INDArray prevMemCellState, boolean forBackprop, boolean forwards) {
        String recurrentKey = "RWF";
        String inputKey = "WF";
        String biasKey = "bF";
        if (!forwards) {
            recurrentKey = "RWB";
            inputKey = "WB";
            biasKey = "bB";
        }
        return LSTMHelpers.activateHelper(this, this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam(recurrentKey), this.getParam(inputKey), this.getParam(biasKey), training, prevOutputActivations, prevMemCellState, forBackprop, forwards, inputKey, this.maskArray);
    }

    @Override
    public INDArray activationMean() {
        return this.activate();
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        if (!this.conf.isUseRegularization()) {
            return 0.0;
        }
        double l2Sum = 0.0;
        for (Map.Entry<String, INDArray> entry : this.paramTable().entrySet()) {
            double l2 = this.conf.getL2ByParam(entry.getKey());
            if (!(l2 > 0.0)) continue;
            double norm2 = this.getParam(entry.getKey()).norm2Number().doubleValue();
            l2Sum += 0.5 * l2 * norm2 * norm2;
        }
        return l2Sum;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        if (!this.conf.isUseRegularization()) {
            return 0.0;
        }
        double l1Sum = 0.0;
        for (Map.Entry<String, INDArray> entry : this.paramTable().entrySet()) {
            double l1 = this.conf.getL1ByParam(entry.getKey());
            if (!(l1 > 0.0)) continue;
            double norm1 = this.getParam(entry.getKey()).norm1Number().doubleValue();
            l1Sum += l1 * norm1;
        }
        return l1Sum;
    }

    @Override
    public INDArray rnnTimeStep(INDArray input) {
        throw new UnsupportedOperationException("you can not time step a bidirectional RNN, it has to run on a batch of data all at once");
    }

    @Override
    public INDArray rnnActivateUsingStoredState(INDArray input, boolean training, boolean storeLastForTBPTT) {
        throw new UnsupportedOperationException("Cannot set stored state: bidirectional RNNs don't have stored state");
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        this.maskArray = maskArray;
        this.maskState = currentMaskState;
        return new Pair<INDArray, MaskState>(maskArray, MaskState.Active);
    }
}

