/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Convolution1DLayer
extends ConvolutionLayer {
    public Convolution1DLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Convolution1DLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        if (epsilon.rank() != 3) {
            throw new DL4JInvalidInputException("Got rank " + epsilon.rank() + " array as epsilon for Convolution1DLayer backprop with shape " + Arrays.toString(epsilon.shape()) + ". Expected rank 3 array with shape [minibatchSize, features, length].");
        }
        epsilon = epsilon.reshape(new int[]{epsilon.size(0), epsilon.size(1), epsilon.size(2), 1});
        INDArray origInput = this.input;
        this.input = this.input.reshape(new int[]{this.input.size(0), this.input.size(1), this.input.size(2), 1});
        Pair<Gradient, INDArray> gradientEpsNext = super.backpropGradient(epsilon);
        INDArray epsNext = gradientEpsNext.getSecond();
        epsNext = epsNext.reshape(new int[]{epsNext.size(0), epsNext.size(1), epsNext.size(2)});
        this.input = origInput;
        return new Pair<Gradient, INDArray>(gradientEpsNext.getFirst(), epsNext);
    }

    @Override
    protected INDArray preOutput4d(boolean training) {
        return super.preOutput(true);
    }

    @Override
    public INDArray preOutput(boolean training) {
        INDArray origInput = this.input;
        this.input = this.input.reshape(new int[]{this.input.size(0), this.input.size(1), this.input.size(2), 1});
        INDArray preOutput = super.preOutput(training);
        this.input = origInput;
        preOutput = preOutput.reshape(new int[]{preOutput.size(0), preOutput.size(1), preOutput.size(2)});
        return preOutput;
    }
}

