/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;

public class PreprocessorVertex
extends GraphVertex {
    private InputPreProcessor preProcessor;
    private InputType outputType;

    public PreprocessorVertex(InputPreProcessor preProcessor) {
        this(preProcessor, null);
    }

    @Deprecated
    public PreprocessorVertex(InputPreProcessor preProcessor, InputType outputType) {
        this.preProcessor = preProcessor;
        this.outputType = outputType;
    }

    @Override
    public GraphVertex clone() {
        return new PreprocessorVertex(this.preProcessor.clone());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PreprocessorVertex)) {
            return false;
        }
        return ((PreprocessorVertex)o).preProcessor.equals(this.preProcessor);
    }

    @Override
    public int hashCode() {
        return this.preProcessor.hashCode();
    }

    @Override
    public int numParams(boolean backprop) {
        return 0;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams) {
        return new org.deeplearning4j.nn.graph.vertex.impl.PreprocessorVertex(graph, name, idx, this.preProcessor);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length != 1) {
            throw new InvalidInputTypeException("Invalid input: Preprocessor vertex expects exactly one input");
        }
        if (this.outputType != null) {
            return this.outputType;
        }
        return this.preProcessor.getOutputType(vertexInputs[0]);
    }

    public PreprocessorVertex() {
    }

    public InputPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public InputType getOutputType() {
        return this.outputType;
    }

    public void setPreProcessor(InputPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public void setOutputType(InputType outputType) {
        this.outputType = outputType;
    }

    public String toString() {
        return "PreprocessorVertex(preProcessor=" + this.getPreProcessor() + ", outputType=" + this.getOutputType() + ")";
    }
}

