/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util.reflections;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.reflections.Configuration;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.reflections.vfs.Vfs;

public class DL4JSubTypesScanner
implements Scanner {
    private final List<String> interfaceNames;
    private final List<String> classNames;
    private Configuration configuration;
    private Multimap<String, String> store;

    public DL4JSubTypesScanner(List<Class<?>> interfaces, List<Class<?>> classes) {
        this.interfaceNames = new ArrayList<String>(interfaces.size());
        for (Class<?> c : interfaces) {
            this.interfaceNames.add(c.getName());
        }
        this.classNames = new ArrayList<String>(classes.size());
        for (Class<?> c : interfaces) {
            this.classNames.add(c.getName());
        }
    }

    public void scan(Object cls) {
        String className = this.configuration.getMetadataAdapter().getClassName(cls);
        String superclass = this.configuration.getMetadataAdapter().getSuperclassName(cls);
        if (!"java.lang.Object".equals(superclass)) {
            this.getStore().put((Object)superclass, (Object)className);
        }
        for (String interfaceName : this.configuration.getMetadataAdapter().getInterfacesNames(cls)) {
            if (!this.interfaceNames.contains(interfaceName)) continue;
            this.getStore().put((Object)interfaceName, (Object)className);
        }
    }

    public boolean acceptsInput(String file) {
        return this.configuration.getMetadataAdapter().acceptsInput(file);
    }

    public Object scan(Vfs.File file, Object classObject) {
        if (classObject == null) {
            try {
                classObject = this.configuration.getMetadataAdapter().getOfCreateClassObject(file);
            }
            catch (Exception e) {
                throw new ReflectionsException("could not create class object from file " + file.getRelativePath());
            }
        }
        this.scan(classObject);
        return classObject;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Multimap<String, String> getStore() {
        return this.store;
    }

    public void setStore(Multimap<String, String> store) {
        this.store = store;
    }

    public Scanner filterResultsBy(Predicate<String> filter) {
        return this;
    }

    public boolean acceptResult(String fqn) {
        return fqn != null && (this.classNames.contains(fqn) || this.interfaceNames.contains(fqn));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DL4JSubTypesScanner)) {
            return false;
        }
        DL4JSubTypesScanner other = (DL4JSubTypesScanner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$interfaceNames = this.interfaceNames;
        List<String> other$interfaceNames = other.interfaceNames;
        if (this$interfaceNames == null ? other$interfaceNames != null : !((Object)this$interfaceNames).equals(other$interfaceNames)) {
            return false;
        }
        List<String> this$classNames = this.classNames;
        List<String> other$classNames = other.classNames;
        if (this$classNames == null ? other$classNames != null : !((Object)this$classNames).equals(other$classNames)) {
            return false;
        }
        Configuration this$configuration = this.configuration;
        Configuration other$configuration = other.configuration;
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        Multimap<String, String> this$store = this.getStore();
        Multimap<String, String> other$store = other.getStore();
        return !(this$store == null ? other$store != null : !this$store.equals(other$store));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DL4JSubTypesScanner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $interfaceNames = this.interfaceNames;
        result = result * 59 + ($interfaceNames == null ? 43 : ((Object)$interfaceNames).hashCode());
        List<String> $classNames = this.classNames;
        result = result * 59 + ($classNames == null ? 43 : ((Object)$classNames).hashCode());
        Configuration $configuration = this.configuration;
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        Multimap<String, String> $store = this.getStore();
        result = result * 59 + ($store == null ? 43 : $store.hashCode());
        return result;
    }
}

