/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import org.deeplearning4j.nn.api.Layer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.impl.transforms.LegacyDropOut;
import org.nd4j.linalg.api.ops.impl.transforms.LegacyDropOutInverted;
import org.nd4j.linalg.api.ops.random.impl.DropOut;
import org.nd4j.linalg.api.ops.random.impl.DropOutInverted;
import org.nd4j.linalg.factory.Nd4j;

public class Dropout {
    private Dropout() {
    }

    public static INDArray applyDropConnect(Layer layer, String variable) {
        INDArray result = layer.getParam(variable).dup();
        if (Nd4j.getRandom().getStatePointer() != null) {
            Nd4j.getExecutioner().exec((RandomOp)new DropOut(result, result, layer.conf().getLayer().getDropOut()));
        } else {
            Nd4j.getExecutioner().exec((Op)new LegacyDropOut(result, result, layer.conf().getLayer().getDropOut()));
        }
        return result;
    }

    public static void applyDropout(INDArray input, double dropout) {
        if (Nd4j.getRandom().getStatePointer() != null) {
            Nd4j.getExecutioner().exec((RandomOp)new DropOutInverted(input, dropout));
        } else {
            Nd4j.getExecutioner().exec((Op)new LegacyDropOutInverted(input, dropout));
        }
    }
}

