/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.multilayer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.berkeley.Triple;
import org.deeplearning4j.datasets.iterator.AsyncDataSetIterator;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.Classifier;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.api.Updater;
import org.deeplearning4j.nn.api.layers.IOutputLayer;
import org.deeplearning4j.nn.api.layers.RecurrentLayer;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.updater.MultiLayerUpdater;
import org.deeplearning4j.nn.updater.UpdaterCreator;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.optimize.Solver;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ModelSerializer;
import org.deeplearning4j.util.MultiLayerUtil;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.heartbeat.Heartbeat;
import org.nd4j.linalg.heartbeat.reports.Environment;
import org.nd4j.linalg.heartbeat.reports.Event;
import org.nd4j.linalg.heartbeat.reports.Task;
import org.nd4j.linalg.heartbeat.utils.EnvironmentUtils;
import org.nd4j.linalg.heartbeat.utils.TaskUtils;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.FeatureUtil;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLayerNetwork
implements Serializable,
Classifier,
Layer {
    private static final Logger log = LoggerFactory.getLogger(MultiLayerNetwork.class);
    protected Layer[] layers;
    protected LinkedHashMap<String, Layer> layerMap = new LinkedHashMap();
    protected INDArray input;
    protected INDArray labels;
    protected boolean initCalled = false;
    private Collection<IterationListener> listeners = new ArrayList<IterationListener>();
    private Collection<TrainingListener> trainingListeners = new ArrayList<TrainingListener>();
    protected NeuralNetConfiguration defaultConfiguration;
    protected MultiLayerConfiguration layerWiseConfigurations;
    protected Gradient gradient;
    protected INDArray epsilon;
    protected double score;
    protected boolean initDone = false;
    protected INDArray flattenedParams;
    protected transient INDArray flattenedGradients;
    protected INDArray mask;
    protected int layerIndex;
    protected transient Solver solver;

    public MultiLayerNetwork(MultiLayerConfiguration conf) {
        this.layerWiseConfigurations = conf;
        this.defaultConfiguration = conf.getConf(0).clone();
    }

    public MultiLayerNetwork(String conf, INDArray params) {
        this(MultiLayerConfiguration.fromJson(conf));
        this.init();
        this.setParameters(params);
    }

    public MultiLayerNetwork(MultiLayerConfiguration conf, INDArray params) {
        this(conf);
        this.init();
        this.setParameters(params);
    }

    protected void intializeConfigurations() {
        if (this.layerWiseConfigurations == null) {
            this.layerWiseConfigurations = new MultiLayerConfiguration.Builder().build();
        }
        if (this.layers == null) {
            this.layers = new Layer[this.getnLayers()];
        }
        if (this.defaultConfiguration == null) {
            this.defaultConfiguration = new NeuralNetConfiguration.Builder().build();
        }
    }

    public void pretrain(DataSetIterator iter) {
        if (!this.layerWiseConfigurations.isPretrain()) {
            return;
        }
        for (int i = 0; i < this.getnLayers(); ++i) {
            INDArray layerInput;
            org.nd4j.linalg.dataset.DataSet next;
            if (i == 0) {
                while (iter.hasNext()) {
                    next = (org.nd4j.linalg.dataset.DataSet)iter.next();
                    if (this.getLayerWiseConfigurations().getInputPreProcess(i) != null) {
                        INDArray features = next.getFeatureMatrix();
                        layerInput = this.getLayerWiseConfigurations().getInputPreProcess(i).preProcess(features, features.size(0));
                    } else {
                        layerInput = next.getFeatureMatrix();
                    }
                    this.setInput(layerInput);
                    if (this.getInput() == null || this.getLayers() == null) {
                        this.initializeLayers(this.input());
                    }
                    this.layers[i].fit(this.input());
                    log.info("Training on layer " + (i + 1) + " with " + this.input().size(0) + " examples");
                }
            } else {
                while (iter.hasNext()) {
                    next = (org.nd4j.linalg.dataset.DataSet)iter.next();
                    layerInput = next.getFeatureMatrix();
                    for (int j = 1; j <= i; ++j) {
                        layerInput = this.activationFromPrevLayer(j - 1, layerInput, true);
                    }
                    log.info("Training on layer " + (i + 1) + " with " + layerInput.size(0) + " examples");
                    this.getLayer(i).fit(layerInput);
                }
            }
            iter.reset();
        }
    }

    public void pretrain(INDArray input) {
        if (!this.layerWiseConfigurations.isPretrain()) {
            return;
        }
        int miniBatchSize = input.size(0);
        INDArray layerInput = null;
        for (int i = 0; i < this.getnLayers() - 1; ++i) {
            layerInput = i == 0 ? (this.getLayerWiseConfigurations().getInputPreProcess(i) != null ? this.getLayerWiseConfigurations().getInputPreProcess(i).preProcess(input, miniBatchSize) : input) : this.activationFromPrevLayer(i - 1, layerInput, true);
            log.info("Training on layer " + (i + 1) + " with " + layerInput.size(0) + " examples");
            this.getLayers()[i].fit(layerInput);
        }
    }

    @Override
    public int batchSize() {
        return this.input.size(0);
    }

    @Override
    public NeuralNetConfiguration conf() {
        return this.defaultConfiguration;
    }

    @Override
    public void setConf(NeuralNetConfiguration conf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray input() {
        return this.input;
    }

    @Override
    public void validateInput() {
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray getParam(String param) {
        int idx = param.indexOf(95);
        if (idx == -1) {
            throw new IllegalStateException("Invalid param key: not have layer separator: \"" + param + "\"");
        }
        int layerIdx = Integer.parseInt(param.substring(0, idx));
        String newKey = param.substring(idx + 1);
        return this.layers[layerIdx].getParam(newKey);
    }

    @Override
    public void initParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, INDArray> paramTable() {
        LinkedHashMap<String, INDArray> allParams = new LinkedHashMap<String, INDArray>();
        for (int i = 0; i < this.layers.length; ++i) {
            Map<String, INDArray> paramMap = this.layers[i].paramTable();
            for (Map.Entry<String, INDArray> entry : paramMap.entrySet()) {
                String newKey = i + "_" + entry.getKey();
                allParams.put(newKey, entry.getValue());
            }
        }
        return allParams;
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParam(String key, INDArray val) {
        int idx = key.indexOf(95);
        if (idx == -1) {
            throw new IllegalStateException("Invalid param key: not have layer separator: \"" + key + "\"");
        }
        int layerIdx = Integer.parseInt(key.substring(0, idx));
        String newKey = key.substring(idx + 1);
        this.layers[layerIdx].setParam(newKey, val);
    }

    public MultiLayerConfiguration getLayerWiseConfigurations() {
        return this.layerWiseConfigurations;
    }

    public void setLayerWiseConfigurations(MultiLayerConfiguration layerWiseConfigurations) {
        this.layerWiseConfigurations = layerWiseConfigurations;
    }

    public void initializeLayers(INDArray input) {
        if (input == null) {
            throw new IllegalArgumentException("Unable to initialize neuralNets with empty input");
        }
        this.input = input;
        this.setInputMiniBatchSize(input.size(0));
        if (!this.initCalled) {
            this.init();
        }
    }

    public void init() {
        this.init(null, false);
    }

    public void init(INDArray parameters, boolean cloneParametersArray) {
        if (this.layerWiseConfigurations == null || this.layers == null) {
            this.intializeConfigurations();
        }
        if (this.initCalled) {
            return;
        }
        int nLayers = this.getnLayers();
        if (nLayers < 1) {
            throw new IllegalStateException("Unable to create network: number of layers is less than 1");
        }
        if (this.layers == null || this.layers[0] == null) {
            boolean initializeParams;
            if (this.layers == null) {
                this.layers = new Layer[nLayers];
            }
            int backpropParamLength = 0;
            int[] nParamsPerLayer = new int[nLayers];
            for (int i = 0; i < nLayers; ++i) {
                NeuralNetConfiguration conf = this.layerWiseConfigurations.getConf(i);
                nParamsPerLayer[i] = conf.getLayer().initializer().numParams(conf, true);
                backpropParamLength += nParamsPerLayer[i];
            }
            if (parameters != null) {
                if (!parameters.isRowVector()) {
                    throw new IllegalArgumentException("Invalid parameters: should be a row vector");
                }
                if (parameters.length() != backpropParamLength) {
                    throw new IllegalArgumentException("Invalid parameters: expected length " + backpropParamLength + ", got length " + parameters.length());
                }
                this.flattenedParams = cloneParametersArray ? parameters.dup() : parameters;
                initializeParams = false;
            } else {
                this.flattenedParams = Nd4j.create((int)1, (int)backpropParamLength);
                initializeParams = true;
            }
            int paramCountSoFar = 0;
            for (int i = 0; i < nLayers; ++i) {
                INDArray paramsView = nParamsPerLayer[i] > 0 ? this.flattenedParams.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)paramCountSoFar, (int)(paramCountSoFar + nParamsPerLayer[i]))}) : null;
                paramCountSoFar += nParamsPerLayer[i];
                NeuralNetConfiguration conf = this.layerWiseConfigurations.getConf(i);
                this.layers[i] = conf.getLayer().instantiate(conf, this.listeners, i, paramsView, initializeParams);
                this.layerMap.put(conf.getLayer().getLayerName(), this.layers[i]);
            }
            this.initCalled = true;
            this.initMask();
        }
        this.defaultConfiguration.clearVariables();
        List<String> variables = this.defaultConfiguration.variables(false);
        for (int i = 0; i < this.layers.length; ++i) {
            for (String s : this.layers[i].conf().variables()) {
                variables.add(i + "_" + s);
            }
        }
    }

    public boolean isInitCalled() {
        return this.initCalled;
    }

    public void initGradientsView() {
        if (this.layers == null) {
            this.init();
        }
        int nLayers = this.layers.length;
        int backpropParamLength = 0;
        int[] nParamsPerLayer = new int[nLayers];
        for (int i = 0; i < nLayers; ++i) {
            NeuralNetConfiguration conf = this.layerWiseConfigurations.getConf(i);
            nParamsPerLayer[i] = this.layers[i].conf().getLayer().initializer().numParams(conf, true);
            backpropParamLength += nParamsPerLayer[i];
        }
        this.flattenedGradients = Nd4j.createUninitialized((int[])new int[]{1, backpropParamLength}, (char)'f');
        int backpropParamsSoFar = 0;
        for (int i = 0; i < this.layers.length; ++i) {
            if (nParamsPerLayer[i] == 0) continue;
            INDArray thisLayerGradView = this.flattenedGradients.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)backpropParamsSoFar, (int)(backpropParamsSoFar + nParamsPerLayer[i]))});
            this.layers[i].setBackpropGradientsViewArray(thisLayerGradView);
            backpropParamsSoFar += nParamsPerLayer[i];
        }
    }

    @Override
    public INDArray activate() {
        return this.getLayers()[this.getLayers().length - 1].activate();
    }

    public INDArray activate(int layer) {
        return this.getLayer(layer).activate();
    }

    @Override
    public INDArray activate(INDArray input) {
        throw new UnsupportedOperationException();
    }

    public INDArray activate(int layer, INDArray input) {
        return this.getLayer(layer).activate(input);
    }

    @Override
    public INDArray activationMean() {
        throw new UnsupportedOperationException();
    }

    public void initialize(org.nd4j.linalg.dataset.DataSet data) {
        this.setInput(data.getFeatureMatrix());
        this.feedForward(this.getInput());
        this.labels = data.getLabels();
        if (this.getOutputLayer() instanceof IOutputLayer) {
            IOutputLayer ol = (IOutputLayer)this.getOutputLayer();
            ol.setLabels(this.labels);
        }
    }

    public INDArray zFromPrevLayer(int curr, INDArray input, boolean training) {
        if (this.getLayerWiseConfigurations().getInputPreProcess(curr) != null) {
            input = this.getLayerWiseConfigurations().getInputPreProcess(curr).preProcess(input, input.size(0));
        }
        INDArray ret = this.layers[curr].preOutput(input, training);
        return ret;
    }

    public INDArray activationFromPrevLayer(int curr, INDArray input, boolean training) {
        if (this.getLayerWiseConfigurations().getInputPreProcess(curr) != null) {
            input = this.getLayerWiseConfigurations().getInputPreProcess(curr).preProcess(input, this.getInputMiniBatchSize());
        }
        INDArray ret = this.layers[curr].activate(input, training);
        return ret;
    }

    public INDArray activateSelectedLayers(int from, int to, INDArray input) {
        if (input == null) {
            throw new IllegalStateException("Unable to perform activation; no input found");
        }
        if (from < 0 || from >= this.layers.length || from >= to) {
            throw new IllegalStateException("Unable to perform activation; FROM is out of layer space");
        }
        if (to < 1 || to >= this.layers.length) {
            throw new IllegalStateException("Unable to perform activation; TO is out of layer space");
        }
        INDArray res = input;
        for (int l = from; l <= to; ++l) {
            res = this.activationFromPrevLayer(l, res, false);
        }
        return res;
    }

    public List<INDArray> computeZ(boolean training) {
        INDArray currInput = this.input;
        ArrayList<INDArray> activations = new ArrayList<INDArray>();
        activations.add(currInput);
        for (int i = 0; i < this.layers.length; ++i) {
            currInput = this.zFromPrevLayer(i, currInput, training);
            activations.add(currInput);
        }
        return activations;
    }

    public List<INDArray> computeZ(INDArray input, boolean training) {
        if (input == null) {
            throw new IllegalStateException("Unable to perform feed forward; no input found");
        }
        if (this.getLayerWiseConfigurations().getInputPreProcess(0) != null) {
            this.setInput(this.getLayerWiseConfigurations().getInputPreProcess(0).preProcess(input, this.getInputMiniBatchSize()));
        } else {
            this.setInput(input);
        }
        return this.computeZ(training);
    }

    public List<INDArray> feedForward(INDArray input, boolean train) {
        this.setInput(input);
        return this.feedForward(train);
    }

    public List<INDArray> feedForward(boolean train) {
        return this.feedForwardToLayer(this.layers.length - 1, train);
    }

    public List<INDArray> feedForwardToLayer(int layerNum, INDArray input) {
        return this.feedForwardToLayer(layerNum, input, false);
    }

    public List<INDArray> feedForwardToLayer(int layerNum, INDArray input, boolean train) {
        this.setInput(input);
        return this.feedForwardToLayer(layerNum, train);
    }

    public List<INDArray> feedForwardToLayer(int layerNum, boolean train) {
        INDArray currInput = this.input;
        ArrayList<INDArray> activations = new ArrayList<INDArray>();
        activations.add(currInput);
        for (int i = 0; i <= layerNum; ++i) {
            currInput = this.activationFromPrevLayer(i, currInput, train);
            activations.add(currInput);
        }
        return activations;
    }

    public List<INDArray> feedForward() {
        return this.feedForward(false);
    }

    public List<INDArray> feedForward(INDArray input) {
        if (input == null) {
            throw new IllegalStateException("Unable to perform feed forward; no input found");
        }
        if (this.getLayerWiseConfigurations().getInputPreProcess(0) != null) {
            this.setInput(this.getLayerWiseConfigurations().getInputPreProcess(0).preProcess(input, input.size(0)));
        } else {
            this.setInput(input);
        }
        return this.feedForward();
    }

    public List<INDArray> feedForward(INDArray input, INDArray featuresMask, INDArray labelsMask) {
        this.setLayerMaskArrays(featuresMask, labelsMask);
        List<INDArray> list = this.feedForward(input);
        this.clearLayerMaskArrays();
        return list;
    }

    @Override
    public Gradient gradient() {
        return this.gradient;
    }

    public INDArray epsilon() {
        return this.epsilon;
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair<Gradient, Double>(this.gradient(), this.score());
    }

    protected List<INDArray> computeDeltasR(INDArray v) {
        int i;
        ArrayList<INDArray> deltaRet = new ArrayList<INDArray>();
        INDArray[] deltas = new INDArray[this.getnLayers() + 1];
        List<INDArray> activations = this.feedForward();
        List<INDArray> rActivations = this.feedForwardR(activations, v);
        ArrayList<INDArray> weights = new ArrayList<INDArray>();
        ArrayList<INDArray> biases = new ArrayList<INDArray>();
        ArrayList<String> activationFunctions = new ArrayList<String>();
        for (int j = 0; j < this.getLayers().length; ++j) {
            weights.add(this.getLayers()[j].getParam("W"));
            biases.add(this.getLayers()[j].getParam("b"));
            activationFunctions.add(this.getLayers()[j].conf().getLayer().getActivationFunction());
        }
        INDArray rix = rActivations.get(rActivations.size() - 1).divi((Number)this.input.size(0));
        LinAlgExceptions.assertValidNum((INDArray)rix);
        for (i = this.getnLayers() - 1; i >= 0; --i) {
            deltas[i] = activations.get(i).transpose().mmul(rix);
            if (i <= 0) continue;
            rix = rix.mmul(((INDArray)weights.get(i)).addRowVector((INDArray)biases.get(i)).transpose()).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform((String)activationFunctions.get(i - 1), activations.get(i)).derivative()));
        }
        for (i = 0; i < deltas.length - 1; ++i) {
            deltaRet.add(deltas[i]);
        }
        return deltaRet;
    }

    protected List<Pair<INDArray, INDArray>> computeDeltas2() {
        int i;
        ArrayList<Pair<INDArray, INDArray>> deltaRet = new ArrayList<Pair<INDArray, INDArray>>();
        List<INDArray> activations = this.feedForward();
        INDArray[] deltas = new INDArray[activations.size() - 1];
        INDArray[] preCons = new INDArray[activations.size() - 1];
        INDArray ix = activations.get(activations.size() - 1).sub(this.labels).div((Number)this.labels.size(0));
        ArrayList<INDArray> weights = new ArrayList<INDArray>();
        ArrayList<INDArray> biases = new ArrayList<INDArray>();
        ArrayList<String> activationFunctions = new ArrayList<String>();
        for (int j = 0; j < this.getLayers().length; ++j) {
            weights.add(this.getLayers()[j].getParam("W"));
            biases.add(this.getLayers()[j].getParam("b"));
            activationFunctions.add(this.getLayers()[j].conf().getLayer().getActivationFunction());
        }
        for (i = weights.size() - 1; i >= 0; --i) {
            deltas[i] = activations.get(i).transpose().mmul(ix);
            preCons[i] = Transforms.pow((INDArray)activations.get(i).transpose(), (Number)2).mmul(Transforms.pow((INDArray)ix, (Number)2)).muli((Number)this.labels.size(0));
            if (i <= 0) continue;
            ix = ix.mmul(((INDArray)weights.get(i)).transpose()).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform((String)activationFunctions.get(i - 1), activations.get(i)).derivative()));
        }
        for (i = 0; i < deltas.length; ++i) {
            deltaRet.add(new Pair<INDArray, INDArray>(deltas[i], preCons[i]));
        }
        return deltaRet;
    }

    @Override
    public MultiLayerNetwork clone() {
        Updater u;
        INDArray updaterState;
        MultiLayerConfiguration conf = this.layerWiseConfigurations.clone();
        MultiLayerNetwork ret = new MultiLayerNetwork(conf);
        ret.init(this.params().dup(), false);
        if (this.solver != null && (updaterState = (u = this.getUpdater()).getStateViewArray()) != null) {
            ret.getUpdater().setStateViewArray(ret, updaterState.dup(), false);
        }
        return ret;
    }

    public INDArray params(boolean backwardOnly) {
        if (backwardOnly) {
            return this.params();
        }
        ArrayList<INDArray> params = new ArrayList<INDArray>();
        for (Layer layer : this.getLayers()) {
            INDArray layerParams = layer.params();
            if (layerParams == null) continue;
            params.add(layerParams);
        }
        return Nd4j.toFlattened((char)'f', params);
    }

    @Override
    public INDArray params() {
        return this.flattenedParams;
    }

    @Override
    public void setParams(INDArray params) {
        if (this.flattenedParams == params) {
            return;
        }
        if (this.flattenedParams != null && params.length() == this.flattenedParams.length()) {
            this.flattenedParams.assign(params);
        } else {
            if (this.flattenedParams == null) {
                this.flattenedParams = params.dup();
            }
            int idx = 0;
            for (int i = 0; i < this.getLayers().length; ++i) {
                Layer layer = this.getLayer(i);
                int range = layer.numParams();
                if (range <= 0) continue;
                INDArray get = params.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)idx, (int)(range + idx))});
                layer.setParams(get);
                idx += range;
            }
        }
    }

    @Override
    public void setParamsViewArray(INDArray params) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray gradients) {
        int paramsSoFar = 0;
        for (Layer layer : this.layers) {
            if (layer.numParams() == 0) continue;
            layer.setBackpropGradientsViewArray(gradients.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)paramsSoFar, (int)(paramsSoFar + layer.numParams()))}));
            paramsSoFar += layer.numParams();
        }
    }

    @Override
    public int numParams() {
        if (this.isInitCalled()) {
            return this.numParams(false);
        }
        log.info("Model is not initialized. Initialize net with init()");
        return 0;
    }

    @Override
    public int numParams(boolean backwards) {
        int length = 0;
        for (int i = 0; i < this.layers.length; ++i) {
            length += this.layers[i].numParams(backwards);
        }
        return length;
    }

    @Deprecated
    public INDArray pack() {
        return this.params();
    }

    @Deprecated
    public INDArray pack(List<Pair<INDArray, INDArray>> layers) {
        ArrayList<INDArray> list = new ArrayList<INDArray>();
        for (Pair<INDArray, INDArray> layer : layers) {
            list.add(layer.getFirst());
            list.add(layer.getSecond());
        }
        return Nd4j.toFlattened(list);
    }

    @Override
    public double f1Score(DataSet data) {
        return this.f1Score(data.getFeatures(), data.getLabels());
    }

    @Deprecated
    public List<Pair<INDArray, INDArray>> unPack(INDArray param) {
        if (param.size(0) != 1) {
            param = param.reshape(1, param.length());
        }
        ArrayList<Pair<INDArray, INDArray>> ret = new ArrayList<Pair<INDArray, INDArray>>();
        int curr = 0;
        for (int i = 0; i < this.layers.length; ++i) {
            int layerLength = this.layers[i].getParam("W").length() + this.layers[i].getParam("b").length();
            INDArray subMatrix = param.get(new INDArrayIndex[]{NDArrayIndex.interval((int)curr, (int)(curr + layerLength))});
            INDArray weightPortion = subMatrix.get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)this.layers[i].getParam("W").length())});
            int beginHBias = this.layers[i].getParam("W").length();
            int endHbias = subMatrix.length();
            INDArray hBiasPortion = subMatrix.get(new INDArrayIndex[]{NDArrayIndex.interval((int)beginHBias, (int)endHbias)});
            int layerLengthSum = weightPortion.length() + hBiasPortion.length();
            if (layerLengthSum != layerLength) {
                if (hBiasPortion.length() != this.layers[i].getParam("b").length()) {
                    throw new IllegalStateException("Hidden bias on layer " + i + " was off");
                }
                if (weightPortion.length() != this.layers[i].getParam("W").length()) {
                    throw new IllegalStateException("Weight portion on layer " + i + " was off");
                }
            }
            ret.add(new Pair<INDArray, INDArray>(weightPortion.reshape(this.layers[i].getParam("W").size(0), this.layers[i].getParam("W").columns()), hBiasPortion.reshape(this.layers[i].getParam("b").size(0), this.layers[i].getParam("b").columns())));
            curr += layerLength;
        }
        return ret;
    }

    @Override
    public void fit(DataSetIterator iterator) {
        DataSetIterator iter = iterator.asyncSupported() ? new AsyncDataSetIterator(iterator, 2) : iterator;
        if (this.trainingListeners.size() > 0) {
            for (TrainingListener tl : this.trainingListeners) {
                tl.onEpochStart(this);
            }
        }
        if (this.layerWiseConfigurations.isPretrain()) {
            this.pretrain(iter);
            if (iter.resetSupported()) {
                iter.reset();
            }
        }
        if (this.layerWiseConfigurations.isBackprop()) {
            org.nd4j.linalg.dataset.DataSet next;
            this.update(TaskUtils.buildTask((DataSetIterator)iter));
            if (!iter.hasNext() && iter.resetSupported()) {
                iter.reset();
            }
            while (iter.hasNext() && (next = (org.nd4j.linalg.dataset.DataSet)iter.next()).getFeatureMatrix() != null && next.getLabels() != null) {
                boolean hasMaskArrays = next.hasMaskArrays();
                if (this.layerWiseConfigurations.getBackpropType() == BackpropType.TruncatedBPTT) {
                    this.doTruncatedBPTT(next.getFeatureMatrix(), next.getLabels(), next.getFeaturesMaskArray(), next.getLabelsMaskArray());
                } else {
                    if (hasMaskArrays) {
                        this.setLayerMaskArrays(next.getFeaturesMaskArray(), next.getLabelsMaskArray());
                    }
                    this.setInput(next.getFeatureMatrix());
                    this.setLabels(next.getLabels());
                    if (this.solver == null) {
                        this.solver = new Solver.Builder().configure(this.conf()).listeners(this.getListeners()).model(this).build();
                    }
                    this.solver.optimize();
                }
                if (!hasMaskArrays) continue;
                this.clearLayerMaskArrays();
            }
        } else if (this.layerWiseConfigurations.isPretrain()) {
            log.warn("Warning: finetune is not applied.");
        }
        if (this.trainingListeners.size() > 0) {
            for (TrainingListener tl : this.trainingListeners) {
                tl.onEpochEnd(this);
            }
        }
    }

    protected void backprop() {
        Pair<Gradient, INDArray> pair = this.calcBackpropGradients(null, true);
        this.gradient = pair == null ? null : pair.getFirst();
        this.epsilon = pair == null ? null : pair.getSecond();
    }

    protected Pair<Gradient, INDArray> calcBackpropGradients(INDArray epsilon, boolean withOutputLayer) {
        int layerFrom;
        String multiGradientKey;
        Pair<Object, INDArray> currPair;
        if (this.flattenedGradients == null) {
            this.initGradientsView();
        }
        DefaultGradient gradient = new DefaultGradient(this.flattenedGradients);
        int numLayers = this.getnLayers();
        LinkedList<Triple> gradientList = new LinkedList<Triple>();
        if (withOutputLayer) {
            if (!(this.getOutputLayer() instanceof IOutputLayer)) {
                log.warn("Warning: final layer isn't output layer. You cannot use backprop without an output layer.");
                return null;
            }
            IOutputLayer outputLayer = (IOutputLayer)this.getOutputLayer();
            if (this.labels == null) {
                throw new IllegalStateException("No labels found");
            }
            outputLayer.setLabels(this.labels);
            currPair = outputLayer.backpropGradient(null);
            for (Map.Entry<String, INDArray> entry : ((Gradient)currPair.getFirst()).gradientForVariable().entrySet()) {
                String string = entry.getKey();
                multiGradientKey = String.valueOf(numLayers - 1) + "_" + string;
                gradientList.addLast(new Triple<String, INDArray, Character>(multiGradientKey, entry.getValue(), ((Gradient)currPair.getFirst()).flatteningOrderForVariable(string)));
            }
            if (this.getLayerWiseConfigurations().getInputPreProcess(numLayers - 1) != null) {
                currPair = new Pair<Object, INDArray>(currPair.getFirst(), this.layerWiseConfigurations.getInputPreProcess(numLayers - 1).backprop(currPair.getSecond(), this.getInputMiniBatchSize()));
            }
            layerFrom = numLayers - 2;
        } else {
            currPair = new Pair<Object, INDArray>(null, epsilon);
            layerFrom = numLayers - 1;
        }
        for (int j = layerFrom; j >= 0; --j) {
            Layer currLayer = this.getLayer(j);
            currPair = currLayer.backpropGradient(currPair.getSecond());
            LinkedList<Triple<String, INDArray, Character>> tempList = new LinkedList<Triple<String, INDArray, Character>>();
            for (Map.Entry<String, INDArray> entry : ((Gradient)currPair.getFirst()).gradientForVariable().entrySet()) {
                String origName = entry.getKey();
                multiGradientKey = String.valueOf(j) + "_" + origName;
                tempList.addFirst(new Triple<String, INDArray, Character>(multiGradientKey, entry.getValue(), ((Gradient)currPair.getFirst()).flatteningOrderForVariable(origName)));
            }
            for (Triple triple : tempList) {
                gradientList.addFirst(triple);
            }
            if (this.getLayerWiseConfigurations().getInputPreProcess(j) == null) continue;
            currPair = new Pair<Object, INDArray>(currPair.getFirst(), this.getLayerWiseConfigurations().getInputPreProcess(j).backprop(currPair.getSecond(), this.getInputMiniBatchSize()));
        }
        for (Triple triple : gradientList) {
            gradient.setGradientFor((String)triple.getFirst(), (INDArray)triple.getSecond(), (Character)triple.getThird());
        }
        return new Pair<Gradient, INDArray>(gradient, currPair.getSecond());
    }

    protected void doTruncatedBPTT(INDArray input, INDArray labels, INDArray featuresMaskArray, INDArray labelsMaskArray) {
        if (input.rank() != 3 || labels.rank() != 3) {
            log.warn("Cannot do truncated BPTT with non-3d inputs or labels. Expect input with shape [miniBatchSize,nIn,timeSeriesLength], got " + Arrays.toString(input.shape()) + "\t" + Arrays.toString(labels.shape()));
            return;
        }
        if (input.size(2) != labels.size(2)) {
            log.warn("Input and label time series have different lengths: {} input length, {} label length", (Object)input.size(2), (Object)labels.size(2));
            return;
        }
        int fwdLen = this.layerWiseConfigurations.getTbpttFwdLength();
        this.update(TaskUtils.buildTask((INDArray)input, (INDArray)labels));
        int timeSeriesLength = input.size(2);
        int nSubsets = timeSeriesLength / fwdLen;
        if (timeSeriesLength % fwdLen != 0) {
            ++nSubsets;
        }
        this.rnnClearPreviousState();
        for (int i = 0; i < nSubsets; ++i) {
            int startTimeIdx = i * fwdLen;
            int endTimeIdx = startTimeIdx + fwdLen;
            if (endTimeIdx > timeSeriesLength) {
                endTimeIdx = timeSeriesLength;
            }
            INDArray inputSubset = input.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((int)startTimeIdx, (int)endTimeIdx)});
            INDArray labelSubset = labels.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((int)startTimeIdx, (int)endTimeIdx)});
            this.setInput(inputSubset);
            this.setLabels(labelSubset);
            INDArray featuresMaskSubset = null;
            INDArray labelsMaskSubset = null;
            if (featuresMaskArray != null) {
                featuresMaskSubset = featuresMaskArray.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)startTimeIdx, (int)endTimeIdx)});
            }
            if (labelsMaskArray != null) {
                labelsMaskSubset = labelsMaskArray.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)startTimeIdx, (int)endTimeIdx)});
            }
            if (featuresMaskSubset != null || labelsMaskSubset != null) {
                this.setLayerMaskArrays(featuresMaskSubset, labelsMaskSubset);
            }
            if (this.solver == null) {
                this.solver = new Solver.Builder().configure(this.conf()).listeners(this.getListeners()).model(this).build();
            }
            this.solver.optimize();
            this.updateRnnStateWithTBPTTState();
        }
        this.rnnClearPreviousState();
        if (featuresMaskArray != null || labelsMaskArray != null) {
            this.clearLayerMaskArrays();
        }
    }

    public void updateRnnStateWithTBPTTState() {
        for (int i = 0; i < this.layers.length; ++i) {
            if (this.layers[i] instanceof RecurrentLayer) {
                RecurrentLayer l = (RecurrentLayer)this.layers[i];
                l.rnnSetPreviousState(l.rnnGetTBPTTState());
                continue;
            }
            if (!(this.layers[i] instanceof MultiLayerNetwork)) continue;
            ((MultiLayerNetwork)this.layers[i]).updateRnnStateWithTBPTTState();
        }
    }

    protected void truncatedBPTTGradient() {
        String multiGradientKey;
        if (this.flattenedGradients == null) {
            this.initGradientsView();
        }
        this.gradient = new DefaultGradient();
        if (!(this.getOutputLayer() instanceof IOutputLayer)) {
            log.warn("Warning: final layer isn't output layer. You cannot use backprop (truncated BPTT) without an output layer.");
            return;
        }
        IOutputLayer outputLayer = (IOutputLayer)this.getOutputLayer();
        if (this.labels == null) {
            throw new IllegalStateException("No labels found");
        }
        if (outputLayer.conf().getLayer().getWeightInit() == WeightInit.ZERO) {
            throw new IllegalStateException("Output layer weights cannot be initialized to zero when using backprop.");
        }
        outputLayer.setLabels(this.labels);
        int numLayers = this.getnLayers();
        LinkedList<Pair> gradientList = new LinkedList<Pair>();
        Pair<Gradient, INDArray> currPair = outputLayer.backpropGradient(null);
        for (Map.Entry<String, INDArray> entry : currPair.getFirst().gradientForVariable().entrySet()) {
            multiGradientKey = String.valueOf(numLayers - 1) + "_" + entry.getKey();
            gradientList.addLast(new Pair<String, INDArray>(multiGradientKey, entry.getValue()));
        }
        if (this.getLayerWiseConfigurations().getInputPreProcess(numLayers - 1) != null) {
            currPair = new Pair<Gradient, INDArray>(currPair.getFirst(), this.layerWiseConfigurations.getInputPreProcess(numLayers - 1).backprop(currPair.getSecond(), this.getInputMiniBatchSize()));
        }
        for (int j = numLayers - 2; j >= 0; --j) {
            Layer currLayer = this.getLayer(j);
            currPair = currLayer instanceof RecurrentLayer ? ((RecurrentLayer)currLayer).tbpttBackpropGradient(currPair.getSecond(), this.layerWiseConfigurations.getTbpttBackLength()) : currLayer.backpropGradient(currPair.getSecond());
            LinkedList<Pair<String, INDArray>> tempList = new LinkedList<Pair<String, INDArray>>();
            for (Map.Entry<String, INDArray> entry : currPair.getFirst().gradientForVariable().entrySet()) {
                multiGradientKey = String.valueOf(j) + "_" + entry.getKey();
                tempList.addFirst(new Pair<String, INDArray>(multiGradientKey, entry.getValue()));
            }
            for (Pair pair : tempList) {
                gradientList.addFirst(pair);
            }
            if (this.getLayerWiseConfigurations().getInputPreProcess(j) == null) continue;
            currPair = new Pair<Gradient, INDArray>(currPair.getFirst(), this.getLayerWiseConfigurations().getInputPreProcess(j).backprop(currPair.getSecond(), this.getInputMiniBatchSize()));
        }
        for (Pair pair : gradientList) {
            this.gradient.setGradientFor((String)pair.getFirst(), (INDArray)pair.getSecond());
        }
    }

    @Override
    public Collection<IterationListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void setListeners(Collection<IterationListener> listeners) {
        this.listeners = listeners;
        if (this.layers == null) {
            this.init();
        }
        for (Layer layer : this.layers) {
            layer.setListeners(listeners);
        }
        if (this.solver != null) {
            this.solver.setListeners(listeners);
        }
        this.trainingListeners.clear();
        if (listeners != null) {
            for (IterationListener il : listeners) {
                if (!(il instanceof TrainingListener)) continue;
                this.trainingListeners.add((TrainingListener)il);
            }
        }
    }

    @Override
    public void setListeners(IterationListener ... listeners) {
        ArrayList<IterationListener> cListeners = new ArrayList<IterationListener>();
        if (listeners != null && listeners.length > 0) {
            for (IterationListener i : listeners) {
                if (i == null) continue;
                cListeners.add(i);
            }
        }
        this.setListeners(cListeners);
    }

    @Deprecated
    public void finetune() {
        if (!this.layerWiseConfigurations.isBackprop()) {
            log.warn("Warning: finetune is not applied.");
            return;
        }
        if (!(this.getOutputLayer() instanceof IOutputLayer)) {
            log.warn("Output layer not instance of output layer returning.");
            return;
        }
        if (this.flattenedGradients == null) {
            this.initGradientsView();
        }
        if (this.labels == null) {
            throw new IllegalStateException("No labels found");
        }
        log.info("Finetune phase");
        IOutputLayer output = (IOutputLayer)this.getOutputLayer();
        if (output.conf().getOptimizationAlgo() == OptimizationAlgorithm.HESSIAN_FREE) {
            throw new UnsupportedOperationException();
        }
        this.feedForward();
        output.fit(output.input(), this.labels);
    }

    @Override
    public int[] predict(INDArray d) {
        INDArray output = this.output(d, Layer.TrainingMode.TEST);
        int[] ret = new int[d.size(0)];
        if (d.isRowVector()) {
            ret[0] = Nd4j.getBlasWrapper().iamax(output);
        } else {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = Nd4j.getBlasWrapper().iamax(output.getRow(i));
            }
        }
        return ret;
    }

    @Override
    public List<String> predict(DataSet dataSet) {
        int[] intRet = this.predict(dataSet.getFeatures());
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < intRet.length; ++i) {
            ret.add(i, dataSet.getLabelName(intRet[i]));
        }
        return ret;
    }

    @Override
    public INDArray labelProbabilities(INDArray examples) {
        List<INDArray> feed = this.feedForward(examples);
        IOutputLayer o = (IOutputLayer)this.getOutputLayer();
        return o.labelProbabilities(feed.get(feed.size() - 1));
    }

    @Override
    public void fit(INDArray data, INDArray labels) {
        this.fit(data, labels, null, null);
    }

    public void fit(INDArray features, INDArray labels, INDArray featuresMask, INDArray labelsMask) {
        this.setInput(features);
        this.setLabels(labels);
        if (featuresMask != null || labelsMask != null) {
            this.setLayerMaskArrays(featuresMask, labelsMask);
        }
        this.update(TaskUtils.buildTask((INDArray)features, (INDArray)labels));
        if (this.layerWiseConfigurations.isPretrain()) {
            this.pretrain(features);
        }
        if (this.layerWiseConfigurations.isBackprop()) {
            if (this.layerWiseConfigurations.getBackpropType() == BackpropType.TruncatedBPTT) {
                this.doTruncatedBPTT(features, labels, featuresMask, labelsMask);
            } else {
                if (this.solver == null) {
                    this.solver = new Solver.Builder().configure(this.conf()).listeners(this.getListeners()).model(this).build();
                }
                this.solver.optimize();
            }
        }
        if (featuresMask != null || labelsMask != null) {
            this.clearLayerMaskArrays();
        }
    }

    @Override
    public void fit(INDArray data) {
        this.setInput(data);
        this.update(TaskUtils.buildTask((INDArray)data));
        this.pretrain(data);
    }

    @Override
    public void iterate(INDArray input) {
        this.pretrain(input);
    }

    @Override
    public void fit(DataSet data) {
        if (this.layerWiseConfigurations.getBackpropType() == BackpropType.TruncatedBPTT) {
            this.doTruncatedBPTT(data.getFeatures(), data.getLabels(), data.getFeaturesMaskArray(), data.getLabelsMaskArray());
        } else {
            boolean hasMaskArrays = data.hasMaskArrays();
            if (hasMaskArrays) {
                this.setLayerMaskArrays(data.getFeaturesMaskArray(), data.getLabelsMaskArray());
            }
            this.fit(data.getFeatures(), data.getLabels());
            if (hasMaskArrays) {
                this.clearLayerMaskArrays();
            }
        }
    }

    @Override
    public void fit(INDArray examples, int[] labels) {
        OutputLayer layerConf = (OutputLayer)this.getOutputLayer().conf().getLayer();
        this.fit(examples, FeatureUtil.toOutcomeMatrix((int[])labels, (int)layerConf.getNOut()));
    }

    public INDArray output(INDArray input, Layer.TrainingMode train) {
        return this.output(input, train == Layer.TrainingMode.TRAIN);
    }

    public INDArray output(INDArray input, boolean train) {
        List<INDArray> activations = this.feedForward(input, train);
        return activations.get(activations.size() - 1);
    }

    public INDArray output(INDArray input, boolean train, INDArray featuresMask, INDArray labelsMask) {
        this.setLayerMaskArrays(featuresMask, labelsMask);
        INDArray out = this.output(input, train);
        this.clearLayerMaskArrays();
        return out;
    }

    public INDArray output(INDArray input) {
        return this.output(input, Layer.TrainingMode.TRAIN);
    }

    public INDArray output(DataSetIterator iterator, boolean train) {
        org.nd4j.linalg.dataset.DataSet next;
        ArrayList<INDArray> outList = new ArrayList<INDArray>();
        while (iterator.hasNext() && (next = (org.nd4j.linalg.dataset.DataSet)iterator.next()).getFeatureMatrix() != null && next.getLabels() != null) {
            INDArray features = next.getFeatures();
            if (next.hasMaskArrays()) {
                INDArray fMask = next.getFeaturesMaskArray();
                INDArray lMask = next.getLabelsMaskArray();
                outList.add(this.output(features, train, fMask, lMask));
                continue;
            }
            outList.add(this.output(features, train));
        }
        return Nd4j.vstack((INDArray[])outList.toArray(new INDArray[0]));
    }

    public INDArray output(DataSetIterator iterator) {
        return this.output(iterator, false);
    }

    public INDArray reconstruct(INDArray x, int layerNum) {
        List<INDArray> forward = this.feedForward(x);
        return forward.get(layerNum - 1);
    }

    public void printConfiguration() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (NeuralNetConfiguration conf : this.getLayerWiseConfigurations().getConfs()) {
            sb.append(" Layer " + count++ + " conf " + conf);
        }
        log.info(sb.toString());
    }

    public void update(MultiLayerNetwork network) {
        NeuralNetConfiguration neuralNetConfiguration = this.defaultConfiguration = network.defaultConfiguration != null ? network.defaultConfiguration.clone() : null;
        if (network.input != null) {
            this.setInput(network.input.dup());
        }
        this.labels = network.labels;
        if (network.layers != null) {
            this.layers = new Layer[network.layers.length];
            for (int i = 0; i < this.layers.length; ++i) {
                this.layers[i] = network.layers[i].clone();
            }
        } else {
            this.layers = null;
        }
        if (network.solver != null) {
            INDArray updaterView = network.getUpdater().getStateViewArray();
            if (updaterView != null) {
                MultiLayerUpdater newUpdater = new MultiLayerUpdater(this, updaterView.dup());
                this.setUpdater(newUpdater);
            }
        } else {
            this.solver = null;
        }
    }

    @Override
    public double f1Score(INDArray input, INDArray labels) {
        this.feedForward(input);
        this.setLabels(labels);
        Evaluation eval = new Evaluation();
        eval.eval(labels, this.labelProbabilities(input));
        return eval.f1();
    }

    @Override
    public int numLabels() {
        return this.labels.columns();
    }

    public double score(org.nd4j.linalg.dataset.DataSet data) {
        return this.score(data, false);
    }

    public double score(org.nd4j.linalg.dataset.DataSet data, boolean training) {
        INDArray olInput;
        IOutputLayer ol;
        boolean hasMaskArray = data.hasMaskArrays();
        if (hasMaskArray) {
            this.setLayerMaskArrays(data.getFeaturesMaskArray(), data.getLabelsMaskArray());
        }
        List<INDArray> activations = this.feedForwardToLayer(this.layers.length - 2, data.getFeatureMatrix(), training);
        int n = activations.size();
        this.setLabels(data.getLabels());
        if (this.getOutputLayer() instanceof IOutputLayer) {
            ol = (IOutputLayer)this.getOutputLayer();
            olInput = activations.get(n - 1);
            if (this.getLayerWiseConfigurations().getInputPreProcess(n - 1) != null) {
                olInput = this.getLayerWiseConfigurations().getInputPreProcess(n - 1).preProcess(olInput, this.input.size(0));
            }
        } else {
            log.warn("Cannot calculate score wrt labels without an OutputLayer");
            return 0.0;
        }
        ol.setInput(olInput);
        ol.setLabels(data.getLabels());
        ol.computeScore(this.calcL1(), this.calcL2(), training);
        this.score = ol.score();
        if (hasMaskArray) {
            this.clearLayerMaskArrays();
        }
        return this.score();
    }

    public INDArray scoreExamples(DataSetIterator iter, boolean addRegularizationTerms) {
        ArrayList<INDArray> out = new ArrayList<INDArray>();
        while (iter.hasNext()) {
            out.add(this.scoreExamples((org.nd4j.linalg.dataset.DataSet)iter.next(), addRegularizationTerms));
        }
        return Nd4j.toFlattened((char)'f', out);
    }

    public INDArray scoreExamples(org.nd4j.linalg.dataset.DataSet data, boolean addRegularizationTerms) {
        boolean hasMaskArray = data.hasMaskArrays();
        if (hasMaskArray) {
            this.setLayerMaskArrays(data.getFeaturesMaskArray(), data.getLabelsMaskArray());
        }
        this.feedForward(data.getFeatureMatrix(), false);
        this.setLabels(data.getLabels());
        if (!(this.getOutputLayer() instanceof IOutputLayer)) {
            throw new UnsupportedOperationException("Cannot calculate score with respect to labels without an OutputLayer");
        }
        IOutputLayer ol = (IOutputLayer)this.getOutputLayer();
        ol.setLabels(data.getLabels());
        double l1 = addRegularizationTerms ? this.calcL1() : 0.0;
        double l2 = addRegularizationTerms ? this.calcL2() : 0.0;
        INDArray out = ol.computeScoreForExamples(l1, l2);
        if (hasMaskArray) {
            this.clearLayerMaskArrays();
        }
        return out;
    }

    @Override
    public void fit() {
        this.fit(this.input, this.labels);
    }

    @Override
    public void update(INDArray gradient, String paramType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public double score() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public void computeGradientAndScore() {
        List<INDArray> activations;
        if (this.layerWiseConfigurations.getBackpropType() == BackpropType.TruncatedBPTT) {
            activations = this.rnnActivateUsingStoredState(this.getInput(), true, true);
            if (this.trainingListeners.size() > 0) {
                for (TrainingListener tl : this.trainingListeners) {
                    tl.onForwardPass((Model)this, activations);
                }
            }
            this.truncatedBPTTGradient();
        } else {
            activations = this.feedForwardToLayer(this.layers.length - 2, true);
            if (this.trainingListeners.size() > 0) {
                for (TrainingListener tl : this.trainingListeners) {
                    tl.onForwardPass((Model)this, activations);
                }
            }
            INDArray actSecondLastLayer = activations.get(activations.size() - 1);
            if (this.layerWiseConfigurations.getInputPreProcess(this.layers.length - 1) != null) {
                actSecondLastLayer = this.layerWiseConfigurations.getInputPreProcess(this.layers.length - 1).preProcess(actSecondLastLayer, this.getInputMiniBatchSize());
            }
            this.getOutputLayer().setInput(actSecondLastLayer);
            this.backprop();
        }
        if (!(this.getOutputLayer() instanceof IOutputLayer)) {
            throw new IllegalStateException("Cannot calculate gradient and score with respect to labels: final layer is not an IOutputLayer");
        }
        this.score = ((IOutputLayer)this.getOutputLayer()).computeScore(this.calcL1(), this.calcL2(), true);
        if (this.trainingListeners.size() > 0) {
            for (TrainingListener tl : this.trainingListeners) {
                tl.onBackwardPass(this);
            }
        }
    }

    @Override
    public void accumulateScore(double accum) {
    }

    @Override
    public void clear() {
        for (Layer layer : this.layers) {
            layer.clear();
        }
        this.input = null;
        this.labels = null;
        this.solver = null;
    }

    @Override
    public void merge(Layer layer, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public void merge(MultiLayerNetwork network, int batchSize) {
        if (network.layers.length != this.layers.length) {
            throw new IllegalArgumentException("Unable to merge networks that are not of equal length");
        }
        for (int i = 0; i < this.getnLayers(); ++i) {
            Layer n = this.layers[i];
            Layer otherNetwork = network.layers[i];
            n.merge(otherNetwork, batchSize);
        }
        this.getOutputLayer().merge(network.getOutputLayer(), batchSize);
    }

    @Override
    public void setInput(INDArray input) {
        this.input = input;
        if (this.layers == null) {
            this.initializeLayers(this.getInput());
        }
        if (input != null) {
            if (input.length() == 0) {
                throw new IllegalArgumentException("Invalid input: length 0 (shape: " + Arrays.toString(input.shape()) + ")");
            }
            this.setInputMiniBatchSize(input.size(0));
        }
    }

    private void initMask() {
        this.setMask(Nd4j.ones((int)1, (int)this.pack().length()));
    }

    public Layer getOutputLayer() {
        return this.getLayers()[this.getLayers().length - 1];
    }

    public void setParameters(INDArray params) {
        this.setParams(params);
    }

    @Override
    public void applyLearningRateScoreDecay() {
        for (Layer layer : this.layers) {
            if (layer.conf().getLearningRateByParam().isEmpty()) continue;
            for (Map.Entry<String, Double> lrPair : layer.conf().getLearningRateByParam().entrySet()) {
                layer.conf().setLearningRateByParam(lrPair.getKey(), lrPair.getValue() * (layer.conf().getLrPolicyDecayRate() + Nd4j.EPS_THRESHOLD));
            }
        }
    }

    public List<INDArray> feedForwardR(List<INDArray> acts, INDArray v) {
        ArrayList<INDArray> R = new ArrayList<INDArray>();
        R.add(Nd4j.zeros((int)this.input.size(0), (int)this.input.columns()));
        List<Pair<INDArray, INDArray>> vWvB = this.unPack(v);
        List<INDArray> W = MultiLayerUtil.weightMatrices(this);
        for (int i = 0; i < this.layers.length; ++i) {
            String derivative = this.getLayers()[i].conf().getLayer().getActivationFunction();
            R.add(((INDArray)R.get(i)).mmul(W.get(i)).addi(acts.get(i).mmul(vWvB.get(i).getFirst().addiRowVector(vWvB.get(i).getSecond()))).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(derivative, acts.get(i + 1)).derivative())));
        }
        return R;
    }

    public NeuralNetConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public INDArray getLabels() {
        return this.labels;
    }

    public INDArray getInput() {
        return this.input;
    }

    public void setLabels(INDArray labels) {
        this.labels = labels;
    }

    public int getnLayers() {
        return this.layerWiseConfigurations.getConfs().size();
    }

    public Layer[] getLayers() {
        return this.layers;
    }

    public Layer getLayer(int i) {
        return this.layers[i];
    }

    public Layer getLayer(String name) {
        return this.layerMap.get(name);
    }

    public List<String> getLayerNames() {
        return new ArrayList<String>(this.layerMap.keySet());
    }

    public void setLayers(Layer[] layers) {
        this.layers = layers;
    }

    public INDArray getMask() {
        return this.mask;
    }

    public void setMask(INDArray mask) {
        this.mask = mask;
    }

    @Override
    public INDArray getMaskArray() {
        return this.mask;
    }

    @Override
    public Gradient error(INDArray errorSignal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.MULTILAYER;
    }

    @Override
    public INDArray derivativeActivation(INDArray input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray activation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray preOutput(INDArray x) {
        INDArray lastLayerActivation = x;
        for (int i = 0; i < this.layers.length - 1; ++i) {
            if (this.getLayerWiseConfigurations().getInputPreProcess(i) != null) {
                lastLayerActivation = this.getLayerWiseConfigurations().getInputPreProcess(i).preProcess(lastLayerActivation, this.getInputMiniBatchSize());
            }
            lastLayerActivation = this.layers[i].activate(lastLayerActivation);
        }
        if (this.getLayerWiseConfigurations().getInputPreProcess(this.layers.length - 1) != null) {
            lastLayerActivation = this.getLayerWiseConfigurations().getInputPreProcess(this.layers.length - 1).preProcess(lastLayerActivation, this.getInputMiniBatchSize());
        }
        return this.layers[this.layers.length - 1].preOutput(lastLayerActivation);
    }

    @Override
    public INDArray preOutput(INDArray x, Layer.TrainingMode training) {
        return this.preOutput(x, training == Layer.TrainingMode.TRAIN);
    }

    @Override
    public INDArray activate(Layer.TrainingMode training) {
        return this.activate(training == Layer.TrainingMode.TRAIN);
    }

    @Override
    public INDArray activate(INDArray input, Layer.TrainingMode training) {
        return this.activate(input, training == Layer.TrainingMode.TRAIN);
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        if (this.getOutputLayer() instanceof IOutputLayer) {
            throw new UnsupportedOperationException("Cannot calculate gradients based on epsilon with OutputLayer");
        }
        return this.calcBackpropGradients(epsilon, false);
    }

    @Override
    public void setIndex(int index) {
        this.layerIndex = index;
    }

    @Override
    public int getIndex() {
        return this.layerIndex;
    }

    @Override
    public double calcL2() {
        double l2 = 0.0;
        for (int i = 0; i < this.layers.length; ++i) {
            l2 += this.layers[i].calcL2();
        }
        return l2;
    }

    @Override
    public double calcL1() {
        double l1 = 0.0;
        for (int i = 0; i < this.layers.length; ++i) {
            l1 += this.layers[i].calcL1();
        }
        return l1;
    }

    @Override
    public void update(Gradient gradient) {
        if (gradient.gradient().length() != this.numParams(true)) {
            throw new IllegalArgumentException("Invalid input: expect gradients array of length " + this.numParams(true));
        }
        for (Map.Entry<String, INDArray> entry : gradient.gradientForVariable().entrySet()) {
            String key = entry.getKey();
            INDArray val = entry.getValue();
            int idx = key.indexOf(95);
            if (idx == -1) {
                throw new IllegalStateException("Invalid param key: not have layer separator: \"" + key + "\"");
            }
            Integer layerId = Integer.parseInt(key.substring(0, idx));
            String paramType = key.substring(idx + 1);
            this.gradient.gradientForVariable().put(key, val);
            this.layers[layerId].update(val, paramType);
        }
        this.setBackpropGradientsViewArray(gradient.gradient());
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray activate(boolean training) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInputMiniBatchSize(int size) {
        if (this.layers != null) {
            for (Layer l : this.layers) {
                l.setInputMiniBatchSize(size);
            }
        }
    }

    @Override
    public int getInputMiniBatchSize() {
        return this.input.size(0);
    }

    @Override
    public void setMaskArray(INDArray maskArray) {
        throw new UnsupportedOperationException();
    }

    public INDArray rnnTimeStep(INDArray input) {
        this.setInputMiniBatchSize(input.size(0));
        this.input = input;
        boolean inputIs2d = input.rank() == 2;
        for (int i = 0; i < this.layers.length; ++i) {
            if (this.getLayerWiseConfigurations().getInputPreProcess(i) != null) {
                input = this.getLayerWiseConfigurations().getInputPreProcess(i).preProcess(input, this.getInputMiniBatchSize());
            }
            input = this.layers[i] instanceof RecurrentLayer ? ((RecurrentLayer)this.layers[i]).rnnTimeStep(input) : (this.layers[i] instanceof MultiLayerNetwork ? ((MultiLayerNetwork)this.layers[i]).rnnTimeStep(input) : this.layers[i].activate(input, false));
        }
        if (inputIs2d && input.rank() == 3 && this.layers[this.layers.length - 1].type() == Layer.Type.RECURRENT) {
            return input.tensorAlongDimension(0, new int[]{1, 0});
        }
        this.input = null;
        return input;
    }

    public Map<String, INDArray> rnnGetPreviousState(int layer) {
        if (layer < 0 || layer >= this.layers.length) {
            throw new IllegalArgumentException("Invalid layer number");
        }
        if (!(this.layers[layer] instanceof RecurrentLayer)) {
            throw new IllegalArgumentException("Layer is not an RNN layer");
        }
        return ((RecurrentLayer)this.layers[layer]).rnnGetPreviousState();
    }

    public void rnnSetPreviousState(int layer, Map<String, INDArray> state) {
        if (layer < 0 || layer >= this.layers.length) {
            throw new IllegalArgumentException("Invalid layer number");
        }
        if (!(this.layers[layer] instanceof RecurrentLayer)) {
            throw new IllegalArgumentException("Layer is not an RNN layer");
        }
        RecurrentLayer r = (RecurrentLayer)this.layers[layer];
        r.rnnSetPreviousState(state);
    }

    public void rnnClearPreviousState() {
        if (this.layers == null) {
            return;
        }
        for (int i = 0; i < this.layers.length; ++i) {
            if (this.layers[i] instanceof RecurrentLayer) {
                ((RecurrentLayer)this.layers[i]).rnnClearPreviousState();
                continue;
            }
            if (!(this.layers[i] instanceof MultiLayerNetwork)) continue;
            ((MultiLayerNetwork)this.layers[i]).rnnClearPreviousState();
        }
    }

    public List<INDArray> rnnActivateUsingStoredState(INDArray input, boolean training, boolean storeLastForTBPTT) {
        INDArray currInput = input;
        ArrayList<INDArray> activations = new ArrayList<INDArray>();
        activations.add(currInput);
        for (int i = 0; i < this.layers.length; ++i) {
            if (this.getLayerWiseConfigurations().getInputPreProcess(i) != null) {
                currInput = this.getLayerWiseConfigurations().getInputPreProcess(i).preProcess(currInput, input.size(0));
            }
            if (this.layers[i] instanceof RecurrentLayer) {
                currInput = ((RecurrentLayer)this.layers[i]).rnnActivateUsingStoredState(currInput, training, storeLastForTBPTT);
            } else if (this.layers[i] instanceof MultiLayerNetwork) {
                List<INDArray> temp = ((MultiLayerNetwork)this.layers[i]).rnnActivateUsingStoredState(currInput, training, storeLastForTBPTT);
                currInput = temp.get(temp.size() - 1);
            } else {
                currInput = this.layers[i].activate(currInput, training);
            }
            activations.add(currInput);
        }
        return activations;
    }

    public synchronized Updater getUpdater() {
        if (this.solver == null) {
            this.solver = new Solver.Builder().configure(this.conf()).listeners(this.getListeners()).model(this).build();
            this.solver.getOptimizer().setUpdater(UpdaterCreator.getUpdater(this));
        }
        return this.solver.getOptimizer().getUpdater();
    }

    public void setUpdater(Updater updater) {
        if (this.solver == null) {
            this.solver = new Solver.Builder().configure(this.conf()).listeners(this.getListeners()).model(this).build();
        }
        this.solver.getOptimizer().setUpdater(updater);
    }

    public void setLayerMaskArrays(INDArray featuresMaskArray, INDArray labelsMaskArray) {
        if (featuresMaskArray != null) {
            INDArray reshapedFeaturesMask = TimeSeriesUtils.reshapeTimeSeriesMaskToVector(featuresMaskArray);
            for (int i = 0; i < this.layers.length - 1; ++i) {
                Layer.Type t = this.layers[i].type();
                if (t == Layer.Type.CONVOLUTIONAL || t == Layer.Type.FEED_FORWARD) {
                    this.layers[i].setMaskArray(reshapedFeaturesMask);
                    continue;
                }
                if (t == Layer.Type.RECURRENT) break;
            }
        }
        if (labelsMaskArray != null) {
            if (!(this.getOutputLayer() instanceof IOutputLayer)) {
                return;
            }
            this.layers[this.layers.length - 1].setMaskArray(labelsMaskArray);
        }
    }

    public void clearLayerMaskArrays() {
        for (Layer layer : this.layers) {
            layer.setMaskArray(null);
        }
    }

    public Evaluation evaluate(DataSetIterator iterator) {
        return this.evaluate(iterator, null);
    }

    public Evaluation evaluate(DataSetIterator iterator, List<String> labelsList) {
        return this.evaluate(iterator, labelsList, 1);
    }

    public Evaluation evaluate(DataSetIterator iterator, List<String> labelsList, int topN) {
        org.nd4j.linalg.dataset.DataSet next;
        if (this.layers == null || !(this.getOutputLayer() instanceof IOutputLayer)) {
            throw new IllegalStateException("Cannot evaluate network with no output layer");
        }
        if (labelsList == null) {
            labelsList = iterator.getLabels();
        }
        Evaluation e = new Evaluation(labelsList, topN);
        while (iterator.hasNext() && (next = (org.nd4j.linalg.dataset.DataSet)iterator.next()).getFeatureMatrix() != null && next.getLabels() != null) {
            INDArray out;
            INDArray features = next.getFeatures();
            INDArray labels = next.getLabels();
            if (next.hasMaskArrays()) {
                INDArray fMask = next.getFeaturesMaskArray();
                INDArray lMask = next.getLabelsMaskArray();
                out = this.output(features, false, fMask, lMask);
                if (lMask != null) {
                    e.evalTimeSeries(labels, out, lMask);
                    continue;
                }
                e.evalTimeSeries(labels, out);
                continue;
            }
            out = this.output(features, false);
            if (labels.rank() == 3) {
                e.evalTimeSeries(labels, out);
                continue;
            }
            List meta = next.getExampleMetaData();
            ArrayList meta2 = meta == null ? null : new ArrayList(meta);
            e.eval(labels, out, meta2);
        }
        return e;
    }

    private void update(Task task) {
        if (!this.initDone) {
            this.initDone = true;
            Heartbeat heartbeat = Heartbeat.getInstance();
            task = ModelSerializer.taskByModel(this);
            Environment env = EnvironmentUtils.buildEnvironment();
            heartbeat.reportEvent(Event.STANDALONE, env, task);
        }
    }

    public void setInitDone(boolean initDone) {
        this.initDone = initDone;
    }
}

