/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.iterators;

import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;

public class FilteredSequenceIterator<T extends SequenceElement>
implements SequenceIterator<T> {
    private final SequenceIterator<T> underlyingIterator;
    private final VocabCache<T> vocabCache;

    public FilteredSequenceIterator(@NonNull SequenceIterator<T> iterator, @NonNull VocabCache<T> vocabCache) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache is marked non-null but is null");
        }
        this.vocabCache = vocabCache;
        this.underlyingIterator = iterator;
    }

    @Override
    public boolean hasMoreSequences() {
        return this.underlyingIterator.hasMoreSequences();
    }

    @Override
    public Sequence<T> nextSequence() {
        Sequence<T> originalSequence = this.underlyingIterator.nextSequence();
        Sequence<T> newSequence = new Sequence<T>();
        if (originalSequence != null) {
            for (SequenceElement element : originalSequence.getElements()) {
                if (element == null || !this.vocabCache.hasToken(element.getLabel())) continue;
                newSequence.addElement(this.vocabCache.wordFor(element.getLabel()));
            }
        }
        newSequence.setSequenceId(originalSequence.getSequenceId());
        return newSequence;
    }

    @Override
    public void reset() {
        this.underlyingIterator.reset();
    }
}

