/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.iterators;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;

public class AbstractSequenceIterator<T extends SequenceElement>
implements SequenceIterator<T> {
    private Iterable<Sequence<T>> underlyingIterable;
    private Iterator<Sequence<T>> currentIterator;
    protected AtomicInteger tagger = new AtomicInteger(0);

    protected AbstractSequenceIterator(@NonNull Iterable<Sequence<T>> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable is marked non-null but is null");
        }
        this.underlyingIterable = iterable;
        this.currentIterator = iterable.iterator();
    }

    @Override
    public boolean hasMoreSequences() {
        return this.currentIterator.hasNext();
    }

    @Override
    public Sequence<T> nextSequence() {
        Sequence<T> sequence = this.currentIterator.next();
        sequence.setSequenceId(this.tagger.getAndIncrement());
        return sequence;
    }

    @Override
    public void reset() {
        this.tagger.set(0);
        this.currentIterator = this.underlyingIterable.iterator();
    }

    public static class Builder<T extends SequenceElement> {
        private Iterable<Sequence<T>> underlyingIterable;

        public Builder(@NonNull Iterable<Sequence<T>> iterable) {
            if (iterable == null) {
                throw new NullPointerException("iterable is marked non-null but is null");
            }
            this.underlyingIterable = iterable;
        }

        public AbstractSequenceIterator<T> build() {
            AbstractSequenceIterator<T> iterator = new AbstractSequenceIterator<T>(this.underlyingIterable);
            return iterator;
        }
    }
}

