/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.SequenceLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.BatchSequences;
import org.deeplearning4j.models.embeddings.learning.impl.elements.CBOW;
import org.deeplearning4j.models.embeddings.learning.impl.elements.SkipGram;
import org.deeplearning4j.models.embeddings.learning.impl.sequence.DBOW;
import org.deeplearning4j.models.embeddings.learning.impl.sequence.DM;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.embeddings.loader.WordVectorSerializer;
import org.deeplearning4j.models.embeddings.reader.ModelUtils;
import org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectorsImpl;
import org.deeplearning4j.models.sequencevectors.enums.ListenerEvent;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.interfaces.VectorsListener;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.VocabConstructor;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache;
import org.nd4j.common.util.ThreadUtils;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.memory.enums.LearningPolicy;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterUpdate;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.guava.primitives.Ints;
import org.nd4j.shade.guava.util.concurrent.AtomicDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceVectors<T extends SequenceElement>
extends WordVectorsImpl<T>
implements WordVectors {
    private static final long serialVersionUID = 78249242142L;
    protected transient SequenceIterator<T> iterator;
    protected transient ElementsLearningAlgorithm<T> elementsLearningAlgorithm;
    protected transient SequenceLearningAlgorithm<T> sequenceLearningAlgorithm;
    protected VectorsConfiguration configuration = new VectorsConfiguration();
    protected static final Logger log = LoggerFactory.getLogger(SequenceVectors.class);
    protected transient WordVectors existingModel;
    protected transient WordVectors intersectModel;
    protected transient T unknownElement;
    protected transient AtomicDouble scoreElements = new AtomicDouble(0.0);
    protected transient AtomicDouble scoreSequences = new AtomicDouble(0.0);
    protected transient boolean configured = false;
    protected transient boolean lockFactor = false;
    protected boolean enableScavenger = false;
    protected int vocabLimit = 0;
    private BatchSequences<T> batchSequences;
    protected transient Set<VectorsListener<T>> eventListeners;

    @Override
    public String getUNK() {
        return this.configuration.getUNK();
    }

    @Override
    public void setUNK(String UNK) {
        this.configuration.setUNK(UNK);
        super.setUNK(UNK);
    }

    public double getElementsScore() {
        return this.scoreElements.get();
    }

    public double getSequencesScore() {
        return this.scoreSequences.get();
    }

    @Override
    public INDArray getWordVectorMatrix(String word) {
        if (this.configuration.isUseUnknown() && !this.hasWord(word)) {
            return super.getWordVectorMatrix(this.getUNK());
        }
        return super.getWordVectorMatrix(word);
    }

    public void buildVocab() {
        VocabConstructor<Object> constructor = new VocabConstructor.Builder<T>().addSource(this.iterator, this.minWordFrequency).setTargetVocabCache(this.vocab).fetchLabels(this.trainSequenceVectors).setStopWords(this.stopWords).enableScavenger(this.enableScavenger).setEntriesLimit(this.vocabLimit).allowParallelTokenization(this.configuration.isAllowParallelTokenization()).setUnk(this.useUnknown && this.unknownElement != null ? (Object)this.unknownElement : null).build();
        if (this.existingModel != null && this.lookupTable instanceof InMemoryLookupTable && this.existingModel.lookupTable() instanceof InMemoryLookupTable) {
            log.info("Merging existing vocabulary into the current one...");
            constructor.buildMergedVocabulary(this.existingModel, true);
            ((InMemoryLookupTable)this.lookupTable).consume((InMemoryLookupTable)this.existingModel.lookupTable());
        } else {
            log.info("Starting vocabulary building...");
            constructor.buildJointVocabulary(false, true);
            if ((long)this.vocab.numWords() / constructor.getNumberOfSequences() > 1000L) {
                log.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                log.warn("!                                                                                       !");
                log.warn("! Your input looks malformed: number of sentences is too low, model accuracy may suffer !");
                log.warn("!                                                                                       !");
                log.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
        }
    }

    protected synchronized void initLearners() {
        if (!this.configured) {
            log.info("Building learning algorithms:");
            if (this.trainElementsVectors && this.elementsLearningAlgorithm != null && !this.trainSequenceVectors) {
                log.info("          building ElementsLearningAlgorithm: [" + this.elementsLearningAlgorithm.getCodeName() + "]");
                this.elementsLearningAlgorithm.configure(this.vocab, this.lookupTable, this.configuration);
                this.elementsLearningAlgorithm.pretrain(this.iterator);
            }
            if (this.trainSequenceVectors && this.sequenceLearningAlgorithm != null) {
                log.info("          building SequenceLearningAlgorithm: [" + this.sequenceLearningAlgorithm.getCodeName() + "]");
                this.sequenceLearningAlgorithm.configure(this.vocab, this.lookupTable, this.configuration);
                this.sequenceLearningAlgorithm.pretrain(this.iterator);
                if (this.trainElementsVectors) {
                    this.elementsLearningAlgorithm = this.sequenceLearningAlgorithm.getElementsLearningAlgorithm();
                    log.info("          building ElementsLearningAlgorithm: [" + this.elementsLearningAlgorithm.getCodeName() + "]");
                }
            }
            this.configured = true;
        }
    }

    private void initIntersectVectors() {
        if (this.intersectModel != null && this.intersectModel.vocab().numWords() > 0) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int i = 0; i < this.intersectModel.vocab().numWords(); ++i) {
                String externalWord = this.intersectModel.vocab().wordAtIndex(i);
                int index = this.vocab.indexOf(externalWord);
                if (index < 0) continue;
                ((SequenceElement)this.vocab.wordFor(externalWord)).setLocked(this.lockFactor);
                indexes.add(index);
            }
            if (indexes.size() > 0) {
                int[] intersectIndexes = Ints.toArray(indexes);
                Nd4j.scatterUpdate((ScatterUpdate.UpdateOp)ScatterUpdate.UpdateOp.ASSIGN, (INDArray)((InMemoryLookupTable)this.lookupTable).getSyn0(), (INDArray)Nd4j.createFromArray((int[])intersectIndexes), (INDArray)((InMemoryLookupTable)this.intersectModel.lookupTable()).getSyn0(), (int[])new int[]{1});
            }
        }
    }

    public void fit() {
        Properties props = Nd4j.getExecutioner().getEnvironmentInformation();
        if (props.getProperty("backend").equals("CUDA") && Nd4j.getAffinityManager().getNumberOfDevices() > 1) {
            throw new IllegalStateException("Multi-GPU word2vec/doc2vec isn't available atm");
        }
        Nd4j.getRandom().setSeed(this.configuration.getSeed());
        AtomicLong timeSpent = new AtomicLong(0L);
        if (!this.trainElementsVectors && !this.trainSequenceVectors) {
            throw new IllegalStateException("You should define at least one training goal 'trainElementsRepresentation' or 'trainSequenceRepresentation'");
        }
        if (this.iterator == null) {
            throw new IllegalStateException("You can't fit() data without SequenceIterator defined");
        }
        if (this.resetModel || this.lookupTable != null && this.vocab != null && this.vocab.numWords() == 0) {
            this.buildVocab();
        }
        WordVectorSerializer.printOutProjectedMemoryUse(this.vocab.numWords(), this.configuration.getLayersSize(), this.configuration.isUseHierarchicSoftmax() && this.configuration.getNegative() > 0.0 ? 3 : 2);
        if (this.vocab == null || this.lookupTable == null || this.vocab.numWords() == 0) {
            throw new IllegalStateException("You can't fit() model with empty Vocabulary or WeightLookupTable");
        }
        if (!this.resetModel || this.existingModel != null) {
            this.lookupTable.resetWeights(false);
        } else {
            this.lookupTable.resetWeights(true);
            if (this.configuration.isPreciseWeightInit()) {
                log.info("Using precise weights init...");
                this.iterator.reset();
                while (this.iterator.hasMoreSequences()) {
                    INDArray randArray;
                    Random rng;
                    Object realElement;
                    Sequence<T> sequence = this.iterator.nextSequence();
                    for (SequenceElement element : sequence.getElements()) {
                        realElement = this.vocab.tokenFor(element.getLabel());
                        if (realElement == null || ((SequenceElement)realElement).isInit()) continue;
                        rng = Nd4j.getRandomFactory().getNewRandomInstance(this.configuration.getSeed() * (long)((SequenceElement)realElement).hashCode(), (long)(this.configuration.getLayersSize() + 1));
                        randArray = Nd4j.rand((int[])new int[]{1, this.configuration.getLayersSize()}, (Random)rng).subi((Number)0.5).divi((Number)this.configuration.getLayersSize());
                        this.lookupTable.getWeights().getRow((long)((SequenceElement)realElement).getIndex(), true).assign(randArray);
                        ((SequenceElement)realElement).setInit(true);
                    }
                    for (SequenceElement label : sequence.getSequenceLabels()) {
                        realElement = this.vocab.tokenFor(label.getLabel());
                        if (realElement == null || ((SequenceElement)realElement).isInit()) continue;
                        rng = Nd4j.getRandomFactory().getNewRandomInstance(this.configuration.getSeed() * (long)((SequenceElement)realElement).hashCode(), (long)(this.configuration.getLayersSize() + 1));
                        randArray = Nd4j.rand((int[])new int[]{1, this.configuration.getLayersSize()}, (Random)rng).subi((Number)0.5).divi((Number)this.configuration.getLayersSize());
                        this.lookupTable.getWeights().getRow((long)((SequenceElement)realElement).getIndex(), true).assign(randArray);
                        ((SequenceElement)realElement).setInit(true);
                    }
                }
                this.iterator.reset();
            }
        }
        this.initLearners();
        this.initIntersectVectors();
        log.info("Starting learning process...");
        timeSpent.set(System.currentTimeMillis());
        if (this.stopWords == null) {
            this.stopWords = new ArrayList();
        }
        AtomicLong wordsCounter = new AtomicLong(0L);
        for (int currentEpoch = 1; currentEpoch <= this.numEpochs; ++currentEpoch) {
            AtomicLong linesCounter = new AtomicLong(0L);
            AsyncSequencer sequencer = new AsyncSequencer(this.iterator, this.stopWords);
            sequencer.start();
            AtomicLong timer = new AtomicLong(System.currentTimeMillis());
            VectorCalculationsThread thread = new VectorCalculationsThread(0, currentEpoch, wordsCounter, this.vocab.totalWordOccurrences(), linesCounter, sequencer, timer, this.numEpochs);
            thread.start();
            try {
                sequencer.join();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                thread.join();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.trainElementsVectors && this.elementsLearningAlgorithm != null && (!this.trainSequenceVectors || this.sequenceLearningAlgorithm == null) && this.elementsLearningAlgorithm.isEarlyTerminationHit() || this.trainSequenceVectors && this.sequenceLearningAlgorithm != null && (!this.trainElementsVectors || this.elementsLearningAlgorithm == null) && this.sequenceLearningAlgorithm.isEarlyTerminationHit()) break;
            log.info("Epoch [" + currentEpoch + "] finished; Elements processed so far: [" + wordsCounter.get() + "];  Sequences processed: [" + linesCounter.get() + "]");
            if (this.eventListeners == null || this.eventListeners.isEmpty()) continue;
            for (VectorsListener<T> listener : this.eventListeners) {
                if (!listener.validateEvent(ListenerEvent.EPOCH, currentEpoch)) continue;
                listener.processEvent(ListenerEvent.EPOCH, this, currentEpoch);
            }
        }
        log.info("Time spent on training: {} ms", (Object)(System.currentTimeMillis() - timeSpent.get()));
    }

    protected void trainSequence(@NonNull Sequence<T> sequence, AtomicLong nextRandom, double alpha) {
        if (sequence == null) {
            throw new NullPointerException("sequence is marked non-null but is null");
        }
        if (sequence.getElements().isEmpty()) {
            return;
        }
        if (!(!this.trainElementsVectors || this.trainSequenceVectors && this.sequenceLearningAlgorithm instanceof DM)) {
            nextRandom.set(nextRandom.get() * 25214903917L + 11L);
            if (!this.elementsLearningAlgorithm.isEarlyTerminationHit()) {
                this.scoreElements.set(this.elementsLearningAlgorithm.learnSequence(sequence, nextRandom, alpha, this.batchSequences));
            } else {
                this.scoreElements.set(this.elementsLearningAlgorithm.learnSequence(sequence, nextRandom, alpha));
            }
        }
        if (this.trainSequenceVectors) {
            nextRandom.set(nextRandom.get() * 25214903917L + 11L);
            if (!this.sequenceLearningAlgorithm.isEarlyTerminationHit()) {
                this.scoreSequences.set(this.sequenceLearningAlgorithm.learnSequence(sequence, nextRandom, alpha, this.batchSequences));
            }
        }
    }

    public SequenceIterator<T> getIterator() {
        return this.iterator;
    }

    public void setElementsLearningAlgorithm(ElementsLearningAlgorithm<T> elementsLearningAlgorithm) {
        this.elementsLearningAlgorithm = elementsLearningAlgorithm;
    }

    public VectorsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setEventListeners(Set<VectorsListener<T>> eventListeners) {
        this.eventListeners = eventListeners;
    }

    static /* synthetic */ int[] access$1902(SequenceVectors x0, int[] x1) {
        x0.variableWindows = x1;
        return x1;
    }

    private class VectorCalculationsThread
    extends Thread
    implements Runnable {
        private final int threadId;
        private final int epochNumber;
        private final AtomicLong wordsCounter;
        private final long totalWordsCount;
        private final AtomicLong totalLines;
        private final AsyncSequencer digitizer;
        private final AtomicLong nextRandom;
        private final AtomicLong timer;
        private final long startTime;
        private final int totalEpochs;

        public VectorCalculationsThread(int threadId, int epoch, AtomicLong wordsCounter, long totalWordsCount, AtomicLong linesCounter, AsyncSequencer digitizer, AtomicLong timer, int totalEpochs) {
            this.threadId = threadId;
            this.totalEpochs = totalEpochs;
            this.epochNumber = epoch;
            this.wordsCounter = wordsCounter;
            this.totalWordsCount = totalWordsCount;
            this.totalLines = linesCounter;
            this.digitizer = digitizer;
            this.timer = timer;
            this.startTime = timer.get();
            this.nextRandom = new AtomicLong(this.threadId);
            this.setName("VectorCalculationsThread " + this.threadId);
        }

        @Override
        public void run() {
            WorkspaceConfiguration conf = WorkspaceConfiguration.builder().policyLearning(LearningPolicy.OVER_TIME).cyclesBeforeInitialization(3).initialSize(0x1900000L).build();
            String workspace_id = "sequence_vectors_training_" + UUID.randomUUID().toString();
            Nd4j.getAffinityManager().getDeviceForCurrentThread();
            while (this.digitizer.hasMoreLines()) {
                try {
                    ArrayList sequences = new ArrayList();
                    for (int x = 0; x < SequenceVectors.this.batchSize; ++x) {
                        Sequence sequence;
                        if (!this.digitizer.hasMoreLines() || (sequence = this.digitizer.nextSentence()) == null) continue;
                        sequences.add(sequence);
                    }
                    double alpha = 0.025;
                    if (sequences.isEmpty()) continue;
                    for (int i = 0; i < SequenceVectors.this.numIterations; ++i) {
                        SequenceVectors.this.batchSequences = new BatchSequences(SequenceVectors.this.configuration.getBatchSize());
                        for (int x = 0; x < sequences.size(); ++x) {
                            try (MemoryWorkspace ws = Nd4j.getWorkspaceManager().getAndActivateWorkspace(conf, workspace_id);){
                                Sequence sequence = (Sequence)sequences.get(x);
                                alpha = Math.max(SequenceVectors.this.minLearningRate, SequenceVectors.this.learningRate.get() * (1.0 - 1.0 * (double)this.wordsCounter.get() / (double)this.totalWordsCount / (double)(SequenceVectors.this.numIterations * this.totalEpochs)));
                                SequenceVectors.this.trainSequence(sequence, this.nextRandom, alpha);
                                this.totalLines.incrementAndGet();
                                this.wordsCounter.addAndGet(sequence.getElements().size());
                                if (this.totalLines.get() % 100000L == 0L) {
                                    long currentTime = System.currentTimeMillis();
                                    long timeSpent = currentTime - this.timer.get();
                                    this.timer.set(currentTime);
                                    long totalTimeSpent = currentTime - this.startTime;
                                    double seqSec = 100000.0 / ((double)timeSpent / 1000.0);
                                    double wordsSecTotal = (double)this.wordsCounter.get() / ((double)totalTimeSpent / 1000.0);
                                    log.info("Epoch: [{}]; Words vectorized so far: [{}];  Lines vectorized so far: [{}]; Seq/sec: [{}]; Words/sec: [{}]; learningRate: [{}]", new Object[]{this.epochNumber, this.wordsCounter.get(), this.totalLines.get(), String.format("%.2f", seqSec), String.format("%.2f", wordsSecTotal), alpha});
                                }
                                if (SequenceVectors.this.eventListeners == null || SequenceVectors.this.eventListeners.isEmpty()) continue;
                                for (VectorsListener listener : SequenceVectors.this.eventListeners) {
                                    if (!listener.validateEvent(ListenerEvent.LINE, this.totalLines.get())) continue;
                                    listener.processEvent(ListenerEvent.LINE, SequenceVectors.this, this.totalLines.get());
                                }
                                continue;
                            }
                        }
                        if (SequenceVectors.this.elementsLearningAlgorithm instanceof SkipGram) {
                            ((SkipGram)SequenceVectors.this.elementsLearningAlgorithm).setWorkers(SequenceVectors.this.workers);
                        } else if (SequenceVectors.this.elementsLearningAlgorithm instanceof CBOW) {
                            ((CBOW)SequenceVectors.this.elementsLearningAlgorithm).setWorkers(SequenceVectors.this.workers);
                        }
                        int batchSize = SequenceVectors.this.configuration.getBatchSize();
                        if (batchSize > 1 && SequenceVectors.this.batchSequences != null) {
                            int rest = SequenceVectors.this.batchSequences.size() % batchSize;
                            int chunks = (SequenceVectors.this.batchSequences.size() >= batchSize ? SequenceVectors.this.batchSequences.size() / batchSize : 0) + (rest > 0 ? 1 : 0);
                            for (int j = 0; j < chunks; ++j) {
                                if (SequenceVectors.this.trainElementsVectors) {
                                    if (SequenceVectors.this.elementsLearningAlgorithm instanceof SkipGram) {
                                        ((SkipGram)SequenceVectors.this.elementsLearningAlgorithm).iterateSample(SequenceVectors.this.batchSequences.get(j));
                                    } else if (SequenceVectors.this.elementsLearningAlgorithm instanceof CBOW) {
                                        ((CBOW)SequenceVectors.this.elementsLearningAlgorithm).iterateSample(SequenceVectors.this.batchSequences.get(j));
                                    }
                                }
                                if (!SequenceVectors.this.trainSequenceVectors) continue;
                                if (SequenceVectors.this.sequenceLearningAlgorithm instanceof DBOW) {
                                    ((SkipGram)SequenceVectors.this.sequenceLearningAlgorithm.getElementsLearningAlgorithm()).iterateSample(SequenceVectors.this.batchSequences.get(j));
                                    continue;
                                }
                                if (!(SequenceVectors.this.sequenceLearningAlgorithm instanceof DM)) continue;
                                ((CBOW)SequenceVectors.this.sequenceLearningAlgorithm.getElementsLearningAlgorithm()).iterateSample(SequenceVectors.this.batchSequences.get(j));
                            }
                            SequenceVectors.this.batchSequences.clear();
                            SequenceVectors.this.batchSequences = null;
                        }
                        if (SequenceVectors.this.eventListeners == null || SequenceVectors.this.eventListeners.isEmpty()) continue;
                        for (VectorsListener listener : SequenceVectors.this.eventListeners) {
                            if (!listener.validateEvent(ListenerEvent.ITERATION, i)) continue;
                            listener.processEvent(ListenerEvent.ITERATION, SequenceVectors.this, i);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (SequenceVectors.this.trainElementsVectors) {
                SequenceVectors.this.elementsLearningAlgorithm.finish();
            }
            if (SequenceVectors.this.trainSequenceVectors) {
                SequenceVectors.this.sequenceLearningAlgorithm.finish();
            }
        }
    }

    protected class AsyncSequencer
    extends Thread
    implements Runnable {
        private final SequenceIterator<T> iterator;
        private final LinkedBlockingQueue<Sequence<T>> buffer;
        private final int limitUpper;
        private final int limitLower;
        private AtomicBoolean isRunning = new AtomicBoolean(true);
        private AtomicLong nextRandom;
        private Collection<String> stopList;
        private static final int DEFAULT_BUFFER_SIZE = 512;

        public AsyncSequencer(@NonNull SequenceIterator<T> iterator, Collection<String> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList is marked non-null but is null");
            }
            this.iterator = iterator;
            this.setName("AsyncSequencer thread");
            this.nextRandom = new AtomicLong(SequenceVectors.this.workers + 1);
            this.iterator.reset();
            this.stopList = stopList;
            this.setDaemon(true);
            this.limitLower = SequenceVectors.this.workers * (SequenceVectors.this.batchSize < 512 ? 512 : SequenceVectors.this.batchSize);
            this.limitUpper = this.limitLower * 2;
            this.buffer = new LinkedBlockingQueue(this.limitUpper);
        }

        @Override
        public void run() {
            this.isRunning.set(true);
            while (this.iterator.hasMoreSequences()) {
                if (this.buffer.size() < this.limitLower) {
                    SequenceVectors.this.update();
                    AtomicInteger linesLoaded = new AtomicInteger(0);
                    while (linesLoaded.getAndIncrement() < this.limitUpper && this.iterator.hasMoreSequences()) {
                        Iterator newLabel;
                        Sequence document = this.iterator.nextSequence();
                        Sequence newSequence = new Sequence();
                        if (document.getSequenceLabel() != null && (newLabel = SequenceVectors.this.vocab.wordFor(((SequenceElement)document.getSequenceLabel()).getLabel())) != null) {
                            newSequence.setSequenceLabel(newLabel);
                        }
                        newLabel = document.getElements().iterator();
                        while (newLabel.hasNext()) {
                            SequenceElement element = (SequenceElement)newLabel.next();
                            if (this.stopList.contains(element.getLabel())) continue;
                            Object realElement = SequenceVectors.this.vocab.wordFor(element.getLabel());
                            if (realElement != null) {
                                newSequence.addElement((Iterator)realElement);
                                continue;
                            }
                            if (!SequenceVectors.this.useUnknown || SequenceVectors.this.unknownElement == null) continue;
                            newSequence.addElement((Iterator)SequenceVectors.this.unknownElement);
                        }
                        if (!newSequence.getElements().isEmpty()) {
                            try {
                                this.buffer.put(newSequence);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new RuntimeException(e);
                            }
                        }
                        linesLoaded.incrementAndGet();
                    }
                    continue;
                }
                ThreadUtils.uncheckedSleep((long)50L);
            }
            this.isRunning.set(false);
        }

        public boolean hasMoreLines() {
            return !this.buffer.isEmpty() || this.isRunning.get();
        }

        public Sequence<T> nextSentence() {
            try {
                return this.buffer.poll(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    public static class Builder<T extends SequenceElement> {
        protected VocabCache<T> vocabCache;
        protected WeightLookupTable<T> lookupTable;
        protected SequenceIterator<T> iterator;
        protected ModelUtils<T> modelUtils = new BasicModelUtils();
        protected WordVectors existingVectors;
        protected SequenceVectors<T> intersectVectors;
        protected boolean lockFactor = false;
        protected double sampling = 0.0;
        protected double negative = 0.0;
        protected double learningRate = 0.025;
        protected double minLearningRate = 1.0E-4;
        protected int minWordFrequency = 0;
        protected int iterations = 1;
        protected int numEpochs = 1;
        protected int layerSize = 100;
        protected int window = 5;
        protected boolean hugeModelExpected = false;
        protected int batchSize = 512;
        protected int learningRateDecayWords;
        protected long seed;
        protected boolean useAdaGrad = false;
        protected boolean resetModel = true;
        protected int workers = Runtime.getRuntime().availableProcessors();
        protected boolean useUnknown = false;
        protected boolean useHierarchicSoftmax = true;
        protected int[] variableWindows;
        protected boolean trainSequenceVectors = false;
        protected boolean trainElementsVectors = true;
        protected boolean preciseWeightInit = false;
        protected Collection<String> stopWords = new ArrayList<String>();
        protected VectorsConfiguration configuration = new VectorsConfiguration();
        protected transient T unknownElement;
        protected String UNK = this.configuration.getUNK();
        protected String STOP = this.configuration.getSTOP();
        protected boolean enableScavenger = false;
        protected int vocabLimit;
        protected boolean preciseMode = false;
        protected ElementsLearningAlgorithm<T> elementsLearningAlgorithm = new SkipGram();
        protected SequenceLearningAlgorithm<T> sequenceLearningAlgorithm = new DBOW();
        protected Set<VectorsListener<T>> vectorsListeners = new HashSet<VectorsListener<T>>();

        public Builder() {
        }

        public Builder(@NonNull VectorsConfiguration configuration) {
            if (configuration == null) {
                throw new NullPointerException("configuration is marked non-null but is null");
            }
            this.configuration = configuration;
            this.iterations = configuration.getIterations();
            this.numEpochs = configuration.getEpochs();
            this.minLearningRate = configuration.getMinLearningRate();
            this.learningRate = configuration.getLearningRate();
            this.sampling = configuration.getSampling();
            this.negative = configuration.getNegative();
            this.minWordFrequency = configuration.getMinWordFrequency();
            this.seed = configuration.getSeed();
            this.hugeModelExpected = configuration.isHugeModelExpected();
            this.batchSize = configuration.getBatchSize();
            this.layerSize = configuration.getLayersSize();
            this.learningRateDecayWords = configuration.getLearningRateDecayWords();
            this.useAdaGrad = configuration.isUseAdaGrad();
            this.window = configuration.getWindow();
            this.UNK = configuration.getUNK();
            this.STOP = configuration.getSTOP();
            this.variableWindows = configuration.getVariableWindows();
            this.useHierarchicSoftmax = configuration.isUseHierarchicSoftmax();
            this.preciseMode = configuration.isPreciseMode();
            if (configuration.getModelUtils() != null && !configuration.getModelUtils().isEmpty()) {
                try {
                    this.modelUtils = (ModelUtils)Class.forName(configuration.getModelUtils()).newInstance();
                }
                catch (Exception e) {
                    log.error("Got {} trying to instantiate ModelUtils, falling back to BasicModelUtils instead");
                    this.modelUtils = new BasicModelUtils();
                }
            }
            if (configuration.getElementsLearningAlgorithm() != null && !configuration.getElementsLearningAlgorithm().isEmpty()) {
                this.elementsLearningAlgorithm(configuration.getElementsLearningAlgorithm());
            }
            if (configuration.getSequenceLearningAlgorithm() != null && !configuration.getSequenceLearningAlgorithm().isEmpty()) {
                this.sequenceLearningAlgorithm(configuration.getSequenceLearningAlgorithm());
            }
            if (configuration.getStopList() != null) {
                this.stopWords.addAll(configuration.getStopList());
            }
        }

        protected Builder<T> useExistingWordVectors(@NonNull WordVectors vec) {
            if (vec == null) {
                throw new NullPointerException("vec is marked non-null but is null");
            }
            this.existingVectors = vec;
            return this;
        }

        public Builder<T> iterate(@NonNull SequenceIterator<T> iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.iterator = iterator;
            return this;
        }

        public Builder<T> sequenceLearningAlgorithm(@NonNull String algoName) {
            if (algoName == null) {
                throw new NullPointerException("algoName is marked non-null but is null");
            }
            try {
                Class<?> clazz = Class.forName(algoName);
                this.sequenceLearningAlgorithm = (SequenceLearningAlgorithm)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder<T> sequenceLearningAlgorithm(@NonNull SequenceLearningAlgorithm<T> algorithm) {
            if (algorithm == null) {
                throw new NullPointerException("algorithm is marked non-null but is null");
            }
            this.sequenceLearningAlgorithm = algorithm;
            return this;
        }

        public Builder<T> elementsLearningAlgorithm(@NonNull String algoName) {
            if (algoName == null) {
                throw new NullPointerException("algoName is marked non-null but is null");
            }
            try {
                Class<?> clazz = Class.forName(algoName);
                this.elementsLearningAlgorithm = (ElementsLearningAlgorithm)clazz.newInstance();
                this.configuration.setElementsLearningAlgorithm(this.elementsLearningAlgorithm.getClass().getCanonicalName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder<T> elementsLearningAlgorithm(@NonNull ElementsLearningAlgorithm<T> algorithm) {
            if (algorithm == null) {
                throw new NullPointerException("algorithm is marked non-null but is null");
            }
            this.elementsLearningAlgorithm = algorithm;
            return this;
        }

        public Builder<T> batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder<T> iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder<T> epochs(int numEpochs) {
            this.numEpochs = numEpochs;
            return this;
        }

        public Builder<T> workers(int numWorkers) {
            this.workers = numWorkers;
            return this;
        }

        public Builder<T> useHierarchicSoftmax(boolean reallyUse) {
            this.useHierarchicSoftmax = reallyUse;
            return this;
        }

        @Deprecated
        public Builder<T> useAdaGrad(boolean reallyUse) {
            this.useAdaGrad = reallyUse;
            return this;
        }

        public Builder<T> layerSize(int layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        public Builder<T> learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder<T> minWordFrequency(int minWordFrequency) {
            this.minWordFrequency = minWordFrequency;
            return this;
        }

        public Builder limitVocabularySize(int limit) {
            if (limit < 0) {
                throw new DL4JInvalidConfigException("Vocabulary limit should be non-negative number");
            }
            this.vocabLimit = limit;
            return this;
        }

        public Builder<T> minLearningRate(double minLearningRate) {
            this.minLearningRate = minLearningRate;
            return this;
        }

        public Builder<T> resetModel(boolean reallyReset) {
            this.resetModel = reallyReset;
            return this;
        }

        public Builder<T> vocabCache(@NonNull VocabCache<T> vocabCache) {
            if (vocabCache == null) {
                throw new NullPointerException("vocabCache is marked non-null but is null");
            }
            this.vocabCache = vocabCache;
            return this;
        }

        public Builder<T> lookupTable(@NonNull WeightLookupTable<T> lookupTable) {
            if (lookupTable == null) {
                throw new NullPointerException("lookupTable is marked non-null but is null");
            }
            this.lookupTable = lookupTable;
            this.layerSize(lookupTable.layerSize());
            return this;
        }

        public Builder<T> sampling(double sampling) {
            this.sampling = sampling;
            return this;
        }

        public Builder<T> negativeSample(double negative) {
            this.negative = negative;
            return this;
        }

        public Builder<T> stopWords(@NonNull List<String> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList is marked non-null but is null");
            }
            this.stopWords.addAll(stopList);
            return this;
        }

        public Builder<T> trainElementsRepresentation(boolean trainElements) {
            this.trainElementsVectors = trainElements;
            return this;
        }

        public Builder<T> trainSequencesRepresentation(boolean trainSequences) {
            this.trainSequenceVectors = trainSequences;
            return this;
        }

        public Builder<T> stopWords(@NonNull Collection<T> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList is marked non-null but is null");
            }
            for (SequenceElement word : stopList) {
                this.stopWords.add(word.getLabel());
            }
            return this;
        }

        public Builder<T> windowSize(int windowSize) {
            this.window = windowSize;
            return this;
        }

        public Builder<T> seed(long randomSeed) {
            this.seed = randomSeed;
            return this;
        }

        public Builder<T> modelUtils(@NonNull ModelUtils<T> modelUtils) {
            if (modelUtils == null) {
                throw new NullPointerException("modelUtils is marked non-null but is null");
            }
            this.modelUtils = modelUtils;
            this.configuration.setModelUtils(modelUtils.getClass().getCanonicalName());
            return this;
        }

        public Builder<T> useUnknown(boolean reallyUse) {
            this.useUnknown = reallyUse;
            this.configuration.setUseUnknown(reallyUse);
            return this;
        }

        public Builder<T> unknownElement(@NonNull T element) {
            if (element == null) {
                throw new NullPointerException("element is marked non-null but is null");
            }
            this.unknownElement = element;
            this.UNK = ((SequenceElement)element).getLabel();
            this.configuration.setUNK(this.UNK);
            return this;
        }

        public Builder<T> useVariableWindow(int ... windows) {
            if (windows == null || windows.length == 0) {
                throw new IllegalStateException("Variable windows can't be empty");
            }
            this.variableWindows = windows;
            return this;
        }

        public Builder<T> usePreciseWeightInit(boolean reallyUse) {
            this.preciseWeightInit = reallyUse;
            this.configuration.setPreciseWeightInit(reallyUse);
            return this;
        }

        public Builder<T> usePreciseMode(boolean reallyUse) {
            this.preciseMode = reallyUse;
            this.configuration.setPreciseMode(reallyUse);
            return this;
        }

        protected void presetTables() {
            if (this.lookupTable == null) {
                if (this.vocabCache == null) {
                    this.vocabCache = new AbstractCache.Builder().hugeModelExpected(this.hugeModelExpected).scavengerRetentionDelay(this.configuration.getScavengerRetentionDelay()).scavengerThreshold(this.configuration.getScavengerActivationThreshold()).minElementFrequency(this.minWordFrequency).build();
                }
                this.lookupTable = new InMemoryLookupTable.Builder().useAdaGrad(this.useAdaGrad).cache(this.vocabCache).negative(this.negative).useHierarchicSoftmax(this.useHierarchicSoftmax).vectorLength(this.layerSize).lr(this.learningRate).seed(this.seed).build();
            }
            if (this.configuration.getElementsLearningAlgorithm() != null) {
                try {
                    this.elementsLearningAlgorithm = (ElementsLearningAlgorithm)Class.forName(this.configuration.getElementsLearningAlgorithm()).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.configuration.getSequenceLearningAlgorithm() != null) {
                try {
                    this.sequenceLearningAlgorithm = (SequenceLearningAlgorithm)Class.forName(this.configuration.getSequenceLearningAlgorithm()).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.trainElementsVectors && this.elementsLearningAlgorithm == null) {
                this.elementsLearningAlgorithm = new SkipGram();
            }
            if (this.trainSequenceVectors && this.sequenceLearningAlgorithm == null) {
                this.sequenceLearningAlgorithm = new DBOW();
            }
            this.modelUtils.init(this.lookupTable);
        }

        public Builder<T> setVectorsListeners(@NonNull Collection<VectorsListener<T>> listeners) {
            if (listeners == null) {
                throw new NullPointerException("listeners is marked non-null but is null");
            }
            this.vectorsListeners.addAll(listeners);
            return this;
        }

        public Builder<T> enableScavenger(boolean reallyEnable) {
            this.enableScavenger = reallyEnable;
            return this;
        }

        public Builder<T> intersectModel(@NonNull SequenceVectors<T> intersectVectors, boolean lockFactor) {
            if (intersectVectors == null) {
                throw new NullPointerException("intersectVectors is marked non-null but is null");
            }
            this.intersectVectors = intersectVectors;
            this.lockFactor = lockFactor;
            return this;
        }

        public SequenceVectors<T> build() {
            this.presetTables();
            SequenceVectors vectors = new SequenceVectors();
            if (this.existingVectors != null) {
                this.trainElementsVectors = false;
                this.elementsLearningAlgorithm = null;
            }
            vectors.numEpochs = this.numEpochs;
            vectors.numIterations = this.iterations;
            vectors.vocab = this.vocabCache;
            vectors.minWordFrequency = this.minWordFrequency;
            vectors.learningRate.set(this.learningRate);
            vectors.minLearningRate = this.minLearningRate;
            vectors.sampling = this.sampling;
            vectors.negative = this.negative;
            vectors.layerSize = this.layerSize;
            vectors.batchSize = this.batchSize;
            vectors.learningRateDecayWords = this.learningRateDecayWords;
            vectors.window = this.window;
            vectors.resetModel = this.resetModel;
            vectors.useAdeGrad = this.useAdaGrad;
            vectors.stopWords = this.stopWords;
            vectors.workers = this.workers;
            vectors.iterator = this.iterator;
            vectors.lookupTable = this.lookupTable;
            vectors.modelUtils = this.modelUtils;
            vectors.useUnknown = this.useUnknown;
            vectors.unknownElement = this.unknownElement;
            SequenceVectors.access$1902(vectors, this.variableWindows);
            vectors.vocabLimit = this.vocabLimit;
            vectors.trainElementsVectors = this.trainElementsVectors;
            vectors.trainSequenceVectors = this.trainSequenceVectors;
            vectors.elementsLearningAlgorithm = this.elementsLearningAlgorithm;
            vectors.sequenceLearningAlgorithm = this.sequenceLearningAlgorithm;
            vectors.existingModel = this.existingVectors;
            vectors.intersectModel = this.intersectVectors;
            vectors.enableScavenger = this.enableScavenger;
            vectors.lockFactor = this.lockFactor;
            this.configuration.setLearningRate(this.learningRate);
            this.configuration.setLayersSize(this.layerSize);
            this.configuration.setHugeModelExpected(this.hugeModelExpected);
            this.configuration.setWindow(this.window);
            this.configuration.setMinWordFrequency(this.minWordFrequency);
            this.configuration.setIterations(this.iterations);
            this.configuration.setSeed(this.seed);
            this.configuration.setBatchSize(this.batchSize);
            this.configuration.setLearningRateDecayWords(this.learningRateDecayWords);
            this.configuration.setMinLearningRate(this.minLearningRate);
            this.configuration.setSampling(this.sampling);
            this.configuration.setUseAdaGrad(this.useAdaGrad);
            this.configuration.setNegative(this.negative);
            this.configuration.setEpochs(this.numEpochs);
            this.configuration.setStopList(this.stopWords);
            this.configuration.setVariableWindows(this.variableWindows);
            this.configuration.setUseHierarchicSoftmax(this.useHierarchicSoftmax);
            this.configuration.setPreciseWeightInit(this.preciseWeightInit);
            this.configuration.setModelUtils(this.modelUtils.getClass().getCanonicalName());
            vectors.configuration = this.configuration;
            return vectors;
        }
    }
}

