/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.iterator.provider;

import java.util.List;
import lombok.NonNull;
import org.deeplearning4j.iterator.LabeledSentenceProvider;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.nd4j.common.primitives.Pair;

public class LabelAwareConverter
implements LabeledSentenceProvider {
    private LabelAwareIterator backingIterator;
    private List<String> labels;

    public LabelAwareConverter(@NonNull LabelAwareIterator iterator, @NonNull List<String> labels) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        this.backingIterator = iterator;
        this.labels = labels;
    }

    @Override
    public boolean hasNext() {
        return this.backingIterator.hasNext();
    }

    @Override
    public Pair<String, String> nextSentence() {
        LabelledDocument document = this.backingIterator.nextDocument();
        return Pair.makePair((Object)document.getContent(), (Object)document.getLabels().get(0));
    }

    @Override
    public void reset() {
        this.backingIterator.reset();
    }

    @Override
    public int totalNumSentences() {
        return -1;
    }

    @Override
    public List<String> allLabels() {
        return this.labels;
    }

    @Override
    public int numLabelClasses() {
        return this.labels.size();
    }
}

