/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.iterator.provider;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.iterator.LabeledSentenceProvider;
import org.nd4j.linalg.collection.CompactHeapStringList;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.MathUtils;

public class FileLabeledSentenceProvider
implements LabeledSentenceProvider {
    private final int totalCount;
    private final List<String> filePaths;
    private final int[] fileLabelIndexes;
    private final Random rng;
    private final int[] order;
    private final List<String> allLabels;
    private int cursor = 0;

    public FileLabeledSentenceProvider(Map<String, List<File>> filesByLabel) {
        this(filesByLabel, new Random());
    }

    public FileLabeledSentenceProvider(@NonNull Map<String, List<File>> filesByLabel, Random rng) {
        if (filesByLabel == null) {
            throw new NullPointerException("filesByLabel is marked @NonNull but is null");
        }
        int totalCount = 0;
        for (List<File> l : filesByLabel.values()) {
            totalCount += l.size();
        }
        this.totalCount = totalCount;
        this.rng = rng;
        if (rng == null) {
            this.order = null;
        } else {
            this.order = new int[totalCount];
            for (int i = 0; i < totalCount; ++i) {
                this.order[i] = i;
            }
            MathUtils.shuffleArray((int[])this.order, (Random)rng);
        }
        this.allLabels = new ArrayList<String>(filesByLabel.keySet());
        Collections.sort(this.allLabels);
        HashMap<String, Integer> labelsToIdx = new HashMap<String, Integer>();
        for (int i = 0; i < this.allLabels.size(); ++i) {
            labelsToIdx.put(this.allLabels.get(i), i);
        }
        this.filePaths = new CompactHeapStringList();
        this.fileLabelIndexes = new int[totalCount];
        int position = 0;
        for (Map.Entry<String, List<File>> entry : filesByLabel.entrySet()) {
            int labelIdx = (Integer)labelsToIdx.get(entry.getKey());
            for (File f : entry.getValue()) {
                this.filePaths.add(f.getPath());
                this.fileLabelIndexes[position] = labelIdx;
                ++position;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.totalCount;
    }

    @Override
    public Pair<String, String> nextSentence() {
        String sentence;
        int idx = this.rng == null ? this.cursor++ : this.order[this.cursor++];
        File f = new File(this.filePaths.get(idx));
        String label = this.allLabels.get(this.fileLabelIndexes[idx]);
        try {
            sentence = FileUtils.readFileToString((File)f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Pair((Object)sentence, (Object)label);
    }

    @Override
    public void reset() {
        this.cursor = 0;
        if (this.rng != null) {
            MathUtils.shuffleArray((int[])this.order, (Random)this.rng);
        }
    }

    @Override
    public int totalNumSentences() {
        return this.totalCount;
    }

    @Override
    public List<String> allLabels() {
        return this.allLabels;
    }

    @Override
    public int numLabelClasses() {
        return this.allLabels.size();
    }
}

